/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ContentRootIndexableEntityProvider
implements IndexableEntityProvider.Existing<ContentRootEntity> {
    ContentRootIndexableEntityProvider() {
    }

    @Override
    @NotNull
    public Class<ContentRootEntity> getEntityClass() {
        return ContentRootEntity.class;
    }

    @Override
    @NotNull
    public Collection<IndexableEntityProvider.DependencyOnParent<? extends WorkspaceEntity>> getDependencies() {
        List<IndexableEntityProvider.DependencyOnParent<? extends WorkspaceEntity>> list2 = Collections.singletonList(IndexableEntityProvider.DependencyOnParent.create(ModuleEntity.class, ContentRootIndexableEntityProvider::getReplacedParentEntityIteratorBuilder));
        if (list2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getIteratorBuildersForExistingModule(@NotNull ModuleEntity entity, @NotNull EntityStorage entityStorage, @NotNull Project project2) {
        if (entity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(1);
        }
        if (entityStorage == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(3);
        }
        Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(entity.getSymbolicId(), ContentRootIndexableEntityProvider.collectRootUrls(entity.getContentRoots()));
        if (collection == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getAddedEntityIteratorBuilders(@NotNull ContentRootEntity entity, @NotNull Project project2) {
        if (entity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(6);
        }
        Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(entity.getModule().getSymbolicId(), entity.getUrl());
        if (collection == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getReplacedEntityIteratorBuilders(@NotNull ContentRootEntity oldEntity, @NotNull ContentRootEntity newEntity2, @NotNull Project project2) {
        if (oldEntity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(8);
        }
        if (newEntity2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(10);
        }
        if (!newEntity2.getExcludedPatterns().equals(oldEntity.getExcludedPatterns())) {
            Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(newEntity2.getModule().getSymbolicId(), newEntity2.getUrl());
            if (collection == null) {
                ContentRootIndexableEntityProvider.$$$reportNull$$$0(11);
            }
            return collection;
        }
        List<VirtualFileUrl> newExcludedUrls = ContainerUtil.map(newEntity2.getExcludedUrls(), o -> o.getUrl());
        List<VirtualFileUrl> oldExcludedUrls = ContainerUtil.map(oldEntity.getExcludedUrls(), o -> o.getUrl());
        if (!oldExcludedUrls.equals(newExcludedUrls)) {
            ArrayList<VirtualFileUrl> roots2 = new ArrayList<VirtualFileUrl>();
            for (VirtualFileUrl oldUrl : oldExcludedUrls) {
                boolean found2 = false;
                String oldPath = oldUrl.getUrl();
                for (VirtualFileUrl newUrl : newExcludedUrls) {
                    if (!VfsUtilCore.isEqualOrAncestor(newUrl.getUrl(), oldPath)) continue;
                    found2 = true;
                    break;
                }
                if (found2) continue;
                roots2.add(oldUrl);
            }
            Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(newEntity2.getModule().getSymbolicId(), roots2);
            if (collection == null) {
                ContentRootIndexableEntityProvider.$$$reportNull$$$0(12);
            }
            return collection;
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    static List<VirtualFileUrl> collectRootUrls(List<? extends ContentRootEntity> newContentRoots) {
        List<VirtualFileUrl> list2 = ContainerUtil.map(newContentRoots, o -> o.getUrl());
        if (list2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getRemovedEntityIteratorBuilders(@NotNull ContentRootEntity entity, @NotNull Project project2) {
        VirtualFile root;
        if (entity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(16);
        }
        if (!(entity.getExcludedPatterns().isEmpty() && entity.getExcludedUrls().isEmpty() || (root = ((VirtualFilePointer)entity.getUrl()).getFile()) == null || !ProjectFileIndex.getInstance(project2).isInContent(root))) {
            Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(entity.getModule().getSymbolicId(), entity.getUrl());
            if (collection == null) {
                ContentRootIndexableEntityProvider.$$$reportNull$$$0(17);
            }
            return collection;
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    private static Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getReplacedParentEntityIteratorBuilder(@NotNull ModuleEntity oldEntity, @NotNull ModuleEntity newEntity2) {
        if (oldEntity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(19);
        }
        if (newEntity2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(20);
        }
        List<VirtualFileUrl> newRoots = ContentRootIndexableEntityProvider.collectRootUrls(newEntity2.getContentRoots());
        List<VirtualFileUrl> oldRoots = ContentRootIndexableEntityProvider.collectRootUrls(oldEntity.getContentRoots());
        Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(newEntity2.getSymbolicId(), newRoots, oldRoots);
        if (collection == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(21);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 8, 9, 10, 15, 16, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/roots/ContentRootIndexableEntityProvider";
                break;
            }
            case 1: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityStorage";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldEntity";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/roots/ContentRootIndexableEntityProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorBuildersForExistingModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedEntityIteratorBuilders";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacedEntityIteratorBuilders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRootUrls";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedEntityIteratorBuilders";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacedParentEntityIteratorBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorBuildersForExistingModule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAddedEntityIteratorBuilders";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReplacedEntityIteratorBuilders";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRemovedEntityIteratorBuilders";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getReplacedParentEntityIteratorBuilder";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 5, 6, 8, 9, 10, 15, 16, 19, 20 -> new IllegalArgumentException(string2);
        };
    }
}

