/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.indexing.IndexableFilesIndex;
import com.intellij.util.indexing.dependenciesCache.DependenciesIndexedStatusService;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesContributor;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.SdkIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.StandardContributorsKt;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/util/indexing/roots/DefaultProjectIndexableFilesContributor;", "Lcom/intellij/util/indexing/roots/IndexableFilesContributor;", "()V", "getIndexableFiles", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "project", "Lcom/intellij/openapi/project/Project;", "getOwnFilePredicate", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nstandardContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 standardContributors.kt\ncom/intellij/util/indexing/roots/DefaultProjectIndexableFilesContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class DefaultProjectIndexableFilesContributor
implements IndexableFilesContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public List<IndexableFilesIterator> getIndexableFiles(@NotNull Project project2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean bl2 = bl = !IndexableFilesIndex.isEnabled();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DefaultProjectIndexableFilesContributor$getIndexableFiles$22 = false;
            String $i$a$-assert-DefaultProjectIndexableFilesContributor$getIndexableFiles$22 = "Shouldn't be used with IndexableFilesIndex fully enabled";
            throw new AssertionError((Object)$i$a$-assert-DefaultProjectIndexableFilesContributor$getIndexableFiles$22);
        }
        List providers = null;
        if (StandardContributorsKt.shouldIndexProjectBasedOnIndexableEntityProviders()) {
            List builders = new ArrayList();
            EntityStorageSnapshot entityStorage = WorkspaceModel.Companion.getInstance(project2).getCurrentSnapshot();
            for (IndexableEntityProvider<? extends WorkspaceEntity> provider2 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
                if (!(provider2 instanceof IndexableEntityProvider.Existing)) continue;
                DefaultProjectIndexableFilesContributor.Companion.addIteratorBuildersFromProvider((IndexableEntityProvider.Existing)provider2, (EntityStorage)entityStorage, project2, builders);
                ProgressManager.checkCanceled();
            }
            providers = IndexableIteratorBuilders.INSTANCE.instantiateBuilders(builders, project2, (EntityStorage)entityStorage);
        } else {
            Set seenLibraries = new HashSet();
            Set seenSdks = new HashSet();
            Module[] modules2 = ModuleManager.Companion.getInstance(project2).getSortedModules();
            List providersCollection = new ArrayList();
            for (Module module2 : modules2) {
                OrderEntry[] orderEntries;
                providersCollection.addAll(ModuleIndexableFilesIteratorImpl.Companion.getModuleIterators(module2));
                Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance(module2).getOrderEntries(), (String)"getInstance(module).orderEntries");
                for (OrderEntry orderEntry2 : orderEntries) {
                    Sdk sdk2;
                    OrderEntry orderEntry3 = orderEntry2;
                    if (orderEntry3 instanceof LibraryOrderEntry) {
                        Library library = ((LibraryOrderEntry)orderEntry2).getLibrary();
                        if (library == null || !seenLibraries.add(library)) continue;
                        UtilKt.addIfNotNull(providersCollection, LibraryIndexableFilesIteratorImpl.Companion.createIterator$default(LibraryIndexableFilesIteratorImpl.Companion, library, null, null, 6, null));
                        continue;
                    }
                    if (!(orderEntry3 instanceof JdkOrderEntry) || (sdk2 = ((JdkOrderEntry)orderEntry2).getJdk()) == null || !seenSdks.add(sdk2)) continue;
                    providersCollection.add(SdkIndexableFilesIteratorImpl.Companion.createIterator(sdk2));
                }
            }
            providers = providersCollection;
        }
        if (DependenciesIndexedStatusService.shouldBeUsed()) {
            DependenciesIndexedStatusService dependenciesIndexedStatusService = DependenciesIndexedStatusService.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)dependenciesIndexedStatusService, (String)"getInstance(project)");
            DependenciesIndexedStatusService cacheService = dependenciesIndexedStatusService;
            if (cacheService.shouldSaveStatus()) {
                cacheService.saveExcludePolicies();
            }
        }
        return providers;
    }

    @NotNull
    public Predicate<VirtualFile> getOwnFilePredicate(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(project)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        IndexableFilesIndex indexableFilesIndex = IndexableFilesIndex.isEnabled() ? IndexableFilesIndex.getInstance((Project)project2) : null;
        return arg_0 -> DefaultProjectIndexableFilesContributor.getOwnFilePredicate$lambda$1(project2, indexableFilesIndex, projectFileIndex2, arg_0);
    }

    private static final boolean getOwnFilePredicate$lambda$1(Project $project, IndexableFilesIndex $indexableFilesIndex, ProjectFileIndex $projectFileIndex, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$projectFileIndex, (String)"$projectFileIndex");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (LightEdit.owns((Project)$project)) {
            return false;
        }
        if ($indexableFilesIndex != null) {
            return $indexableFilesIndex.shouldBeIndexed(it);
        }
        return $projectFileIndex.isInContent(it) || $projectFileIndex.isInLibrary(it) ? !FileTypeManager.getInstance().isFileIgnored(it) : false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/indexing/roots/DefaultProjectIndexableFilesContributor$Companion;", "", "()V", "addIteratorBuildersFromProvider", "", "E", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "provider", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$Existing;", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "iterators", "", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$IndexableIteratorBuilder;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final <E extends WorkspaceEntity> void addIteratorBuildersFromProvider(IndexableEntityProvider.Existing<E> provider2, EntityStorage entityStorage, Project project2, List<IndexableEntityProvider.IndexableIteratorBuilder> iterators) {
            Class clazz = provider2.getEntityClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"provider.entityClass");
            Class entityClass = clazz;
            for (WorkspaceEntity entity : entityStorage.entities(entityClass)) {
                Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = provider2.getExistingEntityIteratorBuilder(entity, project2);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"provider.getExistingEnti\u2026rBuilder(entity, project)");
                iterators.addAll(collection);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

