/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.origin.ExternalEntityOriginImpl;
import com.intellij.workspaceModel.storage.EntityReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB-\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/indexing/roots/ExternalWorkspaceEntityIteratorImpl;", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "reference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceRoots", "(Lcom/intellij/workspaceModel/storage/EntityReference;Ljava/util/Collection;Ljava/util/Collection;)V", "allRoots", "getAllRoots", "()Ljava/util/Collection;", "getDebugName", "", "getIndexingProgressText", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/IndexableSetOrigin;", "getRootUrls", "", "project", "Lcom/intellij/openapi/project/Project;", "getRootsScanningProgressText", "iterateFiles", "", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nExternalWorkspaceEntityIteratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalWorkspaceEntityIteratorImpl.kt\ncom/intellij/util/indexing/roots/ExternalWorkspaceEntityIteratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1549#2:46\n1620#2,3:47\n*S KotlinDebug\n*F\n+ 1 ExternalWorkspaceEntityIteratorImpl.kt\ncom/intellij/util/indexing/roots/ExternalWorkspaceEntityIteratorImpl\n*L\n38#1:46\n38#1:47,3\n*E\n"})
public final class ExternalWorkspaceEntityIteratorImpl
implements IndexableFilesIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityReference<?> reference;
    @NotNull
    private final Collection<VirtualFile> roots;
    @NotNull
    private final Collection<VirtualFile> sourceRoots;

    public ExternalWorkspaceEntityIteratorImpl(@NotNull EntityReference<?> reference2, @NotNull Collection<? extends VirtualFile> roots2, @NotNull Collection<? extends VirtualFile> sourceRoots) {
        Intrinsics.checkNotNullParameter(reference2, (String)"reference");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        this.reference = reference2;
        this.roots = roots2;
        this.sourceRoots = sourceRoots;
    }

    @NotNull
    public String getDebugName() {
        return "External roots from entity (" + Companion.getRootsDebugStr(this.roots) + ", " + Companion.getRootsDebugStr(this.sourceRoots) + ")";
    }

    @NotNull
    public String getIndexingProgressText() {
        String string2 = IndexingBundle.message((String)"indexable.files.provider.indexing.additional.dependencies", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026additional.dependencies\")");
        return string2;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        String string2 = IndexingBundle.message((String)"indexable.files.provider.scanning.additional.dependencies", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026additional.dependencies\")");
        return string2;
    }

    @NotNull
    public IndexableSetOrigin getOrigin() {
        return new ExternalEntityOriginImpl(this.reference, this.roots, this.sourceRoots);
    }

    public boolean iterateFiles(@NotNull Project project2, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        return IndexableFilesIterationMethods.iterateRoots$default(IndexableFilesIterationMethods.INSTANCE, project2, this.getAllRoots(), fileIterator, fileFilter, false, 16, null);
    }

    private final Collection<VirtualFile> getAllRoots() {
        return CollectionsKt.plus(this.roots, (Iterable)this.sourceRoots);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getRootUrls(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$map$iv = this.getAllRoots();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/util/indexing/roots/ExternalWorkspaceEntityIteratorImpl$Companion;", "", "()V", "getRootsDebugStr", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nExternalWorkspaceEntityIteratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalWorkspaceEntityIteratorImpl.kt\ncom/intellij/util/indexing/roots/ExternalWorkspaceEntityIteratorImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1549#2:46\n1620#2,3:47\n*S KotlinDebug\n*F\n+ 1 ExternalWorkspaceEntityIteratorImpl.kt\ncom/intellij/util/indexing/roots/ExternalWorkspaceEntityIteratorImpl$Companion\n*L\n43#1:46\n43#1:47,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String getRootsDebugStr(@NotNull Collection<? extends VirtualFile> files2) {
            String string2;
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            if (files2.isEmpty()) {
                string2 = "empty";
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = files2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                string2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)", ", null, null, (int)3, null, null, (int)54, null);
            }
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

