/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableFilesIndex;
import com.intellij.util.indexing.roots.ExternalWorkspaceEntityIteratorImpl;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ModuleUnawareContentEntityIteratorImpl;
import com.intellij.util.indexing.roots.SdkIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.StandardContributorsKt;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0004J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0017\u001a\u00020\u0014J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0011\u001a\u00020\u001dJ \u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/util/indexing/roots/IndexableEntityProviderMethods;", "", "()V", "createExternalEntityIterators", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "reference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceRoots", "createIterators", "module", "Lcom/intellij/openapi/module/Module;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "entity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "createLibraryIterators", "name", "", "createModuleUnawareContentEntityIterators", "getExcludedFiles", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ContentRootEntity;", "getLibIteratorsByName", "libraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIndexableEntityProviderMethods.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexableEntityProviderMethods.kt\ncom/intellij/util/indexing/roots/IndexableEntityProviderMethods\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class IndexableEntityProviderMethods {
    @NotNull
    public static final IndexableEntityProviderMethods INSTANCE = new IndexableEntityProviderMethods();

    private IndexableEntityProviderMethods() {
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull ModuleEntity entity, @NotNull List<? extends VirtualFile> roots2, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (roots2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ModuleBridge moduleBridge = ModuleEntityUtils.findModule(entity, storage);
        if (moduleBridge == null) {
            return CollectionsKt.emptyList();
        }
        ModuleBridge module2 = moduleBridge;
        return this.createIterators(module2, roots2);
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull Module module2, @NotNull List<? extends VirtualFile> roots2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        return SetsKt.setOf((Object)new ModuleIndexableFilesIteratorImpl(module2, roots2, true));
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull ModuleEntity entity, @NotNull EntityStorage entityStorage, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (StandardContributorsKt.shouldIndexProjectBasedOnIndexableEntityProviders()) {
            if (IndexableFilesIndex.isEnabled()) {
                Collection collection = IndexableFilesIndex.getInstance((Project)project2).getModuleIndexingIterators(entity, entityStorage);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getInstance(project).get\u2026rs(entity, entityStorage)");
                return collection;
            }
            List builders = new ArrayList();
            for (IndexableEntityProvider<? extends WorkspaceEntity> provider2 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
                if (!(provider2 instanceof IndexableEntityProvider.Existing)) continue;
                Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = ((IndexableEntityProvider.Existing)provider2).getIteratorBuildersForExistingModule(entity, entityStorage, project2);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"provider.getIteratorBuil\u2026, entityStorage, project)");
                builders.addAll(collection);
            }
            return IndexableIteratorBuilders.INSTANCE.instantiateBuilders(builders, project2, entityStorage);
        }
        ModuleBridge module2 = ModuleEntityUtils.findModule(entity, entityStorage);
        if (module2 == null) {
            return CollectionsKt.emptyList();
        }
        return ModuleIndexableFilesIteratorImpl.Companion.getModuleIterators(module2);
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return CollectionsKt.listOf((Object)SdkIndexableFilesIteratorImpl.Companion.createIterator(sdk2));
    }

    private final List<IndexableFilesIterator> getLibIteratorsByName(LibraryTable libraryTable, String name) {
        List<IndexableFilesIterator> list2;
        Library library = libraryTable.getLibraryByName(name);
        if (library != null) {
            Library $this$getLibIteratorsByName_u24lambda_u240 = library;
            boolean bl = false;
            list2 = LibraryIndexableFilesIteratorImpl.Companion.createIteratorList($this$getLibIteratorsByName_u24lambda_u240);
        } else {
            list2 = null;
        }
        return list2;
    }

    @NotNull
    public final List<IndexableFilesIterator> createLibraryIterators(@NotNull String name, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return (List)ActionsKt.runReadAction((Function0)new Function0<List<? extends IndexableFilesIterator>>(name, project2){
            final /* synthetic */ String $name;
            final /* synthetic */ Project $project;
            {
                this.$name = $name;
                this.$project = $project;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final List<IndexableFilesIterator> invoke() {
                Object object;
                Object v1;
                List<IndexableFilesIterator> list2;
                EntityStorageSnapshot storage;
                block6: {
                    LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
                    LibraryTable libraryTable = registrar.getLibraryTable();
                    Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"registrar.libraryTable");
                    List list3 = IndexableEntityProviderMethods.access$getLibIteratorsByName(IndexableEntityProviderMethods.INSTANCE, libraryTable, this.$name);
                    if (list3 != null) {
                        return list3;
                    }
                    for (LibraryTable customLibraryTable : registrar.getCustomLibraryTables()) {
                        Intrinsics.checkNotNullExpressionValue((Object)customLibraryTable, (String)"customLibraryTable");
                        List list4 = IndexableEntityProviderMethods.access$getLibIteratorsByName(IndexableEntityProviderMethods.INSTANCE, customLibraryTable, this.$name);
                        if (list4 == null) continue;
                        return list4;
                    }
                    storage = WorkspaceModel.Companion.getInstance(this.$project).getCurrentSnapshot();
                    Sequence sequence = storage.entities(LibraryEntity.class);
                    list2 = this.$name;
                    boolean bl = false;
                    for (E element$iv : sequence) {
                        LibraryEntity it = (LibraryEntity)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)list2)) continue;
                        v1 = element$iv;
                        break block6;
                    }
                    v1 = null;
                }
                LibraryEntity libraryEntity = v1;
                if (libraryEntity != null) {
                    LibraryEntity libraryEntity2 = libraryEntity;
                    boolean bl = false;
                    LibraryBridge libraryBridge = (LibraryBridge)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap((EntityStorage)storage).getDataByEntity((WorkspaceEntity)libraryEntity2);
                    if (libraryBridge != null) {
                        LibraryBridge $this$invoke_u24lambda_u244 = libraryBridge;
                        boolean bl3 = false;
                        list2 = LibraryIndexableFilesIteratorImpl.Companion.createIteratorList($this$invoke_u24lambda_u244);
                        if (list2 != null) {
                            object = list2;
                            return object;
                        }
                    }
                }
                object = CollectionsKt.emptyList();
                return object;
            }
        });
    }

    @NotNull
    public final List<VirtualFile> getExcludedFiles(@NotNull ContentRootEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        List<VirtualFile> list2 = ContainerUtil.mapNotNull(entity.getExcludedUrls(), arg_0 -> IndexableEntityProviderMethods.getExcludedFiles$lambda$1(getExcludedFiles.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"mapNotNull(entity.exclud\u2026> param.url.virtualFile }");
        return list2;
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createExternalEntityIterators(@NotNull EntityReference<?> reference2, @NotNull Collection<? extends VirtualFile> roots2, @NotNull Collection<? extends VirtualFile> sourceRoots) {
        Intrinsics.checkNotNullParameter(reference2, (String)"reference");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        if (roots2.isEmpty() && sourceRoots.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new ExternalWorkspaceEntityIteratorImpl(reference2, roots2, sourceRoots));
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createModuleUnawareContentEntityIterators(@NotNull EntityReference<?> reference2, @NotNull Collection<? extends VirtualFile> roots2) {
        Intrinsics.checkNotNullParameter(reference2, (String)"reference");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        if (roots2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new ModuleUnawareContentEntityIteratorImpl(reference2, roots2));
    }

    private static final VirtualFile getExcludedFiles$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VirtualFile)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getLibIteratorsByName(IndexableEntityProviderMethods $this, LibraryTable libraryTable, String name) {
        return $this.getLibIteratorsByName(libraryTable, name);
    }
}

