/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.IndexableFilesIndex;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.dependenciesCache.DependenciesIndexedStatusService;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.IndexableSetContributorFilesIterator;
import com.intellij.util.indexing.roots.IndexingRootsCollectionUtil;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.SyntheticLibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleContentOrSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetVisitor;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyIndex;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
@ApiStatus.Internal
public class IndexableFilesIndexImpl
implements IndexableFilesIndex {
    @NotNull
    private final Project project;
    private final AdditionalIndexableFileSet filesFromIndexableSetContributors;

    @NotNull
    public static IndexableFilesIndexImpl getInstanceImpl(@NotNull Project project2) {
        if (project2 == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(0);
        }
        IndexableFilesIndexImpl indexableFilesIndexImpl = (IndexableFilesIndexImpl)IndexableFilesIndex.getInstance((Project)project2);
        if (indexableFilesIndexImpl == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(1);
        }
        return indexableFilesIndexImpl;
    }

    public IndexableFilesIndexImpl(@NotNull Project project2) {
        if (project2 == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(2);
        }
        this.project = project2;
        this.filesFromIndexableSetContributors = new AdditionalIndexableFileSet(project2);
    }

    public boolean shouldBeIndexed(@NotNull VirtualFile file2) {
        if (file2 == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(3);
        }
        if (WorkspaceFileIndex.getInstance(this.project).isInWorkspace(file2)) {
            return true;
        }
        return this.filesFromIndexableSetContributors.isInSet(file2);
    }

    @NotNull
    public List<IndexableFilesIterator> getIndexingIterators() {
        List list2 = ReadAction.nonBlocking(this::doGetIndexingIterators).expireWith(this.project).executeSynchronously();
        if (list2 == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    private List<IndexableFilesIterator> doGetIndexingIterators() {
        DependenciesIndexedStatusService cacheService;
        Object projectSdk;
        EntityStorage entityStorage = WorkspaceModel.getInstance(this.project).getEntityStorage().getCurrent();
        ArrayList<IndexableFilesIterator> iterators = new ArrayList<IndexableFilesIterator>();
        ArrayList<Object> sdks = new ArrayList<Object>();
        ModuleDependencyIndex moduleDependencyIndex = ModuleDependencyIndex.getInstance(this.project);
        for (Sdk sdk2 : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!moduleDependencyIndex.hasDependencyOn(sdk2)) continue;
            sdks.add(sdk2);
        }
        if (sdks.isEmpty() && (projectSdk = ProjectRootManager.getInstance(this.project).getProjectSdk()) != null) {
            sdks.add(projectSdk);
        }
        for (Sdk sdk2 : sdks) {
            ProgressManager.checkCanceled();
            iterators.addAll(IndexableEntityProviderMethods.INSTANCE.createIterators(sdk2));
        }
        HashSet<IndexableSetOrigin> libraryOrigins = new HashSet<IndexableSetOrigin>();
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Sequence libs = SequencesKt.asSequence(libraryTablesRegistrar.getCustomLibraryTables().iterator());
        libs = SequencesKt.plus((Sequence)libs, (Object)libraryTablesRegistrar.getLibraryTable());
        for (LibraryTable libraryTable : SequencesKt.asIterable((Sequence)libs)) {
            for (Library library : libraryTable.getLibraries()) {
                ProgressManager.checkCanceled();
                if (!moduleDependencyIndex.hasDependencyOn(library)) continue;
                for (IndexableFilesIterator iterator2 : LibraryIndexableFilesIteratorImpl.Companion.createIteratorList(library)) {
                    if (!libraryOrigins.add(iterator2.getOrigin())) continue;
                    iterators.add(iterator2);
                }
            }
        }
        IndexingRootsCollectionUtil.IndexingRootsDescriptions descriptions = IndexingRootsCollectionUtil.collectRootsFromWorkspaceFileIndexContributors(this.project, entityStorage, null);
        IndexingRootsCollectionUtil.addIteratorsFromRootsDescriptions(descriptions, iterators, libraryOrigins, entityStorage);
        boolean addedFromDependenciesIndexedStatusService = false;
        if (DependenciesIndexedStatusService.shouldBeUsed() && (cacheService = DependenciesIndexedStatusService.getInstance(this.project)).shouldSaveStatus()) {
            addedFromDependenciesIndexedStatusService = true;
            ProgressManager.checkCanceled();
            iterators.addAll(cacheService.saveIndexableSetsAndInstantiateIterators());
            ProgressManager.checkCanceled();
            iterators.addAll(cacheService.saveLibsAndInstantiateLibraryIterators());
            cacheService.saveExcludePolicies();
        }
        if (!addedFromDependenciesIndexedStatusService) {
            for (AdditionalLibraryRootsProvider provider2 : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
                for (SyntheticLibrary syntheticLibrary : provider2.getAdditionalProjectLibraries(this.project)) {
                    iterators.add((IndexableFilesIterator)new SyntheticLibraryIndexableFilesIteratorImpl(syntheticLibrary));
                }
            }
            for (IndexableSetContributor contributor : IndexableSetContributor.EP_NAME.getExtensionList()) {
                iterators.add(new IndexableSetContributorFilesIterator(contributor, this.project));
                iterators.add(new IndexableSetContributorFilesIterator(contributor));
            }
        }
        ArrayList<IndexableFilesIterator> arrayList = iterators;
        if (arrayList == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public Collection<IndexableFilesIterator> getModuleIndexingIterators(@NotNull ModuleEntity entity, @NotNull EntityStorage entityStorage) {
        ModuleBridge module2;
        if (entity == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(6);
        }
        if (entityStorage == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(7);
        }
        if ((module2 = ModuleEntityUtils.findModule(entity, entityStorage)) == null) {
            List<IndexableFilesIterator> list2 = Collections.emptyList();
            if (list2 == null) {
                IndexableFilesIndexImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List<VirtualFile> roots2 = this.getModuleRootsToIndex(module2);
        if (roots2.isEmpty()) {
            List<IndexableFilesIterator> list3 = Collections.emptyList();
            if (list3 == null) {
                IndexableFilesIndexImpl.$$$reportNull$$$0(9);
            }
            return list3;
        }
        List<ModuleIndexableFilesIteratorImpl> list4 = Collections.singletonList(new ModuleIndexableFilesIteratorImpl(module2, roots2, true));
        if (list4 == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(10);
        }
        return list4;
    }

    @NotNull
    private List<VirtualFile> getModuleRootsToIndex(final @NotNull Module module2) {
        if (module2 == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(11);
        }
        List roots2 = ReadAction.nonBlocking(() -> {
            if (this.project.isDisposed()) {
                return null;
            }
            WorkspaceFileIndexEx index2 = (WorkspaceFileIndexEx)WorkspaceFileIndex.getInstance(this.project);
            final SmartList files2 = new SmartList();
            index2.visitFileSets(new WorkspaceFileSetVisitor(){

                @Override
                public void visitIncludedRoot(@NotNull WorkspaceFileSet fileSet) {
                    if (fileSet == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!(fileSet instanceof WorkspaceFileSetWithCustomData)) {
                        return;
                    }
                    ModuleContentOrSourceRootData data2 = ObjectUtils.tryCast(((WorkspaceFileSetWithCustomData)fileSet).getData(), ModuleContentOrSourceRootData.class);
                    if (data2 != null && data2.getModule().equals(module2)) {
                        files2.add(fileSet.getRoot());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/util/indexing/roots/IndexableFilesIndexImpl$1", "visitIncludedRoot"));
                }
            });
            return files2;
        }).executeSynchronously();
        List<VirtualFile> list2 = IndexingRootsCollectionUtil.optimizeRoots(roots2);
        if (list2 == null) {
            IndexableFilesIndexImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 8, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/roots/IndexableFilesIndexImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityStorage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/roots/IndexableFilesIndexImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingIterators";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetIndexingIterators";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleIndexingIterators";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRootsToIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceImpl";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeIndexed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleIndexingIterators";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRootsToIndex";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4, 5, 8, 9, 10, 12 -> new IllegalStateException(string2);
        };
    }
}

