/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.TreeNodeProcessingResult;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0004J:\u0010\u0012\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\u0004J.\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J.\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/intellij/util/indexing/roots/IndexableFilesIterationMethods;", "", "()V", "followSymlinks", "", "getFollowSymlinks", "()Z", "iterateRoots", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "contentIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "excludeNonProjectRoots", "iterateRootsIndependentlyFromProjectFileIndex", "exclusionCondition", "Ljava/util/function/Predicate;", "iterateAsContent", "shouldIndexFile", "file", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "rootsSet", "", "shouldIndexFileIndependentlyFromProjectFileIndex", "toContentIteratorEx", "Lcom/intellij/openapi/roots/ContentIteratorEx;", "processor", "intellij.platform.lang.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIndexableFilesIterationMethods.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexableFilesIterationMethods.kt\ncom/intellij/util/indexing/roots/IndexableFilesIterationMethods\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1726#2,3:153\n1726#2,3:156\n1726#2,3:159\n*S KotlinDebug\n*F\n+ 1 IndexableFilesIterationMethods.kt\ncom/intellij/util/indexing/roots/IndexableFilesIterationMethods\n*L\n36#1:153,3\n85#1:156,3\n91#1:159,3\n*E\n"})
public final class IndexableFilesIterationMethods {
    @NotNull
    public static final IndexableFilesIterationMethods INSTANCE = new IndexableFilesIterationMethods();

    private IndexableFilesIterationMethods() {
    }

    private final boolean getFollowSymlinks() {
        return Registry.is("indexer.follows.symlinks");
    }

    public final boolean iterateRoots(@NotNull Project project2, @NotNull Iterable<? extends VirtualFile> roots2, @NotNull ContentIterator contentIterator, @NotNull VirtualFileFilter fileFilter, boolean excludeNonProjectRoots) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(roots2, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)contentIterator, (String)"contentIterator");
            Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(project)");
            ProjectFileIndex projectFileIndex2 = projectFileIndex;
            Set rootsSet = CollectionsKt.toSet(roots2);
            VirtualFileFilter virtualFileFilter = fileFilter.and(arg_0 -> IndexableFilesIterationMethods.iterateRoots$lambda$0(projectFileIndex2, rootsSet, excludeNonProjectRoots, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileFilter, (String)"fileFilter.and { shouldI\u2026excludeNonProjectRoots) }");
            VirtualFileFilter finalFileFilter = virtualFileFilter;
            Iterable<? extends VirtualFile> $this$all$iv = roots2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator<? extends VirtualFile> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    VirtualFile element$iv;
                    VirtualFile root = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (VfsUtilCore.iterateChildrenRecursively(root, finalFileFilter, contentIterator)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean iterateRoots$default(IndexableFilesIterationMethods indexableFilesIterationMethods, Project project2, Iterable iterable, ContentIterator contentIterator, VirtualFileFilter virtualFileFilter, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return indexableFilesIterationMethods.iterateRoots(project2, iterable, contentIterator, virtualFileFilter, bl);
    }

    private final boolean shouldIndexFile(VirtualFile file2, ProjectFileIndex projectFileIndex, Set<? extends VirtualFile> rootsSet, boolean excludeNonProjectRoots) {
        if (file2.is(VFileProperty.SYMLINK)) {
            if (!this.getFollowSymlinks()) {
                return false;
            }
            VirtualFile targetFile = file2.getCanonicalFile();
            if (targetFile == null || targetFile.is(VFileProperty.SYMLINK)) {
                return false;
            }
            if (rootsSet.contains(file2)) {
                return true;
            }
            return this.shouldIndexFile(targetFile, projectFileIndex, rootsSet, excludeNonProjectRoots);
        }
        if (!(file2 instanceof VirtualFileWithId) || ((VirtualFileWithId)((Object)file2)).getId() <= 0) {
            return false;
        }
        return !excludeNonProjectRoots || (Boolean)ActionsKt.runReadAction((Function0)new Function0<Boolean>(projectFileIndex, file2){
            final /* synthetic */ ProjectFileIndex $projectFileIndex;
            final /* synthetic */ VirtualFile $file;
            {
                this.$projectFileIndex = $projectFileIndex;
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$projectFileIndex.isExcluded(this.$file);
            }
        }) == false;
    }

    public final boolean iterateRootsIndependentlyFromProjectFileIndex(@NotNull Iterable<? extends VirtualFile> roots2, @NotNull ContentIterator contentIterator, @NotNull VirtualFileFilter fileFilter, @NotNull Predicate<VirtualFile> exclusionCondition, boolean iterateAsContent) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter(roots2, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)contentIterator, (String)"contentIterator");
            Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
            Intrinsics.checkNotNullParameter(exclusionCondition, (String)"exclusionCondition");
            FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
            if (!iterateAsContent) {
                boolean bl2;
                block7: {
                    Set rootsSet = CollectionsKt.toSet(roots2);
                    VirtualFileFilter virtualFileFilter = fileFilter.and(arg_0 -> IndexableFilesIterationMethods.iterateRootsIndependentlyFromProjectFileIndex$lambda$2(fileTypeRegistry, roots2, arg_0)).and(arg_0 -> IndexableFilesIterationMethods.iterateRootsIndependentlyFromProjectFileIndex$lambda$3(rootsSet, exclusionCondition, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileFilter, (String)"fileFilter.and {\n       \u2026clusionCondition)\n      }");
                    VirtualFileFilter finalFileFilter = virtualFileFilter;
                    Iterable<? extends VirtualFile> $this$all$iv = roots2;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        Iterator<? extends VirtualFile> iterator2 = $this$all$iv.iterator();
                        while (iterator2.hasNext()) {
                            VirtualFile element$iv;
                            VirtualFile root = element$iv = iterator2.next();
                            boolean bl3 = false;
                            if (VfsUtilCore.iterateChildrenRecursively(root, finalFileFilter, contentIterator)) continue;
                            bl2 = false;
                            break block7;
                        }
                        bl2 = true;
                    }
                }
                return bl2;
            }
            ContentIteratorEx contentIteratorEx = this.toContentIteratorEx(contentIterator);
            Set rootsSet = CollectionsKt.toSet(roots2);
            Iterable<? extends VirtualFile> $this$all$iv = roots2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator<? extends VirtualFile> iterator3 = $this$all$iv.iterator();
                while (iterator3.hasNext()) {
                    VirtualFileVisitor.Result result2;
                    VirtualFile element$iv;
                    VirtualFile root = element$iv = iterator3.next();
                    boolean bl4 = false;
                    VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor<Unit>(exclusionCondition, fileTypeRegistry, roots2, fileFilter, (Set<? extends VirtualFile>)rootsSet, contentIteratorEx, root, optionArray){
                        final /* synthetic */ Predicate<VirtualFile> $exclusionCondition;
                        final /* synthetic */ FileTypeRegistry $fileTypeRegistry;
                        final /* synthetic */ Iterable<VirtualFile> $roots;
                        final /* synthetic */ VirtualFileFilter $fileFilter;
                        final /* synthetic */ Set<VirtualFile> $rootsSet;
                        final /* synthetic */ ContentIteratorEx $contentIteratorEx;
                        final /* synthetic */ VirtualFile $root;
                        {
                            this.$exclusionCondition = $exclusionCondition;
                            this.$fileTypeRegistry = $fileTypeRegistry;
                            this.$roots = $roots;
                            this.$fileFilter = $fileFilter;
                            this.$rootsSet = $rootsSet;
                            this.$contentIteratorEx = $contentIteratorEx;
                            this.$root = $root;
                            super($super_call_param$1);
                        }

                        @NotNull
                        public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                            VirtualFileVisitor.Result result2;
                            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                            if (this.$exclusionCondition.test(file2)) {
                                VirtualFileVisitor.Result result3 = VirtualFileVisitor.SKIP_CHILDREN;
                                Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"SKIP_CHILDREN");
                                return result3;
                            }
                            if (this.$fileTypeRegistry.isFileIgnored(file2) && !CollectionsKt.contains(this.$roots, (Object)file2)) {
                                VirtualFileVisitor.Result result4 = VirtualFileVisitor.SKIP_CHILDREN;
                                Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"SKIP_CHILDREN");
                                return result4;
                            }
                            boolean accepted2 = this.$fileFilter.accept(file2) && IndexableFilesIterationMethods.access$shouldIndexFileIndependentlyFromProjectFileIndex(IndexableFilesIterationMethods.INSTANCE, file2, this.$rootsSet, null);
                            TreeNodeProcessingResult treeNodeProcessingResult = accepted2 ? this.$contentIteratorEx.processFileEx(file2) : TreeNodeProcessingResult.CONTINUE;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)treeNodeProcessingResult), (String)"if (accepted) contentIte\u2026ProcessingResult.CONTINUE");
                            TreeNodeProcessingResult status = treeNodeProcessingResult;
                            switch (iterateRootsIndependentlyFromProjectFileIndex.2.result.WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                                case 1: {
                                    VirtualFileVisitor.Result result5 = VirtualFileVisitor.CONTINUE;
                                    result2 = result5;
                                    Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"CONTINUE");
                                    break;
                                }
                                case 2: {
                                    VirtualFileVisitor.Result result6 = VirtualFileVisitor.SKIP_CHILDREN;
                                    result2 = result6;
                                    Intrinsics.checkNotNullExpressionValue((Object)result6, (String)"SKIP_CHILDREN");
                                    break;
                                }
                                case 3: {
                                    VirtualFileVisitor.Result result7 = VirtualFileVisitor.skipTo(file2.getParent());
                                    result2 = result7;
                                    Intrinsics.checkNotNullExpressionValue((Object)result7, (String)"skipTo(file.parent)");
                                    break;
                                }
                                case 4: {
                                    VirtualFileVisitor.Result result8 = VirtualFileVisitor.skipTo(this.$root);
                                    result2 = result8;
                                    Intrinsics.checkNotNullExpressionValue((Object)result8, (String)"skipTo(root)");
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            return result2;
                        }
                    }), (String)"roots: Iterable<VirtualF\u2026     }\n        }\n      })");
                    if (!Comparing.equal(result2.skipToParent, root)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final ContentIteratorEx toContentIteratorEx(ContentIterator processor) {
        return processor instanceof ContentIteratorEx ? (ContentIteratorEx)processor : arg_0 -> IndexableFilesIterationMethods.toContentIteratorEx$lambda$6(processor, arg_0);
    }

    private final boolean shouldIndexFileIndependentlyFromProjectFileIndex(VirtualFile file2, Set<? extends VirtualFile> rootsSet, Predicate<VirtualFile> exclusionCondition) {
        if (file2.is(VFileProperty.SYMLINK)) {
            if (!this.getFollowSymlinks()) {
                return false;
            }
            VirtualFile targetFile = file2.getCanonicalFile();
            if (targetFile == null || targetFile.is(VFileProperty.SYMLINK)) {
                return false;
            }
            if (rootsSet.contains(file2)) {
                return true;
            }
            return this.shouldIndexFileIndependentlyFromProjectFileIndex(targetFile, rootsSet, exclusionCondition);
        }
        if (!(file2 instanceof VirtualFileWithId) || ((VirtualFileWithId)((Object)file2)).getId() <= 0) {
            return false;
        }
        Predicate<VirtualFile> predicate2 = exclusionCondition;
        return !(predicate2 != null ? predicate2.test(file2) : false);
    }

    private static final boolean iterateRoots$lambda$0(ProjectFileIndex $projectFileIndex, Set $rootsSet, boolean $excludeNonProjectRoots, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)$projectFileIndex, (String)"$projectFileIndex");
        Intrinsics.checkNotNullParameter((Object)$rootsSet, (String)"$rootsSet");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.shouldIndexFile(it, $projectFileIndex, $rootsSet, $excludeNonProjectRoots);
    }

    private static final boolean iterateRootsIndependentlyFromProjectFileIndex$lambda$2(FileTypeRegistry $fileTypeRegistry, Iterable $roots, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)$roots, (String)"$roots");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$fileTypeRegistry.isFileIgnored(it) || CollectionsKt.contains((Iterable)$roots, (Object)it);
    }

    private static final boolean iterateRootsIndependentlyFromProjectFileIndex$lambda$3(Set $rootsSet, Predicate $exclusionCondition, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)$rootsSet, (String)"$rootsSet");
        Intrinsics.checkNotNullParameter((Object)$exclusionCondition, (String)"$exclusionCondition");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.shouldIndexFileIndependentlyFromProjectFileIndex(it, $rootsSet, $exclusionCondition);
    }

    private static final TreeNodeProcessingResult toContentIteratorEx$lambda$6(ContentIterator $processor, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)$processor, (String)"$processor");
        VirtualFile virtualFile2 = fileOrDir;
        Intrinsics.checkNotNull((Object)virtualFile2);
        return $processor.processFile(virtualFile2) ? TreeNodeProcessingResult.CONTINUE : TreeNodeProcessingResult.STOP;
    }

    public static final /* synthetic */ boolean access$shouldIndexFileIndependentlyFromProjectFileIndex(IndexableFilesIterationMethods $this, VirtualFile file2, Set rootsSet, Predicate exclusionCondition) {
        return $this.shouldIndexFileIndependentlyFromProjectFileIndex(file2, rootsSet, exclusionCondition);
    }
}

