/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.origin.IndexableSetContributorOriginImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B5\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/indexing/roots/IndexableSetContributorFilesIterator;", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "indexableSetContributor", "Lcom/intellij/util/indexing/IndexableSetContributor;", "(Lcom/intellij/util/indexing/IndexableSetContributor;)V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/util/indexing/IndexableSetContributor;Lcom/intellij/openapi/project/Project;)V", "name", "", "debugName", "projectAware", "", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/lang/String;Ljava/lang/String;ZLjava/util/Set;Lcom/intellij/util/indexing/IndexableSetContributor;)V", "getDebugName", "getIndexingProgressText", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/IndexableSetOrigin;", "getRootUrls", "getRootsScanningProgressText", "iterateFiles", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIndexableSetContributorFilesIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexableSetContributorFilesIterator.kt\ncom/intellij/util/indexing/roots/IndexableSetContributorFilesIterator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1549#2:66\n1620#2,3:67\n*S KotlinDebug\n*F\n+ 1 IndexableSetContributorFilesIterator.kt\ncom/intellij/util/indexing/roots/IndexableSetContributorFilesIterator\n*L\n57#1:66\n57#1:67,3\n*E\n"})
public final class IndexableSetContributorFilesIterator
implements IndexableFilesIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String name;
    @NotNull
    private final String debugName;
    private final boolean projectAware;
    @NotNull
    private final Set<VirtualFile> roots;
    @NotNull
    private final IndexableSetContributor indexableSetContributor;

    public IndexableSetContributorFilesIterator(@Nullable String name, @NotNull String debugName, boolean projectAware, @NotNull Set<? extends VirtualFile> roots2, @NotNull IndexableSetContributor indexableSetContributor) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)indexableSetContributor, (String)"indexableSetContributor");
        this.name = name;
        this.debugName = debugName;
        this.projectAware = projectAware;
        this.roots = roots2;
        this.indexableSetContributor = indexableSetContributor;
    }

    public IndexableSetContributorFilesIterator(@NotNull IndexableSetContributor indexableSetContributor) {
        Intrinsics.checkNotNullParameter((Object)indexableSetContributor, (String)"indexableSetContributor");
        String string2 = IndexableSetContributorFilesIterator.Companion.getName(indexableSetContributor);
        String string3 = IndexableSetContributorFilesIterator.Companion.getDebugName(indexableSetContributor);
        Set set2 = indexableSetContributor.getAdditionalRootsToIndex();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"indexableSetContributor.additionalRootsToIndex");
        this(string2, string3, false, set2, indexableSetContributor);
    }

    public IndexableSetContributorFilesIterator(@NotNull IndexableSetContributor indexableSetContributor, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)indexableSetContributor, (String)"indexableSetContributor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string2 = IndexableSetContributorFilesIterator.Companion.getName(indexableSetContributor);
        String string3 = IndexableSetContributorFilesIterator.Companion.getDebugName(indexableSetContributor);
        Set set2 = indexableSetContributor.getAdditionalProjectRootsToIndex(project2);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"indexableSetContributor.\u2026jectRootsToIndex(project)");
        this(string2, string3, true, set2, indexableSetContributor);
    }

    @NotNull
    public String getDebugName() {
        return "Indexable set contributor '" + this.debugName + "' " + (this.projectAware ? "(project)" : "(non-project)");
    }

    @NotNull
    public String getIndexingProgressText() {
        CharSequence charSequence = this.name;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Object[] objectArray = new Object[]{this.name};
            String string2 = IndexingBundle.message((String)"indexable.files.provider.indexing.named.provider", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026ng.named.provider\", name)");
            return string2;
        }
        String string3 = IndexingBundle.message((String)"indexable.files.provider.indexing.additional.dependencies", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"indexable.files\u2026additional.dependencies\")");
        return string3;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        CharSequence charSequence = this.name;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Object[] objectArray = new Object[]{this.name};
            String string2 = IndexingBundle.message((String)"indexable.files.provider.scanning.files.contributor", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026files.contributor\", name)");
            return string2;
        }
        String string3 = IndexingBundle.message((String)"indexable.files.provider.scanning.additional.dependencies", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"indexable.files\u2026additional.dependencies\")");
        return string3;
    }

    @NotNull
    public IndexableSetOrigin getOrigin() {
        return (IndexableSetOrigin)new IndexableSetContributorOriginImpl(this.indexableSetContributor, this.roots);
    }

    public boolean iterateFiles(@NotNull Project project2, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        return IndexableFilesIterationMethods.INSTANCE.iterateRoots(project2, (Iterable<? extends VirtualFile>)this.roots, fileIterator, fileFilter, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getRootUrls(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$map$iv = this.roots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u000e\u0018\u00010\u0004\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/util/indexing/roots/IndexableSetContributorFilesIterator$Companion;", "", "()V", "getDebugName", "", "indexableSetContributor", "Lcom/intellij/util/indexing/IndexableSetContributor;", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/Nullable;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nIndexableSetContributorFilesIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexableSetContributorFilesIterator.kt\ncom/intellij/util/indexing/roots/IndexableSetContributorFilesIterator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getName(IndexableSetContributor indexableSetContributor) {
            ItemPresentation itemPresentation = indexableSetContributor instanceof ItemPresentation ? (ItemPresentation)indexableSetContributor : null;
            return itemPresentation != null ? itemPresentation.getPresentableText() : null;
        }

        private final String getDebugName(IndexableSetContributor indexableSetContributor) {
            String string2;
            block4: {
                block3: {
                    String string3;
                    string2 = this.getName(indexableSetContributor);
                    if (string2 == null) break block3;
                    String it = string3 = string2;
                    boolean bl = false;
                    string2 = !(((CharSequence)it).length() == 0) ? string3 : null;
                    if (string2 != null) break block4;
                }
                String string4 = indexableSetContributor.getDebugName();
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"indexableSetContributor.debugName");
            }
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

