/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleContentOrSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexImpl;
import com.intellij.workspaceModel.ide.VirtualFileUrls;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexingRootsCollectionUtil {
    private static final int ROOTS_SIZE_OPTIMISING_LIMIT = 1000;

    private IndexingRootsCollectionUtil() {
    }

    @NotNull
    public static IndexingRootsDescriptions collectRootsFromWorkspaceFileIndexContributors(@NotNull Project project2, @NotNull EntityStorage entityStorage, @Nullable IndexingRootsCollectionSettings settings) {
        if (project2 == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(0);
        }
        if (entityStorage == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(1);
        }
        List<WorkspaceFileIndexContributor<?>> contributors = ((WorkspaceFileIndexImpl)WorkspaceFileIndex.getInstance(project2)).getContributors();
        IndexingRootsDescriptions roots2 = new IndexingRootsDescriptions();
        RootsCollector registrar = new RootsCollector(settings);
        for (WorkspaceFileIndexContributor<?> contributor : contributors) {
            ProgressManager.checkCanceled();
            IndexingRootsCollectionUtil.handleContributor(contributor, roots2, registrar, entityStorage);
        }
        registrar.collectModuleAwareRoots(roots2);
        IndexingRootsDescriptions indexingRootsDescriptions = roots2;
        if (indexingRootsDescriptions == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(2);
        }
        return indexingRootsDescriptions;
    }

    private static <E extends WorkspaceEntity> void handleContributor(@NotNull WorkspaceFileIndexContributor<E> contributor, @NotNull IndexingRootsDescriptions roots2, @NotNull RootsCollector registrar, @NotNull EntityStorage entityStorage) {
        if (contributor == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(3);
        }
        if (roots2 == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(4);
        }
        if (registrar == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(5);
        }
        if (entityStorage == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(6);
        }
        registrar.registerAndCollectNonModuleAwareRoots(roots2, contributor, entityStorage.entities(contributor.getEntityClass()), entityStorage);
    }

    public static void addIteratorsFromRootsDescriptions(@NotNull IndexingRootsDescriptions descriptions, @NotNull List<IndexableFilesIterator> iterators, @NotNull Set<IndexableSetOrigin> libraryOrigins, @NotNull EntityStorage storage) {
        if (descriptions == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(7);
        }
        if (iterators == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(8);
        }
        if (libraryOrigins == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(9);
        }
        if (storage == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(10);
        }
        ArrayList<Object> initialIterators = new ArrayList<Object>();
        for (ModuleRootsDescription moduleRootsDescription : descriptions.moduleRoots()) {
            initialIterators.add(new ModuleIndexableFilesIteratorImpl(moduleRootsDescription.module(), moduleRootsDescription.roots(), true));
        }
        for (LibraryRootsDescription libraryRootsDescription : descriptions.libraryRoots()) {
            LibraryIndexableFilesIteratorImpl iterator2;
            Library library = LibraryEntityUtils.findLibraryBridge(libraryRootsDescription.library, storage);
            if (library == null || (iterator2 = LibraryIndexableFilesIteratorImpl.createIterator(library, libraryRootsDescription.classRoots(), libraryRootsDescription.sourceRoots())) == null || !libraryOrigins.add((IndexableSetOrigin)iterator2.getOrigin())) continue;
            initialIterators.add(iterator2);
        }
        iterators.addAll(0, initialIterators);
        for (EntityContentRootsDescription entityContentRootsDescription : descriptions.contentEntityRoots()) {
            iterators.addAll(IndexableEntityProviderMethods.INSTANCE.createModuleUnawareContentEntityIterators(entityContentRootsDescription.entityReference(), entityContentRootsDescription.roots()));
        }
        for (EntityRootsDescription entityRootsDescription : descriptions.externalEntityRoots()) {
            iterators.addAll(IndexableEntityProviderMethods.INSTANCE.createExternalEntityIterators(entityRootsDescription.entityReference(), entityRootsDescription.roots(), entityRootsDescription.sourceRoots()));
        }
    }

    @NotNull
    public static Collection<IndexableEntityProvider.IndexableIteratorBuilder> createBuildersFromRootsDescriptions(@NotNull IndexingRootsDescriptions descriptions) {
        if (descriptions == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(11);
        }
        return IndexingRootsCollectionUtil.doCreateBuilders(descriptions, null);
    }

    @NotNull
    private static ArrayList<IndexableEntityProvider.IndexableIteratorBuilder> doCreateBuilders(@NotNull IndexingRootsDescriptions descriptions, @Nullable VirtualFile root) {
        if (descriptions == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(12);
        }
        ArrayList<IndexableEntityProvider.IndexableIteratorBuilder> builders = new ArrayList<IndexableEntityProvider.IndexableIteratorBuilder>();
        for (ModuleRootsDescription moduleRootsDescription : descriptions.moduleRoots()) {
            if (root != null && !VfsUtilCore.isUnderFiles(root, moduleRootsDescription.roots)) continue;
            builders.addAll(IndexableIteratorBuilders.INSTANCE.forModuleRootsFileBased(((ModuleBridge)moduleRootsDescription.module()).getModuleEntityId(), root == null ? moduleRootsDescription.roots() : Collections.singletonList(root)));
        }
        for (LibraryRootsDescription libraryRootsDescription : descriptions.libraryRoots()) {
            if (root == null || VfsUtilCore.isUnderFiles(root, libraryRootsDescription.classRoots) || VfsUtilCore.isUnderFiles(root, libraryRootsDescription.sourceRoots)) {
                builders.addAll(IndexableIteratorBuilders.INSTANCE.forLibraryEntity(libraryRootsDescription.library().getSymbolicId(), false, libraryRootsDescription.classRoots(), libraryRootsDescription.sourceRoots()));
                continue;
            }
            if (VfsUtilCore.isUnderFiles(root, libraryRootsDescription.classRoots)) {
                builders.addAll(IndexableIteratorBuilders.INSTANCE.forLibraryEntity(libraryRootsDescription.library().getSymbolicId(), false, Collections.singletonList(root), Collections.emptyList()));
                continue;
            }
            if (!VfsUtilCore.isUnderFiles(root, libraryRootsDescription.sourceRoots)) continue;
            builders.addAll(IndexableIteratorBuilders.INSTANCE.forLibraryEntity(libraryRootsDescription.library().getSymbolicId(), false, Collections.emptyList(), Collections.singletonList(root)));
        }
        for (EntityContentRootsDescription entityContentRootsDescription : descriptions.contentEntityRoots()) {
            if (root != null && !VfsUtilCore.isUnderFiles(root, entityContentRootsDescription.roots)) continue;
            builders.addAll(IndexableIteratorBuilders.INSTANCE.forModuleUnawareContentEntity(entityContentRootsDescription.entityReference(), root == null ? entityContentRootsDescription.roots() : Collections.singletonList(root)));
        }
        for (EntityRootsDescription entityRootsDescription : descriptions.externalEntityRoots()) {
            if (root == null) {
                builders.addAll(IndexableIteratorBuilders.INSTANCE.forExternalEntity(entityRootsDescription.entityReference(), entityRootsDescription.roots(), entityRootsDescription.sourceRoots()));
                continue;
            }
            if (VfsUtilCore.isUnderFiles(root, entityRootsDescription.roots)) {
                builders.addAll(IndexableIteratorBuilders.INSTANCE.forExternalEntity(entityRootsDescription.entityReference(), Collections.singletonList(root), Collections.emptyList()));
                continue;
            }
            if (!VfsUtilCore.isUnderFiles(root, entityRootsDescription.sourceRoots)) continue;
            builders.addAll(IndexableIteratorBuilders.INSTANCE.forExternalEntity(entityRootsDescription.entityReference(), Collections.emptyList(), Collections.singletonList(root)));
        }
        ArrayList<IndexableEntityProvider.IndexableIteratorBuilder> arrayList = builders;
        if (arrayList == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> createBuilderForFile(@NotNull IndexingRootsDescriptions roots2, @NotNull VirtualFile file2) {
        if (roots2 == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(15);
        }
        return IndexingRootsCollectionUtil.doCreateBuilders(roots2, file2);
    }

    public static List<VirtualFile> optimizeRoots(@NotNull Collection<VirtualFile> roots2) {
        int size;
        if (roots2 == null) {
            IndexingRootsCollectionUtil.$$$reportNull$$$0(16);
        }
        if ((size = roots2.size()) == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return new SmartList<VirtualFile>(roots2.iterator().next());
        }
        if (size > 1000) {
            return new ArrayList<VirtualFile>(roots2);
        }
        final ArrayList<VirtualFile> filteredList = new ArrayList<VirtualFile>();
        Consumer<VirtualFile> consumer2 = new Consumer<VirtualFile>(){
            private String previousPath = null;

            @Override
            public void accept(VirtualFile file2) {
                String path2 = file2.getPath();
                if (this.previousPath == null || !FileUtil.startsWith(path2, this.previousPath)) {
                    filteredList.add(file2);
                    this.previousPath = path2;
                }
            }
        };
        roots2.stream().sorted((o1, o2) -> StringUtil.compare(o1.getPath(), o2.getPath(), false)).forEachOrdered(consumer2);
        return filteredList;
    }

    private static <T> List<? extends T> toList(Collection<T> value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityStorage";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 4: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryOrigins";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRootsFromWorkspaceFileIndexContributors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateBuilders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectRootsFromWorkspaceFileIndexContributors";
                break;
            }
            case 2: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleContributor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addIteratorsFromRootsDescriptions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createBuildersFromRootsDescriptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCreateBuilders";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "optimizeRoots";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 13 -> new IllegalStateException(string2);
        };
    }

    public record IndexingRootsDescriptions(@NotNull Collection<ModuleRootsDescription> moduleRoots, @NotNull Collection<EntityContentRootsDescription> contentEntityRoots, @NotNull Collection<LibraryRootsDescription> libraryRoots, @NotNull Collection<EntityRootsDescription> externalEntityRoots) {
        @NotNull
        private final Collection<ModuleRootsDescription> moduleRoots;
        @NotNull
        private final Collection<EntityContentRootsDescription> contentEntityRoots;
        @NotNull
        private final Collection<LibraryRootsDescription> libraryRoots;
        @NotNull
        private final Collection<EntityRootsDescription> externalEntityRoots;

        public IndexingRootsDescriptions() {
            this(new ArrayList<ModuleRootsDescription>(), new HashSet<EntityContentRootsDescription>(), new HashSet<LibraryRootsDescription>(), new HashSet<EntityRootsDescription>());
        }

        public IndexingRootsDescriptions(@NotNull Collection<ModuleRootsDescription> moduleRoots, @NotNull Collection<EntityContentRootsDescription> contentEntityRoots, @NotNull Collection<LibraryRootsDescription> libraryRoots, @NotNull Collection<EntityRootsDescription> externalEntityRoots) {
            if (moduleRoots == null) {
                IndexingRootsDescriptions.$$$reportNull$$$0(0);
            }
            if (contentEntityRoots == null) {
                IndexingRootsDescriptions.$$$reportNull$$$0(1);
            }
            if (libraryRoots == null) {
                IndexingRootsDescriptions.$$$reportNull$$$0(2);
            }
            if (externalEntityRoots == null) {
                IndexingRootsDescriptions.$$$reportNull$$$0(3);
            }
        }

        @NotNull
        public Collection<ModuleRootsDescription> moduleRoots() {
            Collection<ModuleRootsDescription> collection = this.moduleRoots;
            if (collection == null) {
                IndexingRootsDescriptions.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @NotNull
        public Collection<EntityContentRootsDescription> contentEntityRoots() {
            Collection<EntityContentRootsDescription> collection = this.contentEntityRoots;
            if (collection == null) {
                IndexingRootsDescriptions.$$$reportNull$$$0(5);
            }
            return collection;
        }

        @NotNull
        public Collection<LibraryRootsDescription> libraryRoots() {
            Collection<LibraryRootsDescription> collection = this.libraryRoots;
            if (collection == null) {
                IndexingRootsDescriptions.$$$reportNull$$$0(6);
            }
            return collection;
        }

        @NotNull
        public Collection<EntityRootsDescription> externalEntityRoots() {
            Collection<EntityRootsDescription> collection = this.externalEntityRoots;
            if (collection == null) {
                IndexingRootsDescriptions.$$$reportNull$$$0(7);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleRoots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentEntityRoots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryRoots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalEntityRoots";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$IndexingRootsDescriptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$IndexingRootsDescriptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moduleRoots";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contentEntityRoots";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "libraryRoots";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "externalEntityRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 5, 6, 7 -> new IllegalStateException(string2);
            };
        }
    }

    public static class RootsCollector {
        private final MultiMap<Module, VirtualFile> myContents = MultiMap.create();
        private final IndexingRootsCollectionSettings mySettings;
        private final MultiMap<WorkspaceEntity, VirtualFile> myContentRoots = MultiMap.createSet();
        private final MultiMap<LibraryEntity, VirtualFile> myLibraryRoots = MultiMap.createSet();
        private final MultiMap<LibraryEntity, VirtualFile> myLibrarySourceRoots = MultiMap.createSet();
        private final MultiMap<WorkspaceEntity, VirtualFile> myExternalRoots = MultiMap.createSet();
        private final MultiMap<WorkspaceEntity, VirtualFile> myExternalSourceRoots = MultiMap.createSet();
        @Nullable
        private WorkspaceFileIndexContributor<?> myCurrentContributor;
        private final WorkspaceFileSetRegistrar myRegistrar = new WorkspaceFileSetRegistrar(){

            @Override
            public void registerFileSet(@NotNull VirtualFileUrl root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
                if (root == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (kind == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (entity == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.shouldIgnore(kind, customData)) {
                    return;
                }
                VirtualFile file2 = VirtualFileUrls.getVirtualFile(root);
                if (file2 != null) {
                    this.doRegisterFileSet(file2, kind, entity, customData);
                }
            }

            @Override
            public void registerFileSet(@NotNull VirtualFile root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
                if (root == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (kind == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (entity == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (this.shouldIgnore(kind, customData)) {
                    return;
                }
                this.doRegisterFileSet(root, kind, entity, customData);
            }

            private void doRegisterFileSet(@NotNull VirtualFile root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
                if (root == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (kind == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (entity == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (customData instanceof ModuleContentOrSourceRootData) {
                    myContents.putValue(((ModuleContentOrSourceRootData)customData).getModule(), root);
                } else if (kind.isContent()) {
                    myContentRoots.putValue(entity, root);
                } else if (kind == WorkspaceFileKind.EXTERNAL) {
                    if (myCurrentContributor instanceof LibraryRootFileIndexContributor) {
                        myLibraryRoots.putValue((LibraryEntity)entity, root);
                    } else {
                        myExternalRoots.putValue(entity, root);
                    }
                } else if (myCurrentContributor instanceof LibraryRootFileIndexContributor) {
                    myLibrarySourceRoots.putValue((LibraryEntity)entity, root);
                } else {
                    myExternalSourceRoots.putValue(entity, root);
                }
            }

            @Override
            public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceEntity entity) {
                if (excludedRoot == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (entity == null) {
                    1.$$$reportNull$$$0(10);
                }
            }

            @Override
            public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceFileKind excludedFrom, @NotNull WorkspaceEntity entity) {
                if (excludedRoot == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (excludedFrom == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (entity == null) {
                    1.$$$reportNull$$$0(13);
                }
            }

            @Override
            public void registerExcludedRoot(@NotNull VirtualFile excludedRoot, @NotNull WorkspaceFileKind excludedFrom, @NotNull WorkspaceEntity entity) {
                if (excludedRoot == null) {
                    1.$$$reportNull$$$0(14);
                }
                if (excludedFrom == null) {
                    1.$$$reportNull$$$0(15);
                }
                if (entity == null) {
                    1.$$$reportNull$$$0(16);
                }
            }

            @Override
            public void registerExclusionPatterns(@NotNull VirtualFileUrl root, @NotNull List<String> patterns, @NotNull WorkspaceEntity entity) {
                if (root == null) {
                    1.$$$reportNull$$$0(17);
                }
                if (patterns == null) {
                    1.$$$reportNull$$$0(18);
                }
                if (entity == null) {
                    1.$$$reportNull$$$0(19);
                }
            }

            @Override
            public void registerExclusionCondition(@NotNull VirtualFile root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull WorkspaceEntity entity) {
                if (root == null) {
                    1.$$$reportNull$$$0(20);
                }
                if (condition == null) {
                    1.$$$reportNull$$$0(21);
                }
                if (entity == null) {
                    1.$$$reportNull$$$0(22);
                }
            }

            @Override
            public void registerExclusionCondition(@NotNull VirtualFileUrl root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull WorkspaceEntity entity) {
                if (root == null) {
                    1.$$$reportNull$$$0(23);
                }
                if (condition == null) {
                    1.$$$reportNull$$$0(24);
                }
                if (entity == null) {
                    1.$$$reportNull$$$0(25);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "kind";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 8: 
                    case 10: 
                    case 13: 
                    case 16: 
                    case 19: 
                    case 22: 
                    case 25: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "entity";
                        break;
                    }
                    case 9: 
                    case 11: 
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "excludedRoot";
                        break;
                    }
                    case 12: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "excludedFrom";
                        break;
                    }
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "patterns";
                        break;
                    }
                    case 21: 
                    case 24: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "condition";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$RootsCollector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerFileSet";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doRegisterFileSet";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerExcludedRoot";
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 19: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerExclusionPatterns";
                        break;
                    }
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerExclusionCondition";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        public RootsCollector(@Nullable IndexingRootsCollectionSettings settings) {
            this.mySettings = ObjectUtils.notNull(settings, new IndexingRootsCollectionSettings());
        }

        private boolean shouldIgnore(@NotNull WorkspaceFileKind kind, @Nullable WorkspaceFileSetData data2) {
            if (kind == null) {
                RootsCollector.$$$reportNull$$$0(0);
            }
            if (data2 instanceof ModuleContentOrSourceRootData) {
                if (!this.mySettings.collectModuleAwareContent) {
                    return true;
                }
                if (this.mySettings.retainModuleContentCondition != null && !this.mySettings.retainModuleContentCondition.value((ModuleContentOrSourceRootData)data2)) {
                    return true;
                }
            }
            return switch (kind) {
                default -> throw new IncompatibleClassChangeError();
                case WorkspaceFileKind.CONTENT, WorkspaceFileKind.TEST_CONTENT -> {
                    if (!this.mySettings.collectModuleUnawareContent) {
                        yield true;
                    }
                    yield false;
                }
                case WorkspaceFileKind.EXTERNAL -> {
                    if (!this.mySettings.collectExternalEntities) {
                        yield true;
                    }
                    yield false;
                }
                case WorkspaceFileKind.EXTERNAL_SOURCE -> !this.mySettings.collectExternalSourceEntities;
            };
        }

        public void clearNonModuleAwareMaps() {
            this.myContentRoots.clear();
            this.myLibraryRoots.clear();
            this.myLibrarySourceRoots.clear();
            this.myExternalRoots.clear();
            this.myExternalSourceRoots.clear();
        }

        public <E extends WorkspaceEntity> void registerAndCollectNonModuleAwareRoots(@NotNull IndexingRootsDescriptions roots2, @NotNull WorkspaceFileIndexContributor<E> contributor, @NotNull Sequence<E> entities2, @NotNull EntityStorage entityStorage) {
            if (roots2 == null) {
                RootsCollector.$$$reportNull$$$0(1);
            }
            if (contributor == null) {
                RootsCollector.$$$reportNull$$$0(2);
            }
            if (entities2 == null) {
                RootsCollector.$$$reportNull$$$0(3);
            }
            if (entityStorage == null) {
                RootsCollector.$$$reportNull$$$0(4);
            }
            if (this.shouldIgnore(contributor)) {
                return;
            }
            this.clearNonModuleAwareMaps();
            this.myCurrentContributor = contributor;
            for (WorkspaceEntity entity : SequencesKt.asIterable(entities2)) {
                contributor.registerFileSets(entity, this.myRegistrar, entityStorage);
            }
            this.myCurrentContributor = null;
            this.doCollectNonModuleAwareRoots(roots2);
            this.clearNonModuleAwareMaps();
        }

        public <E extends WorkspaceEntity> void registerAndCollectAllRoots(@NotNull IndexingRootsDescriptions roots2, @NotNull WorkspaceFileIndexContributor<E> contributor, @NotNull Sequence<E> entities2, @NotNull EntityStorage entityStorage) {
            if (roots2 == null) {
                RootsCollector.$$$reportNull$$$0(5);
            }
            if (contributor == null) {
                RootsCollector.$$$reportNull$$$0(6);
            }
            if (entities2 == null) {
                RootsCollector.$$$reportNull$$$0(7);
            }
            if (entityStorage == null) {
                RootsCollector.$$$reportNull$$$0(8);
            }
            if (this.shouldIgnore(contributor)) {
                return;
            }
            this.myContents.clear();
            this.clearNonModuleAwareMaps();
            this.myCurrentContributor = contributor;
            for (WorkspaceEntity entity : SequencesKt.asIterable(entities2)) {
                contributor.registerFileSets(entity, this.myRegistrar, entityStorage);
            }
            this.myCurrentContributor = null;
            this.collectModuleAwareRoots(roots2);
            this.doCollectNonModuleAwareRoots(roots2);
            this.clearNonModuleAwareMaps();
        }

        private void doCollectNonModuleAwareRoots(@NotNull IndexingRootsDescriptions roots2) {
            Collection sourceRoots;
            LibraryEntity entity;
            if (roots2 == null) {
                RootsCollector.$$$reportNull$$$0(9);
            }
            for (Map.Entry<WorkspaceEntity, Collection<VirtualFile>> entry : this.myContentRoots.entrySet()) {
                roots2.contentEntityRoots.add(new EntityContentRootsDescription(entry.getKey().createReference(), entry.getValue()));
            }
            for (Map.Entry<WorkspaceEntity, Collection<VirtualFile>> entry : this.myLibraryRoots.entrySet()) {
                entity = (LibraryEntity)entry.getKey();
                sourceRoots = ObjectUtils.notNull(this.myLibrarySourceRoots.remove(entity), Collections.emptyList());
                roots2.libraryRoots.add(new LibraryRootsDescription(entity, IndexingRootsCollectionUtil.toList(entry.getValue()), IndexingRootsCollectionUtil.toList(sourceRoots)));
            }
            for (Map.Entry<WorkspaceEntity, Collection<VirtualFile>> entry : this.myLibrarySourceRoots.entrySet()) {
                roots2.libraryRoots.add(new LibraryRootsDescription((LibraryEntity)entry.getKey(), Collections.emptyList(), IndexingRootsCollectionUtil.toList(entry.getValue())));
            }
            for (Map.Entry<WorkspaceEntity, Collection<VirtualFile>> entry : this.myExternalRoots.entrySet()) {
                entity = entry.getKey();
                sourceRoots = this.myExternalSourceRoots.remove((WorkspaceEntity)entity);
                sourceRoots = ObjectUtils.notNull(sourceRoots, Collections.emptyList());
                roots2.externalEntityRoots.add(new EntityRootsDescription(entity.createReference(), entry.getValue(), sourceRoots));
            }
            for (Map.Entry<WorkspaceEntity, Collection<VirtualFile>> entry : this.myExternalSourceRoots.entrySet()) {
                entity = entry.getKey();
                roots2.externalEntityRoots.add(new EntityRootsDescription(entity.createReference(), Collections.emptyList(), entry.getValue()));
            }
        }

        private <E extends WorkspaceEntity> boolean shouldIgnore(@NotNull WorkspaceFileIndexContributor<E> contributor) {
            if (contributor == null) {
                RootsCollector.$$$reportNull$$$0(10);
            }
            if (contributor.getStorageKind() != EntityStorageKind.MAIN) {
                return true;
            }
            return this.mySettings.retainCondition != null && !this.mySettings.retainCondition.value(contributor);
        }

        private void collectModuleAwareRoots(@NotNull IndexingRootsDescriptions roots2) {
            if (roots2 == null) {
                RootsCollector.$$$reportNull$$$0(11);
            }
            for (Map.Entry<Module, Collection<VirtualFile>> entry : this.myContents.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                roots2.moduleRoots.add(new ModuleRootsDescription(entry.getKey(), IndexingRootsCollectionUtil.optimizeRoots(entry.getValue())));
                ProgressManager.checkCanceled();
            }
            this.myContents.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: 
                case 5: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entities";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entityStorage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$RootsCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldIgnore";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerAndCollectNonModuleAwareRoots";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerAndCollectAllRoots";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectNonModuleAwareRoots";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectModuleAwareRoots";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class IndexingRootsCollectionSettings {
        @Nullable
        public Condition<? super WorkspaceFileIndexContributor<?>> retainCondition = null;
        public boolean collectModuleAwareContent = true;
        @Nullable
        public Condition<ModuleContentOrSourceRootData> retainModuleContentCondition = null;
        public boolean collectModuleUnawareContent = true;
        public boolean collectExternalEntities = true;
        public boolean collectExternalSourceEntities = true;
    }

    public record ModuleRootsDescription(@NotNull Module module, @NotNull List<? extends VirtualFile> roots) {
        @NotNull
        private final Module module;
        @NotNull
        private final List<? extends VirtualFile> roots;

        public ModuleRootsDescription(@NotNull Module module2, @NotNull List<? extends VirtualFile> roots2) {
            if (module2 == null) {
                ModuleRootsDescription.$$$reportNull$$$0(0);
            }
            if (roots2 == null) {
                ModuleRootsDescription.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Module module() {
            Module module2 = this.module;
            if (module2 == null) {
                ModuleRootsDescription.$$$reportNull$$$0(2);
            }
            return module2;
        }

        @NotNull
        public List<? extends VirtualFile> roots() {
            List<? extends VirtualFile> list2 = this.roots;
            if (list2 == null) {
                ModuleRootsDescription.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$ModuleRootsDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$ModuleRootsDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "module";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    public record LibraryRootsDescription(@NotNull LibraryEntity library, @NotNull List<? extends VirtualFile> classRoots, @NotNull List<? extends VirtualFile> sourceRoots) {
        @NotNull
        private final LibraryEntity library;
        @NotNull
        private final List<? extends VirtualFile> classRoots;
        @NotNull
        private final List<? extends VirtualFile> sourceRoots;

        public LibraryRootsDescription(@NotNull LibraryEntity library, @NotNull List<? extends VirtualFile> classRoots, @NotNull List<? extends VirtualFile> sourceRoots) {
            if (library == null) {
                LibraryRootsDescription.$$$reportNull$$$0(0);
            }
            if (classRoots == null) {
                LibraryRootsDescription.$$$reportNull$$$0(1);
            }
            if (sourceRoots == null) {
                LibraryRootsDescription.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public LibraryEntity library() {
            LibraryEntity libraryEntity = this.library;
            if (libraryEntity == null) {
                LibraryRootsDescription.$$$reportNull$$$0(3);
            }
            return libraryEntity;
        }

        @NotNull
        public List<? extends VirtualFile> classRoots() {
            List<? extends VirtualFile> list2 = this.classRoots;
            if (list2 == null) {
                LibraryRootsDescription.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        public List<? extends VirtualFile> sourceRoots() {
            List<? extends VirtualFile> list2 = this.sourceRoots;
            if (list2 == null) {
                LibraryRootsDescription.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classRoots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRoots";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$LibraryRootsDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$LibraryRootsDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "library";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classRoots";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sourceRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5 -> new IllegalStateException(string2);
            };
        }
    }

    public record EntityContentRootsDescription(@NotNull EntityReference<?> entityReference, @NotNull Collection<? extends VirtualFile> roots) {
        @NotNull
        private final EntityReference<?> entityReference;
        @NotNull
        private final Collection<? extends VirtualFile> roots;

        public EntityContentRootsDescription(@NotNull EntityReference<?> entityReference, @NotNull Collection<? extends VirtualFile> roots2) {
            if (entityReference == null) {
                EntityContentRootsDescription.$$$reportNull$$$0(0);
            }
            if (roots2 == null) {
                EntityContentRootsDescription.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public EntityReference<?> entityReference() {
            EntityReference<?> entityReference = this.entityReference;
            if (entityReference == null) {
                EntityContentRootsDescription.$$$reportNull$$$0(2);
            }
            return entityReference;
        }

        @NotNull
        public Collection<? extends VirtualFile> roots() {
            Collection<? extends VirtualFile> collection = this.roots;
            if (collection == null) {
                EntityContentRootsDescription.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entityReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$EntityContentRootsDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$EntityContentRootsDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "entityReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    public record EntityRootsDescription(@NotNull EntityReference<?> entityReference, @NotNull Collection<? extends VirtualFile> roots, @NotNull Collection<? extends VirtualFile> sourceRoots) {
        @NotNull
        private final EntityReference<?> entityReference;
        @NotNull
        private final Collection<? extends VirtualFile> roots;
        @NotNull
        private final Collection<? extends VirtualFile> sourceRoots;

        public EntityRootsDescription(@NotNull EntityReference<?> entityReference, @NotNull Collection<? extends VirtualFile> roots2, @NotNull Collection<? extends VirtualFile> sourceRoots) {
            if (entityReference == null) {
                EntityRootsDescription.$$$reportNull$$$0(0);
            }
            if (roots2 == null) {
                EntityRootsDescription.$$$reportNull$$$0(1);
            }
            if (sourceRoots == null) {
                EntityRootsDescription.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public EntityReference<?> entityReference() {
            EntityReference<?> entityReference = this.entityReference;
            if (entityReference == null) {
                EntityRootsDescription.$$$reportNull$$$0(3);
            }
            return entityReference;
        }

        @NotNull
        public Collection<? extends VirtualFile> roots() {
            Collection<? extends VirtualFile> collection = this.roots;
            if (collection == null) {
                EntityRootsDescription.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @NotNull
        public Collection<? extends VirtualFile> sourceRoots() {
            Collection<? extends VirtualFile> collection = this.sourceRoots;
            if (collection == null) {
                EntityRootsDescription.$$$reportNull$$$0(5);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entityReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRoots";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$EntityRootsDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/roots/IndexingRootsCollectionUtil$EntityRootsDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "entityReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roots";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sourceRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5 -> new IllegalStateException(string2);
            };
        }
    }
}

