/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import com.intellij.util.indexing.roots.origin.LibraryOriginImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB?\b\u0002\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl;", "Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIterator;", "libraryName", "", "Lcom/intellij/openapi/util/NlsSafe;", "presentableLibraryName", "Lorg/jetbrains/annotations/Nls;", "classRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceRoots", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getDebugName", "getIndexingProgressText", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/LibraryOrigin;", "getRootUrls", "", "project", "Lcom/intellij/openapi/project/Project;", "getRootsScanningProgressText", "iterateFiles", "", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "validCount", "", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nLibraryIndexableFilesIteratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryIndexableFilesIteratorImpl.kt\ncom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1549#2:89\n1620#2,3:90\n766#2:93\n857#2,2:94\n*S KotlinDebug\n*F\n+ 1 LibraryIndexableFilesIteratorImpl.kt\ncom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl\n*L\n56#1:89\n56#1:90,3\n87#1:93\n87#1:94,2\n*E\n"})
public final class LibraryIndexableFilesIteratorImpl
implements LibraryIndexableFilesIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String libraryName;
    @NotNull
    private final String presentableLibraryName;
    @NotNull
    private final List<VirtualFile> classRoots;
    @NotNull
    private final List<VirtualFile> sourceRoots;

    private LibraryIndexableFilesIteratorImpl(String libraryName, String presentableLibraryName, List<? extends VirtualFile> classRoots, List<? extends VirtualFile> sourceRoots) {
        this.libraryName = libraryName;
        this.presentableLibraryName = presentableLibraryName;
        this.classRoots = classRoots;
        this.sourceRoots = sourceRoots;
    }

    @NotNull
    public String getDebugName() {
        return "Library " + this.presentableLibraryName + " (#" + this.validCount(this.classRoots) + " class roots, #" + this.validCount(this.sourceRoots) + " source roots)";
    }

    @NotNull
    public String getIndexingProgressText() {
        Object[] objectArray = new Object[]{this.presentableLibraryName};
        String string2 = IndexingBundle.message((String)"indexable.files.provider.indexing.library.name", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026  presentableLibraryName)");
        return string2;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        CharSequence charSequence = this.libraryName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Object[] objectArray = new Object[]{this.libraryName};
            String string2 = IndexingBundle.message((String)"indexable.files.provider.scanning.library.name", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026brary.name\", libraryName)");
            return string2;
        }
        String string3 = IndexingBundle.message((String)"indexable.files.provider.scanning.additional.dependencies", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"indexable.files\u2026additional.dependencies\")");
        return string3;
    }

    @NotNull
    public LibraryOrigin getOrigin() {
        return new LibraryOriginImpl(this.classRoots, this.sourceRoots);
    }

    public boolean iterateFiles(@NotNull Project project2, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        Set roots2 = (Set)ActionsKt.runReadAction((Function0)new Function0<Set<? extends VirtualFile>>(this){
            final /* synthetic */ LibraryIndexableFilesIteratorImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<VirtualFile> invoke() {
                return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)LibraryIndexableFilesIteratorImpl.access$getClassRoots$p(this.this$0)), (Sequence)CollectionsKt.asSequence((Iterable)LibraryIndexableFilesIteratorImpl.access$getSourceRoots$p(this.this$0))), (Function1)iterateFiles.roots.1.INSTANCE));
            }
        });
        return IndexableFilesIterationMethods.iterateRoots$default(IndexableFilesIterationMethods.INSTANCE, project2, roots2, fileIterator, fileFilter, false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getRootUrls(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$map$iv = CollectionsKt.plus((Collection)this.classRoots, (Iterable)this.sourceRoots);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final int validCount(List<? extends VirtualFile> $this$validCount) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$validCount;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size();
    }

    @JvmStatic
    @RequiresReadLock
    @Nullable
    public static final LibraryIndexableFilesIteratorImpl createIterator(@NotNull Library library, @Nullable List<? extends VirtualFile> roots2, @Nullable List<? extends VirtualFile> sourceRoots) {
        return Companion.createIterator(library, roots2, sourceRoots);
    }

    @JvmStatic
    @NotNull
    public static final List<IndexableFilesIterator> createIteratorList(@NotNull Library library) {
        return Companion.createIteratorList(library);
    }

    public static final /* synthetic */ List access$getClassRoots$p(LibraryIndexableFilesIteratorImpl $this) {
        return $this.classRoots;
    }

    public static final /* synthetic */ List access$getSourceRoots$p(LibraryIndexableFilesIteratorImpl $this) {
        return $this.sourceRoots;
    }

    public /* synthetic */ LibraryIndexableFilesIteratorImpl(String libraryName, String presentableLibraryName, List classRoots, List sourceRoots, DefaultConstructorMarker $constructor_marker) {
        this(libraryName, presentableLibraryName, classRoots, sourceRoots);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004J6\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl$Companion;", "", "()V", "collectFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "rootType", "Lcom/intellij/openapi/roots/OrderRootType;", "rootsToFilter", "createIterator", "Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl;", "roots", "sourceRoots", "createIteratorList", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nLibraryIndexableFilesIteratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryIndexableFilesIteratorImpl.kt\ncom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n766#2:89\n857#2,2:90\n1#3:92\n*S KotlinDebug\n*F\n+ 1 LibraryIndexableFilesIteratorImpl.kt\ncom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl$Companion\n*L\n62#1:89\n62#1:90,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VirtualFile> collectFiles(@NotNull Library library, @NotNull OrderRootType rootType, @Nullable List<? extends VirtualFile> rootsToFilter) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
            Object[] objectArray = library.getRootProvider().getFiles(rootType);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"library.rootProvider.getFiles(rootType)");
            Object[] libraryRoots = objectArray;
            List<? extends VirtualFile> list3 = rootsToFilter;
            if (list3 != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list3;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Object object;
                    block4: {
                        VirtualFile root = (VirtualFile)element$iv$iv;
                        boolean bl = false;
                        Object[] objectArray2 = libraryRoots;
                        int n = objectArray2.length;
                        for (int j = 0; j < n; ++j) {
                            Object object2;
                            Object libraryRoot = object2 = objectArray2[j];
                            boolean bl2 = false;
                            if (!VfsUtil.isAncestor((VirtualFile)libraryRoot, root, false)) continue;
                            object = object2;
                            break block4;
                        }
                        object = null;
                    }
                    boolean bl = object != null;
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = ArraysKt.toList((Object[])libraryRoots);
            }
            List rootsToIterate = list2;
            return rootsToIterate;
        }

        public static /* synthetic */ List collectFiles$default(Companion companion, Library library, OrderRootType orderRootType, List list2, int n, Object object) {
            if ((n & 4) != 0) {
                list2 = null;
            }
            return companion.collectFiles(library, orderRootType, list2);
        }

        @JvmStatic
        @RequiresReadLock
        @Nullable
        public final LibraryIndexableFilesIteratorImpl createIterator(@NotNull Library library, @Nullable List<? extends VirtualFile> roots2, @Nullable List<? extends VirtualFile> sourceRoots) {
            LibraryIndexableFilesIteratorImpl libraryIndexableFilesIteratorImpl;
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            if (library instanceof LibraryEx && ((LibraryEx)library).isDisposed()) {
                libraryIndexableFilesIteratorImpl = null;
            } else {
                String string2 = library.getName();
                String string3 = library.getPresentableName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"library.presentableName");
                OrderRootType orderRootType = OrderRootType.CLASSES;
                Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"CLASSES");
                List<VirtualFile> list2 = this.collectFiles(library, orderRootType, roots2);
                OrderRootType orderRootType2 = OrderRootType.SOURCES;
                Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"SOURCES");
                libraryIndexableFilesIteratorImpl = new LibraryIndexableFilesIteratorImpl(string2, string3, list2, this.collectFiles(library, orderRootType2, sourceRoots), null);
            }
            return libraryIndexableFilesIteratorImpl;
        }

        public static /* synthetic */ LibraryIndexableFilesIteratorImpl createIterator$default(Companion companion, Library library, List list2, List list3, int n, Object object) {
            if ((n & 2) != 0) {
                list2 = null;
            }
            if ((n & 4) != 0) {
                list3 = null;
            }
            return companion.createIterator(library, list2, list3);
        }

        @JvmStatic
        @NotNull
        public final List<IndexableFilesIterator> createIteratorList(@NotNull Library library) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                    object = com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl$Companion.createIterator$default(this, library, null, null, 6, null);
                    if (object == null) break block2;
                    LibraryIndexableFilesIteratorImpl $this$createIteratorList_u24lambda_u242 = object;
                    boolean bl = false;
                    List list2 = CollectionsKt.listOf((Object)$this$createIteratorList_u24lambda_u242);
                    object = list2;
                    if (list2 != null) break block3;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

