/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.ExternalWorkspaceEntityIteratorImpl;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.origin.ContentModuleUnawareEntityOriginImpl;
import com.intellij.workspaceModel.storage.EntityReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/roots/ModuleUnawareContentEntityIteratorImpl;", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "reference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/workspaceModel/storage/EntityReference;Ljava/util/Collection;)V", "getDebugName", "", "getIndexingProgressText", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/IndexableSetOrigin;", "getRootUrls", "", "project", "Lcom/intellij/openapi/project/Project;", "getRootsScanningProgressText", "iterateFiles", "", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nModuleUnawareContentEntityIteratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleUnawareContentEntityIteratorImpl.kt\ncom/intellij/util/indexing/roots/ModuleUnawareContentEntityIteratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1549#2:37\n1620#2,3:38\n*S KotlinDebug\n*F\n+ 1 ModuleUnawareContentEntityIteratorImpl.kt\ncom/intellij/util/indexing/roots/ModuleUnawareContentEntityIteratorImpl\n*L\n34#1:37\n34#1:38,3\n*E\n"})
public final class ModuleUnawareContentEntityIteratorImpl
implements IndexableFilesIterator {
    @NotNull
    private final EntityReference<?> reference;
    @NotNull
    private final Collection<VirtualFile> roots;

    public ModuleUnawareContentEntityIteratorImpl(@NotNull EntityReference<?> reference2, @NotNull Collection<? extends VirtualFile> roots2) {
        Intrinsics.checkNotNullParameter(reference2, (String)"reference");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        this.reference = reference2;
        this.roots = roots2;
    }

    @NotNull
    public String getDebugName() {
        return "Content roots from entity (" + ExternalWorkspaceEntityIteratorImpl.Companion.getRootsDebugStr(this.roots) + ")";
    }

    @NotNull
    public String getIndexingProgressText() {
        String string2 = IndexingBundle.message((String)"indexable.files.provider.indexing.content", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026ovider.indexing.content\")");
        return string2;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        String string2 = IndexingBundle.message((String)"indexable.files.provider.scanning.content", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026ovider.scanning.content\")");
        return string2;
    }

    @NotNull
    public IndexableSetOrigin getOrigin() {
        return new ContentModuleUnawareEntityOriginImpl(this.reference, this.roots);
    }

    public boolean iterateFiles(@NotNull Project project2, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        return IndexableFilesIterationMethods.iterateRoots$default(IndexableFilesIterationMethods.INSTANCE, project2, this.roots, fileIterator, fileFilter, false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getRootUrls(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$map$iv = this.roots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

