/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.origin.SdkOriginImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\r\u001a\f0\t\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\f0\t\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000fH\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/roots/SdkIndexableFilesIteratorImpl;", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "rootsToIndex", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/util/Collection;)V", "sdkPresentableName", "", "getSdkPresentableName", "()Ljava/lang/String;", "getDebugName", "getIndexingProgressText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/IndexableSetOrigin;", "getRootUrls", "", "project", "Lcom/intellij/openapi/project/Project;", "getRootsScanningProgressText", "iterateFiles", "", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSdkIndexableFilesIteratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkIndexableFilesIteratorImpl.kt\ncom/intellij/util/indexing/roots/SdkIndexableFilesIteratorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n1549#3:98\n1620#3,3:99\n*S KotlinDebug\n*F\n+ 1 SdkIndexableFilesIteratorImpl.kt\ncom/intellij/util/indexing/roots/SdkIndexableFilesIteratorImpl\n*L\n44#1:98\n44#1:99,3\n*E\n"})
public final class SdkIndexableFilesIteratorImpl
implements IndexableFilesIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final Collection<VirtualFile> rootsToIndex;

    private SdkIndexableFilesIteratorImpl(Sdk sdk2, Collection<? extends VirtualFile> rootsToIndex) {
        this.sdk = sdk2;
        this.rootsToIndex = rootsToIndex;
    }

    @NotNull
    public String getDebugName() {
        return this.getSdkPresentableName() + " " + this.sdk.getName() + " " + this.sdk.getHomePath();
    }

    private final String getSdkPresentableName() {
        String string2;
        String string3;
        String string4;
        SdkTypeId sdkTypeId = this.sdk.getSdkType();
        SdkType sdkType = sdkTypeId instanceof SdkType ? (SdkType)sdkTypeId : null;
        String it = string4 = sdkType != null ? sdkType.getPresentableName() : null;
        boolean bl = false;
        CharSequence charSequence = it;
        String string5 = string3 = !(charSequence == null || charSequence.length() == 0) ? string4 : null;
        if (string3 == null) {
            String string6 = IndexingBundle.message((String)"indexable.files.provider.indexing.sdk.unnamed", (Object[])new Object[0]);
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"indexable.files\u2026er.indexing.sdk.unnamed\")");
        } else {
            string2 = string3;
        }
        return string2;
    }

    @NotNull
    public String getIndexingProgressText() {
        Object[] objectArray = new Object[]{this.getSdkPresentableName(), this.sdk.getName()};
        String string2 = IndexingBundle.message((String)"indexable.files.provider.indexing.sdk", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026resentableName, sdk.name)");
        return string2;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        Object[] objectArray = new Object[]{this.getSdkPresentableName(), this.sdk.getName()};
        String string2 = IndexingBundle.message((String)"indexable.files.provider.scanning.sdk", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"indexable.files\u2026                sdk.name)");
        return string2;
    }

    @NotNull
    public IndexableSetOrigin getOrigin() {
        return (IndexableSetOrigin)new SdkOriginImpl(this.sdk, this.rootsToIndex);
    }

    public boolean iterateFiles(@NotNull Project project2, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        return IndexableFilesIterationMethods.iterateRoots$default(IndexableFilesIterationMethods.INSTANCE, project2, this.rootsToIndex, fileIterator, fileFilter, false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getRootUrls(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$map$iv = this.rootsToIndex;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public /* synthetic */ SdkIndexableFilesIteratorImpl(Sdk sdk2, Collection rootsToIndex, DefaultConstructorMarker $constructor_marker) {
        this(sdk2, rootsToIndex);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/indexing/roots/SdkIndexableFilesIteratorImpl$Companion;", "", "()V", "createIterator", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "createIterators", "", "listOfRootsToFilter", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filterRootsToIterate", "initialRoots", "", "getRootsToIndex", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IndexableFilesIterator createIterator(@NotNull Sdk sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            return new SdkIndexableFilesIteratorImpl(sdk2, this.getRootsToIndex(sdk2), null);
        }

        @NotNull
        public final Collection<VirtualFile> getRootsToIndex(@NotNull Sdk sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            RootProvider rootProvider = sdk2.getRootProvider();
            Intrinsics.checkNotNullExpressionValue((Object)rootProvider, (String)"sdk.rootProvider");
            RootProvider rootProvider2 = rootProvider;
            VirtualFile[] virtualFileArray = rootProvider2.getFiles(OrderRootType.SOURCES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"rootProvider.getFiles(OrderRootType.SOURCES)");
            Collection collection = ArraysKt.toList((Object[])virtualFileArray);
            VirtualFile[] virtualFileArray2 = rootProvider2.getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"rootProvider.getFiles(OrderRootType.CLASSES)");
            return CollectionsKt.plus((Collection)collection, (Object[])virtualFileArray2);
        }

        @NotNull
        public final Collection<IndexableFilesIterator> createIterators(@NotNull Sdk sdk2, @NotNull List<? extends VirtualFile> listOfRootsToFilter) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            Intrinsics.checkNotNullParameter(listOfRootsToFilter, (String)"listOfRootsToFilter");
            List sdkRoots = CollectionsKt.toMutableList(this.getRootsToIndex(sdk2));
            List<VirtualFile> rootsToIndex = this.filterRootsToIterate(sdkRoots, listOfRootsToFilter);
            if (rootsToIndex.isEmpty()) {
                collection = CollectionsKt.emptyList();
            } else {
                List<SdkIndexableFilesIteratorImpl> list2 = Collections.singletonList(new SdkIndexableFilesIteratorImpl(sdk2, rootsToIndex, null));
                Intrinsics.checkNotNullExpressionValue(list2, (String)"{\n        Collections.si\u2026k, rootsToIndex))\n      }");
                collection = list2;
            }
            return collection;
        }

        @NotNull
        public final List<VirtualFile> filterRootsToIterate(@NotNull List<VirtualFile> initialRoots, @NotNull List<? extends VirtualFile> listOfRootsToFilter) {
            Intrinsics.checkNotNullParameter(initialRoots, (String)"initialRoots");
            Intrinsics.checkNotNullParameter(listOfRootsToFilter, (String)"listOfRootsToFilter");
            List rootsToFilter = CollectionsKt.toMutableList((Collection)listOfRootsToFilter);
            List rootsToIndex = new ArrayList();
            Iterator iteratorToFilter = rootsToFilter.iterator();
            block0: while (iteratorToFilter.hasNext()) {
                VirtualFile next2 = (VirtualFile)iteratorToFilter.next();
                for (VirtualFile sdkRoot : initialRoots) {
                    if (!VfsUtil.isAncestor(next2, sdkRoot, false)) continue;
                    rootsToIndex.add(sdkRoot);
                    initialRoots.remove(sdkRoot);
                    iteratorToFilter.remove();
                    continue block0;
                }
            }
            for (VirtualFile file2 : rootsToFilter) {
                for (VirtualFile sdkRoot : initialRoots) {
                    if (!VfsUtil.isAncestor(sdkRoot, file2, false)) continue;
                    rootsToIndex.add(file2);
                }
            }
            return rootsToIndex;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

