/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexableFilesIndex;
import com.intellij.util.indexing.roots.IndexableFilesContributor;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.IndexingRootsCollectionUtil;
import com.intellij.util.indexing.roots.StandardContributorsKt;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.PlatformInternalWorkspaceFileIndexContributor;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.EntityStorage;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/indexing/roots/WorkspaceFileIndexContributorBasedContributor;", "Lcom/intellij/util/indexing/roots/IndexableFilesContributor;", "()V", "getIndexableFiles", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "project", "Lcom/intellij/openapi/project/Project;", "getOwnFilePredicate", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nstandardContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 standardContributors.kt\ncom/intellij/util/indexing/roots/WorkspaceFileIndexContributorBasedContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class WorkspaceFileIndexContributorBasedContributor
implements IndexableFilesContributor {
    @NotNull
    public List<IndexableFilesIterator> getIndexableFiles(@NotNull Project project2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!StandardContributorsKt.shouldIndexProjectBasedOnIndexableEntityProviders()) {
            return CollectionsKt.emptyList();
        }
        boolean bl2 = bl = !IndexableFilesIndex.isEnabled();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WorkspaceFileIndexContributorBasedContributor$getIndexableFiles$22 = false;
            String $i$a$-assert-WorkspaceFileIndexContributorBasedContributor$getIndexableFiles$22 = "Shouldn't be used with IndexableFilesIndex fully enabled";
            throw new AssertionError((Object)$i$a$-assert-WorkspaceFileIndexContributorBasedContributor$getIndexableFiles$22);
        }
        EntityStorage entityStorage = WorkspaceModel.Companion.getInstance(project2).getEntityStorage().getCurrent();
        IndexingRootsCollectionUtil.IndexingRootsCollectionSettings settings = new IndexingRootsCollectionUtil.IndexingRootsCollectionSettings();
        settings.retainCondition = WorkspaceFileIndexContributorBasedContributor::getIndexableFiles$lambda$1;
        IndexingRootsCollectionUtil.IndexingRootsDescriptions indexingRootsDescriptions = IndexingRootsCollectionUtil.collectRootsFromWorkspaceFileIndexContributors(project2, entityStorage, settings);
        Intrinsics.checkNotNullExpressionValue((Object)indexingRootsDescriptions, (String)"collectRootsFromWorkspac\u2026 entityStorage, settings)");
        IndexingRootsCollectionUtil.IndexingRootsDescriptions roots2 = indexingRootsDescriptions;
        List result2 = new ArrayList();
        IndexingRootsCollectionUtil.addIteratorsFromRootsDescriptions(roots2, result2, new LinkedHashSet(), entityStorage);
        return result2;
    }

    @NotNull
    public Predicate<VirtualFile> getOwnFilePredicate(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return WorkspaceFileIndexContributorBasedContributor::getOwnFilePredicate$lambda$2;
    }

    private static final boolean getIndexableFiles$lambda$1(WorkspaceFileIndexContributor contributor) {
        return !(contributor instanceof PlatformInternalWorkspaceFileIndexContributor);
    }

    private static final boolean getOwnFilePredicate$lambda$2(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }
}

