/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots.builders;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.builders.ExternalEntityIteratorBuilder;
import com.intellij.util.indexing.roots.builders.FullModuleContentIteratorBuilder;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilderHandler;
import com.intellij.util.indexing.roots.builders.InheritedSdkIteratorBuilder;
import com.intellij.util.indexing.roots.builders.LibraryIdIteratorBuilder;
import com.intellij.util.indexing.roots.builders.ModuleRootsFileBasedIteratorBuilder;
import com.intellij.util.indexing.roots.builders.ModuleRootsIteratorBuilder;
import com.intellij.util.indexing.roots.builders.ModuleUnawareContentEntityBuilder;
import com.intellij.util.indexing.roots.builders.SdkIteratorBuilder;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0007J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007JB\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00072\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0007H\u0007J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007J0\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cJ\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u0007J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\fJ\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\"\u001a\u00020#2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u0007J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&J*\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001c2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/util/indexing/roots/builders/IndexableIteratorBuilders;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "forExternalEntity", "", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$IndexableIteratorBuilder;", "entityReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceRoots", "forInheritedSdk", "forLibraryEntity", "libraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "dependencyChecked", "", "forModuleContent", "moduleId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleId;", "forModuleRoots", "url", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "urls", "newRoots", "", "oldRoots", "forModuleRootsFileBased", "files", "forModuleUnawareContentEntity", "forSdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "file", "sdkName", "", "sdkType", "instantiateBuilders", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "builders", "project", "Lcom/intellij/openapi/project/Project;", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nindexableIteratorBuilders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 indexableIteratorBuilders.kt\ncom/intellij/util/indexing/roots/builders/IndexableIteratorBuilders\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n3190#2,10:126\n8#3:136\n*S KotlinDebug\n*F\n+ 1 indexableIteratorBuilders.kt\ncom/intellij/util/indexing/roots/builders/IndexableIteratorBuilders\n*L\n76#1:126,10\n20#1:136\n*E\n"})
public final class IndexableIteratorBuilders {
    @NotNull
    public static final IndexableIteratorBuilders INSTANCE;
    @NotNull
    private static final Logger logger;

    private IndexableIteratorBuilders() {
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleRoots(@NotNull ModuleId moduleId, @NotNull Collection<? extends VirtualFileUrl> urls) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        return urls.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)new ModuleRootsIteratorBuilder(moduleId, urls));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleRootsFileBased(@NotNull ModuleId moduleId, @NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        return files2.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)new ModuleRootsFileBasedIteratorBuilder(moduleId, files2));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleRoots(@NotNull ModuleId moduleId, @NotNull VirtualFileUrl url) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return CollectionsKt.listOf((Object)new ModuleRootsIteratorBuilder(moduleId, url));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleRoots(@NotNull ModuleId moduleId, @NotNull List<? extends VirtualFileUrl> newRoots, @NotNull List<? extends VirtualFileUrl> oldRoots) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter(newRoots, (String)"newRoots");
        Intrinsics.checkNotNullParameter(oldRoots, (String)"oldRoots");
        List roots2 = CollectionsKt.toMutableList((Collection)newRoots);
        roots2.removeAll((Collection)oldRoots);
        return this.forModuleRoots(moduleId, roots2);
    }

    @JvmOverloads
    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forLibraryEntity(@NotNull LibraryId libraryId, boolean dependencyChecked, @Nullable Collection<? extends VirtualFile> roots2, @Nullable Collection<? extends VirtualFile> sourceRoots) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return CollectionsKt.listOf((Object)new LibraryIdIteratorBuilder(libraryId, roots2, sourceRoots, dependencyChecked));
    }

    public static /* synthetic */ Collection forLibraryEntity$default(IndexableIteratorBuilders indexableIteratorBuilders, LibraryId libraryId, boolean bl, Collection collection, Collection collection2, int n, Object object) {
        if ((n & 4) != 0) {
            collection = null;
        }
        if ((n & 8) != 0) {
            collection2 = null;
        }
        return indexableIteratorBuilders.forLibraryEntity(libraryId, bl, collection, collection2);
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forSdk(@NotNull String sdkName, @NotNull String sdkType) {
        Intrinsics.checkNotNullParameter((Object)sdkName, (String)"sdkName");
        Intrinsics.checkNotNullParameter((Object)sdkType, (String)"sdkType");
        return CollectionsKt.listOf((Object)new SdkIteratorBuilder(sdkName, sdkType, null, 4, null));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forSdk(@NotNull Sdk sdk2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.forSdk(sdk2, CollectionsKt.listOf((Object)file2));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forSdk(@NotNull Sdk sdk2, @NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        return CollectionsKt.listOf((Object)new SdkIteratorBuilder(sdk2, files2));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forInheritedSdk() {
        return CollectionsKt.listOf((Object)InheritedSdkIteratorBuilder.INSTANCE);
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleContent(@NotNull ModuleId moduleId) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        return CollectionsKt.listOf((Object)new FullModuleContentIteratorBuilder(moduleId));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleUnawareContentEntity(@NotNull EntityReference<?> entityReference, @NotNull Collection<? extends VirtualFile> roots2) {
        Intrinsics.checkNotNullParameter(entityReference, (String)"entityReference");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        return roots2.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)new ModuleUnawareContentEntityBuilder(entityReference, roots2));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forExternalEntity(@NotNull EntityReference<?> entityReference, @NotNull Collection<? extends VirtualFile> roots2, @NotNull Collection<? extends VirtualFile> sourceRoots) {
        Intrinsics.checkNotNullParameter(entityReference, (String)"entityReference");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        return roots2.isEmpty() && sourceRoots.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)new ExternalEntityIteratorBuilder(entityReference, roots2, sourceRoots));
    }

    @NotNull
    public final List<IndexableFilesIterator> instantiateBuilders(@NotNull List<? extends IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull Project project2, @NotNull EntityStorage entityStorage) {
        Intrinsics.checkNotNullParameter(builders, (String)"builders");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        if (builders.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList result2 = new ArrayList(builders.size());
        List buildersToProceed = builders;
        List<IndexableIteratorBuilderHandler> handlers2 = IndexableIteratorBuilderHandler.EP_NAME.getExtensionList();
        for (IndexableIteratorBuilderHandler handler2 : handlers2) {
            ProgressManager.checkCanceled();
            Iterable $this$partition$iv = buildersToProceed;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                IndexableEntityProvider.IndexableIteratorBuilder it = (IndexableEntityProvider.IndexableIteratorBuilder)element$iv;
                boolean bl = false;
                if (handler2.accepts(it)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair partition = new Pair(first$iv, second$iv);
            buildersToProceed = (List)partition.getSecond();
            if (!(!((Collection)partition.getFirst()).isEmpty())) continue;
            result2.addAll(handler2.instantiate((Collection)partition.getFirst(), project2, entityStorage));
        }
        if (!((Collection)buildersToProceed).isEmpty()) {
            logger.error("Failed to find handlers for IndexableIteratorBuilders: " + buildersToProceed + ";\navailable handlers: " + handlers2);
        }
        return result2;
    }

    @JvmOverloads
    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forLibraryEntity(@NotNull LibraryId libraryId, boolean dependencyChecked, @Nullable Collection<? extends VirtualFile> roots2) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return IndexableIteratorBuilders.forLibraryEntity$default(this, libraryId, dependencyChecked, roots2, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forLibraryEntity(@NotNull LibraryId libraryId, boolean dependencyChecked) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return IndexableIteratorBuilders.forLibraryEntity$default(this, libraryId, dependencyChecked, null, null, 12, null);
    }

    static {
        IndexableIteratorBuilders $this$thisLogger$iv = INSTANCE = new IndexableIteratorBuilders();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexableIteratorBuilders.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        IndexableIteratorBuilders.logger = logger;
    }
}

