/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots.builders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilderHandler;
import com.intellij.util.indexing.roots.builders.LibraryIdIteratorBuilder;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryEntityUtils;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0012H\u0002J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler;", "Lcom/intellij/util/indexing/roots/builders/IndexableIteratorBuilderHandler;", "()V", "accepts", "", "builder", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$IndexableIteratorBuilder;", "createLibraryIterator", "Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIterator;", "libraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "root", "Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$Root;", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "getRoot", "Lcom/intellij/util/indexing/roots/builders/LibraryIdIteratorBuilder;", "instantiate", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "builders", "", "merge", "first", "second", "AllRoots", "DependencyChecker", "Root", "RootList", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nLibraryIndexableIteratorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryIndexableIteratorHandler.kt\ncom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1855#2,2:168\n1855#2,2:170\n1855#2,2:172\n*S KotlinDebug\n*F\n+ 1 LibraryIndexableIteratorHandler.kt\ncom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler\n*L\n29#1:168,2\n38#1:170,2\n47#1:172,2\n*E\n"})
public final class LibraryIndexableIteratorHandler
implements IndexableIteratorBuilderHandler {
    @Override
    public boolean accepts(@NotNull IndexableEntityProvider.IndexableIteratorBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        return builder2 instanceof LibraryIdIteratorBuilder;
    }

    @NotNull
    public List<IndexableFilesIterator> instantiate(@NotNull Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull Project project2, @NotNull EntityStorage entityStorage) {
        Intrinsics.checkNotNullParameter(builders, (String)"builders");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        Map rootMap = new LinkedHashMap();
        Set idsToIndex = new LinkedHashSet();
        Iterable $this$forEach$iv = builders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryIdIteratorBuilder builder2 = (LibraryIdIteratorBuilder)element$iv;
            boolean bl = false;
            LibraryId libraryId = builder2.getLibraryId();
            if (builder2.getDependencyChecked()) {
                idsToIndex.add(libraryId);
            }
            rootMap.put(libraryId, this.merge(this.getRoot(builder2), (Root)rootMap.get(libraryId)));
        }
        DependencyChecker dependencyChecker = new DependencyChecker(entityStorage, idsToIndex);
        Iterable $this$forEach$iv2 = builders;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            LibraryIdIteratorBuilder builder3 = (LibraryIdIteratorBuilder)element$iv;
            boolean bl = false;
            if (builder3.getDependencyChecked()) continue;
            dependencyChecker.checkDependency(builder3.getLibraryId());
        }
        List result2 = new ArrayList();
        Set ids = new LinkedHashSet();
        Iterable $this$forEach$iv3 = idsToIndex;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            LibraryIndexableFilesIterator libraryIndexableFilesIterator;
            LibraryId id = (LibraryId)element$iv;
            boolean bl = false;
            Object v = rootMap.get(id);
            Intrinsics.checkNotNull(v);
            if (this.createLibraryIterator(id, (Root)v, entityStorage, project2) == null) continue;
            LibraryIndexableFilesIterator it = libraryIndexableFilesIterator;
            boolean bl2 = false;
            LibraryOrigin libraryOrigin = it.getOrigin();
            Intrinsics.checkNotNullExpressionValue((Object)libraryOrigin, (String)"it.origin");
            if (!ids.add(libraryOrigin)) continue;
            result2.add(it);
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Root merge(Root first2, Root second2) {
        Root root;
        Root root2 = second2;
        if (Intrinsics.areEqual((Object)root2, (Object)AllRoots.INSTANCE)) {
            return AllRoots.INSTANCE;
        }
        if (root2 == null) {
            root = first2;
            return root;
        } else {
            if (!(root2 instanceof RootList)) throw new NoWhenBranchMatchedException();
            Root root3 = first2;
            if (Intrinsics.areEqual((Object)root3, (Object)AllRoots.INSTANCE)) {
                root = AllRoots.INSTANCE;
                return root;
            } else {
                if (!(root3 instanceof RootList)) throw new NoWhenBranchMatchedException();
                ((RootList)first2).getRoots().addAll((Collection<VirtualFile>)((RootList)second2).getRoots());
                ((RootList)first2).getSourceRoots().addAll((Collection<VirtualFile>)((RootList)second2).getSourceRoots());
                root = first2;
            }
        }
        return root;
    }

    private final Root getRoot(LibraryIdIteratorBuilder builder2) {
        if (builder2.getRoots() == null && builder2.getSourceRoots() == null) {
            return AllRoots.INSTANCE;
        }
        return new RootList(builder2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LibraryIndexableFilesIterator createLibraryIterator(LibraryId libraryId, Root root, EntityStorage entityStorage, Project project2) {
        LibraryIndexableFilesIteratorImpl libraryIndexableFilesIteratorImpl;
        Library library = LibraryEntityUtils.findLibraryBridge(libraryId, entityStorage, project2);
        if (library != null) {
            Library it = library;
            boolean bl = false;
            Root root2 = root;
            if (Intrinsics.areEqual((Object)root2, (Object)AllRoots.INSTANCE)) {
                libraryIndexableFilesIteratorImpl = LibraryIndexableFilesIteratorImpl.Companion.createIterator$default(LibraryIndexableFilesIteratorImpl.Companion, it, null, null, 6, null);
                return libraryIndexableFilesIteratorImpl;
            } else {
                if (!(root2 instanceof RootList)) throw new NoWhenBranchMatchedException();
                libraryIndexableFilesIteratorImpl = LibraryIndexableFilesIteratorImpl.Companion.createIterator(it, ((RootList)root).getRoots(), ((RootList)root).getSourceRoots());
            }
            return libraryIndexableFilesIteratorImpl;
        } else {
            libraryIndexableFilesIteratorImpl = null;
        }
        return libraryIndexableFilesIteratorImpl;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001\u0082\u0001\u0002\u0002\u0003\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$Root;", "", "Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$AllRoots;", "Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$RootList;", "intellij.platform.lang.impl"})
    private static interface Root {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0006R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$DependencyChecker;", "", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "idsToIndex", "", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "(Lcom/intellij/workspaceModel/storage/EntityStorage;Ljava/util/Set;)V", "dependencyIterator", "", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem;", "getEntityStorage", "()Lcom/intellij/workspaceModel/storage/EntityStorage;", "idsFromDependencies", "getIdsToIndex", "()Ljava/util/Set;", "moduleIterator", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "checkDependencies", "", "iterator", "libraryId", "checkDependency", "", "intellij.platform.lang.impl"})
    private static final class DependencyChecker {
        @NotNull
        private final EntityStorage entityStorage;
        @NotNull
        private final Set<LibraryId> idsToIndex;
        @NotNull
        private final Set<LibraryId> idsFromDependencies;
        @Nullable
        private Iterator<? extends ModuleEntity> moduleIterator;
        @Nullable
        private Iterator<? extends ModuleDependencyItem> dependencyIterator;

        public DependencyChecker(@NotNull EntityStorage entityStorage, @NotNull Set<LibraryId> idsToIndex) {
            Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
            Intrinsics.checkNotNullParameter(idsToIndex, (String)"idsToIndex");
            this.entityStorage = entityStorage;
            this.idsToIndex = idsToIndex;
            this.idsFromDependencies = new LinkedHashSet();
            this.idsFromDependencies.addAll((Collection<LibraryId>)this.idsToIndex);
        }

        @NotNull
        public final EntityStorage getEntityStorage() {
            return this.entityStorage;
        }

        @NotNull
        public final Set<LibraryId> getIdsToIndex() {
            return this.idsToIndex;
        }

        public final void checkDependency(@NotNull LibraryId libraryId) {
            Iterator<Object> localDependencyIterator;
            Iterator localModuleIterator;
            Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
            if (libraryId.getTableId() instanceof LibraryTableId.ModuleLibraryTableId) {
                this.idsToIndex.add(libraryId);
                return;
            }
            if (this.idsFromDependencies.contains(libraryId)) {
                this.idsToIndex.add(libraryId);
                return;
            }
            Iterator iterator2 = this.moduleIterator;
            if (iterator2 == null) {
                iterator2 = localModuleIterator = this.entityStorage.entities(ModuleEntity.class).iterator();
            }
            if ((localDependencyIterator = this.dependencyIterator) == null || !localDependencyIterator.hasNext()) {
                if (localModuleIterator.hasNext()) {
                    localDependencyIterator = ((ModuleEntity)localModuleIterator.next()).getDependencies().iterator();
                } else {
                    return;
                }
            }
            boolean foundInDependencies = this.checkDependencies(localDependencyIterator, libraryId);
            this.dependencyIterator = localDependencyIterator;
            if (foundInDependencies) {
                return;
            }
            while (localModuleIterator.hasNext()) {
                localDependencyIterator = ((ModuleEntity)localModuleIterator.next()).getDependencies().iterator();
                boolean foundInDependency = this.checkDependencies(localDependencyIterator, libraryId);
                this.dependencyIterator = localDependencyIterator;
                this.moduleIterator = localModuleIterator;
                if (!foundInDependency) continue;
                return;
            }
        }

        private final boolean checkDependencies(Iterator<? extends ModuleDependencyItem> iterator2, LibraryId libraryId) {
            while (iterator2.hasNext()) {
                ModuleDependencyItem next2 = iterator2.next();
                if (!(next2 instanceof ModuleDependencyItem.Exportable.LibraryDependency)) continue;
                this.idsFromDependencies.add(((ModuleDependencyItem.Exportable.LibraryDependency)next2).getLibrary());
                if (!Intrinsics.areEqual((Object)libraryId, (Object)((ModuleDependencyItem.Exportable.LibraryDependency)next2).getLibrary())) continue;
                this.idsToIndex.add(libraryId);
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$AllRoots;", "Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$Root;", "()V", "intellij.platform.lang.impl"})
    private static final class AllRoots
    implements Root {
        @NotNull
        public static final AllRoots INSTANCE = new AllRoots();

        private AllRoots() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$RootList;", "Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$Root;", "builder", "Lcom/intellij/util/indexing/roots/builders/LibraryIdIteratorBuilder;", "(Lcom/intellij/util/indexing/roots/builders/LibraryIdIteratorBuilder;)V", "()V", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRoots", "()Ljava/util/List;", "sourceRoots", "getSourceRoots", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nLibraryIndexableIteratorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryIndexableIteratorHandler.kt\ncom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$RootList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
    private static final class RootList
    implements Root {
        @NotNull
        private final List<VirtualFile> roots;
        @NotNull
        private final List<VirtualFile> sourceRoots;

        public RootList() {
            this.roots = new ArrayList();
            this.sourceRoots = new ArrayList();
        }

        @NotNull
        public final List<VirtualFile> getRoots() {
            return this.roots;
        }

        @NotNull
        public final List<VirtualFile> getSourceRoots() {
            return this.sourceRoots;
        }

        public RootList(@NotNull LibraryIdIteratorBuilder builder2) {
            block1: {
                Collection<VirtualFile> it;
                Collection<VirtualFile> collection;
                Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                this();
                Collection<VirtualFile> collection2 = builder2.getRoots();
                if (collection2 != null) {
                    it = collection = collection2;
                    boolean bl = false;
                    this.roots.addAll(it);
                }
                Collection<VirtualFile> collection3 = builder2.getSourceRoots();
                if (collection3 == null) break block1;
                it = collection = collection3;
                boolean bl = false;
                this.sourceRoots.addAll(it);
            }
        }
    }
}

