/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots.builders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.SdkIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilderHandler;
import com.intellij.util.indexing.roots.builders.InheritedSdkIteratorBuilder;
import com.intellij.util.indexing.roots.builders.SdkIteratorBuilder;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableRootModelBridge;
import com.intellij.workspaceModel.storage.EntityStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0002J,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler;", "Lcom/intellij/util/indexing/roots/builders/IndexableIteratorBuilderHandler;", "()V", "accepts", "", "builder", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$IndexableIteratorBuilder;", "builderToRoot", "Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler$Roots;", "Lcom/intellij/util/indexing/roots/builders/SdkIteratorBuilder;", "instantiate", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "builders", "", "project", "Lcom/intellij/openapi/project/Project;", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "AllRoots", "ListOfRoots", "Roots", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSdkIndexableIteratorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkIndexableIteratorHandler.kt\ncom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class SdkIndexableIteratorHandler
implements IndexableIteratorBuilderHandler {
    @Override
    public boolean accepts(@NotNull IndexableEntityProvider.IndexableIteratorBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        return builder2 instanceof SdkIteratorBuilder || builder2 instanceof InheritedSdkIteratorBuilder;
    }

    @NotNull
    public List<IndexableFilesIterator> instantiate(@NotNull Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull Project project2, @NotNull EntityStorage entityStorage) {
        Sdk sdk2;
        Map map2;
        Object key;
        Intrinsics.checkNotNullParameter(builders, (String)"builders");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        Map unifiedBuilders = new LinkedHashMap();
        Roots projectSdkRoots = null;
        for (IndexableEntityProvider.IndexableIteratorBuilder indexableIteratorBuilder : builders) {
            if (indexableIteratorBuilder instanceof SdkIteratorBuilder) {
                key = new Pair((Object)((SdkIteratorBuilder)indexableIteratorBuilder).getSdkName(), (Object)((SdkIteratorBuilder)indexableIteratorBuilder).getSdkType());
                Roots newRoot = this.builderToRoot((SdkIteratorBuilder)indexableIteratorBuilder);
                map2 = unifiedBuilders;
                Roots roots2 = (Roots)unifiedBuilders.get(key);
                if (roots2 == null || (roots2 = roots2.merge(newRoot)) == null) {
                    roots2 = newRoot;
                }
                Roots roots3 = roots2;
                map2.put(key, roots3);
                continue;
            }
            if (projectSdkRoots != null) continue;
            projectSdkRoots = AllRoots.INSTANCE;
        }
        if (projectSdkRoots != null && (sdk2 = ProjectRootManager.getInstance(project2).getProjectSdk()) != null) {
            Pair pair = new Pair((Object)sdk2.getName(), (Object)sdk2.getSdkType().getName());
            key = unifiedBuilders;
            Roots roots4 = (Roots)unifiedBuilders.get(pair);
            if (roots4 == null || (roots4 = roots4.merge(projectSdkRoots)) == null) {
                roots4 = projectSdkRoots;
            }
            Roots roots5 = roots4;
            key.put(pair, roots5);
        }
        List result2 = new ArrayList();
        for (Map.Entry entry : unifiedBuilders.entrySet()) {
            if (ModifiableRootModelBridge.Companion.findSdk((String)((Pair)entry.getKey()).getFirst(), (String)((Pair)entry.getKey()).getSecond()) == null) continue;
            Object $this$instantiate_u24lambda_u240 = map2;
            boolean bl = false;
            result2.addAll(((Roots)entry.getValue()).createIterator((Sdk)$this$instantiate_u24lambda_u240, project2));
        }
        return result2;
    }

    private final Roots builderToRoot(SdkIteratorBuilder builder2) {
        Roots roots2;
        Collection<VirtualFile> collection = builder2.getRoots();
        if (collection != null) {
            Collection<VirtualFile> it = collection;
            boolean bl = false;
            roots2 = new ListOfRoots((Collection<? extends VirtualFile>)it);
        } else {
            roots2 = AllRoots.INSTANCE;
        }
        return roots2;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000H&\u0082\u0001\u0002\u000b\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler$Roots;", "", "createIterator", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "merge", "newRoot", "Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler$AllRoots;", "Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler$ListOfRoots;", "intellij.platform.lang.impl"})
    private static interface Roots {
        @NotNull
        public Roots merge(@NotNull Roots var1);

        @NotNull
        public Collection<IndexableFilesIterator> createIterator(@NotNull Sdk var1, @NotNull Project var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler$AllRoots;", "Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler$Roots;", "()V", "createIterator", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "merge", "newRoot", "intellij.platform.lang.impl"})
    private static final class AllRoots
    implements Roots {
        @NotNull
        public static final AllRoots INSTANCE = new AllRoots();

        private AllRoots() {
        }

        @Override
        @NotNull
        public Roots merge(@NotNull Roots newRoot) {
            Intrinsics.checkNotNullParameter((Object)newRoot, (String)"newRoot");
            return this;
        }

        @Override
        @NotNull
        public Collection<IndexableFilesIterator> createIterator(@NotNull Sdk sdk2, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return IndexableEntityProviderMethods.INSTANCE.createIterators(sdk2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00032\u00020\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler$ListOfRoots;", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/collections/ArrayList;", "Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler$Roots;", "files", "", "(Ljava/util/Collection;)V", "()V", "createIterator", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "merge", "newRoot", "intellij.platform.lang.impl"})
    private static final class ListOfRoots
    extends ArrayList<VirtualFile>
    implements Roots {
        public ListOfRoots() {
        }

        public ListOfRoots(@NotNull Collection<? extends VirtualFile> files2) {
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            this();
            this.addAll(files2);
        }

        @Override
        @NotNull
        public Roots merge(@NotNull Roots newRoot) {
            Intrinsics.checkNotNullParameter((Object)newRoot, (String)"newRoot");
            Roots roots2 = newRoot;
            if (Intrinsics.areEqual((Object)roots2, (Object)AllRoots.INSTANCE)) {
                return newRoot;
            }
            if (roots2 instanceof ListOfRoots) {
                this.addAll((Collection)((Object)newRoot));
                return this;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public Collection<IndexableFilesIterator> createIterator(@NotNull Sdk sdk2, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return SdkIndexableFilesIteratorImpl.Companion.createIterators(sdk2, this);
        }
    }
}

