/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.openapi.Forceable;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.snapshot.CompositeHashId;
import com.intellij.util.indexing.snapshot.CompositeHashIdDescriptor;
import com.intellij.util.indexing.snapshot.CompositeHashIdEnumeratorKt;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentEnumerator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\b\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/indexing/snapshot/CompositeHashIdEnumerator;", "Ljava/io/Closeable;", "Lcom/intellij/openapi/Forceable;", "indexId", "Lcom/intellij/util/indexing/ID;", "(Lcom/intellij/util/indexing/ID;)V", "enumerator", "Lcom/intellij/util/io/PersistentEnumerator;", "Lcom/intellij/util/indexing/snapshot/CompositeHashId;", "clear", "", "close", "enumerate", "", "hashId", "subIndexerTypeId", "force", "getBasePath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "init", "isDirty", "", "intellij.platform.lang.impl"})
public final class CompositeHashIdEnumerator
implements Closeable,
Forceable {
    @NotNull
    private final ID<?, ?> indexId;
    @NotNull
    private volatile PersistentEnumerator<CompositeHashId> enumerator;

    public CompositeHashIdEnumerator(@NotNull ID<?, ?> indexId) {
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        this.indexId = indexId;
        this.enumerator = this.init();
    }

    @Override
    public void close() throws IOException {
        this.enumerator.close();
    }

    @Override
    public boolean isDirty() {
        return this.enumerator.isDirty();
    }

    @Override
    public void force() {
        this.enumerator.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() throws IOException {
        try {
            this.close();
        }
        catch (IOException e) {
            CompositeHashIdEnumeratorKt.access$getLOG$p().error(e);
        }
        finally {
            IOUtil.deleteAllFilesStartingWith(this.getBasePath());
            this.init();
        }
    }

    public final int enumerate(int hashId, int subIndexerTypeId) {
        return this.enumerator.enumerate(new CompositeHashId(hashId, subIndexerTypeId));
    }

    private final Path getBasePath() {
        return IndexInfrastructure.getIndexRootDir(this.indexId).resolve("compositeHashId");
    }

    private final PersistentEnumerator<CompositeHashId> init() {
        this.enumerator = new PersistentEnumerator(this.getBasePath(), new CompositeHashIdDescriptor(), 65536);
        return this.enumerator;
    }
}

