/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u00072\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010J\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService;", "Ljava/io/Closeable;", "()V", "contentHashEnumerator", "Lcom/intellij/util/hash/ContentHashEnumerator;", "handles", "", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandle;", "lock", "Ljava/util/concurrent/locks/Lock;", "state", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$State;", "close", "", "createHashEnumeratorHandle", "requestorIndexId", "Lcom/intellij/util/indexing/ID;", "flush", "initialize", "", "Companion", "HashEnumeratorHandle", "HashEnumeratorHandleImpl", "State", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSnapshotHashEnumeratorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotHashEnumeratorService.kt\ncom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,122:1\n10#2:123\n*S KotlinDebug\n*F\n+ 1 SnapshotHashEnumeratorService.kt\ncom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService\n*L\n21#1:123\n*E\n"})
public final class SnapshotHashEnumeratorService
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile State state = State.CLOSED;
    @Nullable
    private volatile ContentHashEnumerator contentHashEnumerator;
    @NotNull
    private final Set<HashEnumeratorHandle> handles = new HashSet();
    @NotNull
    private final Lock lock = new ReentrantLock();
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initialize() throws IOException {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.state == State.CLOSED) {
                Path hashEnumeratorFile = IndexInfrastructure.getPersistentIndexRoot().resolve("textContentHashes");
                this.state = State.OPEN;
                ContentHashEnumerator contentHashEnumerator = IOUtil.openCleanOrResetBroken(() -> SnapshotHashEnumeratorService.initialize$lambda$2$lambda$0(hashEnumeratorFile), () -> SnapshotHashEnumeratorService.initialize$lambda$2$lambda$1(hashEnumeratorFile, this));
                Intrinsics.checkNotNull((Object)contentHashEnumerator);
                this.contentHashEnumerator = contentHashEnumerator;
            }
            LOG.assertTrue(this.state != State.CLOSED);
            boolean bl2 = this.state == State.OPEN;
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.state == State.OPEN) {
                ContentHashEnumerator contentHashEnumerator = this.contentHashEnumerator;
                Intrinsics.checkNotNull((Object)contentHashEnumerator);
                contentHashEnumerator.close();
                this.state = State.CLOSED;
                LOG.assertTrue(this.handles.isEmpty(), "enumerator handles are still held: " + this.handles);
                this.handles.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.state == State.OPEN) {
                ContentHashEnumerator contentHashEnumerator = this.contentHashEnumerator;
                Intrinsics.checkNotNull((Object)contentHashEnumerator);
                contentHashEnumerator.force();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashEnumeratorHandle createHashEnumeratorHandle(@NotNull ID<?, ?> requestorIndexId) {
        Intrinsics.checkNotNullParameter(requestorIndexId, (String)"requestorIndexId");
        HashEnumeratorHandleImpl handle2 = new HashEnumeratorHandleImpl(requestorIndexId);
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.handles.add(handle2);
        }
        finally {
            lock.unlock();
        }
        return handle2;
    }

    private static final ContentHashEnumerator initialize$lambda$2$lambda$0(Path $hashEnumeratorFile) {
        return new ContentHashEnumerator($hashEnumeratorFile);
    }

    private static final void initialize$lambda$2$lambda$1(Path $hashEnumeratorFile, SnapshotHashEnumeratorService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IOUtil.deleteAllFilesStartingWith($hashEnumeratorFile);
        this$0.state = State.OPEN_AND_CLEAN;
    }

    @JvmStatic
    @NotNull
    public static final SnapshotHashEnumeratorService getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final void closeIfCreated() {
        Companion.closeIfCreated();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SnapshotHashEnumeratorService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$State;", "", "(Ljava/lang/String;I)V", "OPEN", "OPEN_AND_CLEAN", "CLOSED", "intellij.platform.lang.impl"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State OPEN = new State();
        public static final /* enum */ State OPEN_AND_CLEAN = new State();
        public static final /* enum */ State CLOSED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.OPEN, State.OPEN_AND_CLEAN, State.CLOSED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandle;", "", "enumerateHash", "", "digest", "", "release", "", "intellij.platform.lang.impl"})
    public static interface HashEnumeratorHandle {
        public int enumerateHash(@NotNull byte[] var1) throws IOException;

        public void release();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandleImpl;", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandle;", "requestorIndexId", "Lcom/intellij/util/indexing/ID;", "(Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService;Lcom/intellij/util/indexing/ID;)V", "enumerateHash", "", "digest", "", "equals", "", "other", "", "hashCode", "release", "", "toString", "", "intellij.platform.lang.impl"})
    private final class HashEnumeratorHandleImpl
    implements HashEnumeratorHandle {
        @NotNull
        private final ID<?, ?> requestorIndexId;

        public HashEnumeratorHandleImpl(ID<?, ?> requestorIndexId) {
            Intrinsics.checkNotNullParameter(requestorIndexId, (String)"requestorIndexId");
            this.requestorIndexId = requestorIndexId;
        }

        @Override
        public int enumerateHash(@NotNull byte[] digest) {
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            ContentHashEnumerator contentHashEnumerator = SnapshotHashEnumeratorService.this.contentHashEnumerator;
            Intrinsics.checkNotNull((Object)contentHashEnumerator);
            return contentHashEnumerator.enumerate(digest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Lock lock = SnapshotHashEnumeratorService.this.lock;
            SnapshotHashEnumeratorService snapshotHashEnumeratorService = SnapshotHashEnumeratorService.this;
            lock.lock();
            try {
                boolean bl = false;
                snapshotHashEnumeratorService.handles.remove(this);
                boolean bl2 = LOG.assertTrue(snapshotHashEnumeratorService.state != State.CLOSED, "handle is released for closed enumerator");
            }
            finally {
                lock.unlock();
            }
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof HashEnumeratorHandleImpl && Intrinsics.areEqual(((HashEnumeratorHandleImpl)other).requestorIndexId, this.requestorIndexId);
        }

        public int hashCode() {
            return this.requestorIndexId.hashCode();
        }

        @NotNull
        public String toString() {
            return "handle for " + this.requestorIndexId.getName();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "closeIfCreated", "", "getInstance", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nSnapshotHashEnumeratorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotHashEnumeratorService.kt\ncom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,122:1\n39#2,3:123\n52#2:126\n*S KotlinDebug\n*F\n+ 1 SnapshotHashEnumeratorService.kt\ncom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$Companion\n*L\n24#1:123,3\n28#1:126\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SnapshotHashEnumeratorService getInstance() {
            boolean $i$f$service = false;
            Class<SnapshotHashEnumeratorService> serviceClass$iv = SnapshotHashEnumeratorService.class;
            SnapshotHashEnumeratorService snapshotHashEnumeratorService = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (snapshotHashEnumeratorService == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return snapshotHashEnumeratorService;
        }

        @JvmStatic
        public final void closeIfCreated() {
            block0: {
                boolean $i$f$serviceIfCreated = false;
                Application application = ApplicationManager.getApplication();
                SnapshotHashEnumeratorService snapshotHashEnumeratorService = application != null ? application.getServiceIfCreated(SnapshotHashEnumeratorService.class) : null;
                if (snapshotHashEnumeratorService == null) break block0;
                snapshotHashEnumeratorService.close();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

