/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.snapshot.EmptyValueContainer;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.storage.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.io.MeasurableIndexStore;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotSingleValueIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance(SnapshotSingleValueIndexStorage.class);
    private volatile UpdatableSnapshotInputMappingIndex<Key, Value, FileContent> mySnapshotInputMappings;
    private volatile IntForwardIndex myForwardIndex;
    private final Lock myCacheLock = new ReentrantLock();
    private final SLRUCache<Key, ValueContainer<Value>> myCache;
    private volatile boolean myInitialized;

    public SnapshotSingleValueIndexStorage(int cacheSize) {
        this.myCache = new SLRUCache<Key, ValueContainer<Value>>(cacheSize, (int)Math.ceil((double)cacheSize * 0.25)){

            @Override
            @NotNull
            public ValueContainer<Value> createValue(Key key) {
                ValueContainer valueContainer;
                try {
                    valueContainer = SnapshotSingleValueIndexStorage.this.doRead(key);
                }
                catch (StorageException e) {
                    throw new RuntimeException(e);
                }
                if (valueContainer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return valueContainer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/snapshot/SnapshotSingleValueIndexStorage$1", "createValue"));
            }
        };
    }

    public void init(@NotNull SnapshotInputMappings<Key, Value> snapshotInputMappings, @NotNull IntForwardIndex forwardIndex) {
        if (snapshotInputMappings == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(0);
        }
        if (forwardIndex == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(1);
        }
        assert (!this.myInitialized);
        this.myForwardIndex = forwardIndex;
        this.mySnapshotInputMappings = snapshotInputMappings;
        this.myInitialized = true;
    }

    @NotNull
    public ValueContainer<Value> read(Key key) throws StorageException {
        assert (this.myInitialized);
        this.myCacheLock.lock();
        ValueContainer<Value> valueContainer = this.myCache.get(key);
        ValueContainer<Value> valueContainer2 = valueContainer;
        if (valueContainer2 == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(2);
        }
        return valueContainer2;
        finally {
            this.myCacheLock.unlock();
        }
    }

    @NotNull
    private ValueContainer<Value> doRead(Key key) throws StorageException {
        ValueContainerImpl valueContainerImpl;
        int inputId = SnapshotSingleValueIndexStorage.inputKey(key);
        try {
            int hashId = this.myForwardIndex.getInt(inputId);
            if (hashId == 0) {
                return new ValueContainerImpl();
            }
            Object item = ContainerUtil.getFirstItem(this.mySnapshotInputMappings.readData(hashId).values());
            ValueContainerImpl container = new ValueContainerImpl();
            container.addValue(inputId, item);
            valueContainerImpl = container;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        if (valueContainerImpl == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(3);
        }
        return valueContainerImpl;
    }

    public boolean processKeys(@NotNull Processor<? super Key> processor, GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (processor == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(4);
        }
        assert (this.myInitialized);
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addValue(Key key, int inputId, Value value) {
        assert (this.myInitialized);
        this.checkKeyInputIdConsistency(key, inputId);
        this.myCache.remove(key);
    }

    public void removeAllValues(@NotNull Key key, int inputId) {
        if (key == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(5);
        }
        assert (this.myInitialized);
        this.checkKeyInputIdConsistency(key, inputId);
        this.myCache.remove(key);
    }

    public void clear() {
        this.clearCaches();
    }

    public void clearCaches() {
        this.myCacheLock.lock();
        try {
            this.myCache.clear();
        }
        finally {
            this.myCacheLock.unlock();
        }
    }

    public int keysCountApproximately() {
        assert (this.myInitialized);
        return MeasurableIndexStore.keysCountApproximatelyIfPossible(this.myForwardIndex);
    }

    public void close() throws StorageException {
    }

    public void flush() throws IOException {
        this.clearCaches();
    }

    private void checkKeyInputIdConsistency(Key key, int inputId) {
        if (!Comparing.equal(key, inputId)) {
            LOG.error("key (" + key + ") and inputId (" + inputId + ") should be the same for " + SingleEntryFileBasedIndexExtension.class.getName());
        }
    }

    private static <Key> int inputKey(Key key) {
        return (Integer)key;
    }

    public static <Value> ValueContainer<Value> empty() {
        return EmptyValueContainer.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotInputMappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/snapshot/SnapshotSingleValueIndexStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/snapshot/SnapshotSingleValueIndexStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doRead";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

