/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.PageCacheUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectByteBufferAllocator {
    private static final ExecutorService ourAllocator = SystemInfoRt.isLinux && Boolean.parseBoolean(System.getProperty("idea.limit.paged.storage.allocators", "true")) ? ConcurrencyUtil.newSingleThreadExecutor("DirectBufferWrapper allocation thread") : null;
    private static final boolean USE_POOLED_ALLOCATOR = SystemProperties.getBooleanProperty("idea.index.use.pooled.page.allocator", true);
    private static final int POOL_CAPACITY_PER_BUFFER_SIZE = 40;
    private final ConcurrentSkipListMap<Integer, ArrayBlockingQueue<ByteBuffer>> myPool = new ConcurrentSkipListMap();
    private final AtomicInteger mySize = new AtomicInteger();
    private final int mySizeLimitInBytes;
    private volatile int hits;
    private volatile int misses;
    private volatile int reclaimed;
    private volatile int disposed;
    public static final DirectByteBufferAllocator ALLOCATOR = new DirectByteBufferAllocator(PageCacheUtils.ALLOCATOR_SIZE);

    static <E extends Exception> ByteBuffer allocate(ThrowableComputable<? extends ByteBuffer, E> computable) throws E {
        if (ourAllocator != null) {
            try {
                return ourAllocator.submit(computable::compute).get();
            }
            catch (InterruptedException e) {
                Logger.getInstance(DirectByteBufferAllocator.class).error(e);
                return computable.compute();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)cause;
                }
                throw new RuntimeException(e);
            }
        }
        return computable.compute();
    }

    private DirectByteBufferAllocator(int sizeLimitInBytes) {
        this.mySizeLimitInBytes = sizeLimitInBytes;
    }

    @NotNull
    public ByteBuffer allocate(int size) {
        if (USE_POOLED_ALLOCATOR) {
            Map.Entry<Integer, ArrayBlockingQueue<ByteBuffer>> buffers = this.myPool.ceilingEntry(size);
            while (buffers != null) {
                ByteBuffer cachedBuffer = buffers.getValue().poll();
                int capacity = buffers.getKey();
                if (cachedBuffer != null) {
                    cachedBuffer.rewind();
                    cachedBuffer.limit(size);
                    this.mySize.addAndGet(-capacity);
                    ++this.hits;
                    ByteBuffer byteBuffer = cachedBuffer;
                    if (byteBuffer == null) {
                        DirectByteBufferAllocator.$$$reportNull$$$0(0);
                    }
                    return byteBuffer;
                }
                buffers = this.myPool.higherEntry(capacity);
            }
        }
        ++this.misses;
        ByteBuffer byteBuffer = DirectByteBufferAllocator.allocateNewBuffer(size);
        if (byteBuffer == null) {
            DirectByteBufferAllocator.$$$reportNull$$$0(1);
        }
        return byteBuffer;
    }

    private static ByteBuffer allocateNewBuffer(int size) {
        return DirectByteBufferAllocator.allocate(() -> ByteBuffer.allocateDirect(size));
    }

    public void release(@NotNull ByteBuffer buffer) {
        int capacity;
        if (buffer == null) {
            DirectByteBufferAllocator.$$$reportNull$$$0(2);
        }
        if (USE_POOLED_ALLOCATOR && this.mySize.get() < this.mySizeLimitInBytes && this.myPool.computeIfAbsent(capacity = buffer.capacity(), __ -> new ArrayBlockingQueue(40)).offer(buffer)) {
            this.mySize.addAndGet(capacity);
            ++this.reclaimed;
            return;
        }
        ByteBufferUtil.cleanBuffer(buffer);
        ++this.disposed;
    }

    public Statistics getStatistics() {
        return new Statistics(this.hits, this.misses, this.reclaimed, this.disposed, this.mySize.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/DirectByteBufferAllocator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "allocate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/DirectByteBufferAllocator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Statistics {
        public final int hits;
        public final int misses;
        public final int reclaimed;
        public final int disposed;
        public final int totalSizeOfBuffersCachedInBytes;

        private Statistics(int hits, int misses, int reclaimed, int disposed, int totalSizeOfBuffersCachedInBytes) {
            this.hits = hits;
            this.misses = misses;
            this.reclaimed = reclaimed;
            this.disposed = disposed;
            this.totalSizeOfBuffersCachedInBytes = totalSizeOfBuffersCachedInBytes;
        }
    }
}

