/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.UnInterruptibleFileChannelHandle;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

final class FileChannelWithSizeTracking {
    private static final Logger LOG = Logger.getInstance(FileChannelWithSizeTracking.class);
    private static final boolean doAssertions = SystemProperties.getBooleanProperty("idea.do.random.access.wrapper.assertions", false);
    private final Path myPath;
    private final UnInterruptibleFileChannelHandle myChannelHandle;
    private volatile long mySize;

    FileChannelWithSizeTracking(@NotNull Path path2) throws IOException {
        if (path2 == null) {
            FileChannelWithSizeTracking.$$$reportNull$$$0(0);
        }
        Path parent2 = path2.getParent();
        if (!Files.exists(parent2, new LinkOption[0])) {
            Files.createDirectories(parent2, new FileAttribute[0]);
        }
        this.myChannelHandle = new UnInterruptibleFileChannelHandle(path2, EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
        this.mySize = this.myChannelHandle.executeOperation(ch -> ch.size());
        this.myPath = path2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Inst:" + this + "," + Thread.currentThread() + "," + this.getClass().getClassLoader());
        }
    }

    long length() throws IOException {
        if (doAssertions) assert (this.mySize == this.myChannelHandle.executeOperation(ch -> ch.size()));
        return this.mySize;
    }

    void write(long addr, byte[] dst, int off, int len) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("write:" + this + "," + Thread.currentThread() + "," + len + "," + addr);
        }
        int written = this.myChannelHandle.executeOperation(ch -> ch.write(ByteBuffer.wrap(dst, off, len), addr));
        this.mySize = Math.max((long)written + addr, this.length());
    }

    void read(long addr, byte[] dst, int off, int len) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("read:" + this + "," + Thread.currentThread() + "," + len + "," + addr);
        }
        this.myChannelHandle.executeOperation(ch -> ch.read(ByteBuffer.wrap(dst, off, len), addr));
    }

    void close() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Closed:" + this + "," + Thread.currentThread());
        }
        this.force();
        this.myChannelHandle.close();
    }

    public String toString() {
        return this.myPath + "@" + Integer.toHexString(this.hashCode());
    }

    public void force() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Forcing:" + this + "," + Thread.currentThread());
        }
        this.myChannelHandle.executeOperation(ch -> {
            ch.force(true);
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/io/FileChannelWithSizeTracking", "<init>"));
    }
}

