/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.UnInterruptibleFileChannel;
import com.intellij.util.io.stats.CachedChannelsStatistics;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class OpenChannelsCache {
    private final int myCapacity;
    private int myHitCount;
    private int myMissCount;
    private int myLoadCount;
    @NotNull
    private final Map<Path, ChannelDescriptor> myCache;
    private final transient Object myCacheLock = new Object();

    OpenChannelsCache(int capacity) {
        this.myCapacity = capacity;
        this.myCache = new LinkedHashMap<Path, ChannelDescriptor>(capacity, 0.5f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    CachedChannelsStatistics getStatistics() {
        Object object = this.myCacheLock;
        // MONITORENTER : object
        CachedChannelsStatistics cachedChannelsStatistics = new CachedChannelsStatistics(this.myHitCount, this.myMissCount, this.myLoadCount, this.myCapacity);
        // MONITOREXIT : object
        if (cachedChannelsStatistics != null) return cachedChannelsStatistics;
        OpenChannelsCache.$$$reportNull$$$0(0);
        return cachedChannelsStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T useChannel(@NotNull Path path2, @NotNull ChannelProcessor<T> processor, boolean read) throws IOException {
        ChannelDescriptor descriptor2;
        if (path2 == null) {
            OpenChannelsCache.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            OpenChannelsCache.$$$reportNull$$$0(2);
        }
        Object object = this.myCacheLock;
        synchronized (object) {
            descriptor2 = this.myCache.get(path2);
            if (descriptor2 == null) {
                boolean somethingDropped = this.releaseOverCachedChannels();
                descriptor2 = new ChannelDescriptor(path2, read);
                this.myCache.put(path2, descriptor2);
                if (somethingDropped) {
                    ++this.myMissCount;
                } else {
                    ++this.myLoadCount;
                }
            } else if (!read && descriptor2.isReadOnly()) {
                if (descriptor2.isLocked()) {
                    descriptor2 = new ChannelDescriptor(path2, false);
                } else {
                    this.closeChannel(path2);
                    descriptor2 = new ChannelDescriptor(path2, false);
                    this.myCache.put(path2, descriptor2);
                }
                ++this.myMissCount;
            } else {
                ++this.myHitCount;
            }
            descriptor2.lock();
        }
        try {
            object = processor.process(descriptor2.getChannel());
            return (T)object;
        }
        finally {
            Object object2 = this.myCacheLock;
            synchronized (object2) {
                descriptor2.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeChannel(Path path2) throws IOException {
        Object object = this.myCacheLock;
        synchronized (object) {
            ChannelDescriptor descriptor2 = this.myCache.remove(path2);
            if (descriptor2 != null) {
                assert (!descriptor2.isLocked()) : "Channel is in use: " + descriptor2;
                descriptor2.close();
            }
        }
    }

    private boolean releaseOverCachedChannels() throws IOException {
        int dropCount = this.myCache.size() - this.myCapacity;
        if (dropCount >= 0) {
            ArrayList<Path> keysToDrop = new ArrayList<Path>();
            for (Map.Entry<Path, ChannelDescriptor> entry : this.myCache.entrySet()) {
                if (dropCount < 0) break;
                if (entry.getValue().isLocked()) continue;
                --dropCount;
                keysToDrop.add(entry.getKey());
            }
            for (Path file2 : keysToDrop) {
                this.closeChannel(file2);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/OpenChannelsCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatistics";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/OpenChannelsCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "useChannel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ChannelDescriptor
    implements Closeable {
        private int myLockCount;
        @NotNull
        private final UnInterruptibleFileChannel myChannel;
        private final boolean myReadOnly;
        private static final OpenOption[] MODIFIABLE_OPTS = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
        private static final OpenOption[] READ_ONLY_OPTS = new OpenOption[]{StandardOpenOption.READ};

        ChannelDescriptor(@NotNull Path file2, boolean readOnly) throws IOException {
            if (file2 == null) {
                ChannelDescriptor.$$$reportNull$$$0(0);
            }
            this.myLockCount = 0;
            this.myReadOnly = readOnly;
            this.myChannel = Objects.requireNonNull(FileUtilRt.doIOOperation(lastAttempt -> {
                try {
                    return new UnInterruptibleFileChannel(file2, readOnly ? READ_ONLY_OPTS : MODIFIABLE_OPTS);
                }
                catch (NoSuchFileException ex) {
                    Path parent2 = file2.getParent();
                    if (!readOnly) {
                        if (!Files.exists(parent2, new LinkOption[0])) {
                            Files.createDirectories(parent2, new FileAttribute[0]);
                        }
                        if (!lastAttempt) {
                            return null;
                        }
                    }
                    throw ex;
                }
            }));
        }

        boolean isReadOnly() {
            return this.myReadOnly;
        }

        void lock() {
            ++this.myLockCount;
        }

        void unlock() {
            --this.myLockCount;
        }

        boolean isLocked() {
            return this.myLockCount != 0;
        }

        @NotNull
        UnInterruptibleFileChannel getChannel() {
            UnInterruptibleFileChannel unInterruptibleFileChannel = this.myChannel;
            if (unInterruptibleFileChannel == null) {
                ChannelDescriptor.$$$reportNull$$$0(1);
            }
            return unInterruptibleFileChannel;
        }

        @Override
        public void close() throws IOException {
            this.myChannel.close();
        }

        public String toString() {
            return "ChannelDescriptor{locks=" + this.myLockCount + ", channel=" + this.myChannel + ", readOnly=" + this.myReadOnly + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/OpenChannelsCache$ChannelDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/OpenChannelsCache$ChannelDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChannel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @FunctionalInterface
    static interface ChannelProcessor<T> {
        public T process(@NotNull FileChannel var1) throws IOException;
    }
}

