/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.FilePageCacheLockFree;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.io.PageCacheUtils;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.pagecache.FilePageCacheStatistics;
import com.intellij.util.io.pagecache.Page;
import com.intellij.util.io.pagecache.PagedStorage;
import com.intellij.util.io.pagecache.impl.PageImpl;
import com.intellij.util.io.pagecache.impl.PageToStorageHandle;
import com.intellij.util.io.pagecache.impl.PagesTable;
import com.intellij.util.io.storage.AbstractStorage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PagedFileStorageLockFree
implements PagedStorage {
    private static final Logger LOG = Logger.getInstance(PagedFileStorageLockFree.class);
    public static final int DEFAULT_PAGE_SIZE = PageCacheUtils.DEFAULT_PAGE_SIZE;
    private static final StorageLockContext DEFAULT_LOCK_CONTEXT = new StorageLockContext(false);
    public static final ThreadLocal<StorageLockContext> THREAD_LOCAL_STORAGE_LOCK_CONTEXT = new ThreadLocal();
    @NotNull
    private final StorageLockContext storageLockContext;
    @NotNull
    private final Path file;
    private final boolean readOnly;
    private final int pageSize;
    private final boolean nativeBytesOrder;
    @NotNull
    private final FilePageCacheLockFree pageCache;
    private final PagesTable pages;
    private volatile Future<?> closingInProgress;
    private final AtomicInteger dirtyPagesCount;
    private final AtomicLong actualSize;
    private final transient PageToStorageHandle pageToStorageHandle;
    private static final int MAX_FILLER_SIZE = 8192;
    private static final byte[] ZEROES = new byte[8192];

    public PagedFileStorageLockFree(@NotNull Path file2, @Nullable StorageLockContext storageLockContext, int pageSize, boolean nativeBytesOrder) throws IOException {
        if (file2 == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(0);
        }
        this.closingInProgress = null;
        this.dirtyPagesCount = new AtomicInteger(0);
        this.actualSize = new AtomicLong(0L);
        this.pageToStorageHandle = new PageToStorageHandle(){

            @Override
            public void pageBecomeDirty() {
                PagedFileStorageLockFree.this.dirtyPagesCount.incrementAndGet();
            }

            @Override
            public void pageBecomeClean() {
                int dirtyPages = PagedFileStorageLockFree.this.dirtyPagesCount.decrementAndGet();
                if (dirtyPages < 0) {
                    throw new AssertionError((Object)("Bug: dirty pages (=" + dirtyPages + ") can't be negative"));
                }
            }

            @Override
            public void modifiedRegionUpdated(long startOffsetInFile, int length) {
                long requiredFileSize;
                long actualFileSize;
                do {
                    if ((actualFileSize = PagedFileStorageLockFree.this.actualSize.get()) < (requiredFileSize = startOffsetInFile + (long)length)) continue;
                    return;
                } while (!PagedFileStorageLockFree.this.actualSize.compareAndSet(actualFileSize, requiredFileSize));
            }

            @Override
            public void flushBytes(@NotNull ByteBuffer dataToFlush, long offsetInFile) throws IOException {
                if (dataToFlush == null) {
                    1.$$$reportNull$$$0(0);
                }
                PagedFileStorageLockFree.this.flushPage(dataToFlush, offsetInFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataToFlush", "com/intellij/util/io/PagedFileStorageLockFree$1", "flushBytes"));
            }
        };
        this.file = file2;
        this.readOnly = PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get() == Boolean.TRUE;
        this.storageLockContext = PagedFileStorageLockFree.findOutAppropriateContext(storageLockContext);
        this.pageSize = Math.max(pageSize > 0 ? pageSize : PageCacheUtils.DEFAULT_PAGE_SIZE, AbstractStorage.PAGE_SIZE);
        this.nativeBytesOrder = nativeBytesOrder;
        this.pageCache = this.storageLockContext.pageCache();
        this.pages = this.pageCache.registerStorage(this);
        try {
            if (Files.exists(file2, new LinkOption[0])) {
                this.actualSize.set(Files.size(file2));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public StorageLockContext getStorageLockContext() {
        StorageLockContext storageLockContext = this.storageLockContext;
        if (storageLockContext == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(1);
        }
        return storageLockContext;
    }

    @Override
    @NotNull
    public Path getFile() {
        Path path2 = this.file;
        if (path2 == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(2);
        }
        return path2;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean isNativeBytesOrder() {
        return this.nativeBytesOrder;
    }

    @Override
    public void putInt(long offsetInFile, int value) throws IOException {
        this.checkValueIsPageAligned(offsetInFile, 4);
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetOnPage = this.toOffsetInPage(offsetInFile);
        try (Page page2 = this.pageByIndex(pageIndex, true);){
            page2.putInt(offsetOnPage, value);
        }
    }

    @Override
    public int getInt(long offsetInFile) throws IOException {
        this.checkValueIsPageAligned(offsetInFile, 4);
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page2 = this.pageByIndex(pageIndex, false);){
            int n = page2.getInt(offsetInPage);
            return n;
        }
    }

    @Override
    public void putLong(long offsetInFile, long value) throws IOException {
        this.checkValueIsPageAligned(offsetInFile, 8);
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page2 = this.pageByIndex(pageIndex, true);){
            page2.putLong(offsetInPage, value);
        }
    }

    @Override
    public long getLong(long offsetInFile) throws IOException {
        this.checkValueIsPageAligned(offsetInFile, 8);
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page2 = this.pageByIndex(pageIndex, false);){
            long l = page2.getLong(offsetInPage);
            return l;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putBuffer(long offsetInFile, @NotNull ByteBuffer byteBuffer) throws IOException {
        void data2;
        if (byteBuffer == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(3);
        }
        this.checkValueIsPageAligned(offsetInFile, data2.remaining());
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page2 = this.pageByIndex(pageIndex, true);){
            page2.putFromBuffer((ByteBuffer)data2, offsetInPage);
        }
    }

    @Override
    public byte get(long offsetInFile) throws IOException {
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page2 = this.pageByIndex(pageIndex, false);){
            byte by = page2.get(offsetInPage);
            return by;
        }
    }

    @Override
    public void put(long offsetInFile, byte value) throws IOException {
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page2 = this.pageByIndex(pageIndex, true);){
            page2.put(offsetInPage, value);
        }
    }

    @Override
    public void get(long offsetInFile, byte[] destination, int offsetInArray, int length) throws IOException {
        long currentOffsetInFile = offsetInFile;
        int currentOffsetInArray = offsetInArray;
        int remainingBytesToRead = length;
        while (remainingBytesToRead > 0) {
            int pageIndex = this.toPageIndex(currentOffsetInFile);
            int offsetInPage = this.toOffsetInPage(currentOffsetInFile);
            int bytesToRead = Math.min(remainingBytesToRead, this.pageSize - offsetInPage);
            try (Page page2 = this.pageByIndex(pageIndex, false);){
                page2.readToArray(destination, currentOffsetInArray, offsetInPage, bytesToRead);
            }
            remainingBytesToRead -= bytesToRead;
            currentOffsetInArray += bytesToRead;
            currentOffsetInFile += (long)bytesToRead;
        }
    }

    @Override
    public void put(long offsetInFile, byte[] src, int offsetInArray, int length) throws IOException {
        long i2 = offsetInFile;
        int o = offsetInArray;
        int l = length;
        while (l > 0) {
            int pageIndex = this.toPageIndex(i2);
            int offsetInPage = this.toOffsetInPage(i2);
            int page_len = Math.min(l, this.pageSize - offsetInPage);
            try (Page page2 = this.pageByIndex(pageIndex, true);){
                page2.putFromArray(src, o, offsetInPage, page_len);
            }
            l -= page_len;
            o += page_len;
            i2 += (long)page_len;
        }
    }

    @Override
    public final long length() {
        return this.actualSize.get();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public boolean isDirty() {
        return this.dirtyPagesCount.get() > 0;
    }

    @Override
    @NotNull
    public Page pageByOffset(long offsetInFile, boolean forModification) throws IOException {
        int pageIndex = this.toPageIndex(offsetInFile);
        Page page2 = this.pageByIndex(pageIndex, forModification);
        if (page2 == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(4);
        }
        return page2;
    }

    public Page pageByIndex(int pageIndex, boolean forModification) throws IOException {
        if (this.readOnly && forModification) {
            throw new IOException("Read-only storage can't be modified");
        }
        if (pageIndex < 0) {
            throw new AssertionError((Object)("Page " + pageIndex + " must be >=0"));
        }
        FilePageCacheStatistics statistics = this.pageCache.getStatistics();
        long startedAtNs = statistics.startTimestampNs();
        while (true) {
            if (this.isClosed()) {
                throw new ClosedStorageException("Storage is already closed: " + this.file);
            }
            PageImpl page2 = this.pages.lookupOrCreate(pageIndex, this::createUninitializedPage, this::loadPageData);
            try {
                while (!page2.tryAcquireForUse(this)) {
                    Thread.yield();
                }
                statistics.pageRequested(page2.pageSize(), startedAtNs);
                return page2;
            }
            catch (IOException ignore) {
                LOG.trace("Page " + page2 + " likely released -> request it again");
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closingInProgress != null;
    }

    @Override
    public void force() throws IOException {
        if (this.isDirty()) {
            this.pages.flushAll();
        }
    }

    @Override
    public void close() throws IOException, InterruptedException {
        if (this.isClosed()) {
            return;
        }
        this.pageCache.tryToReclaimAll(this.pages);
        Future<?> future = this.closeAsync();
        try {
            future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Can't close storage for " + this.file, cause);
        }
    }

    public synchronized Future<?> closeAsync() {
        if (!this.isClosed()) {
            CompletableFuture<Object> closingProgress = new CompletableFuture<Object>();
            this.closingInProgress = closingProgress;
            this.pageCache.enqueueStoragePagesClosing(this, closingProgress);
        }
        return this.closingInProgress;
    }

    @Override
    public int toOffsetInPage(long offsetInFile) {
        return (int)(offsetInFile % (long)this.pageSize);
    }

    public String toString() {
        return "PagedFileStorage[" + this.file + "]{size: " + this.actualSize.get() + ", dirtyPages: " + this.dirtyPagesCount.get() + "}{pageSize: " + this.pageSize + ", " + (this.isClosed() ? "closed " : " ") + (this.isReadOnly() ? "readOnly " : " ") + (this.isNativeBytesOrder() ? "nativeByteOrder " : " ") + "}";
    }

    private int toPageIndex(long offsetInFile) {
        int pageIndex = (int)(offsetInFile / (long)this.pageSize);
        assert (pageIndex >= 0) : "pageIndex(offset: " + offsetInFile + ") = " + pageIndex + ", but must be >=0";
        return pageIndex;
    }

    private boolean isValueAlignedToPage(long offsetInFile, int valueLength) {
        int offsetInPage = (int)(offsetInFile % (long)this.pageSize);
        int remainsOnPage = this.pageSize - offsetInPage;
        return valueLength <= remainsOnPage;
    }

    private void checkValueIsPageAligned(long offsetInFile, int valueLength) throws IOException {
        if (!this.isValueAlignedToPage(offsetInFile, valueLength)) {
            throw new IOException(valueLength + " bytes @ " + offsetInFile + " break page [" + this.pageSize + "b] border: use PagedStorageWithUnalignedAccess wrapper if un-aligned primitive access is needed");
        }
    }

    protected PagesTable pages() {
        return this.pages;
    }

    <R> R useChannel(@NotNull OpenChannelsCache.ChannelProcessor<R> processor, boolean read) throws IOException {
        if (processor == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(5);
        }
        if (this.storageLockContext.useChannelCache()) {
            return PageCacheUtils.CHANNELS_CACHE.useChannel(this.file, processor, read);
        }
        this.storageLockContext.getBufferCache().incrementUncachedFileAccess();
        try (OpenChannelsCache.ChannelDescriptor desc = new OpenChannelsCache.ChannelDescriptor(this.file, read);){
            R r = processor.process(desc.getChannel());
            return r;
        }
    }

    private PageImpl createUninitializedPage(int pageIndex) {
        return PageImpl.notReady(pageIndex, this.pageSize, this.pageToStorageHandle);
    }

    private ByteBuffer loadPageData(@NotNull PageImpl pageToLoad) throws IOException {
        if (pageToLoad == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(6);
        }
        if (this.isClosed()) {
            throw new ClosedStorageException("Storage is already closed");
        }
        if (!pageToLoad.isNotReadyYet()) {
            throw new AssertionError((Object)("Page must be NOT_READY_YET, but " + pageToLoad));
        }
        FilePageCacheStatistics statistics = this.pageCache.getStatistics();
        long startedAtNs = statistics.startTimestampNs();
        ByteBuffer pageBuffer = this.pageCache.allocatePageBuffer(this.pageSize);
        pageBuffer.order(this.nativeBytesOrder ? ByteOrder.nativeOrder() : ByteOrder.BIG_ENDIAN);
        this.useChannel(ch -> {
            int readBytes = ch.read(pageBuffer, pageToLoad.offsetInFile());
            if (readBytes < this.pageSize) {
                int startFrom = Math.max(0, readBytes);
                PagedFileStorageLockFree.fillWithZeroes(pageBuffer, startFrom, this.pageSize);
            }
            statistics.pageRead(readBytes, startedAtNs);
            return pageBuffer;
        }, this.isReadOnly());
        return pageBuffer;
    }

    private void flushPage(@NotNull ByteBuffer bufferToSave, long offsetInFile) throws IOException {
        if (bufferToSave == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(7);
        }
        FilePageCacheStatistics statistics = this.pageCache.getStatistics();
        long startedAtNs = statistics.startTimestampNs();
        int bytesToStore = bufferToSave.remaining();
        this.useChannel(ch -> {
            ch.write(bufferToSave, offsetInFile);
            return null;
        }, this.isReadOnly());
        statistics.pageWritten(bytesToStore, startedAtNs);
    }

    private static void fillWithZeroes(@NotNull ByteBuffer pageBuffer, int startOffsetInclusive, int endOffsetExclusive) {
        int toFillNow;
        if (pageBuffer == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(8);
        }
        for (int currentOffset = startOffsetInclusive; currentOffset < endOffsetExclusive; currentOffset += toFillNow) {
            int remains = endOffsetExclusive - currentOffset;
            toFillNow = Math.min(remains, 8192);
            pageBuffer.put(ZEROES, 0, toFillNow);
        }
    }

    @NotNull
    private static StorageLockContext findOutAppropriateContext(@Nullable StorageLockContext storageLockContext) {
        StorageLockContext threadContext = THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get();
        if (threadContext != null) {
            if (storageLockContext != null && storageLockContext != threadContext) {
                throw new IllegalStateException("Context(" + storageLockContext + ") != THREAD_LOCAL_STORAGE_LOCK_CONTEXT(" + threadContext + ")");
            }
            StorageLockContext storageLockContext2 = threadContext;
            if (storageLockContext2 == null) {
                PagedFileStorageLockFree.$$$reportNull$$$0(9);
            }
            return storageLockContext2;
        }
        StorageLockContext storageLockContext3 = storageLockContext != null ? storageLockContext : DEFAULT_LOCK_CONTEXT;
        if (storageLockContext3 == null) {
            PagedFileStorageLockFree.$$$reportNull$$$0(10);
        }
        return storageLockContext3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PagedFileStorageLockFree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageToLoad";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bufferToSave";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PagedFileStorageLockFree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageLockContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pageByOffset";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOutAppropriateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putBuffer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "useChannel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadPageData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "flushPage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillWithZeroes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

