/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u0010\u0010\r\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a1\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00010\u0011H\u0001\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\f*\u00020\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u001b\u001a\u00020\u0002*\u00020\u0002\u001a\u0012\u0010\u001c\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u001a\u0016\u0010\u001d\u001a\u00020\u0019*\u00020\u00022\b\b\u0002\u0010\u001e\u001a\u00020\u0001H\u0007\u001a\u0012\u0010\u001f\u001a\u00020\u0019*\u00020\u00022\u0006\u0010 \u001a\u00020\u0005\u001a\u001c\u0010!\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\"\u001a\u00020\u00022\b\b\u0002\u0010#\u001a\u00020\u0001\u001ak\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%*\u00020\u00022#\b\b\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00010\u00112'\u0010&\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00020'\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b((\u0012\u0004\u0012\u0002H%0\u0011H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)\u001aF\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%*\u00020\u00022'\u0010&\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00020'\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b((\u0012\u0004\u0012\u0002H%0\u0011H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*\u001a\f\u0010+\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\n\u0010,\u001a\u00020-*\u00020\u0002\u001a\f\u0010.\u001a\u0004\u0018\u00010-*\u00020\u0002\u001a\u0012\u0010/\u001a\u00020\u0001*\u00020\u00022\u0006\u00100\u001a\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010#\u001a\u00020\u0001*\u00020\u0002\u001a\n\u00101\u001a\u00020\u0001*\u00020\u0002\u001a\n\u00102\u001a\u000203*\u00020\u0002\u001a\u0012\u00104\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u001a\u0016\u00105\u001a\u000206*\u00020\u00022\b\b\u0002\u00107\u001a\u00020\u0001H\u0007\u001a\n\u00108\u001a\u000209*\u00020\u0002\u001a\n\u0010:\u001a\u00020;*\u00020\u0002\u001a\n\u0010<\u001a\u00020\u0005*\u00020\u0002\u001a\n\u0010=\u001a\u000206*\u00020\u0002\u001a\n\u0010>\u001a\u00020?*\u00020\u0002\u001a\n\u0010@\u001a\u00020?*\u00020\u0002\u001a\u001c\u0010A\u001a\u00020\u0002*\u00020\u00022\u0006\u0010B\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020\u0001\u001a(\u0010A\u001a\u00020\u0002*\u00020\u00022\u0006\u0010B\u001a\u0002092\b\b\u0002\u0010E\u001a\u00020F2\b\b\u0002\u0010>\u001a\u00020FH\u0007\u001a(\u0010A\u001a\u00020\u0002*\u00020\u00022\u0006\u0010B\u001a\u00020;2\b\b\u0002\u0010G\u001a\u00020H2\b\b\u0002\u0010D\u001a\u00020\u0001H\u0007\u001a\u001a\u0010I\u001a\u00020\u0002*\u00020\u00022\u0006\u0010J\u001a\u00020\u00052\u0006\u0010B\u001a\u000209\u001a\u001a\u0010I\u001a\u00020\u0002*\u00020\u00022\u0006\u0010J\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006K"}, d2={"isWritable", "", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Z", "systemIndependentPath", "", "getSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "generateRandomPath", "parentDirectory", "isDirectory", "attributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "isSymbolicLink", "makeFilter", "Ljava/nio/file/DirectoryStream$Filter;", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "path", "basicAttributesIfExists", "copy", "target", "copyRecursively", "", "createDirectories", "createFile", "createSymbolicLink", "delete", "recursively", "deleteChildrenStartingWith", "prefix", "deleteWithParentsIfEmpty", "root", "isFile", "directoryStreamIfExists", "R", "task", "Ljava/nio/file/DirectoryStream;", "stream", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exists", "inputStream", "Ljava/io/InputStream;", "inputStreamIfExists", "isAncestor", "child", "isHidden", "lastModified", "Ljava/nio/file/attribute/FileTime;", "move", "outputStream", "Ljava/io/OutputStream;", "append", "readBytes", "", "readChars", "", "readText", "safeOutputStream", "size", "", "sizeOrNull", "write", "data", "Ljava/nio/ByteBuffer;", "createParentDirs", "offset", "", "charset", "Ljava/nio/charset/Charset;", "writeChild", "relativePath", "intellij.platform.util.ex"})
@SourceDebugExtension(value={"SMAP\npath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 path.kt\ncom/intellij/util/io/PathKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n215#1,6:256\n1855#2,2:262\n1#3:264\n*S KotlinDebug\n*F\n+ 1 path.kt\ncom/intellij/util/io/PathKt\n*L\n98#1:256,6\n98#1:262,2\n*E\n"})
public final class PathKt {
    @Deprecated(message="Use kotlin.io.path.exists", level=DeprecationLevel.ERROR)
    public static final boolean exists(@NotNull Path $this$exists) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists($this$exists, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    @NotNull
    public static final Path createDirectories(@NotNull Path $this$createDirectories) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectories, (String)"<this>");
        Path path2 = NioFiles.createDirectories($this$createDirectories);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(this)");
        return path2;
    }

    @JvmOverloads
    @NotNull
    public static final OutputStream outputStream(@NotNull Path $this$outputStream, boolean append) {
        Intrinsics.checkNotNullParameter((Object)$this$outputStream, (String)"<this>");
        Path path2 = $this$outputStream.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        if (append) {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            OutputStream outputStream = Files.newOutputStream($this$outputStream, openOptionArray);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this, St\u2026tandardOpenOption.CREATE)");
            return outputStream;
        }
        OutputStream outputStream = Files.newOutputStream($this$outputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this)");
        return outputStream;
    }

    public static /* synthetic */ OutputStream outputStream$default(Path path2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PathKt.outputStream(path2, bl);
    }

    @NotNull
    public static final OutputStream safeOutputStream(@NotNull Path $this$safeOutputStream) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$safeOutputStream, (String)"<this>");
            Path path2 = $this$safeOutputStream.getParent();
            if (path2 == null) break block0;
            PathKt.createDirectories(path2);
        }
        return new SafeFileOutputStream($this$safeOutputStream);
    }

    @NotNull
    public static final InputStream inputStream(@NotNull Path $this$inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$inputStream, (String)"<this>");
        InputStream inputStream = Files.newInputStream($this$inputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this)");
        return inputStream;
    }

    @Nullable
    public static final InputStream inputStreamIfExists(@NotNull Path $this$inputStreamIfExists) {
        Intrinsics.checkNotNullParameter((Object)$this$inputStreamIfExists, (String)"<this>");
        try {
            return PathKt.inputStream($this$inputStreamIfExists);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @NotNull
    public static final Path createSymbolicLink(@NotNull Path $this$createSymbolicLink, @NotNull Path target2) {
        Intrinsics.checkNotNullParameter((Object)$this$createSymbolicLink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Path path2 = $this$createSymbolicLink.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createSymbolicLink($this$createSymbolicLink, target2, new FileAttribute[0]);
        return $this$createSymbolicLink;
    }

    @JvmOverloads
    public static final void delete(@NotNull Path $this$delete, boolean recursively) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        if (recursively) {
            NioFiles.deleteRecursively($this$delete);
            return;
        }
        Files.delete($this$delete);
    }

    public static /* synthetic */ void delete$default(Path path2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        PathKt.delete(path2, bl);
    }

    public static final boolean deleteWithParentsIfEmpty(@NotNull Path $this$deleteWithParentsIfEmpty, @NotNull Path root, boolean isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteWithParentsIfEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        try {
            PathKt.delete$default($this$deleteWithParentsIfEmpty, false, 1, null);
        }
        catch (NoSuchFileException e) {
            return false;
        }
        for (Path parent2 = isFile ? $this$deleteWithParentsIfEmpty.getParent() : null; parent2 != null && !Intrinsics.areEqual((Object)parent2, (Object)root); parent2 = parent2.getParent()) {
            try {
                Files.delete(parent2);
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean deleteWithParentsIfEmpty$default(Path path2, Path path3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PathKt.deleteWithParentsIfEmpty(path2, path3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void deleteChildrenStartingWith(@NotNull Path $this$deleteChildrenStartingWith, @NotNull String prefix) {
        block9: {
            Iterable iterable;
            Intrinsics.checkNotNullParameter((Object)$this$deleteChildrenStartingWith, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Path path2 = $this$deleteChildrenStartingWith;
            Function1 filter$iv = (Function1)new Function1<Path, Boolean>(prefix){
                final /* synthetic */ String $prefix;
                {
                    this.$prefix = $prefix;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Path it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$prefix, (boolean)false, (int)2, null);
                }
            };
            boolean $i$f$directoryStreamIfExists = false;
            try {
                void $this$directoryStreamIfExists$iv;
                Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, PathKt.makeFilter((Function1<? super Path, Boolean>)filter$iv));
                Throwable throwable = null;
                try {
                    Iterable it = (DirectoryStream)closeable;
                    boolean bl = false;
                    it = CollectionsKt.toList((Iterable)it);
                    iterable = it;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                iterable = null;
            }
            if (iterable == null) break block9;
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                PathKt.delete$default(it, false, 1, null);
            }
        }
    }

    @NotNull
    public static final FileTime lastModified(@NotNull Path $this$lastModified) {
        Intrinsics.checkNotNullParameter((Object)$this$lastModified, (String)"<this>");
        FileTime fileTime = Files.getLastModifiedTime($this$lastModified, new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(this)");
        return fileTime;
    }

    @NotNull
    public static final String getSystemIndependentPath(@NotNull Path $this$systemIndependentPath) {
        Intrinsics.checkNotNullParameter((Object)$this$systemIndependentPath, (String)"<this>");
        return StringsKt.replace$default((String)((Object)$this$systemIndependentPath).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Path $this$readBytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        byte[] byArray = Files.readAllBytes($this$readBytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(this)");
        return byArray;
    }

    @NotNull
    public static final String readText(@NotNull Path $this$readText) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        String string2 = Files.readString($this$readText);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(this)");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CharSequence readChars(@NotNull Path $this$readChars) {
        Intrinsics.checkNotNullParameter((Object)$this$readChars, (String)"<this>");
        Closeable closeable = Files.newByteChannel($this$readChars, new OpenOption[0]);
        Throwable throwable = null;
        try {
            CharSequence charSequence;
            SeekableByteChannel channel = (SeekableByteChannel)closeable;
            boolean bl = false;
            int size = (int)channel.size();
            Closeable closeable2 = Channels.newReader(channel, Charsets.UTF_8.newDecoder(), size);
            Throwable throwable2 = null;
            try {
                Reader reader = (Reader)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"reader");
                charSequence = IoKt.readCharSequence(reader, size);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            CharSequence charSequence2 = charSequence;
            return charSequence2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $this$writeChild, @NotNull String relativePath, @NotNull byte[] data2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$writeChild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Path path2 = $this$writeChild.resolve(relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(relativePath)");
        return PathKt.write$default(path2, data2, 0, 0, 6, null);
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $this$writeChild, @NotNull String relativePath, @NotNull String data2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$writeChild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string2 = data2;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return PathKt.writeChild($this$writeChild, relativePath, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull byte[] data2, int offset2, int size) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Closeable closeable = PathKt.outputStream$default($this$write, false, 1, null);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            it.write(data2, offset2, size);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return $this$write;
    }

    public static /* synthetic */ Path write$default(Path path2, byte[] byArray, int n, int n2, int n3, Object object) throws IOException {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return PathKt.write(path2, byArray, n, n2);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull CharSequence data2, @NotNull Charset charset, boolean createParentDirs) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (createParentDirs) {
            Path path2 = $this$write.getParent();
            if (path2 != null) {
                PathKt.createDirectories(path2);
            }
        }
        Files.writeString($this$write, data2, charset, new OpenOption[0]);
        return $this$write;
    }

    public static /* synthetic */ Path write$default(Path path2, CharSequence charSequence, Charset charset, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return PathKt.write(path2, charSequence, charset, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull ByteBuffer data2, boolean createParentDirs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (createParentDirs) {
            Path path2 = $this$write.getParent();
            if (path2 != null) {
                PathKt.createDirectories(path2);
            }
        }
        Object object = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        object = Files.newByteChannel($this$write, new HashSet(CollectionsKt.listOf((Object[])object)), new FileAttribute[0]);
        Throwable throwable = null;
        try {
            SeekableByteChannel it = (SeekableByteChannel)object;
            boolean bl = false;
            int n = it.write(data2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return $this$write;
    }

    public static /* synthetic */ Path write$default(Path path2, ByteBuffer byteBuffer, boolean bl, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PathKt.write(path2, byteBuffer, bl);
    }

    public static final long size(@NotNull Path $this$size) {
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        return Files.size($this$size);
    }

    @Nullable
    public static final BasicFileAttributes basicAttributesIfExists(@NotNull Path $this$basicAttributesIfExists) {
        Intrinsics.checkNotNullParameter((Object)$this$basicAttributesIfExists, (String)"<this>");
        try {
            return Files.readAttributes($this$basicAttributesIfExists, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (FileSystemException ignored) {
            return null;
        }
    }

    public static final long sizeOrNull(@NotNull Path $this$sizeOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$sizeOrNull, (String)"<this>");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists($this$sizeOrNull);
        return basicFileAttributes != null ? basicFileAttributes.size() : -1L;
    }

    public static final boolean isHidden(@NotNull Path $this$isHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$isHidden, (String)"<this>");
        return Files.isHidden($this$isHidden);
    }

    public static final boolean isDirectory(@NotNull Path $this$isDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectory, (String)"<this>");
        return Files.isDirectory($this$isDirectory, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $this$isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isFile, (String)"<this>");
        return Files.isRegularFile($this$isFile, new LinkOption[0]);
    }

    @NotNull
    public static final Path move(@NotNull Path $this$move, @NotNull Path target2) {
        Intrinsics.checkNotNullParameter((Object)$this$move, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Path path2 = target2.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Path path3 = Files.move($this$move, target2, copyOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"move(this, target, Stand\u2026yOption.REPLACE_EXISTING)");
        return path3;
    }

    @NotNull
    public static final Path copy(@NotNull Path $this$copy, @NotNull Path target2) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Path path2 = target2.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Path path3 = Files.copy($this$copy, target2, copyOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"copy(this, target, Stand\u2026yOption.REPLACE_EXISTING)");
        return path3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyRecursively(@NotNull Path $this$copyRecursively, @NotNull Path target2) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Path path2 = target2.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        AutoCloseable autoCloseable = Files.walk($this$copyRecursively, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            stream.forEach(arg_0 -> PathKt.copyRecursively$lambda$7$lambda$6((Function1)new Function1<Path, Unit>(target2, $this$copyRecursively){
                final /* synthetic */ Path $target;
                final /* synthetic */ Path $this_copyRecursively;
                {
                    this.$target = $target;
                    this.$this_copyRecursively = $receiver;
                    super(1);
                }

                public final void invoke(Path file2) {
                    Files.copy(file2, this.$target.resolve(this.$this_copyRecursively.relativize(file2)), new CopyOption[0]);
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Path createFile(@NotNull Path $this$createFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        Path path2 = $this$createFile.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createFile($this$createFile, new FileAttribute[0]);
        return $this$createFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $this$directoryStreamIfExists, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task2) {
        Intrinsics.checkNotNullParameter((Object)$this$directoryStreamIfExists, (String)"<this>");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists);
            Throwable throwable = null;
            try {
                object = task2.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $this$directoryStreamIfExists, @NotNull Function1<? super Path, Boolean> filter2, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task2) {
        Intrinsics.checkNotNullParameter((Object)$this$directoryStreamIfExists, (String)"<this>");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists, PathKt.makeFilter(filter2));
            Throwable throwable = null;
            try {
                object = task2.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    @PublishedApi
    @NotNull
    public static final DirectoryStream.Filter<Path> makeFilter(@NotNull Function1<? super Path, Boolean> filter2) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return arg_0 -> PathKt.makeFilter$lambda$8(filter2, arg_0);
    }

    public static final boolean isWritable(@NotNull Path $this$isWritable) {
        Intrinsics.checkNotNullParameter((Object)$this$isWritable, (String)"<this>");
        return Files.isWritable($this$isWritable);
    }

    public static final boolean isDirectory(@Nullable BasicFileAttributes attributes) {
        return attributes != null && attributes.isDirectory();
    }

    public static final boolean isSymbolicLink(@Nullable BasicFileAttributes attributes) {
        return attributes != null && attributes.isSymbolicLink();
    }

    public static final boolean isAncestor(@NotNull Path $this$isAncestor, @NotNull Path child) {
        Intrinsics.checkNotNullParameter((Object)$this$isAncestor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return child.startsWith($this$isAncestor);
    }

    @NotNull
    public static final Path generateRandomPath(@NotNull Path parentDirectory) throws IOException {
        Path path2;
        LinkOption[] linkOptionArray;
        Intrinsics.checkNotNullParameter((Object)parentDirectory, (String)"parentDirectory");
        Path path3 = parentDirectory.resolve(UUID.randomUUID().toString());
        int i2 = 0;
        while (true) {
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || i2 >= 5) break;
            path3 = parentDirectory.resolve(UUID.randomUUID().toString());
            ++i2;
        }
        Path path4 = path3;
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path");
        path2 = path4;
        linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("Couldn't generate unique random path.");
        }
        Path path5 = path3;
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"path");
        return path5;
    }

    @JvmOverloads
    @NotNull
    public static final OutputStream outputStream(@NotNull Path $this$outputStream) {
        Intrinsics.checkNotNullParameter((Object)$this$outputStream, (String)"<this>");
        return PathKt.outputStream$default($this$outputStream, false, 1, null);
    }

    @JvmOverloads
    public static final void delete(@NotNull Path $this$delete) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        PathKt.delete$default($this$delete, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull byte[] data2, int offset2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return PathKt.write$default($this$write, data2, offset2, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull byte[] data2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return PathKt.write$default($this$write, data2, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull CharSequence data2, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return PathKt.write$default($this$write, data2, charset, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull CharSequence data2) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return PathKt.write$default($this$write, data2, null, false, 6, null);
    }

    private static final void copyRecursively$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean makeFilter$lambda$8(Function1 $filter, Path it) {
        Intrinsics.checkNotNullParameter((Object)$filter, (String)"$filter");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (Boolean)$filter.invoke((Object)it);
    }
}

