/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class UnInterruptibleFileChannelHandle {
    private static final Logger LOG = Logger.getInstance(UnInterruptibleFileChannelHandle.class);
    @NotNull
    private final Lock myOpenCloseLock;
    @NotNull
    private final Path myPath;
    private final Set<? extends @NotNull OpenOption> myOpenOptions;
    private volatile FileChannel myChannel;

    UnInterruptibleFileChannelHandle(@NotNull Path path2, Set<? extends @NotNull OpenOption> openOptions) throws IOException {
        if (path2 == null) {
            UnInterruptibleFileChannelHandle.$$$reportNull$$$0(0);
        }
        this.myOpenCloseLock = new ReentrantLock();
        this.myPath = path2;
        this.myOpenOptions = openOptions;
        this.reopenChannel();
    }

    <T> T executeOperation(@NotNull FileChannelIdempotentOperation<T> operation) throws IOException {
        if (operation == null) {
            UnInterruptibleFileChannelHandle.$$$reportNull$$$0(1);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        boolean restoreInterruption = false;
        while (true) {
            try {
                T t = operation.execute(this.myChannel);
                return t;
            }
            catch (ClosedChannelException e) {
                LOG.warn("Channel " + System.identityHashCode(this.myChannel) + " for " + this.myPath + " closed. Trying to reopen it again");
                if (Thread.currentThread().isInterrupted()) {
                    Thread.interrupted();
                    restoreInterruption = true;
                }
                this.reopenChannel();
                continue;
            }
            break;
        }
        finally {
            if (restoreInterruption) {
                Thread.currentThread().interrupt();
            }
        }
    }

    boolean isOpen() {
        return this.myChannel != null;
    }

    void close() throws IOException {
        ConcurrencyUtil.withLock(this.myOpenCloseLock, () -> this.tryClose());
    }

    void reopenChannel() throws IOException {
        ConcurrencyUtil.withLock(this.myOpenCloseLock, () -> {
            FileChannel newFileChannel = FileChannel.open(this.myPath, this.myOpenOptions, new FileAttribute[0]);
            try {
                this.tryClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.myChannel = newFileChannel;
        });
    }

    private void tryClose() throws IOException {
        try {
            FileChannel channel = this.myChannel;
            if (channel != null && channel.isOpen()) {
                channel.close();
            }
        }
        finally {
            this.myChannel = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/UnInterruptibleFileChannelHandle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "executeOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface FileChannelIdempotentOperation<T> {
        public T execute(@NotNull FileChannel var1) throws IOException;
    }
}

