/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.util.io.ContentMismatchReporter;
import com.intellij.util.io.FileTextMatcher;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.ComparisonFailure;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\u001aB\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001aF\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0000\u001aL\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002\u001aL\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002\u001a\u001a\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\"\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0000\u001a$\u0010\u001f\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\fH\u0002\u001a\u000e\u0010\"\u001a\u0004\u0018\u00010\u0006*\u00020#H\u0002\u001a \u0010$\u001a\u00020\u0006*\u00020\u00032\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006%"}, d2={"appendToString", "", "spec", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "result", "", "", "indent", "", "relativePath", "filePathFilter", "Lkotlin/Function1;", "", "assertContentUnderFileMatches", "file", "Ljava/nio/file/Path;", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "fileTextMatcher", "Lcom/intellij/util/io/FileTextMatcher;", "customErrorReporter", "Lcom/intellij/util/io/ContentMismatchReporter;", "expectedDataIsInSpec", "assertDirectoryContentMatches", "errorReporter", "assertDirectoryMatches", "createSpecByPath", "path", "originalFile", "fillSpecFromDirectory", "dir", "originalDir", "assertTrue", "errorMessage", "condition", "convertToText", "", "toString", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nDirectoryContentSpecImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryContentSpecImpl.kt\ncom/intellij/util/io/impl/DirectoryContentSpecImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 path.kt\ncom/intellij/util/io/PathKt\n*L\n1#1,282:1\n1#2:283\n766#3:284\n857#3,2:285\n1855#3,2:287\n766#3:291\n857#3,2:292\n1549#3:294\n1620#3,3:295\n766#3:301\n857#3,2:302\n1549#3:304\n1620#3,3:305\n1855#3,2:310\n206#4,2:289\n209#4,3:298\n206#4,2:308\n209#4,3:312\n*S KotlinDebug\n*F\n+ 1 DirectoryContentSpecImpl.kt\ncom/intellij/util/io/impl/DirectoryContentSpecImplKt\n*L\n144#1:284\n144#1:285,2\n146#1:287,2\n244#1:291\n244#1:292,2\n245#1:294\n245#1:295,3\n248#1:301\n248#1:302,2\n249#1:304\n249#1:305,3\n265#1:310,2\n243#1:289,2\n243#1:298,3\n264#1:308,2\n264#1:312,3\n*E\n"})
public final class DirectoryContentSpecImplKt {
    private static final String toString(DirectorySpecBase $this$toString, Function1<? super String, Boolean> filePathFilter) {
        ArrayList arrayList;
        ArrayList it = arrayList = new ArrayList();
        boolean bl = false;
        DirectoryContentSpecImplKt.appendToString($this$toString, it, 0, ".", filePathFilter);
        return CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendToString(DirectorySpecBase spec, List<String> result2, int indent, String relativePath, Function1<? super String, Boolean> filePathFilter) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        Iterable iterable = spec.getChildren().entrySet();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(!(it.getValue() instanceof FileSpec) || (Boolean)filePathFilter.invoke((Object)(relativePath + "/" + it.getKey())) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
        $this$filter$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator((Comparator)$this$filter$iv){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                String string2 = (String)it.getKey();
                bl = false;
                String string3 = (String)it.getKey();
                return comparator.compare(string2, string3);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            result2.add(StringsKt.repeat((CharSequence)" ", (int)indent) + it.getKey());
            DirectoryContentSpecImpl child = (DirectoryContentSpecImpl)it.getValue();
            if (!(child instanceof DirectorySpec)) continue;
            DirectoryContentSpecImplKt.appendToString((DirectorySpecBase)child, result2, indent + 2, relativePath + "/" + it.getKey(), filePathFilter);
        }
    }

    public static final void assertContentUnderFileMatches(@NotNull Path file2, @NotNull DirectoryContentSpecImpl spec, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter, @Nullable ContentMismatchReporter customErrorReporter, boolean expectedDataIsInSpec) {
        ContentMismatchReporter contentMismatchReporter;
        DirectoryContentSpecImpl actualSpec;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        if (spec instanceof DirectorySpecBase && (actualSpec = DirectoryContentSpecImplKt.createSpecByPath(file2, file2)) instanceof DirectorySpecBase) {
            String specString = DirectoryContentSpecImplKt.toString((DirectorySpecBase)spec, filePathFilter);
            String dirString = DirectoryContentSpecImplKt.toString((DirectorySpecBase)actualSpec, filePathFilter);
            Pair pair = expectedDataIsInSpec ? TuplesKt.to((Object)specString, (Object)dirString) : TuplesKt.to((Object)dirString, (Object)specString);
            String expected = (String)pair.component1();
            String actual = (String)pair.component2();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        if ((contentMismatchReporter = customErrorReporter) == null) {
            contentMismatchReporter = DirectoryContentSpecImplKt::assertContentUnderFileMatches$lambda$4;
        }
        ContentMismatchReporter errorReporter = contentMismatchReporter;
        DirectoryContentSpecImplKt.assertDirectoryContentMatches(file2, spec, ".", fileTextMatcher, filePathFilter, errorReporter, expectedDataIsInSpec);
    }

    private static final void assertTrue(ContentMismatchReporter $this$assertTrue, String relativePath, String errorMessage, boolean condition) {
        if (!condition) {
            $this$assertTrue.reportError(relativePath, (Throwable)((Object)new AssertionError((Object)errorMessage)));
        }
    }

    private static final void assertDirectoryContentMatches(Path file2, DirectoryContentSpecImpl spec, String relativePath, FileTextMatcher fileTextMatcher, Function1<? super String, Boolean> filePathFilter, ContentMismatchReporter errorReporter, boolean expectedDataIsInSpec) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        DirectoryContentSpecImplKt.assertTrue(errorReporter, relativePath, file2 + " doesn't exist", Files.exists(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        DirectoryContentSpecImpl directoryContentSpecImpl = spec;
        if (directoryContentSpecImpl instanceof DirectorySpec) {
            DirectoryContentSpecImplKt.assertDirectoryMatches(file2, (DirectorySpecBase)spec, relativePath, fileTextMatcher, filePathFilter, errorReporter, expectedDataIsInSpec);
        } else if (directoryContentSpecImpl instanceof ZipSpec) {
            DirectoryContentSpecImplKt.assertTrue(errorReporter, relativePath, file2 + " is not a file", PathKt.isFile(file2));
            Path dirForExtracted = FileUtil.createTempDirectory("extracted-" + PathsKt.getName((Path)file2), null, false).toPath();
            ZipUtil.extract(file2, dirForExtracted, null);
            Intrinsics.checkNotNullExpressionValue((Object)dirForExtracted, (String)"dirForExtracted");
            DirectoryContentSpecImplKt.assertDirectoryMatches(dirForExtracted, (DirectorySpecBase)spec, relativePath, fileTextMatcher, filePathFilter, errorReporter, expectedDataIsInSpec);
            FileUtil.delete(dirForExtracted);
        } else if (directoryContentSpecImpl instanceof FileSpec) {
            byte[] fileBytes;
            DirectoryContentSpecImplKt.assertTrue(errorReporter, relativePath, file2 + " is not a file", PathKt.isFile(file2));
            if (((FileSpec)spec).getContent() != null && !Arrays.equals(fileBytes = PathKt.readBytes(file2), ((FileSpec)spec).getContent())) {
                Object place;
                String fileString = DirectoryContentSpecImplKt.convertToText(fileBytes);
                String specString = DirectoryContentSpecImplKt.convertToText(((FileSpec)spec).getContent());
                Object object = place = !Intrinsics.areEqual((Object)relativePath, (Object)".") ? " at " + relativePath : "";
                if (fileString != null && specString != null) {
                    if (!fileTextMatcher.matches(fileString, specString)) {
                        Comparable<Path> comparable = spec.getOriginalFile();
                        String specFilePath = comparable != null && (comparable = comparable.toFile()) != null ? ((File)comparable).getAbsolutePath() : null;
                        Pair pair = expectedDataIsInSpec ? TuplesKt.to((Object)specString, (Object)fileString) : TuplesKt.to((Object)fileString, (Object)specString);
                        String expected = (String)pair.component1();
                        String actual = (String)pair.component2();
                        Pair pair2 = expectedDataIsInSpec ? TuplesKt.to((Object)specFilePath, null) : TuplesKt.to(null, (Object)specFilePath);
                        String expectedPath = (String)pair2.component1();
                        String actualPath = (String)pair2.component2();
                        errorReporter.reportError(relativePath, (Throwable)new FileComparisonFailure("File content mismatch" + (String)place + ":", expected, actual, expectedPath, actualPath));
                    }
                } else {
                    errorReporter.reportError(relativePath, (Throwable)((Object)new AssertionError((Object)("Binary file content mismatch" + (String)place))));
                }
            }
        }
    }

    private static final String convertToText(byte[] $this$convertToText) {
        Charset charset;
        if ($this$convertToText.length == 0) {
            return "";
        }
        switch (WhenMappings.$EnumSwitchMapping$0[new CharsetToolkit($this$convertToText, Charsets.UTF_8, false).guessFromContent($this$convertToText.length).ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        return new String($this$convertToText, charset2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void assertDirectoryMatches(Path file2, DirectorySpecBase spec, String relativePath, FileTextMatcher fileTextMatcher, Function1<? super String, Boolean> filePathFilter, ContentMismatchReporter errorReporter, boolean expectedDataIsInSpec) {
        String dirString;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        List list2;
        Iterable iterable;
        Pair pair;
        DirectoryContentSpecImplKt.assertTrue(errorReporter, relativePath, file2 + " is not a directory", PathKt.isDirectory(file2));
        Path $this$directoryStreamIfExists$iv = file2;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            pair = null;
            try {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Path it2;
                void $this$filterTo$iv$iv2;
                Iterable children2 = (DirectoryStream)closeable;
                boolean bl = false;
                Iterable $this$filter$iv = children2;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it2 = (Path)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    if (!(PathKt.isDirectory(it2) || DirectoryContentSpecImplKt.assertDirectoryMatches$childNameFilter(filePathFilter, relativePath, PathsKt.getName((Path)it2)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it2 = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    collection.add(PathsKt.getName((Path)it2));
                }
                children2 = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                iterable = children2;
            }
            catch (Throwable children2) {
                pair = children2;
                throw children2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)pair);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            iterable = list2 = null;
        }
        if (iterable == null) {
            list2 = CollectionsKt.emptyList();
        }
        List childrenNamesInDir = list2;
        Map<String, DirectoryContentSpecImpl> children3 = spec.getChildren();
        Iterable $this$filter$iv = children3.entrySet();
        boolean $i$f$filter = false;
        pair = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(it.getValue() instanceof DirectorySpec || DirectoryContentSpecImplKt.assertDirectoryMatches$childNameFilter(filePathFilter, relativePath, (String)it.getKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        List childrenNamesInSpec = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        String specString = CollectionsKt.joinToString$default((Iterable)childrenNamesInSpec, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (!Intrinsics.areEqual((Object)specString, (Object)(dirString = CollectionsKt.joinToString$default((Iterable)childrenNamesInDir, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)))) {
            pair = expectedDataIsInSpec ? TuplesKt.to((Object)specString, (Object)dirString) : TuplesKt.to((Object)dirString, (Object)specString);
            String expected = (String)pair.component1();
            String actual = (String)pair.component2();
            errorReporter.reportError(relativePath, (Throwable)new ComparisonFailure("Directory content mismatch" + (String)(!Intrinsics.areEqual((Object)relativePath, (Object)"") ? " at " + relativePath : "") + ":", expected, actual));
        }
        for (String child : childrenNamesInDir) {
            Path path2 = file2.resolve(child);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.resolve(child)");
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(path2, (DirectoryContentSpecImpl)MapsKt.getValue(children3, (Object)child), relativePath + "/" + child, fileTextMatcher, filePathFilter, errorReporter, expectedDataIsInSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void fillSpecFromDirectory(@NotNull DirectorySpecBase spec, @NotNull Path dir, @Nullable Path originalDir) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path $this$directoryStreamIfExists$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                DirectoryStream children2 = (DirectoryStream)closeable;
                boolean bl = false;
                Iterable $this$forEach$iv = children2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    String string2 = ((Object)it.getFileName()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    Path path2 = originalDir;
                    spec.addChild(string2, DirectoryContentSpecImplKt.createSpecByPath(it, path2 != null ? path2.resolve(it.getFileName()) : null));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
    }

    private static final DirectoryContentSpecImpl createSpecByPath(Path path2, Path originalFile) {
        if (PathKt.isDirectory(path2)) {
            DirectorySpec directorySpec;
            DirectorySpec it = directorySpec = new DirectorySpec(originalFile);
            boolean bl = false;
            DirectoryContentSpecImplKt.fillSpecFromDirectory(it, path2, originalFile);
            return directorySpec;
        }
        Object[] objectArray = new String[]{"zip", "jar"};
        if (SetsKt.setOf((Object[])objectArray).contains(PathsKt.getExtension((Path)path2))) {
            ZipSpec zipSpec;
            Path dirForExtracted = FileUtil.createTempDirectory("extracted-" + PathsKt.getName((Path)path2), null, false).toPath();
            ZipUtil.extract(path2, dirForExtracted, null);
            ZipSpec it = zipSpec = new ZipSpec(0, 1, null);
            boolean bl = false;
            DirectorySpecBase directorySpecBase = it;
            Intrinsics.checkNotNullExpressionValue((Object)dirForExtracted, (String)"dirForExtracted");
            DirectoryContentSpecImplKt.fillSpecFromDirectory(directorySpecBase, dirForExtracted, null);
            return zipSpec;
        }
        return new FileSpec(Files.readAllBytes(path2), originalFile);
    }

    private static final void assertContentUnderFileMatches$lambda$4(String string2, Throwable error2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        throw error2;
    }

    private static final boolean assertDirectoryMatches$childNameFilter(Function1<? super String, Boolean> $filePathFilter, String $relativePath, String name) {
        return (Boolean)$filePathFilter.invoke((Object)($relativePath + "/" + name));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CharsetToolkit.GuessedEncoding.values().length];
            try {
                nArray[CharsetToolkit.GuessedEncoding.SEVEN_BIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CharsetToolkit.GuessedEncoding.VALID_UTF8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

