/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.keyStorage;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.IOCancellationCallbackHolder;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.MappedFileInputStream;
import com.intellij.util.io.keyStorage.NoDataException;
import com.intellij.util.lang.CompoundRuntimeException;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class AppendableStorageBackedByResizableMappedFile<Data>
extends ResizeableMappedFile
implements AppendableObjectStorage<Data> {
    @VisibleForTesting
    @ApiStatus.Internal
    public static final int ourAppendBufferLength = 4096;
    private static final ThreadLocal<MyDataIS> ourReadStream = ThreadLocal.withInitial(() -> new MyDataIS());
    private volatile int myFileLength;
    @Nullable
    private volatile AppendMemoryBuffer myAppendBuffer;
    @NotNull
    private final DataExternalizer<Data> myDataDescriptor;
    private static final InputStream TOMBSTONE = new InputStream(){

        @Override
        public int read() {
            throw new IllegalStateException("should not happen");
        }
    };

    public AppendableStorageBackedByResizableMappedFile(Path file2, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, @NotNull DataExternalizer<Data> dataDescriptor) throws IOException {
        if (dataDescriptor == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(0);
        }
        super(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned);
        this.myDataDescriptor = dataDescriptor;
        this.myFileLength = (int)this.length();
    }

    @Override
    public void clear() throws IOException {
        super.clear();
        this.myFileLength = 0;
    }

    private void flushKeyStoreBuffer() throws IOException {
        if (AppendMemoryBuffer.hasChanges(this.myAppendBuffer)) {
            int bufferPosition = this.myAppendBuffer.getBufferPosition();
            this.put(this.myFileLength, this.myAppendBuffer.getAppendBuffer(), 0, bufferPosition);
            this.myFileLength += bufferPosition;
            this.myAppendBuffer = this.myAppendBuffer.rewind(this.myFileLength);
        }
    }

    @Override
    public void force() throws IOException {
        this.flushKeyStoreBuffer();
        super.force();
    }

    @Override
    public void close() throws IOException {
        try {
            SmartList exceptions = new SmartList();
            ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> this.flushKeyStoreBuffer()));
            ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> super.close()));
            if (!exceptions.isEmpty()) {
                throw new IOException(new CompoundRuntimeException(exceptions));
            }
        }
        finally {
            ourReadStream.remove();
        }
    }

    @Override
    public Data read(int addr, boolean checkAccess) throws IOException {
        AppendMemoryBuffer memoryBufferForRead;
        AppendMemoryBuffer buffer = this.myAppendBuffer;
        AppendMemoryBuffer appendMemoryBuffer = memoryBufferForRead = buffer != null ? buffer.copyToRead(addr) : null;
        if (memoryBufferForRead != null) {
            int bufferOffset = addr - memoryBufferForRead.myCreationFileLength;
            if (bufferOffset > memoryBufferForRead.getBufferPosition()) {
                throw new NoDataException("requested address points to un-existed data");
            }
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(memoryBufferForRead.getAppendBuffer(), bufferOffset, memoryBufferForRead.getBufferPosition());
            return this.myDataDescriptor.read(new DataInputStream(is));
        }
        if (addr >= this.myFileLength) {
            throw new NoDataException("requested address points to un-existed data");
        }
        MyDataIS rs = ourReadStream.get();
        rs.setup(this, addr, this.myFileLength, checkAccess);
        return this.myDataDescriptor.read(rs);
    }

    @Override
    public boolean processAll(@NotNull AppendableObjectStorage.StorageObjectProcessor<? super Data> processor) throws IOException {
        if (processor == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(1);
        }
        assert (!this.isDirty());
        if (this.myFileLength == 0) {
            return true;
        }
        IOCancellationCallbackHolder.checkCancelled();
        return this.readInputStream(is -> {
            LimitedInputStream lis = new LimitedInputStream(new BufferedInputStream((InputStream)is), this.myFileLength){

                @Override
                public int available() {
                    return this.remainingLimit();
                }
            };
            DataInputStream keyStream = new DataInputStream(lis);
            try {
                Data key;
                int offset2;
                while (processor.process(offset2 = lis.getBytesRead(), (Data)(key = this.myDataDescriptor.read(keyStream)))) {
                }
                return false;
            }
            catch (EOFException eOFException) {
                return true;
            }
        });
    }

    @Override
    public int getCurrentLength() {
        return AppendMemoryBuffer.getBufferPosition(this.myAppendBuffer) + this.myFileLength;
    }

    @Override
    public int append(Data value) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.myDataDescriptor.save(out, value);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        int currentLength = this.getCurrentLength();
        if (size > 4096) {
            this.flushKeyStoreBuffer();
            this.put(currentLength, buffer, 0, size);
            this.myFileLength += size;
            if (this.myAppendBuffer != null) {
                this.myAppendBuffer = this.myAppendBuffer.rewind(this.myFileLength);
            }
        } else {
            if (size > 4096 - AppendMemoryBuffer.getBufferPosition(this.myAppendBuffer)) {
                this.flushKeyStoreBuffer();
            }
            if (this.myAppendBuffer == null) {
                this.myAppendBuffer = new AppendMemoryBuffer(this.myFileLength);
            }
            this.myAppendBuffer.append(buffer, size);
        }
        return currentLength;
    }

    @Override
    public boolean checkBytesAreTheSame(int addr, Data value) throws IOException {
        try (CheckerOutputStream comparer = this.buildOldComparerStream(addr);){
            DataOutputStream out = new DataOutputStream(comparer);
            this.myDataDescriptor.save(out, value);
            boolean bl = comparer.same;
            return bl;
        }
    }

    @NotNull
    private CheckerOutputStream buildOldComparerStream(final int addr) throws IOException {
        final PagedFileStorage storage = this.getPagedFileStorage();
        CheckerOutputStream comparer = this.myFileLength <= addr ? new CheckerOutputStream(){
            int address;
            {
                this.address = addr - AppendableStorageBackedByResizableMappedFile.this.myFileLength;
            }

            @Override
            public void write(int b) {
                if (this.same) {
                    this.same = this.address < AppendMemoryBuffer.getBufferPosition(AppendableStorageBackedByResizableMappedFile.this.myAppendBuffer) && AppendableStorageBackedByResizableMappedFile.this.myAppendBuffer.getAppendBuffer()[this.address++] == (byte)b;
                }
            }
        } : new CheckerOutputStream(){
            int base;
            int address;
            DirectBufferWrapper buffer;
            final int myPageSize;
            {
                this.base = addr;
                this.address = storage.getOffsetInPage(addr);
                this.buffer = storage.getByteBuffer(addr, false);
                this.myPageSize = storage.getPageSize();
            }

            @Override
            public void write(int b) throws IOException {
                if (this.same) {
                    if (this.myPageSize == this.address && this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength) {
                        this.base += this.address;
                        this.buffer.unlock();
                        this.buffer = storage.getByteBuffer(this.base, false);
                        this.address = 0;
                    }
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength && this.buffer.get(this.address++, true) == (byte)b;
                }
            }

            @Override
            public void close() {
                this.buffer.unlock();
            }
        };
        CheckerOutputStream checkerOutputStream = comparer;
        if (checkerOutputStream == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(2);
        }
        return checkerOutputStream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/keyStorage/AppendableStorageBackedByResizableMappedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/keyStorage/AppendableStorageBackedByResizableMappedFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOldComparerStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AppendMemoryBuffer {
        private final byte[] myAppendBuffer;
        private int myBufferPosition;
        private final int myCreationFileLength;

        private AppendMemoryBuffer(int creationFileLength) {
            this(new byte[4096], 0, creationFileLength);
        }

        private AppendMemoryBuffer(byte[] appendBuffer, int bufferPosition, int creationFileLength) {
            this.myAppendBuffer = appendBuffer;
            this.myCreationFileLength = creationFileLength;
            this.myBufferPosition = bufferPosition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private AppendMemoryBuffer copyToRead(long readOffset) {
            if (readOffset >= (long)this.myCreationFileLength) {
                AppendMemoryBuffer appendMemoryBuffer = this;
                synchronized (appendMemoryBuffer) {
                    return new AppendMemoryBuffer(ByteArrays.copy(this.myAppendBuffer), this.myBufferPosition, this.myCreationFileLength);
                }
            }
            return null;
        }

        private synchronized byte[] getAppendBuffer() {
            return this.myAppendBuffer;
        }

        private synchronized int getBufferPosition() {
            return this.myBufferPosition;
        }

        public synchronized void append(byte[] buffer, int size) {
            System.arraycopy(buffer, 0, this.myAppendBuffer, this.myBufferPosition, size);
            this.myBufferPosition += size;
        }

        public synchronized AppendMemoryBuffer rewind(int newFileLength) {
            return new AppendMemoryBuffer(this.myAppendBuffer, 0, newFileLength);
        }

        private static int getBufferPosition(@Nullable AppendMemoryBuffer buffer) {
            return buffer != null ? buffer.myBufferPosition : 0;
        }

        private static boolean hasChanges(@Nullable AppendMemoryBuffer buffer) {
            return buffer != null && buffer.getBufferPosition() > 0;
        }
    }

    private static final class MyDataIS
    extends DataInputStream {
        private MyDataIS() {
            super(new MyBufferedIS());
        }

        void setup(ResizeableMappedFile is, long pos, long limit2, boolean checkAccess) {
            ((MyBufferedIS)this.in).setup(is, pos, limit2, checkAccess);
        }
    }

    private static abstract class CheckerOutputStream
    extends OutputStream {
        boolean same = true;

        private CheckerOutputStream() {
        }
    }

    private static class MyBufferedIS
    extends BufferedInputStream {
        MyBufferedIS() {
            super(TOMBSTONE, 512);
        }

        void setup(ResizeableMappedFile in, long pos, long limit2, boolean checkAccess) {
            this.pos = 0;
            this.count = 0;
            this.in = new MappedFileInputStream(in, pos, limit2, checkAccess);
        }
    }
}

