/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH$J\u001a\u0010\u0014\u001a\u00020\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016J+\u0010\u0018\u001a\u00020\u000e\"\b\b\u0000\u0010\u0019*\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00102\u0006\u0010\u001a\u001a\u0002H\u0019\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R<\u0010\b\u001a.\u0012*\u0012(\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\n0\t8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u001e\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/util/messages/impl/BaseBusConnection;", "Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "bus", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "(Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "isDisposed", "", "()Z", "subscriptions", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "kotlin.jvm.PlatformType", "collectHandlers", "", "topic", "Lcom/intellij/util/messages/Topic;", "result", "", "disconnect", "disconnectIfNeeded", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "subscribe", "L", "handler", "(Lcom/intellij/util/messages/Topic;Ljava/lang/Object;)V", "toString", "", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "Lcom/intellij/util/messages/impl/SimpleMessageBusConnectionImpl;", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nBaseBusConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseBusConnection.kt\ncom/intellij/util/messages/impl/BaseBusConnection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,93:1\n37#2,2:94\n*S KotlinDebug\n*F\n+ 1 BaseBusConnection.kt\ncom/intellij/util/messages/impl/BaseBusConnection\n*L\n84#1:94,2\n*E\n"})
public abstract class BaseBusConnection
implements MessageBusImpl.MessageHandlerHolder {
    @JvmField
    @Nullable
    public MessageBusImpl bus;
    @JvmField
    @NotNull
    protected final AtomicReference<Object[]> subscriptions = new AtomicReference<Object[]>(ArrayUtilRt.EMPTY_OBJECT_ARRAY);

    private BaseBusConnection(MessageBusImpl bus) {
        this.bus = bus;
    }

    @Override
    public boolean isDisposed() {
        return this.bus == null;
    }

    public final <L> void subscribe(@NotNull Topic<L> topic, @NotNull L handler2) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Object[] list2 = null;
        Object[] newList = null;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)this.subscriptions.get(), (String)"subscriptions.get()");
            if (list2.length == 0) {
                Object[] objectArray = new Object[]{topic, handler2};
                newList = objectArray;
                continue;
            }
            int size = list2.length;
            Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(list2, size + 2), (String)"copyOf(list, size + 2)");
            newList[size] = topic;
            newList[size + 1] = handler2;
        } while (!this.subscriptions.compareAndSet(list2, newList));
        MessageBusImpl messageBusImpl = this.bus;
        Intrinsics.checkNotNull((Object)messageBusImpl);
        messageBusImpl.notifyOnSubscription$intellij_platform_core(topic);
    }

    @Override
    public void collectHandlers(@NotNull Topic<?> topic, @NotNull List<? super Object> result2) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Object[] list2 = this.subscriptions.get();
        int n = list2.length;
        for (int i2 = 0; i2 < n; i2 += 2) {
            if (list2[i2] != topic) continue;
            Object object = list2[i2 + 1];
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"list[i + 1]");
            result2.add(object);
        }
    }

    @Override
    public void disconnectIfNeeded(@NotNull Predicate<Class<?>> predicate2) {
        Collection $this$toTypedArray$iv;
        Collection thisCollection$iv;
        Object[] list2;
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        do {
            list2 = this.subscriptions.get();
            List newList = null;
            for (int i2 = 0; i2 < list2.length; i2 += 2) {
                if (predicate2.test(list2[i2 + 1].getClass())) {
                    if (newList != null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"list");
                    newList = CollectionsKt.toMutableList((Collection)ArraysKt.asList((Object[])list2).subList(0, i2));
                    continue;
                }
                if (newList == null) continue;
                Object object = list2[i2];
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"list[i]");
                newList.add(object);
                Object object2 = list2[i2 + 1];
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"list[i + 1]");
                newList.add(object2);
            }
            if (newList == null) {
                return;
            }
            if (newList.isEmpty()) {
                this.disconnect();
                return;
            }
            $this$toTypedArray$iv = newList;
            boolean $i$f$toTypedArray = false;
        } while (!this.subscriptions.compareAndSet(list2, (thisCollection$iv = $this$toTypedArray$iv).toArray(new Object[0])));
    }

    protected abstract void disconnect();

    @NotNull
    public String toString() {
        String string2 = Arrays.toString(this.subscriptions.get());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        return string2;
    }

    public /* synthetic */ BaseBusConnection(MessageBusImpl bus, DefaultConstructorMarker $constructor_marker) {
        this(bus);
    }
}

