/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TObjectHashingStrategy;

public final class CharSequenceHashingStrategy
implements TObjectHashingStrategy<CharSequence> {
    public static final CharSequenceHashingStrategy CASE_SENSITIVE = new CharSequenceHashingStrategy(true);
    private final boolean myCaseSensitive;

    private CharSequenceHashingStrategy(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
    }

    @Override
    public int computeHashCode(CharSequence chars) {
        return this.myCaseSensitive ? StringUtil.stringHashCode(chars) : StringUtil.stringHashCodeInsensitive(chars);
    }

    @Override
    public boolean equals(CharSequence s1, CharSequence s2) {
        return Comparing.equal(s1, s2, this.myCaseSensitive);
    }
}

