/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextCompletionProviderBase<T>
implements TextCompletionProvider {
    @NotNull
    protected final TextCompletionValueDescriptor<T> myDescriptor;
    @NotNull
    private final List<Character> mySeparators;
    private final boolean myCaseSensitive;
    @NotNull
    private final InsertHandler<LookupElement> myInsertHandler;

    public TextCompletionProviderBase(@NotNull TextCompletionValueDescriptor<T> descriptor2, @NotNull List<Character> separators, boolean caseSensitive) {
        if (descriptor2 == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(0);
        }
        if (separators == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(1);
        }
        this.myInsertHandler = new CompletionCharInsertHandler();
        this.myDescriptor = descriptor2;
        this.mySeparators = separators;
        this.myCaseSensitive = caseSensitive;
    }

    @Nullable
    public String getAdvertisement() {
        return "";
    }

    @Nullable
    public String getPrefix(@NotNull String text2, int offset2) {
        if (text2 == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(2);
        }
        return TextCompletionProviderBase.getPrefix(text2, offset2, this.mySeparators);
    }

    @NotNull
    protected static String getPrefix(@NotNull String text2, int offset2, @NotNull Collection<Character> separators) {
        if (text2 == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(3);
        }
        if (separators == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(4);
        }
        int index2 = -1;
        for (char c2 : separators) {
            index2 = Math.max(text2.lastIndexOf(c2, offset2 - 1), index2);
        }
        String string2 = text2.substring(index2 + 1, offset2);
        if (string2 == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        if (result2 == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(7);
        }
        CompletionResultSet resultWithMatcher = result2.withPrefixMatcher(new PlainPrefixMatcher(prefix));
        if (!this.myCaseSensitive) {
            resultWithMatcher = resultWithMatcher.caseInsensitive();
        }
        CompletionResultSet completionResultSet = resultWithMatcher;
        if (completionResultSet == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(8);
        }
        return completionResultSet;
    }

    @Nullable
    public CharFilter.Result acceptChar(char c2) {
        if (!this.mySeparators.contains(Character.valueOf(c2))) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        return CharFilter.Result.HIDE_LOOKUP;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(11);
        }
        Collection<T> values2 = this.getValues(parameters2, prefix, result2);
        values2 = ContainerUtil.sorted(values2, this.myDescriptor);
        for (T completionVariant : values2) {
            result2.addElement(this.installInsertHandler(this.myDescriptor.createLookupBuilder(completionVariant)));
        }
        result2.stopHere();
    }

    @NotNull
    protected LookupElement installInsertHandler(@NotNull LookupElementBuilder builder2) {
        InsertHandler<LookupElement> handler2;
        if (builder2 == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(12);
        }
        if ((handler2 = builder2.getInsertHandler()) == null) {
            LookupElementBuilder lookupElementBuilder = builder2.withInsertHandler(this.myInsertHandler);
            if (lookupElementBuilder == null) {
                TextCompletionProviderBase.$$$reportNull$$$0(13);
            }
            return lookupElementBuilder;
        }
        LookupElementBuilder lookupElementBuilder = builder2.withInsertHandler(new InsertHandler<LookupElement>(){

            @Override
            public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
                if (context2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextCompletionProviderBase.this.myInsertHandler.handleInsert(context2, item);
                handler2.handleInsert(context2, item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/textCompletion/TextCompletionProviderBase$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (lookupElementBuilder == null) {
            TextCompletionProviderBase.$$$reportNull$$$0(14);
        }
        return lookupElementBuilder;
    }

    @NotNull
    protected abstract Collection<? extends T> getValues(@NotNull CompletionParameters var1, @NotNull String var2, @NotNull CompletionResultSet var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/textCompletion/TextCompletionProviderBase";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/textCompletion/TextCompletionProviderBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPrefixMatcher";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "installInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyPrefixMatcher";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installInsertHandler";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 8, 13, 14 -> new IllegalStateException(string2);
        };
    }

    public class CompletionCharInsertHandler
    implements InsertHandler<LookupElement> {
        @Override
        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            if (context2 == null) {
                CompletionCharInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                CompletionCharInsertHandler.$$$reportNull$$$0(1);
            }
            context2.setAddCompletionChar(TextCompletionProviderBase.this.mySeparators.contains(Character.valueOf(context2.getCompletionChar())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/textCompletion/TextCompletionProviderBase$CompletionCharInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

