/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.AvatarPalette;
import com.intellij.util.ui.Avatars;
import com.intellij.util.ui.ColorPalette;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/ui/AvatarUtils;", "", "()V", "generateColoredAvatar", "Ljava/awt/image/BufferedImage;", "gc", "Ljava/awt/GraphicsConfiguration;", "size", "", "arcRatio", "", "gradientSeed", "", "name", "palette", "Lcom/intellij/util/ui/ColorPalette;", "generateColoredAvatar$intellij_platform_util_ui", "intellij.platform.util.ui"})
public final class AvatarUtils {
    @NotNull
    public static final AvatarUtils INSTANCE = new AvatarUtils();

    private AvatarUtils() {
    }

    @NotNull
    public final BufferedImage generateColoredAvatar(@NotNull String gradientSeed, @NotNull String name, int size, double arcRatio, @NotNull ColorPalette palette) {
        Intrinsics.checkNotNullParameter((Object)gradientSeed, (String)"gradientSeed");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return this.generateColoredAvatar$intellij_platform_util_ui(null, size, arcRatio, gradientSeed, name, palette);
    }

    public static /* synthetic */ BufferedImage generateColoredAvatar$default(AvatarUtils avatarUtils, String string2, String string3, int n, double d, ColorPalette colorPalette, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 64;
        }
        if ((n2 & 8) != 0) {
            d = 0.0;
        }
        if ((n2 & 0x10) != 0) {
            colorPalette = AvatarPalette.INSTANCE;
        }
        return avatarUtils.generateColoredAvatar(string2, string3, n, d, colorPalette);
    }

    @NotNull
    public final BufferedImage generateColoredAvatar$intellij_platform_util_ui(@Nullable GraphicsConfiguration gc, int size, double arcRatio, @NotNull String gradientSeed, @NotNull String name, @NotNull ColorPalette palette) {
        Intrinsics.checkNotNullParameter((Object)gradientSeed, (String)"gradientSeed");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        Pair<Color, Color> pair = palette.gradient(gradientSeed);
        Color color1 = (Color)pair.component1();
        Color color2 = (Color)pair.component2();
        String shortName = Avatars.INSTANCE.initials(name);
        BufferedImage bufferedImage = ImageUtil.createImage(gc, size, size, 2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(gc, size, si\u2026feredImage.TYPE_INT_ARGB)");
        BufferedImage image = bufferedImage;
        Graphics2D g2 = image.createGraphics();
        ImageUtil.applyQualityRenderingHints(g2);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, color2, size, size, color1));
        double arcSize = arcRatio * (double)size;
        Area avatarOvalArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, size, size, arcSize, arcSize));
        g2.fill(avatarOvalArea);
        g2.setPaint(JBColor.WHITE);
        g2.setFont(JBFont.create(new Font("Segoe UI", 0, (int)((double)size / 2.2))));
        UIUtil.drawCenteredString(g2, new Rectangle(0, 0, size, size), shortName);
        g2.dispose();
        return image;
    }

    public static /* synthetic */ BufferedImage generateColoredAvatar$intellij_platform_util_ui$default(AvatarUtils avatarUtils, GraphicsConfiguration graphicsConfiguration, int n, double d, String string2, String string3, ColorPalette colorPalette, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            colorPalette = AvatarPalette.INSTANCE;
        }
        return avatarUtils.generateColoredAvatar$intellij_platform_util_ui(graphicsConfiguration, n, d, string2, string3, colorPalette);
    }
}

