/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ColorsIcon
extends ColorIcon {
    private static final int SQUARE_SIZE = JBUIScale.scale(6);
    private static final BufferedImage CHESS_IMAGE = ImageUtil.createImage(SQUARE_SIZE, SQUARE_SIZE, 1);
    private static final TexturePaint CHESS;
    private final Color[] myColors;

    public ColorsIcon(int size, Color ... colors) {
        if (colors == null) {
            ColorsIcon.$$$reportNull$$$0(0);
        }
        super(size, size, Gray.TRANSPARENT, false);
        this.myColors = ArrayUtil.reverseArray(colors);
    }

    protected ColorsIcon(ColorsIcon icon2) {
        super(icon2);
        this.myColors = icon2.myColors;
    }

    @Override
    @NotNull
    public ColorsIcon copy() {
        return new ColorsIcon(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component component2, Graphics g, int x, int y) {
        block7: {
            Graphics2D g2d = (Graphics2D)g.create();
            GraphicsConfig config = GraphicsUtil.setupAAPainting(g2d);
            try {
                int w = this.getIconWidth();
                int h = this.getIconHeight();
                if (this.myColors.length == 2) {
                    g2d.setPaint(this.getPaint(this.myColors[0]));
                    g2d.fillPolygon(new int[]{x, x + w, x}, new int[]{y, y, y + h}, 3);
                    g2d.setPaint(this.getPaint(this.myColors[1]));
                    g2d.fillPolygon(new int[]{x + w, x + w, x}, new int[]{y, y + h, y + h}, 3);
                    break block7;
                }
                for (int i2 = 0; i2 < this.myColors.length; ++i2) {
                    g2d.setPaint(this.getPaint(this.myColors[i2]));
                    RectanglePainter.FILL.paint(g2d, i2 % 2 == 0 ? x : x + w / 2 + 1, i2 < 2 ? y : y + h / 2 + 1, w / 2 - 1, h / 2 - 1, null);
                    if (i2 != 3) continue;
                    break;
                }
            }
            catch (Exception e) {
                g2d.dispose();
            }
            finally {
                config.restore();
            }
        }
    }

    protected Paint getPaint(Color color) {
        return color == null || color.getAlpha() == 0 ? CHESS : color;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColorsIcon icon2 = (ColorsIcon)o;
        if (this.getIconWidth() != icon2.getIconWidth()) {
            return false;
        }
        if (this.getIconHeight() != icon2.getIconHeight()) {
            return false;
        }
        return Arrays.equals(this.myColors, icon2.myColors);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.myColors);
        return result2;
    }

    static {
        Graphics2D graphics = CHESS_IMAGE.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setColor(JBColor.LIGHT_GRAY);
        graphics.fillRect(0, 0, SQUARE_SIZE + 1, SQUARE_SIZE + 1);
        graphics.setColor(JBColor.GRAY);
        graphics.fillRect(0, 0, SQUARE_SIZE / 2, SQUARE_SIZE / 2);
        graphics.fillRect(SQUARE_SIZE / 2, SQUARE_SIZE / 2, SQUARE_SIZE / 2, SQUARE_SIZE / 2);
        graphics.dispose();
        CHESS = new TexturePaint(CHESS_IMAGE, new Rectangle(0, 0, SQUARE_SIZE, SQUARE_SIZE));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/util/ui/ColorsIcon", "<init>"));
    }
}

