/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.HiDpiImagesExtension;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ParagraphView;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00102\u00020\u0001:\u0004\u0010\u0011\u0012\u0013BC\b\u0010\u0012:\u0010\u0002\u001a\u001e\u0012\u001a\b\u0001\u0012\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u0003\"\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007B\u001b\b\u0010\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0003\"\u00020\b\u00a2\u0006\u0002\u0010\tB3\b\u0000\u0012 \u0010\u0002\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0002\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory;", "Ljavax/swing/text/html/HTMLEditorKit$HTMLFactory;", "extensions", "", "Lkotlin/Function2;", "Ljavax/swing/text/Element;", "Ljavax/swing/text/View;", "([Lkotlin/jvm/functions/Function2;)V", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "([Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;)V", "", "base", "Ljavax/swing/text/ViewFactory;", "(Ljava/util/List;Ljavax/swing/text/ViewFactory;)V", "create", "elem", "Companion", "Extension", "Extensions", "WordWrapExtension", "intellij.platform.util.ui"})
public final class ExtendableHTMLViewFactory
extends HTMLEditorKit.HTMLFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Function2<Element, View, View>> extensions;
    @NotNull
    private final ViewFactory base;
    @JvmField
    @NotNull
    public static final List<Extension> DEFAULT_EXTENSIONS;
    @JvmField
    @NotNull
    public static final ExtendableHTMLViewFactory DEFAULT;
    @NotNull
    private static final List<Extension> DEFAULT_EXTENSIONS_WORD_WRAP;
    @JvmField
    @NotNull
    public static final ExtendableHTMLViewFactory DEFAULT_WORD_WRAP;

    public ExtendableHTMLViewFactory(@NotNull List<? extends Function2<? super Element, ? super View, ? extends View>> extensions2, @NotNull ViewFactory base) {
        Intrinsics.checkNotNullParameter(extensions2, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this.extensions = extensions2;
        this.base = base;
    }

    public /* synthetic */ ExtendableHTMLViewFactory(List list2, ViewFactory viewFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ViewFactory viewFactory2 = new HTMLEditorKit().getViewFactory();
            Intrinsics.checkNotNullExpressionValue((Object)viewFactory2, (String)"HTMLEditorKit().viewFactory");
            viewFactory = viewFactory2;
        }
        this(list2, viewFactory);
    }

    public ExtendableHTMLViewFactory(Function2<? super Element, ? super View, ? extends View> ... extensions2) {
        Intrinsics.checkNotNullParameter(extensions2, (String)"extensions");
        this(ArraysKt.asList((Object[])extensions2), null, 2, null);
    }

    public ExtendableHTMLViewFactory(Extension ... extensions2) {
        Intrinsics.checkNotNullParameter((Object)extensions2, (String)"extensions");
        this(ArraysKt.asList((Object[])extensions2), null, 2, null);
    }

    @Override
    @NotNull
    public View create(@NotNull Element elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        View defaultView = this.base.create(elem);
        for (Function2<Element, View, View> extension2 : this.extensions) {
            Intrinsics.checkNotNullExpressionValue((Object)defaultView, (String)"defaultView");
            View view = (View)extension2.invoke((Object)elem, (Object)defaultView);
            if (view == null || view == defaultView) continue;
            return view;
        }
        Intrinsics.checkNotNullExpressionValue((Object)defaultView, (String)"defaultView");
        return defaultView;
    }

    static {
        Object[] objectArray = new Extension[]{Extensions.ICONS, Extensions.BASE64_IMAGES, Extensions.HIDPI_IMAGES};
        DEFAULT_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        DEFAULT = new ExtendableHTMLViewFactory(DEFAULT_EXTENSIONS, null, 2, null);
        DEFAULT_EXTENSIONS_WORD_WRAP = CollectionsKt.plus((Collection)DEFAULT_EXTENSIONS, (Object)Extensions.WORD_WRAP);
        DEFAULT_WORD_WRAP = new ExtendableHTMLViewFactory(DEFAULT_EXTENSIONS_WORD_WRAP, null, 2, null);
    }

    @FunctionalInterface
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "Lkotlin/Function2;", "Ljavax/swing/text/Element;", "Ljavax/swing/text/View;", "intellij.platform.util.ui"})
    public static interface Extension
    extends Function2<Element, View, View> {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Companion;", "", "()V", "DEFAULT", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory;", "DEFAULT_EXTENSIONS", "", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "DEFAULT_EXTENSIONS_WORD_WRAP", "DEFAULT_WORD_WRAP", "intellij.platform.util.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\b\u001a\u00020\u00042#\u0010\t\u001a\u001f\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\nH\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001e\u0010\b\u001a\u00020\u00042\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extensions;", "", "()V", "BASE64_IMAGES", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "HIDPI_IMAGES", "ICONS", "WORD_WRAP", "icons", "existingIconsProvider", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "key", "Ljavax/swing/Icon;", "htmlChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "preLoaded", "", "Base64ImagesExtension", "IconsExtension", "intellij.platform.util.ui"})
    public static final class Extensions {
        @NotNull
        public static final Extensions INSTANCE = new Extensions();
        @JvmField
        @NotNull
        public static final Extension ICONS = new IconsExtension(MapsKt.emptyMap());
        @JvmField
        @NotNull
        public static final Extension BASE64_IMAGES = new Base64ImagesExtension();
        @JvmField
        @NotNull
        public static final Extension WORD_WRAP = new WordWrapExtension();
        @JvmField
        @NotNull
        public static final Extension HIDPI_IMAGES = new HiDpiImagesExtension();

        private Extensions() {
        }

        @JvmStatic
        @NotNull
        public static final Extension icons(@NotNull Map<String, ? extends Icon> preLoaded) {
            Intrinsics.checkNotNullParameter(preLoaded, (String)"preLoaded");
            return preLoaded.isEmpty() ? ICONS : (Extension)new IconsExtension(preLoaded);
        }

        public static /* synthetic */ Extension icons$default(Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = MapsKt.emptyMap();
            }
            return Extensions.icons(map2);
        }

        @JvmStatic
        @NotNull
        public static final Extension icons(@NotNull Function1<? super String, ? extends Icon> existingIconsProvider) {
            Intrinsics.checkNotNullParameter(existingIconsProvider, (String)"existingIconsProvider");
            return new IconsExtension(existingIconsProvider);
        }

        @JvmStatic
        @NotNull
        public static final Extension icons(@NotNull HtmlChunk htmlChunk) {
            Intrinsics.checkNotNullParameter((Object)htmlChunk, (String)"htmlChunk");
            return new IconsExtension((Function1<? super String, ? extends Icon>)((Function1)new Function1<String, Icon>(htmlChunk){
                final /* synthetic */ HtmlChunk $htmlChunk;
                {
                    this.$htmlChunk = $htmlChunk;
                    super(1);
                }

                @Nullable
                public final Icon invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$htmlChunk.findIcon(it);
                }
            }));
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006B*\u0012#\u0010\u0007\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00050\b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0096\u0002R+\u0010\u0007\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extensions$IconsExtension;", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "preloadedIcons", "", "", "Ljavax/swing/Icon;", "(Ljava/util/Map;)V", "existingIconsProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "key", "(Lkotlin/jvm/functions/Function1;)V", "getIcon", "src", "invoke", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "defaultView", "Companion", "JBIconView", "intellij.platform.util.ui"})
        private static final class IconsExtension
        implements Extension {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Function1<String, Icon> existingIconsProvider;

            public IconsExtension(@NotNull Function1<? super String, ? extends Icon> existingIconsProvider) {
                Intrinsics.checkNotNullParameter(existingIconsProvider, (String)"existingIconsProvider");
                this.existingIconsProvider = existingIconsProvider;
            }

            public IconsExtension(@NotNull Map<String, ? extends Icon> preloadedIcons) {
                Intrinsics.checkNotNullParameter(preloadedIcons, (String)"preloadedIcons");
                this((Function1<? super String, ? extends Icon>)IconsExtension.Companion.preloadedIconsProvider(preloadedIcons));
            }

            @Nullable
            public View invoke(@NotNull Element elem, @NotNull View defaultView) {
                Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
                Intrinsics.checkNotNullParameter((Object)defaultView, (String)"defaultView");
                if (!Intrinsics.areEqual((Object)"icon", (Object)elem.getName())) {
                    return null;
                }
                Object object = elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                String string2 = object instanceof String ? (String)object : null;
                if (string2 == null) {
                    return null;
                }
                String src = string2;
                Icon icon2 = this.getIcon(src);
                if (icon2 == null) {
                    return null;
                }
                Icon icon3 = icon2;
                return new JBIconView(elem, icon3);
            }

            private final Icon getIcon(String src) {
                Icon existingIcon = (Icon)this.existingIconsProvider.invoke((Object)src);
                if (existingIcon != null) {
                    return existingIcon;
                }
                return IconLoader.findIcon(src, ExtendableHTMLViewFactory.class, true, false);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extensions$IconsExtension$Companion;", "", "()V", "preloadedIconsProvider", "Lkotlin/Function1;", "", "Ljavax/swing/Icon;", "preloadedIcons", "", "intellij.platform.util.ui"})
            public static final class Companion {
                private Companion() {
                }

                private final Function1<String, Icon> preloadedIconsProvider(Map<String, ? extends Icon> preloadedIcons) {
                    return (Function1)new Function1<String, Icon>(preloadedIcons){
                        final /* synthetic */ Map<String, Icon> $preloadedIcons;
                        {
                            this.$preloadedIcons = $preloadedIcons;
                            super(1);
                        }

                        @Nullable
                        public final Icon invoke(@NotNull String key) {
                            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                            return this.$preloadedIcons.get(key);
                        }
                    };
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J3\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extensions$IconsExtension$JBIconView;", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "icon", "Ljavax/swing/Icon;", "(Ljavax/swing/text/Element;Ljavax/swing/Icon;)V", "getAlignment", "", "axis", "", "getPreferredSpan", "getToolTipText", "", "x", "y", "allocation", "Ljava/awt/Shape;", "modelToView", "pos", "a", "b", "Ljavax/swing/text/Position$Bias;", "paint", "", "g", "Ljava/awt/Graphics;", "viewToModel", "bias", "", "(FFLjava/awt/Shape;[Ljavax/swing/text/Position$Bias;)I", "intellij.platform.util.ui"})
            private static final class JBIconView
            extends View {
                @NotNull
                private final Icon icon;

                public JBIconView(@NotNull Element elem, @NotNull Icon icon2) {
                    Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
                    Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
                    super(elem);
                    this.icon = icon2;
                }

                @Override
                public float getPreferredSpan(int axis) {
                    return switch (axis) {
                        case 0 -> this.icon.getIconWidth();
                        case 1 -> this.icon.getIconHeight();
                        default -> throw new IllegalArgumentException("Invalid axis: " + axis);
                    };
                }

                @Override
                public float getAlignment(int axis) {
                    if (axis == 1) {
                        return (float)JBUIScale.scale(12) / (float)this.icon.getIconHeight();
                    }
                    return super.getAlignment(axis);
                }

                @Override
                @Nullable
                public String getToolTipText(float x, float y, @NotNull Shape allocation) {
                    Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
                    Object object = this.getElement().getAttributes().getAttribute(HTML.Attribute.ALT);
                    String string2 = object instanceof String ? (String)object : null;
                    return string2 != null ? StringKt.nullize(string2, true) : null;
                }

                @Override
                public void paint(@NotNull Graphics g, @NotNull Shape allocation) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
                    Graphics2D g2d = (Graphics2D)g;
                    Composite savedComposite = g2d.getComposite();
                    g2d.setComposite(AlphaComposite.SrcOver);
                    this.icon.paintIcon(null, g, allocation.getBounds().x, allocation.getBounds().y);
                    g2d.setComposite(savedComposite);
                }

                @Override
                @NotNull
                public Shape modelToView(int pos, @NotNull Shape a, @NotNull Position.Bias b) throws BadLocationException {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    int p0 = this.getStartOffset();
                    int p1 = this.getEndOffset();
                    boolean bl = p0 <= pos ? pos <= p1 : false;
                    if (bl) {
                        Rectangle r = a.getBounds();
                        if (pos == p1) {
                            r.x += r.width;
                        }
                        r.width = 0;
                        Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
                        return r;
                    }
                    throw new BadLocationException(pos + " not in range " + p0 + "," + p1, pos);
                }

                @Override
                public int viewToModel(float x, float y, @NotNull Shape a, @NotNull Position.Bias[] bias) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Intrinsics.checkNotNullParameter((Object)bias, (String)"bias");
                    Rectangle alloc = (Rectangle)a;
                    if (x < (float)alloc.x + (float)alloc.width / 2.0f) {
                        Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Forward, (String)"Forward");
                        return this.getStartOffset();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Backward, (String)"Backward");
                    return this.getEndOffset();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extensions$Base64ImagesExtension;", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "()V", "invoke", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "defaultView", "BufferedImageView", "intellij.platform.util.ui"})
        @SourceDebugExtension(value={"SMAP\nExtendableHTMLViewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtendableHTMLViewFactory.kt\ncom/intellij/util/ui/ExtendableHTMLViewFactory$Extensions$Base64ImagesExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,352:1\n1#2:353\n8#3:354\n8#3:355\n*S KotlinDebug\n*F\n+ 1 ExtendableHTMLViewFactory.kt\ncom/intellij/util/ui/ExtendableHTMLViewFactory$Extensions$Base64ImagesExtension\n*L\n218#1:354\n221#1:355\n*E\n"})
        private static final class Base64ImagesExtension
        implements Extension {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public View invoke(@NotNull Element elem, @NotNull View defaultView) {
                Base64ImagesExtension $this$thisLogger$iv;
                Object it;
                Object object;
                Object object2;
                block16: {
                    block15: {
                        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
                        Intrinsics.checkNotNullParameter((Object)defaultView, (String)"defaultView");
                        if (!Intrinsics.areEqual((Object)"img", (Object)elem.getName())) {
                            return null;
                        }
                        Object object3 = elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                        object2 = object3 instanceof String ? (String)object3 : null;
                        if (object2 == null) break block15;
                        it = object = object2;
                        boolean bl = false;
                        object2 = StringsKt.startsWith$default((String)it, (String)"data:image", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"base64", (boolean)false, (int)2, null) ? object : null;
                        if (object2 != null) break block16;
                    }
                    return null;
                }
                String src = object2;
                object = new char[1];
                object[0] = 44;
                it = object = StringsKt.split$default((CharSequence)src, (char[])object, (boolean)false, (int)0, (int)6, null);
                boolean bl = false;
                Object object4 = it.size() == 2 ? object : null;
                if (object4 == null || (object4 = (String)object4.get(1)) == null) {
                    return null;
                }
                Object encodedImage = object4;
                try {
                    BufferedImage bufferedImage;
                    it = new ByteArrayInputStream(Base64.getDecoder().decode((String)encodedImage));
                    Throwable throwable = null;
                    try {
                        InputStream p0 = (InputStream)it;
                        boolean bl2 = false;
                        BufferedImage bufferedImage2 = ImageIO.read(p0);
                        bufferedImage = bufferedImage2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)it, (Throwable)throwable);
                    }
                    if (bufferedImage == null) {
                        return null;
                    }
                    BufferedImage image = bufferedImage;
                    return new BufferedImageView(elem, image);
                }
                catch (IllegalArgumentException e) {
                    $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(Base64ImagesExtension.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                    logger.debug(e);
                }
                catch (IOException e) {
                    $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(Base64ImagesExtension.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                    logger.debug(e);
                }
                return null;
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J3\u0010#\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0%H\u0016\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extensions$Base64ImagesExtension$BufferedImageView;", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "bufferedImage", "Ljava/awt/image/BufferedImage;", "(Ljavax/swing/text/Element;Ljava/awt/image/BufferedImage;)V", "border", "", "height", "vAlign", "", "width", "getAlignment", "axis", "getIntAttr", "name", "Ljavax/swing/text/html/HTML$Attribute;", "defaultValue", "getPreferredSpan", "getToolTipText", "", "x", "y", "allocation", "Ljava/awt/Shape;", "modelToView", "pos", "a", "b", "Ljavax/swing/text/Position$Bias;", "paint", "", "g", "Ljava/awt/Graphics;", "viewToModel", "bias", "", "(FFLjava/awt/Shape;[Ljavax/swing/text/Position$Bias;)I", "Companion", "intellij.platform.util.ui"})
            private static final class BufferedImageView
            extends View {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @NotNull
                private final BufferedImage bufferedImage;
                private final int width;
                private final int height;
                private final int border;
                private final float vAlign;
                private static final int DEFAULT_BORDER = 0;

                public BufferedImageView(@NotNull Element elem, @NotNull BufferedImage bufferedImage) {
                    Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
                    Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"bufferedImage");
                    super(elem);
                    this.bufferedImage = bufferedImage;
                    HTML.Attribute attribute = HTML.Attribute.WIDTH;
                    Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"WIDTH");
                    int width = this.getIntAttr(attribute, -1);
                    HTML.Attribute attribute2 = HTML.Attribute.HEIGHT;
                    Intrinsics.checkNotNullExpressionValue((Object)attribute2, (String)"HEIGHT");
                    int height = this.getIntAttr(attribute2, -1);
                    int aspectRatio = this.bufferedImage.getWidth() / this.bufferedImage.getHeight();
                    if (width < 0 && height < 0) {
                        this.width = this.bufferedImage.getWidth();
                        this.height = this.bufferedImage.getHeight();
                    } else if (width < 0) {
                        this.width = height * aspectRatio;
                        this.height = height;
                    } else if (height < 0) {
                        this.width = width;
                        this.height = width / aspectRatio;
                    } else {
                        this.width = width;
                        this.height = height;
                    }
                    HTML.Attribute attribute3 = HTML.Attribute.BORDER;
                    Intrinsics.checkNotNullExpressionValue((Object)attribute3, (String)"BORDER");
                    this.border = this.getIntAttr(attribute3, 0);
                    Object alignment = elem.getAttributes().getAttribute(HTML.Attribute.ALIGN);
                    float vAlign = 1.0f;
                    if (alignment != null) {
                        if (Intrinsics.areEqual((Object)"top", (Object)(alignment = alignment.toString()))) {
                            vAlign = 0.0f;
                        } else if (Intrinsics.areEqual((Object)"middle", (Object)alignment)) {
                            vAlign = 0.5f;
                        }
                    }
                    this.vAlign = vAlign;
                }

                private final int getIntAttr(HTML.Attribute name, int defaultValue) {
                    int n;
                    AttributeSet attr = this.getElement().getAttributes();
                    if (!attr.isDefined(name)) {
                        return defaultValue;
                    }
                    Object object = attr.getAttribute(name);
                    String string2 = object instanceof String ? (String)object : null;
                    if (string2 == null) {
                        return defaultValue;
                    }
                    String value = string2;
                    try {
                        n = Math.max(0, Integer.parseInt(value));
                    }
                    catch (NumberFormatException x) {
                        n = defaultValue;
                    }
                    return n;
                }

                @Override
                public float getPreferredSpan(int axis) {
                    return switch (axis) {
                        case 0 -> this.width + 2 * this.border;
                        case 1 -> this.height + 2 * this.border;
                        default -> throw new IllegalArgumentException("Invalid axis: " + axis);
                    };
                }

                @Override
                @Nullable
                public String getToolTipText(float x, float y, @NotNull Shape allocation) {
                    Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
                    Object object = super.getElement().getAttributes().getAttribute(HTML.Attribute.ALT);
                    return object instanceof String ? (String)object : null;
                }

                @Override
                public void paint(@NotNull Graphics g, @NotNull Shape a) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Rectangle bounds = a.getBounds();
                    g.drawImage(this.bufferedImage, bounds.x + this.border, bounds.y + this.border, this.width, this.height, null);
                }

                @Override
                @Nullable
                public Shape modelToView(int pos, @NotNull Shape a, @NotNull Position.Bias b) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    int p0 = this.getStartOffset();
                    int p1 = this.getEndOffset();
                    boolean bl = p0 <= pos ? pos <= p1 : false;
                    if (bl) {
                        Rectangle r = a.getBounds();
                        if (pos == p1) {
                            r.x += r.width;
                        }
                        r.width = 0;
                        return r;
                    }
                    return null;
                }

                @Override
                public int viewToModel(float x, float y, @NotNull Shape a, @NotNull Position.Bias[] bias) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Intrinsics.checkNotNullParameter((Object)bias, (String)"bias");
                    Rectangle alloc = (Rectangle)a;
                    if (x < (float)(alloc.x + alloc.width)) {
                        Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Forward, (String)"Forward");
                        return this.getStartOffset();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Backward, (String)"Backward");
                    return this.getEndOffset();
                }

                @Override
                public float getAlignment(int axis) {
                    return axis == 1 ? this.vAlign : super.getAlignment(axis);
                }

                @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extensions$Base64ImagesExtension$BufferedImageView$Companion;", "", "()V", "DEFAULT_BORDER", "", "intellij.platform.util.ui"})
                public static final class Companion {
                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/util/ui/ExtendableHTMLViewFactory$WordWrapExtension;", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "()V", "invoke", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "defaultView", "intellij.platform.util.ui"})
    private static final class WordWrapExtension
    implements Extension {
        @Nullable
        public View invoke(@NotNull Element elem, @NotNull View defaultView) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            Intrinsics.checkNotNullParameter((Object)defaultView, (String)"defaultView");
            if (!(defaultView instanceof ParagraphView)) {
                return null;
            }
            return new ParagraphView(elem){

                @NotNull
                protected SizeRequirements calculateMinorAxisRequirements(int axis, @Nullable SizeRequirements requirements) {
                    SizeRequirements sizeRequirements;
                    SizeRequirements sizeRequirements2 = requirements;
                    if (sizeRequirements2 == null) {
                        sizeRequirements2 = new SizeRequirements();
                    }
                    SizeRequirements $this$calculateMinorAxisRequirements_u24lambda_u240 = sizeRequirements = sizeRequirements2;
                    boolean bl = false;
                    $this$calculateMinorAxisRequirements_u24lambda_u240.minimum = (int)this.layoutPool.getMinimumSpan(axis);
                    $this$calculateMinorAxisRequirements_u24lambda_u240.preferred = Math.max($this$calculateMinorAxisRequirements_u24lambda_u240.minimum, (int)this.layoutPool.getPreferredSpan(axis));
                    $this$calculateMinorAxisRequirements_u24lambda_u240.maximum = Integer.MAX_VALUE;
                    $this$calculateMinorAxisRequirements_u24lambda_u240.alignment = 0.5f;
                    return sizeRequirements;
                }
            };
        }
    }
}

