/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.Scale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageUtil {
    @NotNull
    public static BufferedImage createImage(int width, int height, int type) {
        return ImageUtil.createImage((GraphicsConfiguration)null, width, height, type);
    }

    @NotNull
    public static BufferedImage createImage(@Nullable GraphicsConfiguration gc, int width, int height, int type) {
        if (JreHiDpiUtil.isJreHiDPI(gc)) {
            return new JBHiDPIScaledImage(gc, width, height, type);
        }
        return new BufferedImage(width, height, type);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(ScaleContext context2, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            ImageUtil.$$$reportNull$$$0(0);
        }
        if (StartupUiUtil.isJreHiDPI(context2)) {
            return new JBHiDPIScaledImage(context2, width, height, (int)type, (PaintUtil.RoundingMode)rm);
        }
        return new BufferedImage(rm.round(width), rm.round(height), (int)type);
    }

    @NotNull
    public static BufferedImage createImage(Graphics g, int width, int height, int type) {
        return ImageUtil.createImage(g, (double)width, (double)height, type, PaintUtil.RoundingMode.FLOOR);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(Graphics g, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            ImageUtil.$$$reportNull$$$0(1);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (JreHiDpiUtil.isJreHiDPI(g2d)) {
                BufferedImage bufferedImage = RetinaImage.create(g2d, width, height, (int)type, (PaintUtil.RoundingMode)rm);
                if (bufferedImage == null) {
                    ImageUtil.$$$reportNull$$$0(2);
                }
                return bufferedImage;
            }
            return new BufferedImage(rm.round(width), rm.round(height), (int)type);
        }
        return ImageUtil.createImage(rm.round(width), rm.round(height), (int)type);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(3);
        }
        return ImageUtil.toBufferedImage(image, false, false);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image, boolean inUserSize) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(4);
        }
        return ImageUtil.toBufferedImage(image, inUserSize, false);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image, boolean inUserSize, boolean ensureOneComponent) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(5);
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jbImage = (JBHiDPIScaledImage)image;
            Image delegate2 = jbImage.getDelegate();
            if (delegate2 != null) {
                image = delegate2;
            }
            if (inUserSize) {
                image = ImageUtil.scaleImage(image, 1.0 / jbImage.getScale());
            }
        }
        if (image instanceof BufferedImage && (!ensureOneComponent || ((BufferedImage)image).getColorModel().getNumComponents() == 1)) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (bufferedImage == null) {
                ImageUtil.$$$reportNull$$$0(6);
            }
            return bufferedImage;
        }
        final int width = image.getWidth(null);
        final int height = image.getHeight(null);
        if (width <= 0 || height <= 0) {
            return new BufferedImage(Math.max(width, 1), Math.max(height, 1), 2){

                @Override
                public int getWidth() {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight() {
                    return Math.max(height, 0);
                }

                @Override
                public int getWidth(ImageObserver observer) {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight(ImageObserver observer) {
                    return Math.max(height, 0);
                }
            };
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ImageUtil.$$$reportNull$$$0(7);
        }
        return bufferedImage2;
    }

    public static double getImageScale(Image image) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getScale();
        }
        return 1.0;
    }

    public static int getRealWidth(@NotNull Image image) {
        Image img;
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(8);
        }
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getWidth(null);
    }

    public static int getRealHeight(@NotNull Image image) {
        Image img;
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(9);
        }
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getHeight(null);
    }

    public static int getUserWidth(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(10);
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserWidth(null);
        }
        return image.getWidth(null);
    }

    public static int getUserHeight(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(11);
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserHeight(null);
        }
        return image.getHeight(null);
    }

    public static Image filter(@Nullable Image image, @Nullable ImageFilter filter2) {
        if (image == null || filter2 == null) {
            return image;
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image).getSource(), filter2));
    }

    public static Image scaleImage(Image image, double scale) {
        return ImageLoader.scaleImage(image, scale);
    }

    public static Image scaleImage(Image image, int width, int height) {
        if (width <= 0 || height <= 0) {
            return image;
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).scale(width, height);
        }
        return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull ScaleContext ctx) {
        if (ctx == null) {
            ImageUtil.$$$reportNull$$$0(12);
        }
        if (image == null) {
            return null;
        }
        if (StartupUiUtil.isJreHiDPI(ctx)) {
            return RetinaImage.createFrom(image, ctx.getScale(ScaleType.SYS_SCALE), null);
        }
        return image;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="null, _, _, _ -> null; !null, _, _, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull ScaleContext context2, double userWidth, double d) {
        if (context2 == null) {
            ImageUtil.$$$reportNull$$$0(13);
        }
        if (image == null) {
            return null;
        }
        if (StartupUiUtil.isJreHiDPI(context2)) {
            void userHeight;
            return new JBHiDPIScaledImage(image, userWidth, (double)userHeight, 2);
        }
        return image;
    }

    @NotNull
    public static Image resize(@NotNull Image image, int size, @NotNull ScaleContext scaleContext) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(14);
        }
        if (scaleContext == null) {
            ImageUtil.$$$reportNull$$$0(15);
        }
        Image hidpiImage = ImageUtil.ensureHiDPI(image, scaleContext);
        int scaledSize = (int)scaleContext.apply((double)size, ScaleType.USR_SCALE);
        Image image2 = ImageUtil.scaleImage(hidpiImage, scaledSize, scaledSize);
        if (image2 == null) {
            ImageUtil.$$$reportNull$$$0(16);
        }
        return image2;
    }

    @NotNull
    public static BufferedImage createCircleImage(@NotNull BufferedImage image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(17);
        }
        int size = Math.min(image.getWidth(), image.getHeight());
        Area avatarOvalArea = new Area(new Ellipse2D.Double(0.0, 0.0, size, size));
        return ImageUtil.clipImage(image, avatarOvalArea);
    }

    @NotNull
    public static BufferedImage createRoundedImage(@NotNull BufferedImage image, double arc) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(18);
        }
        int size = Math.min(image.getWidth(), image.getHeight());
        Area avatarOvalArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, size, size, arc, arc));
        return ImageUtil.clipImage(image, avatarOvalArea);
    }

    @NotNull
    public static BufferedImage clipImage(@NotNull BufferedImage image, @NotNull Shape clip) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(19);
        }
        if (clip == null) {
            ImageUtil.$$$reportNull$$$0(20);
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage scaledImage = (JBHiDPIScaledImage)image;
            Image delegate2 = scaledImage.getDelegate();
            if (delegate2 == null) {
                return ImageUtil.doClipImage(scaledImage, clip);
            }
            BufferedImage clippedImage = ImageUtil.doClipImage(ImageUtil.toBufferedImage(delegate2), clip);
            return new JBHiDPIScaledImage(clippedImage, ScaleContext.create(Scale.create(scaledImage.getScale(), ScaleType.SYS_SCALE)), scaledImage.getType());
        }
        return ImageUtil.doClipImage(image, clip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static BufferedImage doClipImage(@NotNull BufferedImage image, @NotNull Shape clip) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(21);
        }
        if (clip == null) {
            ImageUtil.$$$reportNull$$$0(22);
        }
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        ImageUtil.applyQualityRenderingHints(g);
        g.setPaint(new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight())));
        g.fill(clip);
        BufferedImage bufferedImage = newImage;
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ImageUtil.$$$reportNull$$$0(23);
        }
        return bufferedImage2;
        finally {
            g.dispose();
        }
    }

    public static void applyQualityRenderingHints(@NotNull Graphics2D g2) {
        if (g2 == null) {
            ImageUtil.$$$reportNull$$$0(24);
        }
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 16, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ImageUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clip";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ImageUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toBufferedImage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resize";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doClipImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 16: 
            case 23: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toBufferedImage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRealWidth";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRealHeight";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserWidth";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserHeight";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ensureHiDPI";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resize";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCircleImage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createRoundedImage";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "clipImage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doClipImage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyQualityRenderingHints";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6, 7, 16, 23 -> new IllegalStateException(string2);
        };
    }
}

