/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Font;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class JBFont
extends Font {
    JBFont(@NotNull Font font) {
        if (font == null) {
            JBFont.$$$reportNull$$$0(0);
        }
        super(font);
    }

    @NotNull
    public static JBFont label() {
        return JBFont.create(UIManager.getFont("Label.font"), false);
    }

    public static JBFont create(Font font) {
        return JBFont.create(font, true);
    }

    @NotNull
    public static JBFont create(@NotNull Font font, boolean tryToScale) {
        if (font == null) {
            JBFont.$$$reportNull$$$0(1);
        }
        if (font instanceof JBFont) {
            JBFont jBFont = (JBFont)font;
            if (jBFont == null) {
                JBFont.$$$reportNull$$$0(2);
            }
            return jBFont;
        }
        Font scaled = font;
        if (tryToScale) {
            scaled = font.deriveFont((float)font.getSize() * JBUIScale.scale(1.0f));
        }
        if (font instanceof UIResource) {
            return new JBFontUIResource(scaled);
        }
        return new JBFont(scaled);
    }

    public JBFont asBold() {
        return this.deriveFont(1, this.getSize());
    }

    public JBFont asItalic() {
        return this.deriveFont(2, this.getSize());
    }

    public JBFont asPlain() {
        return this.deriveFont(0, this.getSize());
    }

    @Override
    public JBFont deriveFont(int style, float size) {
        Font font = super.deriveFont(style, size);
        return this instanceof JBFontUIResource ? new JBFontUIResource(font) : new JBFont(font);
    }

    @Override
    public JBFont deriveFont(float size) {
        return this.deriveFont(this.getStyle(), size);
    }

    public JBFont biggerOn(float size) {
        return this.deriveFont((float)this.getSize() + JBUIScale.scale(size));
    }

    public JBFont lessOn(float size) {
        return this.deriveFont((float)this.getSize() - JBUIScale.scale(size));
    }

    public static JBFont h0() {
        return JBFont.label().biggerOn(12.0f).asBold();
    }

    public static JBFont h1() {
        return JBFont.label().biggerOn(9.0f).asBold();
    }

    public static JBFont h2() {
        return JBFont.label().biggerOn(5.0f);
    }

    public static JBFont h3() {
        return JBFont.label().biggerOn(3.0f);
    }

    public static JBFont h4() {
        return JBFont.label().biggerOn(1.0f).asBold();
    }

    public static JBFont regular() {
        return JBFont.label();
    }

    public static JBFont medium() {
        return JBFont.mediumAndSmallFontsAsRegular() ? JBFont.label() : JBFont.label().lessOn(1.0f);
    }

    public static JBFont small() {
        return JBFont.mediumAndSmallFontsAsRegular() ? JBFont.label() : JBFont.label().lessOn(2.0f);
    }

    @ApiStatus.Internal
    public static JBFont smallOrNewUiMedium() {
        return Registry.is("ide.experimental.ui") ? JBFont.medium() : JBFont.small();
    }

    private static boolean mediumAndSmallFontsAsRegular() {
        return SystemInfo.isWindows && !Registry.is("ide.experimental.ui");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBFont";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }

    static final class JBFontUIResource
    extends JBFont
    implements UIResource {
        JBFontUIResource(Font font) {
            super(font);
        }
    }
}

