/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.scale.JBUIScale;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class JBInsets
extends Insets {
    private final Insets unscaled;

    @ApiStatus.Internal
    public JBInsets(int all) {
        this(all, all, all, all);
    }

    @ApiStatus.Internal
    @NotNull
    public static JBInsets emptyInsets() {
        return new JBInsets(0, 0, 0, 0);
    }

    public JBInsets(int top, int left, int bottom, int right) {
        super(JBUIScale.scale(top), JBUIScale.scale(left), JBUIScale.scale(bottom), JBUIScale.scale(right));
        this.unscaled = new Insets(top, left, bottom, right);
    }

    public int width() {
        return this.left + this.right;
    }

    public int height() {
        return this.top + this.bottom;
    }

    @NotNull
    public static JBInsets create(int topBottom, int leftRight) {
        return new JBInsets(topBottom, leftRight, topBottom, leftRight);
    }

    @NotNull
    public static JBInsets create(@NotNull Insets insets) {
        if (insets == null) {
            JBInsets.$$$reportNull$$$0(0);
        }
        if (insets instanceof JBInsets) {
            JBInsets copy2 = new JBInsets(0, 0, 0, 0);
            JBInsets.copyInsets(copy2, insets);
            JBInsets jBInsets = copy2;
            if (jBInsets == null) {
                JBInsets.$$$reportNull$$$0(1);
            }
            return jBInsets;
        }
        return new JBInsets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public Insets getUnscaled() {
        return new Insets(this.unscaled.top, this.unscaled.left, this.unscaled.bottom, this.unscaled.right);
    }

    public JBInsetsUIResource asUIResource() {
        return new JBInsetsUIResource(this);
    }

    public static void addTo(@NotNull Dimension dimension, Insets insets) {
        if (dimension == null) {
            JBInsets.$$$reportNull$$$0(2);
        }
        if (insets != null) {
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
    }

    public static void removeFrom(@NotNull Dimension dimension, Insets insets) {
        if (dimension == null) {
            JBInsets.$$$reportNull$$$0(3);
        }
        if (insets != null) {
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
        }
    }

    public static void addTo(@NotNull Rectangle rectangle, Insets insets) {
        if (rectangle == null) {
            JBInsets.$$$reportNull$$$0(4);
        }
        if (insets != null) {
            rectangle.x -= insets.left;
            rectangle.y -= insets.top;
            rectangle.width += insets.left + insets.right;
            rectangle.height += insets.top + insets.bottom;
        }
    }

    public static void removeFrom(@NotNull Rectangle rectangle, Insets insets) {
        if (rectangle == null) {
            JBInsets.$$$reportNull$$$0(5);
        }
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
    }

    @NotNull
    public static JBInsets addInsets(Insets ... insets) {
        if (insets == null) {
            JBInsets.$$$reportNull$$$0(6);
        }
        JBInsets result2 = JBInsets.emptyInsets();
        for (Insets inset : insets) {
            result2.top += inset.top;
            result2.left += inset.left;
            result2.bottom += inset.bottom;
            result2.right += inset.right;
        }
        JBInsets jBInsets = result2;
        if (jBInsets == null) {
            JBInsets.$$$reportNull$$$0(7);
        }
        return jBInsets;
    }

    private static void copyInsets(@NotNull Insets dest, @NotNull Insets src) {
        if (dest == null) {
            JBInsets.$$$reportNull$$$0(8);
        }
        if (src == null) {
            JBInsets.$$$reportNull$$$0(9);
        }
        dest.top = src.top;
        dest.left = src.left;
        dest.bottom = src.bottom;
        dest.right = src.right;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBInsets";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimension";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBInsets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addInsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTo";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyInsets";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 7 -> new IllegalStateException(string2);
        };
    }

    public static final class JBInsetsUIResource
    extends JBInsets
    implements UIResource {
        public JBInsetsUIResource(JBInsets insets) {
            super(0, 0, 0, 0);
            JBInsets.copyInsets(this, insets);
        }
    }
}

