/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/intellij/util/ui/ListUiUtil;", "", "()V", "Selection", "WithTallRow", "intellij.platform.util.ui"})
public final class ListUiUtil {
    @NotNull
    public static final ListUiUtil INSTANCE = new ListUiUtil();

    private ListUiUtil() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\"\u0010\f\u001a\u00020\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001c\u0010\u0010\u001a\u00020\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/ui/ListUiUtil$WithTallRow;", "", "()V", "alternativeRowBackground", "Lcom/intellij/ui/JBColor;", "selectionBackground", "unfocusedSelectionBackground", "alternativeBackground", "Ljava/awt/Color;", "isSelected", "", "hasFocus", "background", "list", "Ljavax/swing/JList;", "foreground", "secondaryForeground", "intellij.platform.util.ui"})
    public static final class WithTallRow {
        @NotNull
        public static final WithTallRow INSTANCE = new WithTallRow();
        @NotNull
        private static final JBColor selectionBackground = new JBColor(15595262, 4606541);
        @NotNull
        private static final JBColor unfocusedSelectionBackground = new JBColor(0xF5F5F5, 4606541);
        @NotNull
        private static final JBColor alternativeRowBackground = new JBColor(0xFFFFFF, 0x313335);

        private WithTallRow() {
        }

        @NotNull
        public final Color foreground(boolean isSelected, boolean hasFocus) {
            Color color;
            Color color2 = UIUtil.getListForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getListForeground()");
            Color color3 = color2;
            if (isSelected) {
                JBColor jBColor = hasFocus ? JBColor.namedColor("Table.lightSelectionForeground", color3) : JBColor.namedColor("Table.lightSelectionInactiveForeground", color3);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"{\n        if (hasFocus) \u2026ground\", default)\n      }");
                color = jBColor;
            } else {
                JBColor jBColor = JBColor.namedColor("Table.foreground", color3);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(\"Table.foreground\", default)");
                color = jBColor;
            }
            return color;
        }

        @Deprecated(message="Deprecated in favor of more fine-grained method", replaceWith=@ReplaceWith(expression="ListUiUtil.WithTallRow.secondaryForeground(isSelected, list.hasFocus())", imports={"com.intellij.util.ui.ListUiUtil"}))
        @NotNull
        public final Color secondaryForeground(@NotNull JList<?> list2, boolean isSelected) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            return this.secondaryForeground(isSelected, list2.hasFocus());
        }

        @NotNull
        public final Color secondaryForeground(boolean isSelected, boolean hasFocus) {
            Color color;
            if (isSelected) {
                color = this.foreground(true, hasFocus);
            } else {
                JBColor jBColor = JBColor.namedColor("Component.infoForeground", UIUtil.getContextHelpForeground());
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(\"Component.in\u2026tContextHelpForeground())");
                color = jBColor;
            }
            return color;
        }

        @NotNull
        public final Color background(@NotNull JList<?> list2, boolean isSelected, boolean hasFocus) {
            Color color;
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (isSelected) {
                JBColor jBColor = hasFocus ? JBColor.namedColor("Table.lightSelectionBackground", selectionBackground) : JBColor.namedColor("Table.lightSelectionInactiveBackground", unfocusedSelectionBackground);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"{\n        if (hasFocus) \u2026ectionBackground)\n      }");
                color = jBColor;
            } else {
                Color color2 = list2.getBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"list.background");
            }
            return color;
        }

        @NotNull
        public final Color alternativeBackground(boolean isSelected, boolean hasFocus) {
            Color color;
            if (isSelected) {
                JBColor jBColor = hasFocus ? JBColor.namedColor("Table.lightSelectionBackground", selectionBackground) : JBColor.namedColor("Table.lightSelectionInactiveBackground", unfocusedSelectionBackground);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"{\n        if (hasFocus) \u2026ectionBackground)\n      }");
                color = jBColor;
            } else {
                JBColor jBColor = JBColor.namedColor("Table.alternativeRowBackground", alternativeRowBackground);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"{\n        JBColor.namedC\u2026iveRowBackground)\n      }");
                color = jBColor;
            }
            return color;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/util/ui/ListUiUtil$Selection;", "", "()V", "installSelectionOnFocus", "Ljava/awt/event/FocusListener;", "list", "Ljavax/swing/JList;", "installSelectionOnRightClick", "Ljava/awt/event/MouseListener;", "intellij.platform.util.ui"})
    public static final class Selection {
        @NotNull
        public static final Selection INSTANCE = new Selection();

        private Selection() {
        }

        @NotNull
        public final FocusListener installSelectionOnFocus(@NotNull JList<?> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            FocusListener listener2 = new FocusAdapter(list2){
                final /* synthetic */ JList<?> $list;
                {
                    this.$list = $list;
                }

                public void focusGained(@NotNull FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (this.$list.isSelectionEmpty() && this.$list.getModel().getSize() > 0) {
                        this.$list.setSelectedIndex(0);
                    }
                }
            };
            list2.addFocusListener(listener2);
            return listener2;
        }

        @NotNull
        public final MouseListener installSelectionOnRightClick(@NotNull JList<?> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            MouseListener listener2 = new MouseAdapter(list2){
                final /* synthetic */ JList<?> $list;
                {
                    this.$list = $list;
                }

                public void mousePressed(@NotNull MouseEvent e) {
                    int row;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (SwingUtilities.isRightMouseButton(e) && (row = this.$list.locationToIndex(e.getPoint())) != -1) {
                        this.$list.setSelectedIndex(row);
                    }
                }
            };
            list2.addMouseListener(listener2);
            return listener2;
        }
    }
}

