/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public final class RadioButtonEnumModel<E extends Enum<E>> {
    private final ButtonGroup myGroup;
    private final List<ButtonModel> myModels;
    private final List<E> myEnums;

    public static <E extends Enum<E>> RadioButtonEnumModel<E> bindEnum(Class<E> e, ButtonGroup group2) {
        return new RadioButtonEnumModel<E>(e, group2);
    }

    private RadioButtonEnumModel(Class<E> e, ButtonGroup group2) {
        this.myGroup = group2;
        this.myModels = ContainerUtil.map(Collections.list(this.myGroup.getElements()), AbstractButton::getModel);
        this.myEnums = Arrays.asList((Enum[])e.getEnumConstants());
    }

    public E getSelected() {
        ButtonModel selection = this.myGroup.getSelection();
        int i2 = this.myModels.indexOf(selection);
        return (E)((Enum)this.myEnums.get(i2));
    }

    public void setSelected(E e) {
        int i2 = this.myEnums.indexOf(e);
        this.setSelected(i2);
    }

    public void addActionListener(ActionListener listener2) {
        for (AbstractButton button2 : Collections.list(this.myGroup.getElements())) {
            button2.addActionListener(listener2);
        }
    }

    public void setSelected(int index2) {
        this.myGroup.setSelected(this.myModels.get(index2), true);
    }

    public AbstractButton getButton(E e) {
        int i2 = this.myEnums.indexOf(e);
        return Collections.list(this.myGroup.getElements()).get(i2);
    }
}

