/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.util.ui.JBCachingScalableIcon;
import com.intellij.util.ui.RegionPainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\fBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0000H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J*\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/util/ui/RegionPaintIcon;", "Lcom/intellij/util/ui/JBCachingScalableIcon;", "width", "", "height", "insets", "painter", "Lcom/intellij/util/ui/RegionPainter;", "Ljava/awt/Component;", "(IIILcom/intellij/util/ui/RegionPainter;)V", "(IILcom/intellij/util/ui/RegionPainter;)V", "size", "(ILcom/intellij/util/ui/RegionPainter;)V", "top", "left", "bottom", "right", "(IIIIIILcom/intellij/util/ui/RegionPainter;)V", "copy", "equals", "", "other", "", "getIconHeight", "getIconWidth", "hashCode", "paintIcon", "", "c", "g", "Ljava/awt/Graphics;", "x", "y", "scaled", "toString", "", "intellij.platform.util.ui"})
public final class RegionPaintIcon
extends JBCachingScalableIcon<RegionPaintIcon> {
    private final int width;
    private final int height;
    private final int top;
    private final int left;
    private final int bottom;
    private final int right;
    @NotNull
    private final RegionPainter<Component> painter;

    public RegionPaintIcon(int width, int height, int top, int left, int bottom, int right, @NotNull RegionPainter<Component> painter) {
        Intrinsics.checkNotNullParameter(painter, (String)"painter");
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.painter = painter;
    }

    public RegionPaintIcon(int width, int height, int insets, @NotNull RegionPainter<Component> painter) {
        Intrinsics.checkNotNullParameter(painter, (String)"painter");
        this(width, height, insets, insets, insets, insets, painter);
    }

    public RegionPaintIcon(int width, int height, @NotNull RegionPainter<Component> painter) {
        Intrinsics.checkNotNullParameter(painter, (String)"painter");
        this(width, height, 0, painter);
    }

    public RegionPaintIcon(int size, @NotNull RegionPainter<Component> painter) {
        Intrinsics.checkNotNullParameter(painter, (String)"painter");
        this(size, size, painter);
    }

    @Override
    @NotNull
    public RegionPaintIcon copy() {
        RegionPaintIcon icon2 = new RegionPaintIcon(this.width, this.height, this.top, this.left, this.bottom, this.right, this.painter);
        icon2.updateContextFrom(this);
        return icon2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(@Nullable Component c2, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (g instanceof Graphics2D) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            Graphics graphics = g.create(x, y, width, height);
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            try {
                int dx = this.scaled(this.left);
                int dy = this.scaled(this.top);
                int dw = dx + this.scaled(this.right);
                int dh = dy + this.scaled(this.bottom);
                this.painter.paint(g2d, dx, dy, width - dw, height - dh, c2);
            }
            finally {
                g2d.dispose();
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.scaled(this.width);
    }

    @Override
    public int getIconHeight() {
        return this.scaled(this.height);
    }

    private final int scaled(int size) {
        return size > 0 ? (int)Math.ceil(this.scaleVal(size)) : 0;
    }

    @Override
    @NotNull
    public String toString() {
        return this.painter.toString();
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.width, this.height, this.painter};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        RegionPaintIcon regionPaintIcon = other instanceof RegionPaintIcon ? (RegionPaintIcon)other : null;
        if (regionPaintIcon == null) {
            return false;
        }
        RegionPaintIcon icon2 = regionPaintIcon;
        return icon2.width == this.width && icon2.height == this.height && icon2.top == this.top && icon2.left == this.left && icon2.right == this.right && icon2.bottom == this.bottom && icon2.scaleVal(1.0, DerivedScaleType.PIX_SCALE) == this.scaleVal(1.0, DerivedScaleType.PIX_SCALE) && Intrinsics.areEqual(icon2.painter, this.painter);
    }
}

