/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Nullable;

public final class ScrollUtil {
    private ScrollUtil() {
    }

    @Nullable
    public static JScrollPane findScrollPane(JComponent c2) {
        if (c2 == null) {
            return null;
        }
        return UIUtil.findComponentOfType(c2, JScrollPane.class);
    }

    @Nullable
    public static JScrollBar findVerticalScrollBar(JComponent c2) {
        return ScrollUtil.findScrollBar(c2, 1);
    }

    @Nullable
    public static JScrollBar findHorizontalScrollBar(JComponent c2) {
        return ScrollUtil.findScrollBar(c2, 0);
    }

    @Nullable
    private static JScrollBar findScrollBar(JComponent c2, @JdkConstants.AdjustableOrientation int orientation) {
        if (c2 == null) {
            return null;
        }
        if (c2 instanceof JScrollBar && ((JScrollBar)c2).getOrientation() == orientation) {
            return (JScrollBar)c2;
        }
        for (Component comp : c2.getComponents()) {
            JScrollBar scrollBar;
            if (!(comp instanceof JComponent) || (scrollBar = ScrollUtil.findScrollBar((JComponent)comp, orientation)) == null) continue;
            return scrollBar;
        }
        return null;
    }

    public static void scrollVertically(JComponent c2, int position) {
        JScrollPane pane = ScrollUtil.findScrollPane(c2);
        if (pane != null) {
            JScrollBar bar = pane.getVerticalScrollBar();
            if (bar != null) {
                bar.setValue(position);
            }
        } else {
            JScrollBar scrollBar = ScrollUtil.findVerticalScrollBar(c2);
            if (scrollBar != null) {
                scrollBar.setValue(position);
            }
        }
    }

    public static void scrollHorizontally(JComponent c2, int position) {
        JScrollPane pane = ScrollUtil.findScrollPane(c2);
        if (pane != null) {
            JScrollBar bar = pane.getHorizontalScrollBar();
            if (bar != null) {
                bar.setValue(position);
            }
        } else {
            JScrollBar scrollBar = ScrollUtil.findHorizontalScrollBar(c2);
            if (scrollBar != null) {
                scrollBar.setValue(position);
            }
        }
    }

    public static void center(JComponent c2, Rectangle r) {
        ScrollUtil.center(c2, r, false);
    }

    public static void center(JComponent c2, Rectangle r, boolean withInsets) {
        Rectangle visible = c2.getVisibleRect();
        visible.x = r.x - (visible.width - r.width) / 2;
        visible.y = r.y - (visible.height - r.height) / 2;
        Rectangle bounds = new Rectangle(c2.getWidth(), c2.getHeight());
        if (!withInsets) {
            JBInsets.removeFrom(bounds, c2.getInsets());
        }
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        c2.scrollRectToVisible(visible);
    }

    public static void scroll(JComponent c2, Rectangle r, ScrollBias horizontalBias, ScrollBias verticalBias) {
        Rectangle visible = c2.getVisibleRect();
        Rectangle dest = new Rectangle(r);
        if (dest.width > visible.width && horizontalBias != ScrollBias.VIEWPORT) {
            if (horizontalBias == ScrollBias.UNCHANGED) {
                if (dest.x <= visible.x && dest.x + dest.width >= visible.x + visible.width) {
                    dest.width = visible.width;
                }
            } else {
                if (horizontalBias == ScrollBias.CENTER) {
                    dest.x += (dest.width - visible.width) / 2;
                } else if (horizontalBias == ScrollBias.LAST) {
                    dest.x += dest.width - visible.width;
                }
                dest.width = visible.width;
            }
        }
        if (dest.height > visible.height) {
            // empty if block
        }
        if (!visible.contains(dest)) {
            c2.scrollRectToVisible(dest);
        }
    }

    public static enum ScrollBias {
        VIEWPORT,
        UNCHANGED,
        FIRST,
        CENTER,
        LAST;

    }
}

