/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.StyleSheetUtil;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.swing.UIManager;
import javax.swing.text.html.StyleSheet;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0004H\u0007J\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0012\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u0010H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/ui/StyleSheetUtil;", "", "()V", "NO_GAPS_BETWEEN_PARAGRAPHS_STYLE", "Ljavax/swing/text/html/StyleSheet;", "getNO_GAPS_BETWEEN_PARAGRAPHS_STYLE", "()Ljavax/swing/text/html/StyleSheet;", "NO_GAPS_BETWEEN_PARAGRAPHS_STYLE$delegate", "Lkotlin/Lazy;", "getDefaultStyleSheet", "loadStyleSheet", "input", "Ljava/io/InputStream;", "ref", "Ljava/net/URL;", "url", "", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nStyleSheetUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleSheetUtil.kt\ncom/intellij/util/ui/StyleSheetUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n8#2:76\n8#2:77\n*S KotlinDebug\n*F\n+ 1 StyleSheetUtil.kt\ncom/intellij/util/ui/StyleSheetUtil\n*L\n31#1:76\n71#1:77\n*E\n"})
public final class StyleSheetUtil {
    @NotNull
    public static final StyleSheetUtil INSTANCE = new StyleSheetUtil();
    @NotNull
    private static final Lazy NO_GAPS_BETWEEN_PARAGRAPHS_STYLE$delegate = LazyKt.lazy((Function0)NO_GAPS_BETWEEN_PARAGRAPHS_STYLE.2.INSTANCE);

    private StyleSheetUtil() {
    }

    @ApiStatus.Internal
    @NotNull
    public final StyleSheet getNO_GAPS_BETWEEN_PARAGRAPHS_STYLE() {
        Lazy lazy = NO_GAPS_BETWEEN_PARAGRAPHS_STYLE$delegate;
        return (StyleSheet)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final StyleSheet getDefaultStyleSheet() {
        StyleSheet globalStyleSheet;
        StyleSheet sheet = new StyleSheet();
        Object object = UIManager.getDefaults().get("HTMLEditorKit.jbStyleSheet");
        StyleSheet styleSheet = globalStyleSheet = object instanceof StyleSheet ? (StyleSheet)object : null;
        if (globalStyleSheet == null) {
            if (!GraphicsEnvironment.isHeadless()) {
                StyleSheetUtil $this$thisLogger$iv = INSTANCE;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(StyleSheetUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.warn("Missing global CSS sheet");
            }
            return sheet;
        }
        sheet.addStyleSheet(globalStyleSheet);
        return sheet;
    }

    @JvmStatic
    @NotNull
    public static final StyleSheet loadStyleSheet(@Language(value="CSS") @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.loadRules(new StringReader(input), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return styleSheet;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StyleSheet loadStyleSheet(@NotNull InputStream input, @Nullable URL ref) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StyleSheet result2 = new StyleSheet();
        result2.loadRules(new InputStreamReader(input, StandardCharsets.UTF_8), ref);
        return result2;
    }

    public static /* synthetic */ StyleSheet loadStyleSheet$default(InputStream inputStream, URL uRL, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            uRL = null;
        }
        return StyleSheetUtil.loadStyleSheet(inputStream, uRL);
    }

    @Deprecated(message="Use loadStyleSheet(InputStream)")
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public final StyleSheet loadStyleSheet(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            StyleSheet result2 = new StyleSheet();
            result2.loadRules(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8), url);
            return result2;
        }
        catch (IOException e) {
            StyleSheetUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(StyleSheetUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.warn(url + " loading failed", e);
            return null;
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StyleSheet loadStyleSheet(@NotNull InputStream input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return StyleSheetUtil.loadStyleSheet$default(input, null, 2, null);
    }
}

