/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.BundleBase;
import com.intellij.diagnostic.LoadingState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.TableUtil;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.FontUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.AppleBoldDottedPainter;
import com.intellij.util.ui.CenteredIcon;
import com.intellij.util.ui.DetectRetinaKit;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.IterablesConcat;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.SwingUndoUtil;
import com.intellij.util.ui.WavePainter;
import java.awt.AWTError;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellRendererPane;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import sun.font.FontUtilities;

public final class UIUtil {
    @NlsSafe
    public static final String BORDER_LINE = "<hr size=1 noshade>";
    @NlsSafe
    public static final String BR = "<br/>";
    @NlsSafe
    public static final String HR = "<hr/>";
    @NlsSafe
    public static final String LINE_SEPARATOR = "\n";
    public static final Key<Boolean> LAF_WITH_THEME_KEY = Key.create("Laf.with.ui.theme");
    public static final Key<String> PLUGGABLE_LAF_KEY = Key.create("Pluggable.laf.name");
    private static final Key<WeakReference<Component>> FOSTER_PARENT = Key.create("Component.fosterParent");
    private static final Key<Boolean> IS_SHOWING = Key.create("Component.isShowing");
    private static final Key<Boolean> HAS_FOCUS = Key.create("Component.hasFocus");
    @ApiStatus.Internal
    public static final String NO_BORDER_UNDER_WINDOW_TITLE_KEY = "";
    private static final NotNullLazyValue<Boolean> X_RENDER_ACTIVE = NotNullLazyValue.atomicLazy(() -> {
        if (!SystemInfoRt.isXWindow) {
            return false;
        }
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
            Method method2 = clazz.getMethod("isXRenderAvailable", new Class[0]);
            return (Boolean)method2.invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    });
    private static final String[] STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    public static final char MNEMONIC = '\u001b';
    @NlsSafe
    public static final String HTML_MIME = "text/html";
    @NonNls
    public static final String JSLIDER_ISFILLED = "JSlider.isFilled";
    @NonNls
    public static final String TABLE_FOCUS_CELL_BACKGROUND_PROPERTY = "Table.focusCellBackground";
    @NonNls
    public static final String HIDE_EDITOR_FROM_DATA_CONTEXT_PROPERTY = "AuxEditorComponent";
    @NonNls
    public static final String CENTER_TOOLTIP_DEFAULT = "ToCenterTooltip";
    @NonNls
    public static final String CENTER_TOOLTIP_STRICT = "ToCenterTooltip.default";
    private static final Pattern CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
    public static final Key<Integer> KEEP_BORDER_SIDES = Key.create("keepBorderSides");
    public static final Key<Boolean> TEXT_COPY_ROOT = Key.create("TEXT_COPY_ROOT");
    private static final Color ACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.active", 10533589);
    private static final Color INACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.inactive", Gray._128);
    public static final Color CONTRAST_BORDER_COLOR = JBColor.namedColor("Borders.ContrastBorderColor", new JBColor(0xC9C9C9, 0x323232));
    public static final Color SIDE_PANEL_BACKGROUND = JBColor.namedColor("SidePanel.background", new JBColor(15133680, 4080460));
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, (Color)Gray.x51);
    public static final Color TRANSPARENT_COLOR = Gray.TRANSPARENT;
    public static final int DEFAULT_HGAP = 10;
    public static final int DEFAULT_VGAP = 4;
    public static final int LARGE_VGAP = 12;
    private static final int REGULAR_PANEL_TOP_BOTTOM_INSET = 8;
    private static final int REGULAR_PANEL_LEFT_RIGHT_INSET = 12;
    public static final Insets PANEL_REGULAR_INSETS = UIUtil.getRegularPanelInsets();
    public static final Insets PANEL_SMALL_INSETS = JBInsets.create(5, 8);
    @NonNls
    private static final String ROOT_PANE = "JRootPane.future";
    private static final Ref<Boolean> ourRetina = Ref.create(SystemInfoRt.isMac ? null : Boolean.valueOf(false));
    public static final int LIST_FIXED_CELL_HEIGHT = 20;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
    private static final JBTreeTraverser<Component> UI_TRAVERSER = JBTreeTraverser.from(c2 -> {
        JBIterable<Object> result2 = c2 instanceof JMenu ? JBIterable.of(((JMenu)c2).getMenuComponents()) : UIUtil.uiChildren(c2);
        if (c2 instanceof JComponent) {
            JPopupMenu jpm;
            JComponent jc = (JComponent)c2;
            Iterable<? extends Component> orphans = ClientProperty.get((Component)jc, NOT_IN_HIERARCHY_COMPONENTS);
            if (orphans != null) {
                result2 = result2.append(orphans);
            }
            if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                result2 = result2.append(Collections.singletonList(jpm));
            }
        }
        return result2;
    });
    private static final Color DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
    public static final String CHECKBOX_ROLLOVER_PROPERTY = "JCheckBox.rollOver.rectangle";
    public static final String CHECKBOX_PRESSED_PROPERTY = "JCheckBox.pressed.rectangle";

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(UIUtil.class);
        if (logger == null) {
            UIUtil.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void decorateWindowHeader(JRootPane pane) {
        if (pane != null && SystemInfoRt.isMac) {
            pane.putClientProperty("apple.awt.windowAppearance", UIUtil.isUnderDarcula() ? "NSAppearanceNameVibrantDark" : "NSAppearanceNameVibrantLight");
        }
    }

    public static int getTransparentTitleBarHeight(JRootPane rootPane) {
        Object property = rootPane.getClientProperty("Window.transparentTitleBarHeight");
        if (property instanceof Integer) {
            return (Integer)property;
        }
        if ("small".equals(rootPane.getClientProperty("Window.style"))) {
            return JBUI.getInt("macOSWindow.Title.heightSmall", 19);
        }
        return JBUI.getInt("macOSWindow.Title.height", SystemInfo.isMacOSBigSur ? 29 : 23);
    }

    public static void markAsPossibleOwner(Dialog dialog) {
        ClientProperty.put((Window)dialog, "PossibleOwner", Boolean.TRUE);
    }

    public static boolean isPossibleOwner(@NotNull Dialog dialog) {
        if (dialog == null) {
            UIUtil.$$$reportNull$$$0(1);
        }
        return ClientProperty.isTrue(dialog, "PossibleOwner");
    }

    public static int getMultiClickInterval() {
        Object property = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (property instanceof Integer) {
            return (Integer)property;
        }
        return 500;
    }

    public static void applyStyle(@NotNull ComponentStyle componentStyle, @NotNull Component comp) {
        if (componentStyle == null) {
            UIUtil.$$$reportNull$$$0(2);
        }
        if (comp == null) {
            UIUtil.$$$reportNull$$$0(3);
        }
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c2 = (JComponent)comp;
        if (UIUtil.isUnderAquaBasedLookAndFeel()) {
            c2.putClientProperty("JComponent.sizeVariant", StringUtil.toLowerCase(componentStyle.name()));
        }
        FontSize fontSize = componentStyle == ComponentStyle.MINI ? FontSize.MINI : (componentStyle == ComponentStyle.SMALL ? FontSize.SMALL : FontSize.NORMAL);
        c2.setFont(UIUtil.getFont(fontSize, c2.getFont()));
        Container p = c2.getParent();
        if (p != null) {
            SwingUtilities.updateComponentTreeUI(p);
        }
    }

    @Nullable
    public static Cursor cursorIfNotDefault(@Nullable Cursor cursorToSet) {
        return cursorToSet != null && cursorToSet.getType() != 0 ? cursorToSet : null;
    }

    @NotNull
    public static RGBImageFilter getGrayFilter() {
        GrayFilter grayFilter = GrayFilter.namedFilter("grayFilter", new GrayFilter(33, -35, 100));
        if (grayFilter == null) {
            UIUtil.$$$reportNull$$$0(4);
        }
        return grayFilter;
    }

    @NotNull
    public static RGBImageFilter getTextGrayFilter() {
        GrayFilter grayFilter = GrayFilter.namedFilter("text.grayFilter", new GrayFilter(20, 0, 100));
        if (grayFilter == null) {
            UIUtil.$$$reportNull$$$0(5);
        }
        return grayFilter;
    }

    @NotNull
    public static Couple<Color> getCellColors(@NotNull JTable table, boolean isSel, int row, int column) {
        if (table == null) {
            UIUtil.$$$reportNull$$$0(6);
        }
        Couple<Color> couple = Couple.of(isSel ? table.getSelectionForeground() : table.getForeground(), isSel ? table.getSelectionBackground() : table.getBackground());
        if (couple == null) {
            UIUtil.$$$reportNull$$$0(7);
        }
        return couple;
    }

    public static void fixOSXEditorBackground(@NotNull JTable table) {
        if (table == null) {
            UIUtil.$$$reportNull$$$0(8);
        }
        if (!SystemInfoRt.isMac) {
            return;
        }
        if (table.isEditing()) {
            int column = table.getEditingColumn();
            int row = table.getEditingRow();
            Component renderer = column >= 0 && row >= 0 ? table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), true, table.hasFocus(), row, column) : null;
            Component component2 = table.getEditorComponent();
            if (component2 != null && renderer != null) {
                UIUtil.changeBackGround(component2, renderer.getBackground());
            }
        }
    }

    private UIUtil() {
    }

    public static boolean isRetina(@NotNull Graphics2D graphics) {
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(9);
        }
        return SystemInfoRt.isMac ? DetectRetinaKit.isMacRetina(graphics) : UIUtil.isRetina();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("is.hidpi"))) {
            return true;
        }
        if (Registry.is("new.retina.detection", false)) {
            return DetectRetinaKit.isRetina();
        }
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set(false);
                try {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    Integer scale = ReflectionUtil.getField(device.getClass(), device, Integer.TYPE, "scale");
                    if (scale != null && scale == 2) {
                        ourRetina.set(true);
                        return true;
                    }
                }
                catch (AWTError | Exception throwable) {
                    // empty catch block
                }
                ourRetina.set(false);
            }
            return ourRetina.get();
        }
    }

    @Deprecated(forRemoval=true)
    public static Object getWindowClientProperty(Window window, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(10);
        }
        return ClientProperty.get((Component)window, key);
    }

    @Deprecated(forRemoval=true)
    public static void putWindowClientProperty(Window window, @NotNull Object key, Object value) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(11);
        }
        ClientProperty.put(window, key, value);
    }

    @Deprecated
    public static boolean isClientPropertyTrue(Object component2, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(12);
        }
        return component2 instanceof Component && ClientProperty.isTrue((Component)component2, key);
    }

    @Deprecated
    public static Object getClientProperty(Object component2, @NotNull @NonNls Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(13);
        }
        return component2 instanceof Component ? ClientProperty.get((Component)component2, key) : null;
    }

    public static <T> T getClientProperty(Component component2, @NotNull Class<T> type) {
        Object obj;
        if (type == null) {
            UIUtil.$$$reportNull$$$0(14);
        }
        return type.isInstance(obj = ClientProperty.get(component2, type)) ? (T)type.cast(obj) : null;
    }

    @Deprecated
    public static <T> T getClientProperty(Object component2, @NotNull Key<T> key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(15);
        }
        return component2 instanceof Component ? (T)ClientProperty.get((Component)component2, key) : null;
    }

    @Deprecated
    public static <T> void putClientProperty(@NotNull JComponent component2, @NotNull Key<T> key, T value) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(16);
        }
        if (key == null) {
            UIUtil.$$$reportNull$$$0(17);
        }
        component2.putClientProperty(key, value);
    }

    @Contract(pure=true)
    @NotNull
    public static String getHtmlBody(@NotNull String text2) {
        int bodyIndex;
        int htmlIndex;
        if (text2 == null) {
            UIUtil.$$$reportNull$$$0(18);
        }
        if ((htmlIndex = 6 + text2.indexOf("<html>")) < 6) {
            String string2 = text2.replaceAll(LINE_SEPARATOR, "<br>");
            if (string2 == null) {
                UIUtil.$$$reportNull$$$0(19);
            }
            return string2;
        }
        int htmlCloseIndex = text2.indexOf("</html>", htmlIndex);
        if (htmlCloseIndex < 0) {
            htmlCloseIndex = text2.length();
        }
        if ((bodyIndex = 6 + text2.indexOf("<body>", htmlIndex)) < 6) {
            String string3 = text2.substring(htmlIndex, htmlCloseIndex);
            if (string3 == null) {
                UIUtil.$$$reportNull$$$0(20);
            }
            return string3;
        }
        int bodyCloseIndex = text2.indexOf("</body>", bodyIndex);
        if (bodyCloseIndex < 0) {
            bodyCloseIndex = text2.length();
        }
        String string4 = text2.substring(bodyIndex, Math.min(bodyCloseIndex, htmlCloseIndex));
        if (string4 == null) {
            UIUtil.$$$reportNull$$$0(21);
        }
        return string4;
    }

    @NotNull
    @Nls
    public static String getHtmlBody(@NotNull Html html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(22);
        }
        String result2 = UIUtil.getHtmlBody(html.getText());
        String string2 = html.isKeepFont() ? result2 : result2.replaceAll("<font(.*?)>", NO_BORDER_UNDER_WINDOW_TITLE_KEY).replaceAll("</font>", NO_BORDER_UNDER_WINDOW_TITLE_KEY);
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(23);
        }
        return string2;
    }

    public static void drawLinePickedOut(@NotNull Graphics graphics, int x, int y, int x1, int y1) {
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(24);
        }
        if (x == x1) {
            int minY = Math.min(y, y1);
            int maxY = Math.max(y, y1);
            LinePainter2D.paint((Graphics2D)graphics, x, minY + 1, (double)x1, maxY - 1);
        } else if (y == y1) {
            int minX = Math.min(x, x1);
            int maxX = Math.max(x, x1);
            LinePainter2D.paint((Graphics2D)graphics, minX + 1, y, (double)(maxX - 1), y1);
        } else {
            LinePainter2D.paint((Graphics2D)graphics, x, y, (double)x1, y1);
        }
    }

    public static boolean isReallyTypedEvent(@NotNull KeyEvent e) {
        char c2;
        if (e == null) {
            UIUtil.$$$reportNull$$$0(25);
        }
        if ((c2 = e.getKeyChar()) == '\uffff') {
            return false;
        }
        if (c2 < ' ' || c2 == '\u007f') {
            return false;
        }
        if (SystemInfoRt.isWindows && c2 >= '\u200c' && c2 <= '\u200f') {
            return true;
        }
        if (SystemInfoRt.isMac) {
            return !e.isMetaDown() && !e.isControlDown();
        }
        return !e.isAltDown() && !e.isControlDown();
    }

    public static int getStringY(@NotNull String string2, @NotNull Rectangle bounds, @NotNull Graphics2D g) {
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(26);
        }
        if (bounds == null) {
            UIUtil.$$$reportNull$$$0(27);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(28);
        }
        int centerY = bounds.height / 2;
        Font font = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle stringBounds = font.getStringBounds(string2.isEmpty() ? " " : string2, frc).getBounds();
        return (int)((double)centerY - (double)stringBounds.height / 2.0 - (double)stringBounds.y);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label2, @NotNull Graphics g) {
        if (label2 == null) {
            UIUtil.$$$reportNull$$$0(29);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(30);
        }
        UIUtil.drawLabelDottedRectangle(label2, g, null);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label2, @NotNull Graphics g, @Nullable Rectangle bounds) {
        if (label2 == null) {
            UIUtil.$$$reportNull$$$0(31);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(32);
        }
        if (bounds == null) {
            bounds = UIUtil.getLabelTextBounds(label2);
        }
        FontMetrics fm = label2.getFontMetrics(label2.getFont());
        int baseLine = label2.getUI().getBaseline(label2, label2.getWidth(), label2.getHeight());
        int textY = baseLine - fm.getLeading() - fm.getAscent();
        int textHeight = fm.getHeight();
        UIUtil.drawDottedRectangle(g, bounds.x, textY, bounds.x + bounds.width - 1, textY + textHeight - 1);
    }

    @NotNull
    public static Rectangle getLabelTextBounds(@NotNull JLabel label2) {
        if (label2 == null) {
            UIUtil.$$$reportNull$$$0(33);
        }
        Dimension size = label2.getPreferredSize();
        Icon icon2 = label2.getIcon();
        Point point = new Point(0, 0);
        Insets insets = label2.getInsets();
        if (icon2 != null) {
            if (label2.getHorizontalTextPosition() == 11) {
                point.x += label2.getIconTextGap();
                point.x += icon2.getIconWidth();
            } else if (label2.getHorizontalTextPosition() == 10) {
                size.width -= icon2.getIconWidth();
            }
        }
        point.x += insets.left;
        point.y += insets.top;
        size.width -= point.x;
        size.width -= insets.right;
        size.height -= insets.bottom;
        return new Rectangle(point, size);
    }

    public static int getHighestGlyphHeight(@NotNull String string2, @NotNull Font font, @NotNull Graphics graphics) {
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(34);
        }
        if (font == null) {
            UIUtil.$$$reportNull$$$0(35);
        }
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(36);
        }
        FontRenderContext frc = ((Graphics2D)graphics).getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, string2);
        int maxHeight = 0;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            maxHeight = Math.max(maxHeight, (int)gv.getGlyphMetrics(i2).getBounds2D().getHeight());
        }
        return maxHeight;
    }

    public static void setEnabled(@NotNull Component component2, boolean enabled, boolean recursively) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(37);
        }
        UIUtil.setEnabled(component2, enabled, recursively, false);
    }

    public static void setEnabled(@NotNull Component component2, boolean enabled, boolean recursively, boolean visibleOnly) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(38);
        }
        JBIterable<Component> all = recursively ? ((JBTreeTraverser)UIUtil.uiTraverser(component2).expandAndFilter(visibleOnly ? Component::isVisible : Conditions.alwaysTrue())).traverse() : JBIterable.of(component2);
        Color fg = enabled ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        for (Component c2 : all) {
            c2.setEnabled(enabled);
            if (!(c2 instanceof JLabel)) continue;
            c2.setForeground(fg);
        }
    }

    public static void drawLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, @Nullable Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(39);
        }
        Color oldFg = g.getColor();
        Color oldBg = g.getBackground();
        if (fgColor != null) {
            g.setColor(fgColor);
        }
        if (bgColor != null) {
            g.setBackground(bgColor);
        }
        LinePainter2D.paint(g, x1, y1, (double)x2, y2);
        if (fgColor != null) {
            g.setColor(oldFg);
        }
        if (bgColor != null) {
            g.setBackground(oldBg);
        }
    }

    public static void drawWave(@NotNull Graphics2D g, @NotNull Rectangle rectangle) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(40);
        }
        if (rectangle == null) {
            UIUtil.$$$reportNull$$$0(41);
        }
        WavePainter.forColor(g.getColor()).paint(g, (int)rectangle.getMinX(), (int)rectangle.getMaxX(), (int)rectangle.getMaxY());
    }

    public static String @NotNull [] splitText(@NotNull String text2, @NotNull FontMetrics fontMetrics, int widthLimit, char separator) {
        if (text2 == null) {
            UIUtil.$$$reportNull$$$0(42);
        }
        if (fontMetrics == null) {
            UIUtil.$$$reportNull$$$0(43);
        }
        ArrayList<String> lines2 = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        StringBuilder currentAtom = new StringBuilder();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            String s;
            int width;
            char ch = text2.charAt(i2);
            currentAtom.append(ch);
            if (ch == separator) {
                currentLine.append((CharSequence)currentAtom);
                currentAtom.setLength(0);
            }
            if ((width = fontMetrics.stringWidth(s = currentLine.toString() + currentAtom)) < widthLimit - fontMetrics.charWidth('w')) continue;
            if (currentLine.length() > 0) {
                lines2.add(currentLine.toString());
                currentLine = new StringBuilder();
                continue;
            }
            lines2.add(currentAtom.toString());
            currentAtom.setLength(0);
        }
        String s = currentLine.toString() + currentAtom;
        if (!s.isEmpty()) {
            lines2.add(s);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(lines2);
        if (stringArray == null) {
            UIUtil.$$$reportNull$$$0(44);
        }
        return stringArray;
    }

    public static void setActionNameAndMnemonic(@NotNull @Nls String text2, @NotNull Action action2) {
        if (text2 == null) {
            UIUtil.$$$reportNull$$$0(45);
        }
        if (action2 == null) {
            UIUtil.$$$reportNull$$$0(46);
        }
        UIUtil.assignMnemonic(text2, action2);
        text2 = text2.replaceAll("&", NO_BORDER_UNDER_WINDOW_TITLE_KEY);
        action2.putValue("Name", text2);
    }

    public static void assignMnemonic(@NotNull @Nls String text2, @NotNull Action action2) {
        String mnemoChar;
        int mnemoPos;
        if (text2 == null) {
            UIUtil.$$$reportNull$$$0(47);
        }
        if (action2 == null) {
            UIUtil.$$$reportNull$$$0(48);
        }
        if ((mnemoPos = text2.indexOf(38)) >= 0 && mnemoPos < text2.length() - 2 && (mnemoChar = text2.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action2.putValue("MnemonicKey", mnemoChar.charAt(0));
        }
    }

    @NotNull
    public static Font getLabelFont(@NotNull FontSize size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(49);
        }
        return UIUtil.getFont(size, null);
    }

    @NotNull
    public static Font getFont(@NotNull FontSize size, @Nullable Font base) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(50);
        }
        if (base == null) {
            base = StartupUiUtil.getLabelFont();
        }
        JBFont jBFont = JBFont.create(base).deriveFont(UIUtil.getFontSize(size));
        if (jBFont == null) {
            UIUtil.$$$reportNull$$$0(51);
        }
        return jBFont;
    }

    public static float getFontSize(@NotNull FontSize size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(52);
        }
        int defSize = StartupUiUtil.getLabelFont().getSize();
        return switch (size) {
            case FontSize.SMALL -> Math.max((float)defSize - JBUIScale.scale(2.0f), JBUIScale.scale(11.0f));
            case FontSize.MINI -> Math.max((float)defSize - JBUIScale.scale(4.0f), JBUIScale.scale(9.0f));
            default -> defSize;
        };
    }

    @NotNull
    public static Color getLabelFontColor(@NotNull FontColor fontColor) {
        if (fontColor == null) {
            UIUtil.$$$reportNull$$$0(53);
        }
        Color defColor = UIUtil.getLabelForeground();
        if (fontColor == FontColor.BRIGHTER) {
            return new JBColor(new Color(Math.min(defColor.getRed() + 50, 255), Math.min(defColor.getGreen() + 50, 255), Math.min(defColor.getBlue() + 50, 255)), defColor.darker());
        }
        Color color = defColor;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(54);
        }
        return color;
    }

    public static int getCheckBoxTextHorizontalOffset(@NotNull JCheckBox cb2) {
        if (cb2 == null) {
            UIUtil.$$$reportNull$$$0(55);
        }
        ButtonUI ui = cb2.getUI();
        Icon buttonIcon = cb2.getIcon();
        if (buttonIcon == null && ui != null && ui instanceof BasicRadioButtonUI) {
            buttonIcon = ((BasicRadioButtonUI)ui).getDefaultIcon();
        }
        return UIUtil.getButtonTextHorizontalOffset(cb2, cb2.getSize(new Dimension()), buttonIcon);
    }

    public static int getButtonTextHorizontalOffset(@NotNull AbstractButton button2, @NotNull Dimension size, @Nullable Icon buttonIcon) {
        if (button2 == null) {
            UIUtil.$$$reportNull$$$0(56);
        }
        if (size == null) {
            UIUtil.$$$reportNull$$$0(57);
        }
        String text2 = button2.getText();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i2 = button2.getInsets();
        viewRect.y = i2.top;
        viewRect.width = size.width - (i2.right + viewRect.x);
        viewRect.height = size.height - (i2.bottom + viewRect.y);
        SwingUtilities.layoutCompoundLabel(button2, button2.getFontMetrics(button2.getFont()), text2, buttonIcon, button2.getVerticalAlignment(), button2.getHorizontalAlignment(), button2.getVerticalTextPosition(), button2.getHorizontalTextPosition(), viewRect, iconRect, textRect, text2 == null ? 0 : button2.getIconTextGap());
        return textRect.x;
    }

    public static int getScrollBarWidth() {
        return UIManager.getInt("ScrollBar.width");
    }

    public static Color getLabelBackground() {
        return UIManager.getColor("Label.background");
    }

    @NotNull
    public static Color getLabelForeground() {
        JBColor jBColor = JBColor.namedColor("Label.foreground", new JBColor(Gray._0, (Color)Gray.xBB));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(58);
        }
        return jBColor;
    }

    @NotNull
    public static Color getLabelSuccessForeground() {
        JBColor jBColor = JBColor.namedColor("Label.successForeground", 3573574, 5285473);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(59);
        }
        return jBColor;
    }

    @NotNull
    public static Color getErrorForeground() {
        Color color = NamedColorUtil.getErrorForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(60);
        }
        return color;
    }

    @NotNull
    public static Color getLabelDisabledForeground() {
        JBColor jBColor = JBColor.namedColor("Label.disabledForeground", JBColor.GRAY);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(61);
        }
        return jBColor;
    }

    @NotNull
    public static Color getLabelInfoForeground() {
        JBColor jBColor = JBColor.namedColor("Label.infoForeground", new JBColor(Gray._120, (Color)Gray._135));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(62);
        }
        return jBColor;
    }

    @NotNull
    public static Color getContextHelpForeground() {
        Color color = JBUI.CurrentTheme.ContextHelp.FOREGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(63);
        }
        return color;
    }

    @Nls
    @NotNull
    public static String removeMnemonic(@Nls @NotNull String s) {
        if (s == null) {
            UIUtil.$$$reportNull$$$0(64);
        }
        String string2 = TextWithMnemonic.parse(s).getText();
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(65);
        }
        return string2;
    }

    public static int getDisplayMnemonicIndex(@NotNull String s) {
        int idx;
        if (s == null) {
            UIUtil.$$$reportNull$$$0(66);
        }
        if ((idx = s.indexOf(38)) >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(38)) {
            return idx;
        }
        idx = s.indexOf(27);
        if (idx >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(27)) {
            return idx;
        }
        return -1;
    }

    @Nls
    public static String replaceMnemonicAmpersand(@Nls String value) {
        return BundleBase.replaceMnemonicAmpersand(value);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color getTreeTextForeground() {
        return UIUtil.getTreeForeground();
    }

    @Deprecated
    @NotNull
    public static Color getTreeTextBackground() {
        return UIUtil.getTreeBackground();
    }

    public static Color getFieldForegroundColor() {
        return UIManager.getColor("field.foreground");
    }

    public static Color getActiveTextColor() {
        return UIManager.getColor("textActiveText");
    }

    @NotNull
    public static Color getInactiveTextColor() {
        Color color = NamedColorUtil.getInactiveTextColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(67);
        }
        return color;
    }

    public static Color getInactiveTextFieldBackgroundColor() {
        return UIManager.getColor("TextField.inactiveBackground");
    }

    public static Color getTreeSelectionBorderColor() {
        return UIManager.getColor("Tree.selectionBorderColor");
    }

    public static int getTreeRightChildIndent() {
        return UIManager.getInt("Tree.rightChildIndent");
    }

    public static int getTreeLeftChildIndent() {
        return UIManager.getInt("Tree.leftChildIndent");
    }

    @NotNull
    public static Color getToolTipBackground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.background", new JBColor(Gray.xF2, new Color(3948353)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(68);
        }
        return jBColor;
    }

    @NotNull
    public static Color getToolTipActionBackground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.Actions.background", new JBColor(Gray.xEB, new Color(4409162)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(69);
        }
        return jBColor;
    }

    @NotNull
    public static Color getToolTipForeground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.foreground", new JBColor(Gray.x00, (Color)Gray.xBF));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(70);
        }
        return jBColor;
    }

    public static Color getComboBoxDisabledForeground() {
        return UIManager.getColor("ComboBox.disabledForeground");
    }

    public static Color getComboBoxDisabledBackground() {
        return UIManager.getColor("ComboBox.disabledBackground");
    }

    public static Color getButtonSelectColor() {
        return UIManager.getColor("Button.select");
    }

    public static Integer getPropertyMaxGutterIconWidth(@NotNull String propertyPrefix) {
        if (propertyPrefix == null) {
            UIUtil.$$$reportNull$$$0(71);
        }
        return (Integer)UIManager.get(propertyPrefix + ".maxGutterIconWidth");
    }

    public static Color getMenuItemDisabledForeground() {
        return UIManager.getColor("MenuItem.disabledForeground");
    }

    public static Object getMenuItemDisabledForegroundObject() {
        return UIManager.get("MenuItem.disabledForeground");
    }

    public static Object getTabbedPanePaintContentBorder(@NotNull JComponent c2) {
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(72);
        }
        return c2.getClientProperty("TabbedPane.paintContentBorder");
    }

    public static Color getTableGridColor() {
        return UIManager.getColor("Table.gridColor");
    }

    @NotNull
    public static Color getPanelBackground() {
        Color color = JBColor.PanelBackground;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(73);
        }
        return color;
    }

    public static Color getEditorPaneBackground() {
        return UIManager.getColor("EditorPane.background");
    }

    public static Color getTableFocusCellBackground() {
        return UIManager.getColor(TABLE_FOCUS_CELL_BACKGROUND_PROPERTY);
    }

    public static Color getTextFieldForeground() {
        return UIManager.getColor("TextField.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor("TextField.background");
    }

    public static Color getTextFieldDisabledBackground() {
        return UIManager.getColor("TextField.disabledBackground");
    }

    public static Font getButtonFont() {
        return UIManager.getFont("Button.font");
    }

    public static Font getToolTipFont() {
        return UIManager.getFont("ToolTip.font");
    }

    public static void setSliderIsFilled(@NotNull JSlider slider, boolean value) {
        if (slider == null) {
            UIUtil.$$$reportNull$$$0(74);
        }
        slider.putClientProperty(JSLIDER_ISFILLED, value);
    }

    public static Color getLabelTextForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Font getOptionPaneMessageFont() {
        return UIManager.getFont("OptionPane.messageFont");
    }

    public static Font getMenuFont() {
        return UIManager.getFont("Menu.font");
    }

    public static Color getSeparatorShadow() {
        return UIManager.getColor("Separator.shadow");
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color getSeparatorColor() {
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(75);
        }
        return color;
    }

    public static Border getTableFocusCellHighlightBorder() {
        return UIManager.getBorder("Table.focusCellHighlightBorder");
    }

    @Deprecated
    public static void setLineStyleAngled(@NotNull JTree component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(76);
        }
    }

    public static Color getTableFocusCellForeground() {
        return UIManager.getColor("Table.focusCellForeground");
    }

    public static Border getTextFieldBorder() {
        return UIManager.getBorder("TextField.border");
    }

    @NotNull
    public static Icon getErrorIcon() {
        Icon icon2 = Objects.requireNonNullElse(UIManager.getIcon("OptionPane.errorIcon"), AllIcons.General.ErrorDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(77);
        }
        return icon2;
    }

    @NotNull
    public static Icon getInformationIcon() {
        Icon icon2 = Objects.requireNonNullElse(UIManager.getIcon("OptionPane.informationIcon"), AllIcons.General.InformationDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(78);
        }
        return icon2;
    }

    @NotNull
    public static Icon getQuestionIcon() {
        Icon icon2 = Objects.requireNonNullElse(UIManager.getIcon("OptionPane.questionIcon"), AllIcons.General.QuestionDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(79);
        }
        return icon2;
    }

    @NotNull
    public static Icon getWarningIcon() {
        Icon icon2 = Objects.requireNonNullElse(UIManager.getIcon("OptionPane.warningIcon"), AllIcons.General.WarningDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(80);
        }
        return icon2;
    }

    @NotNull
    public static Icon getBalloonInformationIcon() {
        Icon icon2 = AllIcons.General.BalloonInformation;
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(81);
        }
        return icon2;
    }

    @NotNull
    public static Icon getBalloonWarningIcon() {
        Icon icon2 = AllIcons.General.BalloonWarning;
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(82);
        }
        return icon2;
    }

    @NotNull
    public static Icon getBalloonErrorIcon() {
        Icon icon2 = AllIcons.General.BalloonError;
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(83);
        }
        return icon2;
    }

    @NotNull
    public static Icon getTreeNodeIcon(boolean expanded, boolean selected, boolean focused) {
        boolean white = selected && focused || StartupUiUtil.isUnderDarcula();
        Icon expandedDefault = UIUtil.getTreeExpandedIcon();
        Icon collapsedDefault = UIUtil.getTreeCollapsedIcon();
        Icon expandedSelected = UIUtil.getTreeSelectedExpandedIcon();
        Icon collapsedSelected = UIUtil.getTreeSelectedCollapsedIcon();
        int width = Math.max(Math.max(expandedDefault.getIconWidth(), collapsedDefault.getIconWidth()), Math.max(expandedSelected.getIconWidth(), collapsedSelected.getIconWidth()));
        int height = Math.max(Math.max(expandedDefault.getIconHeight(), collapsedDefault.getIconHeight()), Math.max(expandedSelected.getIconHeight(), collapsedSelected.getIconHeight()));
        return new CenteredIcon(!white ? (expanded ? expandedDefault : collapsedDefault) : (expanded ? expandedSelected : collapsedSelected), width, height, false);
    }

    @NotNull
    public static Icon getTreeCollapsedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.collapsedIcon");
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(84);
        }
        return icon2;
    }

    @NotNull
    public static Icon getTreeExpandedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.expandedIcon");
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(85);
        }
        return icon2;
    }

    @NotNull
    public static Icon getTreeSelectedCollapsedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.collapsedSelectedIcon");
        Icon icon3 = icon2 == null ? UIUtil.getTreeCollapsedIcon() : icon2;
        if (icon3 == null) {
            UIUtil.$$$reportNull$$$0(86);
        }
        return icon3;
    }

    @NotNull
    public static Icon getTreeSelectedExpandedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.expandedSelectedIcon");
        Icon icon3 = icon2 == null ? UIUtil.getTreeExpandedIcon() : icon2;
        if (icon3 == null) {
            UIUtil.$$$reportNull$$$0(87);
        }
        return icon3;
    }

    public static Color getWindowColor() {
        return UIManager.getColor("window");
    }

    public static Color getTextAreaForeground() {
        return UIManager.getColor("TextArea.foreground");
    }

    public static Color getOptionPaneBackground() {
        return UIManager.getColor("OptionPane.background");
    }

    @Deprecated(forRemoval=true)
    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfoRt.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    @Deprecated(forRemoval=true)
    public static boolean isUnderNimbusLookAndFeel() {
        return false;
    }

    public static boolean isUnderAquaBasedLookAndFeel() {
        return SystemInfoRt.isMac && (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
    }

    public static boolean isUnderDefaultMacTheme() {
        if (!SystemInfoRt.isMac) {
            return false;
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof UserDataHolder) {
            UserDataHolder dh = (UserDataHolder)((Object)lookAndFeel);
            return Boolean.TRUE != dh.getUserData(LAF_WITH_THEME_KEY) && Objects.equals(dh.getUserData(PLUGGABLE_LAF_KEY), "macOS Light");
        }
        return false;
    }

    public static boolean isUnderWin10LookAndFeel() {
        if (!SystemInfoRt.isWindows) {
            return false;
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof UserDataHolder) {
            UserDataHolder dataHolder = (UserDataHolder)((Object)lookAndFeel);
            return Boolean.TRUE != dataHolder.getUserData(LAF_WITH_THEME_KEY) && Objects.equals(dataHolder.getUserData(PLUGGABLE_LAF_KEY), "Windows 10 Light");
        }
        return false;
    }

    public static boolean isUnderDarcula() {
        return StartupUiUtil.isUnderDarcula();
    }

    public static boolean isUnderIntelliJLaF() {
        return UIManager.getLookAndFeel().getName().contains("IntelliJ") || UIUtil.isUnderDefaultMacTheme() || UIUtil.isUnderWin10LookAndFeel();
    }

    @Deprecated(forRemoval=true)
    public static boolean isUnderGTKLookAndFeel() {
        return SystemInfoRt.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static boolean isGraphite() {
        if (!SystemInfoRt.isMac) {
            return false;
        }
        try {
            return Foundation.invoke("NSColor", "currentControlTint", new Object[0]).intValue() == 6;
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static Font getToolbarFont() {
        Font font = SystemInfoRt.isMac ? UIUtil.getLabelFont(FontSize.SMALL) : StartupUiUtil.getLabelFont();
        if (font == null) {
            UIUtil.$$$reportNull$$$0(88);
        }
        return font;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Color shade(@NotNull Color c2, double factor, double d) {
        void alphaFactor;
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(89);
        }
        assert (factor >= 0.0) : factor;
        return new Color(Math.min((int)Math.round((double)c2.getRed() * factor), 255), Math.min((int)Math.round((double)c2.getGreen() * factor), 255), Math.min((int)Math.round((double)c2.getBlue() * factor), 255), Math.min((int)Math.round((double)c2.getAlpha() * alphaFactor), 255));
    }

    @NotNull
    public static Color mix(@NotNull Color c1, Color c2, double factor) {
        if (c1 == null) {
            UIUtil.$$$reportNull$$$0(90);
        }
        assert (0.0 <= factor && factor <= 1.0) : factor;
        double backFactor = 1.0 - factor;
        return new Color(Math.min((int)Math.round((double)c1.getRed() * backFactor + (double)c2.getRed() * factor), 255), Math.min((int)Math.round((double)c1.getGreen() * backFactor + (double)c2.getGreen() * factor), 255), Math.min((int)Math.round((double)c1.getBlue() * backFactor + (double)c2.getBlue() * factor), 255));
    }

    public static boolean isFullRowSelectionLAF() {
        return false;
    }

    public static boolean isUnderNativeMacLookAndFeel() {
        return StartupUiUtil.isUnderDarcula();
    }

    public static int getListCellHPadding() {
        return UIUtil.isUnderDefaultMacTheme() ? 8 : (UIUtil.isUnderWin10LookAndFeel() ? 2 : 7);
    }

    public static int getListCellVPadding() {
        return 1;
    }

    @NotNull
    public static JBInsets getRegularPanelInsets() {
        JBInsets jBInsets = JBInsets.create(8, 12);
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(91);
        }
        return jBInsets;
    }

    @NotNull
    public static Insets getListCellPadding() {
        JBInsets jBInsets = JBInsets.create(UIUtil.getListCellVPadding(), UIUtil.getListCellHPadding());
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(92);
        }
        return jBInsets;
    }

    @NotNull
    public static Insets getListViewportPadding() {
        return UIUtil.getListViewportPadding(false);
    }

    @NotNull
    public static Insets getListViewportPadding(boolean listWithAdvertiser) {
        JBInsets jBInsets = listWithAdvertiser ? new JBInsets(4, 0, 8, 0) : JBInsets.create(4, 0);
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(93);
        }
        return jBInsets;
    }

    public static boolean isToUseDottedCellBorder() {
        return !UIUtil.isUnderNativeMacLookAndFeel();
    }

    public static boolean isControlKeyDown(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            UIUtil.$$$reportNull$$$0(94);
        }
        return SystemInfoRt.isMac ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
    }

    public static String @NotNull [] getValidFontNames(boolean familyName) {
        TreeSet<String> result2 = new TreeSet<String>();
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            try {
                if (!FontUtil.isValidFont(font)) continue;
                result2.add(familyName ? font.getFamily() : font.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Font labelFont = StartupUiUtil.getLabelFont();
        if (labelFont != null && FontUtil.isValidFont(labelFont)) {
            result2.add(familyName ? labelFont.getFamily() : labelFont.getName());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            UIUtil.$$$reportNull$$$0(95);
        }
        return stringArray;
    }

    public static String @NotNull [] getStandardFontSizes() {
        if (STANDARD_FONT_SIZES == null) {
            UIUtil.$$$reportNull$$$0(96);
        }
        return STANDARD_FONT_SIZES;
    }

    public static void setupEnclosingDialogBounds(@NotNull JComponent component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(97);
        }
        component2.revalidate();
        component2.repaint();
        Window window = SwingUtilities.windowForComponent(component2);
        if (window != null && (window.getSize().height < window.getMinimumSize().height || window.getSize().width < window.getMinimumSize().width)) {
            window.pack();
        }
    }

    @NotNull
    public static String displayPropertiesToCSS(Font font, Color fg) {
        @NonNls StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            UIUtil.appendColor(fg, rule);
            rule.append(" ; ");
        }
        rule.append(" }");
        String string2 = rule.toString();
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(98);
        }
        return string2;
    }

    public static void appendColor(@NotNull Color color, @NotNull StringBuilder sb) {
        if (color == null) {
            UIUtil.$$$reportNull$$$0(99);
        }
        if (sb == null) {
            UIUtil.$$$reportNull$$$0(100);
        }
        if (color.getRed() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getBlue()));
    }

    public static void drawDottedRectangle(@NotNull Graphics g, @NotNull Rectangle r) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(101);
        }
        if (r == null) {
            UIUtil.$$$reportNull$$$0(102);
        }
        UIUtil.drawDottedRectangle(g, r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public static void drawDottedRectangle(@NotNull Graphics g, int x, int y, int x1, int y1) {
        int i1;
        if (g == null) {
            UIUtil.$$$reportNull$$$0(103);
        }
        for (i1 = x; i1 <= x1; i1 += 2) {
            LinePainter2D.paint((Graphics2D)g, i1, y, (double)i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            LinePainter2D.paint((Graphics2D)g, x1, i1, (double)x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            LinePainter2D.paint((Graphics2D)g, i1, y1, (double)i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            LinePainter2D.paint((Graphics2D)g, x, i1, (double)x, i1);
        }
    }

    public static void drawBoldDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(104);
        }
        if (SystemInfoRt.isMac && !UIUtil.isRetina() || SystemInfoRt.isLinux) {
            UIUtil.drawAppleDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        } else {
            UIUtil.drawBoringDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        }
    }

    public static void drawSearchMatch(@NotNull Graphics2D g, float startX, float endX, int height) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(105);
        }
        UIUtil.drawSearchMatch(g, startX, endX, height, UIUtil.getSearchMatchGradientStartColor(), UIUtil.getSearchMatchGradientEndColor());
    }

    @NotNull
    public static JBColor getSearchMatchGradientStartColor() {
        JBColor jBColor = JBColor.namedColor("SearchMatch.startBackground", JBColor.namedColor("SearchMatch.startColor", new Color(-1275073886, true)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(106);
        }
        return jBColor;
    }

    @NotNull
    public static JBColor getSearchMatchGradientEndColor() {
        JBColor jBColor = JBColor.namedColor("SearchMatch.endBackground", JBColor.namedColor("SearchMatch.endColor", new Color(-1275080638, true)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(107);
        }
        return jBColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawSearchMatch(@NotNull Graphics2D g, float startXf, float endXf, int height, Color c1, Color c2) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(108);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setPaint(UIUtil.getGradientPaint(startXf, 2.0f, c1, startXf, height - 5, c2));
            if (JreHiDpiUtil.isJreHiDPI(g2)) {
                GraphicsUtil.setupRoundedBorderAntialiasing(g2);
                g2.fill(new RoundRectangle2D.Float(startXf, 2.0f, endXf - startXf, height - 4, 5.0f, 5.0f));
            } else {
                boolean drawRound;
                int startX = (int)startXf;
                int endX = (int)endXf;
                g2.fillRect(startX, 3, endX - startX, height - 5);
                boolean bl = drawRound = endXf - startXf > 4.0f;
                if (drawRound) {
                    LinePainter2D.paint(g2, startX - 1, 4.0, (double)(startX - 1), height - 4);
                    LinePainter2D.paint(g2, endX, 4.0, (double)endX, height - 4);
                    g2.setColor(new Color(100, 100, 100, 50));
                    LinePainter2D.paint(g2, startX - 1, 4.0, (double)(startX - 1), height - 4);
                    LinePainter2D.paint(g2, endX, 4.0, (double)endX, height - 4);
                    LinePainter2D.paint(g2, startX, 3.0, (double)(endX - 1), 3.0);
                    LinePainter2D.paint(g2, startX, height - 3, (double)(endX - 1), height - 3);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    private static void drawBoringDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(109);
        }
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
            LinePainter2D.paint(g, startX, lineY + 1, (double)endX, lineY + 1);
        }
        int step2 = 4;
        int startPosCorrection = startX % 4 < 3 ? 0 : 1;
        g.setColor(fgColor != null ? fgColor : oldColor);
        for (int dotXi = (startX / 4 + startPosCorrection) * 4; dotXi < endX; dotXi += 4) {
            LinePainter2D.paint(g, dotXi, lineY, (double)(dotXi + 1), lineY);
            LinePainter2D.paint(g, dotXi, lineY + 1, (double)(dotXi + 1), lineY + 1);
        }
        g.setColor(oldColor);
    }

    public static void drawGradientHToolbarBackground(@NotNull Graphics g, int width, int height) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(110);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._215, 0.0f, height, Gray._200));
        g2d.fillRect(0, 0, width, height);
    }

    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean drawTopLine) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(111);
        }
        UIUtil.drawHeader(g, x, width, height, active, false, drawTopLine, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean toolWindow, boolean drawTopLine, boolean drawBottomLine) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(112);
        }
        GraphicsConfig config = GraphicsUtil.disableAAPainting(g);
        try {
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBackground(active));
            g.fillRect(x, 0, width, height);
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBorderBackground());
            if (drawTopLine) {
                LinePainter2D.paint((Graphics2D)g, x, 0.0, (double)width, 0.0);
            }
            if (drawBottomLine) {
                LinePainter2D.paint((Graphics2D)g, x, height - 1, (double)width, height - 1);
            }
        }
        finally {
            config.restore();
        }
    }

    public static void drawDoubleSpaceDottedLine(@NotNull Graphics2D g, int start, int end, int xOrY, Color fgColor, boolean horizontal) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(113);
        }
        g.setColor(fgColor);
        for (int dot = start; dot < end; dot += 3) {
            if (horizontal) {
                LinePainter2D.paint(g, dot, xOrY, (double)dot, xOrY);
                continue;
            }
            LinePainter2D.paint(g, xOrY, dot, (double)xOrY, dot);
        }
    }

    private static void drawAppleDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(114);
        }
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
            LinePainter2D.paint(g, startX, lineY + 1, (double)endX, lineY + 1);
            LinePainter2D.paint(g, startX, lineY + 2, (double)endX, lineY + 2);
        }
        AppleBoldDottedPainter painter = AppleBoldDottedPainter.forColor(Objects.requireNonNullElse(fgColor, oldColor));
        painter.paint(g, startX, endX, lineY);
    }

    @Deprecated(forRemoval=true)
    public static void applyRenderingHints(@NotNull Graphics g) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(115);
        }
        GraphicsUtil.applyRenderingHints((Graphics2D)g);
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImage(int width, int height, int type) {
        BufferedImage bufferedImage = ImageUtil.createImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(116);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(GraphicsConfiguration gc, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            UIUtil.$$$reportNull$$$0(117);
        }
        if (JreHiDpiUtil.isJreHiDPI(gc)) {
            BufferedImage bufferedImage = RetinaImage.create(gc, width, height, (int)type, (PaintUtil.RoundingMode)rm);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(118);
            }
            return bufferedImage;
        }
        return new BufferedImage(rm.round(width), rm.round(height), (int)type);
    }

    @NotNull
    public static BufferedImage createImage(@Nullable Component component2, int width, int height, int type) {
        BufferedImage bufferedImage = ImageUtil.createImage(component2 == null ? null : component2.getGraphicsConfiguration(), width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(119);
        }
        return bufferedImage;
    }

    public static void setupComposite(@NotNull Graphics2D g) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(120);
        }
        g.setComposite(X_RENDER_ACTIVE.getValue() != false ? AlphaComposite.SrcOver : AlphaComposite.Src);
    }

    @TestOnly
    public static void dispatchAllInvocationEvents() {
        EDT.dispatchAllInvocationEvents();
    }

    /*
     * WARNING - void declaration
     */
    public static void addAwtListener(@NotNull AWTEventListener listener2, long mask, @NotNull Disposable disposable) {
        void parent2;
        if (listener2 == null) {
            UIUtil.$$$reportNull$$$0(121);
        }
        if (disposable == null) {
            UIUtil.$$$reportNull$$$0(122);
        }
        StartupUiUtil.addAwtListener(listener2, mask, (Disposable)parent2);
    }

    public static void addParentChangeListener(@NotNull Component component2, @NotNull PropertyChangeListener listener2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(123);
        }
        if (listener2 == null) {
            UIUtil.$$$reportNull$$$0(124);
        }
        component2.addPropertyChangeListener("ancestor", listener2);
    }

    public static void removeParentChangeListener(@NotNull Component component2, @NotNull PropertyChangeListener listener2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(125);
        }
        if (listener2 == null) {
            UIUtil.$$$reportNull$$$0(126);
        }
        component2.removePropertyChangeListener("ancestor", listener2);
    }

    public static void drawVDottedLine(@NotNull Graphics2D g, int lineX, int startY, int endY, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(127);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, lineX, startY, (double)lineX, endY);
        }
        g.setColor(fgColor);
        for (int i2 = startY / 2 * 2; i2 < endY; i2 += 2) {
            g.drawRect(lineX, i2, 0, 0);
        }
    }

    public static void drawHDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(128);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
        }
        g.setColor(fgColor);
        for (int i2 = startX / 2 * 2; i2 < endX; i2 += 2) {
            g.drawRect(i2, lineY, 0, 0);
        }
    }

    public static void drawDottedLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(129);
        }
        if (x1 == x2) {
            UIUtil.drawVDottedLine(g, x1, y1, y2, bgColor, fgColor);
        } else if (y1 == y2) {
            UIUtil.drawHDottedLine(g, x1, x2, y1, bgColor, fgColor);
        } else {
            throw new IllegalArgumentException("Only vertical or horizontal lines are supported");
        }
    }

    public static void drawStringWithHighlighting(@NotNull Graphics g, @NotNull String s, int x, int y, Color foreground, Color highlighting) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(130);
        }
        if (s == null) {
            UIUtil.$$$reportNull$$$0(131);
        }
        g.setColor(highlighting);
        boolean isRetina = JreHiDpiUtil.isJreHiDPI((Graphics2D)g);
        float scale = 1.0f / JBUIScale.sysScale((Graphics2D)g);
        for (float i2 = (float)(x - 1); i2 <= (float)(x + 1); i2 += isRetina ? scale : 1.0f) {
            for (float j = (float)(y - 1); j <= (float)(y + 1); j += isRetina ? scale : 1.0f) {
                ((Graphics2D)g).drawString(s, i2, j);
            }
        }
        g.setColor(foreground);
        g.drawString(s, x, y);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect2, @NotNull String str, boolean horzCentered, boolean vertCentered) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(132);
        }
        if (rect2 == null) {
            UIUtil.$$$reportNull$$$0(133);
        }
        if (str == null) {
            UIUtil.$$$reportNull$$$0(134);
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int textWidth = fm.stringWidth(str) - 1;
        int x = horzCentered ? Math.max(rect2.x, rect2.x + (rect2.width - textWidth) / 2) : rect2.x;
        int y = vertCentered ? Math.max(rect2.y, rect2.y + rect2.height / 2 + fm.getAscent() * 2 / 5) : rect2.y;
        Shape oldClip = g.getClip();
        g.clip(rect2);
        g.drawString(str, x, y);
        g.setClip(oldClip);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect2, @NotNull String str) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(135);
        }
        if (rect2 == null) {
            UIUtil.$$$reportNull$$$0(136);
        }
        if (str == null) {
            UIUtil.$$$reportNull$$$0(137);
        }
        UIUtil.drawCenteredString(g, rect2, str, true, true);
    }

    public static boolean isFocusAncestor(@NotNull Component component2) {
        Component owner;
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(138);
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            return false;
        }
        if (SwingUtilities.isDescendingFrom(owner, component2)) {
            return true;
        }
        while (component2 != null) {
            if (UIUtil.kindaHasFocus(component2)) {
                return true;
            }
            component2 = component2.getParent();
        }
        return false;
    }

    @ApiStatus.Experimental
    @Nullable
    public static Component getParent(@NotNull Component component2) {
        Container realParent;
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(139);
        }
        if ((realParent = component2.getParent()) != null) {
            return realParent;
        }
        WeakReference<Component> ref = ClientProperty.get(component2, FOSTER_PARENT);
        return ref != null ? (Component)ref.get() : null;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void setFosterParent(@NotNull JComponent component2, @Nullable Component parent2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(140);
        }
        WeakReference<Component> ref = UIUtil.validateFosterParent(component2, parent2);
        ClientProperty.put(component2, FOSTER_PARENT, ref);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void setFosterParent(@NotNull Window window, @Nullable Component parent2) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(141);
        }
        WeakReference<Component> ref = UIUtil.validateFosterParent(window, parent2);
        ClientProperty.put(window, FOSTER_PARENT, ref);
    }

    @Nullable
    private static WeakReference<Component> validateFosterParent(@NotNull Component component2, @Nullable Component parent2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(142);
        }
        if (parent2 != null && UIUtil.isGeneralizedAncestor(component2, parent2)) {
            throw new IllegalArgumentException("Setting this component as a foster parent will form a cycle in a hierarchy graph");
        }
        return parent2 != null ? new WeakReference<Component>(parent2) : null;
    }

    private static boolean isGeneralizedAncestor(@NotNull Component ancestor, @NotNull Component descendant) {
        if (ancestor == null) {
            UIUtil.$$$reportNull$$$0(143);
        }
        if (descendant == null) {
            UIUtil.$$$reportNull$$$0(144);
        }
        do {
            if (descendant != ancestor) continue;
            return true;
        } while ((descendant = UIUtil.getParent(descendant)) != null);
        return false;
    }

    private static boolean kindaHasFocus(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(145);
        }
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        JComponent jComponent = component2 instanceof JComponent ? (JComponent)component2 : null;
        return jComponent != null && Boolean.TRUE.equals(jComponent.getClientProperty(HAS_FOCUS));
    }

    @ApiStatus.Experimental
    public static boolean hasFocus(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(146);
        }
        return UIUtil.kindaHasFocus(component2) || component2.hasFocus();
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void markAsFocused(@NotNull JComponent component2, boolean value) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(147);
        }
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        component2.putClientProperty(HAS_FOCUS, value ? Boolean.TRUE : null);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(148);
        }
        return UIUtil.isCloseClick(e, 501);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e, int effectiveType) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(149);
        }
        if (e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 2 || e.getButton() == 1 && e.isShiftDown();
    }

    public static boolean isActionClick(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(150);
        }
        return UIUtil.isActionClick(e, 501);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(151);
        }
        return UIUtil.isActionClick(e, effectiveType, false);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType, boolean allowShift) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(152);
        }
        if (!allowShift && UIUtil.isCloseClick(e) || e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 1;
    }

    public static int getAllModifiers(@NotNull InputEvent event) {
        if (event == null) {
            UIUtil.$$$reportNull$$$0(153);
        }
        return event.getModifiers() | event.getModifiersEx();
    }

    @NotNull
    public static Color getBgFillColor(@NotNull Component c2) {
        Component parent2;
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(154);
        }
        Color color = (parent2 = UIUtil.findNearestOpaque(c2)) == null ? c2.getBackground() : parent2.getBackground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(155);
        }
        return color;
    }

    @Nullable
    public static Component findNearestOpaque(Component c2) {
        return ComponentUtil.findParentByCondition(c2, Component::isOpaque);
    }

    @Deprecated(forRemoval=true)
    public static Component findParentByCondition(@Nullable Component c2, @NotNull Condition<? super Component> condition) {
        if (condition == null) {
            UIUtil.$$$reportNull$$$0(156);
        }
        return ComponentUtil.findParentByCondition(c2, (? super Component it) -> condition.value((Component)it));
    }

    @Nullable
    public static Component getDeepestComponentAt(@NotNull Component parent2, int x, int y) {
        Component[] components;
        JRootPane rootPane;
        Container container;
        Component component2;
        if (parent2 == null) {
            UIUtil.$$$reportNull$$$0(157);
        }
        if ((component2 = SwingUtilities.getDeepestComponentAt(parent2, x, y)) != null && (container = component2.getParent()) instanceof JRootPane && (component2 = UIUtil.getDeepestComponentAtForComponent(parent2, x, y, (rootPane = (JRootPane)container).getLayeredPane())) == null) {
            component2 = UIUtil.getDeepestComponentAtForComponent(parent2, x, y, rootPane.getContentPane());
        }
        if (component2 != null && component2.getParent() instanceof JLayeredPane && (components = ((JLayeredPane)component2.getParent()).getComponentsInLayer(JLayeredPane.DEFAULT_LAYER)).length == 1 && ArrayUtilRt.indexOf(components, component2, 0, components.length) == -1) {
            component2 = UIUtil.getDeepestComponentAtForComponent(parent2, x, y, components[0]);
        }
        return component2;
    }

    private static Component getDeepestComponentAtForComponent(@NotNull Component parent2, int x, int y, @NotNull Component component2) {
        if (parent2 == null) {
            UIUtil.$$$reportNull$$$0(158);
        }
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(159);
        }
        Point point = SwingUtilities.convertPoint(parent2, new Point(x, y), component2);
        return SwingUtilities.getDeepestComponentAt(component2, point.x, point.y);
    }

    public static void layoutRecursively(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(160);
        }
        if (!(component2 instanceof JComponent)) {
            return;
        }
        UIUtil.forEachComponentInHierarchy(component2, Component::doLayout);
    }

    @Language(value="HTML")
    @NlsSafe
    @NotNull
    public static String getCssFontDeclaration(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(161);
        }
        return UIUtil.getCssFontDeclaration(font, UIUtil.getLabelForeground(), JBUI.CurrentTheme.Link.Foreground.ENABLED, null);
    }

    @Language(value="HTML")
    @NlsSafe
    @NotNull
    public static String getCssFontDeclaration(@NotNull Font font, @Nullable Color fgColor, @Nullable Color linkColor, @Nullable String liImg) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(162);
        }
        String familyAndSize = "font-family:'" + font.getFamily() + "'; font-size:" + font.getSize() + "pt;";
        String string2 = "<style>\nbody, div, td, p {" + familyAndSize + (String)(fgColor != null ? " color:#" + ColorUtil.toHex(fgColor) + ";" : NO_BORDER_UNDER_WINDOW_TITLE_KEY) + "}\na {" + familyAndSize + (String)(linkColor != null ? " color:#" + ColorUtil.toHex(linkColor) + ";" : NO_BORDER_UNDER_WINDOW_TITLE_KEY) + "}\ncode {font-size:" + font.getSize() + "pt;}\nul {list-style:disc; margin-left:15px;}\n</style>";
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(163);
        }
        return string2;
    }

    @NotNull
    public static Color getFocusedFillColor() {
        return UIUtil.toAlpha(UIUtil.getListSelectionBackground(true), 100);
    }

    @NotNull
    public static Color getFocusedBoundsColor() {
        Color color = NamedColorUtil.getBoundsColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(164);
        }
        return color;
    }

    @NotNull
    public static Color getBoundsColor() {
        Color color = NamedColorUtil.getBoundsColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(165);
        }
        return color;
    }

    @NotNull
    public static Color toAlpha(Color color, int alpha) {
        Color actual = color != null ? color : Color.black;
        return new Color(actual.getRed(), actual.getGreen(), actual.getBlue(), alpha);
    }

    public static boolean isFocusable(@Nullable Component component2) {
        return component2 != null && component2.isFocusable() && component2.isEnabled() && component2.isShowing();
    }

    @Deprecated
    public static void requestFocus(@NotNull JComponent c2) {
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(166);
        }
        if (c2.isShowing()) {
            c2.requestFocus();
        } else {
            SwingUtilities.invokeLater(c2::requestFocus);
        }
    }

    public static boolean canDisplayFocusedState(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(167);
        }
        return component2 instanceof JTextComponent || component2 instanceof AbstractButton || component2 instanceof JComboBox;
    }

    public static void dispose(Component c2) {
        MouseWheelListener[] mouseWheelListeners;
        MouseMotionListener[] motionListeners;
        MouseListener[] mouseListeners;
        if (c2 == null) {
            return;
        }
        for (MouseListener each : mouseListeners = c2.getMouseListeners()) {
            c2.removeMouseListener(each);
        }
        for (MouseMotionListener each : motionListeners = c2.getMouseMotionListeners()) {
            c2.removeMouseMotionListener(each);
        }
        for (MouseWheelListener each : mouseWheelListeners = c2.getMouseWheelListeners()) {
            c2.removeMouseWheelListener(each);
        }
        if (c2 instanceof AbstractButton) {
            ActionListener[] listeners;
            for (ActionListener listener2 : listeners = ((AbstractButton)c2).getActionListeners()) {
                ((AbstractButton)c2).removeActionListener(listener2);
            }
        }
    }

    public static void disposeProgress(@NotNull JProgressBar progress) {
        if (progress == null) {
            UIUtil.$$$reportNull$$$0(168);
        }
        if (!UIUtil.isUnderNativeMacLookAndFeel()) {
            return;
        }
        SwingUtilities.invokeLater(() -> progress.setUI(null));
    }

    @Nullable
    public static Component findUltimateParent(@Nullable Component c2) {
        return c2 == null ? null : ComponentUtil.findUltimateParent(c2);
    }

    @NotNull
    public static Color getHeaderActiveColor() {
        Color color = ACTIVE_HEADER_COLOR;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(169);
        }
        return color;
    }

    @NotNull
    public static Color getFocusedBorderColor() {
        Color color = JBUI.CurrentTheme.Focus.focusColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(170);
        }
        return color;
    }

    @NotNull
    public static Color getHeaderInactiveColor() {
        Color color = INACTIVE_HEADER_COLOR;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(171);
        }
        return color;
    }

    @NotNull
    public static Font getTitledBorderFont() {
        Font font = StartupUiUtil.getLabelFont();
        if (font == null) {
            UIUtil.$$$reportNull$$$0(172);
        }
        return font;
    }

    @Deprecated
    @NotNull
    public static HTMLEditorKit getHTMLEditorKit() {
        HTMLEditorKit hTMLEditorKit = HTMLEditorKitBuilder.simple();
        if (hTMLEditorKit == null) {
            UIUtil.$$$reportNull$$$0(173);
        }
        return hTMLEditorKit;
    }

    @Deprecated
    @NotNull
    public static HTMLEditorKit getHTMLEditorKit(boolean noGapsBetweenParagraphs) {
        HTMLEditorKitBuilder builder2 = new HTMLEditorKitBuilder();
        if (!noGapsBetweenParagraphs) {
            builder2.withGapsBetweenParagraphs();
        }
        HTMLEditorKit hTMLEditorKit = builder2.build();
        if (hTMLEditorKit == null) {
            UIUtil.$$$reportNull$$$0(174);
        }
        return hTMLEditorKit;
    }

    @NotNull
    public static Font getFontWithFallbackIfNeeded(@NotNull Font font, @NotNull String text2) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(175);
        }
        if (text2 == null) {
            UIUtil.$$$reportNull$$$0(176);
        }
        if (!SystemInfoRt.isMac && font.canDisplayUpTo(text2) != -1) {
            return UIUtil.getFontWithFallback(font);
        }
        Font font2 = font;
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(177);
        }
        return font2;
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(178);
        }
        if (!SystemInfoRt.isMac) {
            try {
                if (!FontUtilities.fontSupportsDefaultEncoding(font)) {
                    font = FontUtilities.getCompositeFontUIResource(font);
                }
            }
            catch (Throwable e) {
                UIUtil.getLogger().warn(e);
                FontUIResource fontUIResource = StartupUiUtil.getFontWithFallback(font.getFamily(), font.getStyle(), font.getSize());
                if (fontUIResource == null) {
                    UIUtil.$$$reportNull$$$0(179);
                }
                return fontUIResource;
            }
        }
        return font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, int size) {
        FontUIResource fontUIResource = StartupUiUtil.getFontWithFallback(familyName, style, size);
        if (fontUIResource == null) {
            UIUtil.$$$reportNull$$$0(180);
        }
        return fontUIResource;
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, float size) {
        FontUIResource fontUIResource = StartupUiUtil.getFontWithFallback(familyName, style, size);
        if (fontUIResource == null) {
            UIUtil.$$$reportNull$$$0(181);
        }
        return fontUIResource;
    }

    public static <T> T htmlInjectionGuard(T toRender) {
        if (toRender instanceof String && StringUtil.toLowerCase((String)toRender).startsWith("<html>")) {
            return (T)("<html>" + StringUtil.escapeXmlEntities((String)toRender));
        }
        return toRender;
    }

    @Deprecated
    public static void removeScrollBorder(Component c2) {
        JBIterable<JScrollPane> scrollPanes = ((JBTreeTraverser)UIUtil.uiTraverser(c2).expand(o -> o == c2 || o instanceof JPanel || o instanceof JLayeredPane)).filter(JScrollPane.class);
        for (JScrollPane scrollPane : scrollPanes) {
            Integer keepBorderSides = ClientProperty.get((Component)scrollPane, KEEP_BORDER_SIDES);
            if (keepBorderSides != null) {
                if (scrollPane.getBorder() instanceof LineBorder) {
                    Color color = ((LineBorder)scrollPane.getBorder()).getLineColor();
                    scrollPane.setBorder(new SideBorder(color, keepBorderSides));
                    continue;
                }
                scrollPane.setBorder(new SideBorder(NamedColorUtil.getBoundsColor(), keepBorderSides));
                continue;
            }
            scrollPane.setBorder(new SideBorder(NamedColorUtil.getBoundsColor(), 0));
        }
    }

    @NotNull
    @NlsSafe
    public static String toHtml(@NotNull @Nls String html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(182);
        }
        return UIUtil.toHtml(html, 0);
    }

    @NotNull
    @NlsSafe
    public static String toHtml(@NotNull @Nls String html, int hPadding) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(183);
        }
        @NlsSafe String withClosedTag = CLOSE_TAG_PATTERN.matcher(html).replaceAll("<$1$2></$1>");
        Font font = StartupUiUtil.getLabelFont();
        @NonNls String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : JBUIScale.scale(11);
        String string2 = "<html><style>body { font-family: " + family + "; font-size: " + size + ";} ul li {list-style-type:circle;}</style>" + UIUtil.addPadding(withClosedTag, hPadding) + "</html>";
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(184);
        }
        return string2;
    }

    @NotNull
    public static String addPadding(@NotNull String html, int hPadding) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(185);
        }
        String string2 = String.format("<p style=\"margin: 0 %dpx 0 %dpx;\">%s</p>", hPadding, hPadding, html);
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(186);
        }
        return string2;
    }

    @NotNull
    public static String convertSpace2Nbsp(@NotNull String html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(187);
        }
        @NonNls StringBuilder result2 = new StringBuilder();
        int braces = 0;
        for (int currentPos = 0; currentPos < html.length(); ++currentPos) {
            String each = html.substring(currentPos, currentPos + 1);
            if ("<".equals(each)) {
                ++braces;
            } else if (">".equals(each)) {
                --braces;
            }
            if (" ".equals(each) && braces == 0) {
                result2.append("&nbsp;");
                continue;
            }
            result2.append(each);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(188);
        }
        return string2;
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(189);
        }
        EdtInvocationManager.invokeLaterIfNeeded(runnable);
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(190);
        }
        EdtInvocationManager.invokeAndWaitIfNeeded(runnable);
    }

    public static <T> T invokeAndWaitIfNeeded(@NotNull Computable<T> computable) {
        if (computable == null) {
            UIUtil.$$$reportNull$$$0(191);
        }
        Ref result2 = Ref.create();
        UIUtil.invokeAndWaitIfNeeded(() -> result2.set(computable.compute()));
        return result2.get();
    }

    public static void invokeAndWaitIfNeeded(@NotNull ThrowableRunnable<?> runnable) throws Throwable {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(192);
        }
        if (EDT.isCurrentThreadEdt()) {
            runnable.run();
        } else {
            Ref ref = Ref.create();
            EdtInvocationManager.getInstance().invokeAndWait(() -> {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    ref.set(throwable);
                }
            });
            if (!ref.isNull()) {
                throw (Throwable)ref.get();
            }
        }
    }

    public static void maybeInstall(@NotNull InputMap map2, String action2, KeyStroke stroke) {
        if (map2 == null) {
            UIUtil.$$$reportNull$$$0(193);
        }
        if (map2.get(stroke) == null) {
            map2.put(stroke, action2);
        }
    }

    public static void changeBackGround(@NotNull Component component2, Color background) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(194);
        }
        Color oldBackGround = component2.getBackground();
        if (background == null || !background.equals(oldBackGround)) {
            component2.setBackground(background);
        }
    }

    @Nullable
    public static ComboPopup getComboBoxPopup(@NotNull JComboBox<?> comboBox) {
        ComboBoxUI ui;
        if (comboBox == null) {
            UIUtil.$$$reportNull$$$0(195);
        }
        if ((ui = comboBox.getUI()) instanceof BasicComboBoxUI) {
            return ReflectionUtil.getField(BasicComboBoxUI.class, ui, ComboPopup.class, "popup");
        }
        return null;
    }

    public static void fixFormattedField(@NotNull JFormattedTextField field) {
        if (field == null) {
            UIUtil.$$$reportNull$$$0(196);
        }
        if (SystemInfoRt.isMac) {
            int commandKeyMask;
            try {
                commandKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
            catch (HeadlessException e) {
                return;
            }
            InputMap inputMap = field.getInputMap();
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, commandKeyMask);
            inputMap.put(copyKeyStroke, "copy-to-clipboard");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, commandKeyMask);
            inputMap.put(pasteKeyStroke, "paste-from-clipboard");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, commandKeyMask);
            inputMap.put(cutKeyStroke, "cut-to-clipboard");
        }
    }

    public static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    public static int getSelectedButton(@NotNull ButtonGroup group2) {
        if (group2 == null) {
            UIUtil.$$$reportNull$$$0(197);
        }
        Enumeration<AbstractButton> enumeration = group2.getElements();
        int i2 = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button2 = enumeration.nextElement();
            if (group2.isSelected(button2.getModel())) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static void setSelectedButton(@NotNull ButtonGroup group2, int index2) {
        if (group2 == null) {
            UIUtil.$$$reportNull$$$0(198);
        }
        Enumeration<AbstractButton> enumeration = group2.getElements();
        int i2 = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button2 = enumeration.nextElement();
            group2.setSelected(button2.getModel(), index2 == i2);
            ++i2;
        }
    }

    public static boolean isSelectionButtonDown(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(199);
        }
        return e.isShiftDown() || e.isControlDown() || e.isMetaDown();
    }

    public static boolean isToggleListSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(200);
        }
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfoRt.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    public static void setComboBoxEditorBounds(int x, int y, int width, int height, @NotNull JComponent editor2) {
        if (editor2 == null) {
            UIUtil.$$$reportNull$$$0(201);
        }
        editor2.reshape(x, y, width, height);
    }

    public static boolean isDescendingFrom(@Nullable Component child, @NotNull Component parent2) {
        if (parent2 == null) {
            UIUtil.$$$reportNull$$$0(202);
        }
        while (child != null && child != parent2) {
            child = child instanceof JPopupMenu ? ((JPopupMenu)child).getInvoker() : child.getParent();
        }
        return child == parent2;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T getParentOfType(@NotNull Class<? extends T> type, Component component2) {
        if (type == null) {
            UIUtil.$$$reportNull$$$0(203);
        }
        return ComponentUtil.getParentOfType(type, component2);
    }

    @NotNull
    public static JBIterable<Component> uiParents(@Nullable Component c2, boolean strict) {
        JBIterable<Component> jBIterable = strict ? JBIterable.generate(c2, c1 -> c1.getParent()).skip(1) : JBIterable.generate(c2, c1 -> c1.getParent());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(204);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component2) {
        if (!(component2 instanceof Container)) {
            JBIterable<Component> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                UIUtil.$$$reportNull$$$0(205);
            }
            return jBIterable;
        }
        Container container = (Container)component2;
        JBIterable<Component> jBIterable = JBIterable.of(container.getComponents());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(206);
        }
        return jBIterable;
    }

    @NotNull
    public static JBTreeTraverser<Component> uiTraverser(@Nullable Component component2) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)UI_TRAVERSER.withRoot(component2)).expandAndFilter(o -> !(o instanceof CellRendererPane));
        if (jBTreeTraverser == null) {
            UIUtil.$$$reportNull$$$0(207);
        }
        return jBTreeTraverser;
    }

    @ApiStatus.Internal
    public static void addNotInHierarchyComponents(@NotNull JComponent container, @NotNull Iterable<Component> components) {
        Iterable<? extends Component> oldValue;
        if (container == null) {
            UIUtil.$$$reportNull$$$0(208);
        }
        if (components == null) {
            UIUtil.$$$reportNull$$$0(209);
        }
        if ((oldValue = ClientProperty.get((Component)container, NOT_IN_HIERARCHY_COMPONENTS)) == null) {
            ClientProperty.put(container, NOT_IN_HIERARCHY_COMPONENTS, components);
            return;
        }
        ClientProperty.put(container, NOT_IN_HIERARCHY_COMPONENTS, IterablesConcat.concat(oldValue, components));
    }

    public static void scrollListToVisibleIfNeeded(@NotNull JList<?> list2) {
        if (list2 == null) {
            UIUtil.$$$reportNull$$$0(210);
        }
        SwingUtilities.invokeLater(() -> {
            Rectangle cellBounds;
            Rectangle visibleRect;
            int selectedIndex = list2.getSelectedIndex();
            if (selectedIndex >= 0 && !(visibleRect = list2.getVisibleRect()).contains(cellBounds = list2.getCellBounds(selectedIndex, selectedIndex))) {
                list2.scrollRectToVisible(cellBounds);
            }
        });
    }

    @Nullable
    public static <T extends JComponent> T findComponentOfType(JComponent parent2, Class<T> cls) {
        if (parent2 == null || cls.isInstance(parent2)) {
            return (T)((JComponent)cls.cast(parent2));
        }
        for (Component component2 : parent2.getComponents()) {
            T comp;
            if (!(component2 instanceof JComponent) || (comp = UIUtil.findComponentOfType((JComponent)component2, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    @NotNull
    public static <T extends JComponent> List<T> findComponentsOfType(JComponent parent2, @NotNull Class<? extends T> cls) {
        if (cls == null) {
            UIUtil.$$$reportNull$$$0(211);
        }
        List<? extends T> list2 = ComponentUtil.findComponentsOfType(parent2, cls);
        if (list2 == null) {
            UIUtil.$$$reportNull$$$0(212);
        }
        return list2;
    }

    @Nullable
    public static JRootPane getRootPane(Component c2) {
        JRootPane root = ComponentUtil.getParentOfType(JRootPane.class, c2);
        if (root != null) {
            return root;
        }
        for (Component eachParent = c2; eachParent != null; eachParent = eachParent.getParent()) {
            WeakReference pane;
            if (!(eachParent instanceof JComponent) || (pane = (WeakReference)((JComponent)eachParent).getClientProperty(ROOT_PANE)) == null) continue;
            return (JRootPane)pane.get();
        }
        return null;
    }

    public static void setFutureRootPane(@NotNull JComponent c2, @NotNull JRootPane pane) {
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(213);
        }
        if (pane == null) {
            UIUtil.$$$reportNull$$$0(214);
        }
        c2.putClientProperty(ROOT_PANE, new WeakReference<JRootPane>(pane));
    }

    public static boolean isDialogRootPane(JRootPane rootPane) {
        if (rootPane != null) {
            Object isDialog = rootPane.getClientProperty("DIALOG_ROOT_PANE");
            return isDialog instanceof Boolean && (Boolean)isDialog != false;
        }
        return false;
    }

    public static void runWhenVisibilityChanged(@NotNull Component component2, final Runnable runnable) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(215);
        }
        component2.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                runnable.run();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                runnable.run();
            }
        });
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(PanelWithAnchor ... panels) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(216);
        }
        return UIUtil.mergeComponentsWithAnchor(Arrays.asList(panels));
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(@NotNull Collection<? extends PanelWithAnchor> panels) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(217);
        }
        return UIUtil.mergeComponentsWithAnchor(panels, false);
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(@NotNull Collection<? extends PanelWithAnchor> panels, boolean visibleOnly) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(218);
        }
        JComponent maxWidthAnchor = null;
        int maxWidth = 0;
        for (PanelWithAnchor panelWithAnchor : panels) {
            JComponent anchor;
            if (visibleOnly && panelWithAnchor instanceof JComponent && !((JComponent)((Object)panelWithAnchor)).isVisible() || (anchor = panelWithAnchor != null ? panelWithAnchor.getOwnAnchor() : null) == null) continue;
            panelWithAnchor.setAnchor(null);
            int anchorWidth = anchor.getPreferredSize().width;
            if (maxWidth >= anchorWidth) continue;
            maxWidth = anchorWidth;
            maxWidthAnchor = anchor;
        }
        for (PanelWithAnchor panelWithAnchor : panels) {
            if (panelWithAnchor == null) continue;
            panelWithAnchor.setAnchor(maxWidthAnchor);
            if (!(panelWithAnchor instanceof JComponent)) continue;
            ((JComponent)((Object)panelWithAnchor)).revalidate();
            ((JComponent)((Object)panelWithAnchor)).repaint();
        }
        return maxWidthAnchor;
    }

    public static void setNotOpaqueRecursively(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(219);
        }
        UIUtil.setOpaqueRecursively(component2, false);
    }

    public static void setOpaqueRecursively(@NotNull Component component2, boolean opaque) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(220);
        }
        if (!(component2 instanceof JComponent)) {
            return;
        }
        UIUtil.forEachComponentInHierarchy(component2, c2 -> {
            if (c2 instanceof JComponent) {
                ((JComponent)c2).setOpaque(opaque);
            }
        });
    }

    public static void setEnabledRecursively(@NotNull Component component2, boolean enabled) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(221);
        }
        UIUtil.forEachComponentInHierarchy(component2, c2 -> c2.setEnabled(enabled));
    }

    public static void setBackgroundRecursively(@NotNull Component component2, @NotNull Color bg) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(222);
        }
        if (bg == null) {
            UIUtil.$$$reportNull$$$0(223);
        }
        UIUtil.forEachComponentInHierarchy(component2, c2 -> c2.setBackground(bg));
    }

    public static void setForegroundRecursively(@NotNull Component component2, @NotNull Color bg) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(224);
        }
        if (bg == null) {
            UIUtil.$$$reportNull$$$0(225);
        }
        UIUtil.forEachComponentInHierarchy(component2, c2 -> c2.setForeground(bg));
    }

    public static void setTooltipRecursively(@NotNull Component component2, @Nls String text2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(226);
        }
        UIUtil.forEachComponentInHierarchy(component2, c2 -> ((JComponent)c2).setToolTipText(text2));
    }

    public static void forEachComponentInHierarchy(@NotNull Component component2, @NotNull Consumer<? super Component> action2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(227);
        }
        if (action2 == null) {
            UIUtil.$$$reportNull$$$0(228);
        }
        action2.consume(component2);
        if (component2 instanceof Container) {
            for (Component c2 : ((Container)component2).getComponents()) {
                UIUtil.forEachComponentInHierarchy(c2, action2);
            }
        }
    }

    public static void addInsets(@NotNull JComponent component2, int top, int left, int bottom, int right) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(229);
        }
        UIUtil.addBorder(component2, BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    public static void addInsets(@NotNull JComponent component2, @NotNull Insets insets) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(230);
        }
        if (insets == null) {
            UIUtil.$$$reportNull$$$0(231);
        }
        UIUtil.addInsets(component2, insets.top, insets.left, insets.bottom, insets.right);
    }

    public static void adjustWindowToMinimumSize(Window window) {
        if (window == null) {
            return;
        }
        Dimension minSize = window.getMinimumSize();
        Dimension size = window.getSize();
        Dimension newSize = new Dimension(Math.max(size.width, minSize.width), Math.max(size.height, minSize.height));
        if (!newSize.equals(size)) {
            SwingUtilities.invokeLater(() -> {
                if (window.isShowing()) {
                    window.setSize(newSize);
                }
            });
        }
    }

    public static int getLcdContrastValue() {
        int lcdContrastValue;
        int n = lcdContrastValue = LoadingState.APP_STARTED.isOccurred() ? Registry.intValue("lcd.contrast.value", 0) : 0;
        if (lcdContrastValue == 0) {
            return StartupUiUtil.doGetLcdContrastValueForSplash(StartupUiUtil.isUnderDarcula());
        }
        return StartupUiUtil.normalizeLcdContrastValue(lcdContrastValue);
    }

    public static void addBorder(JComponent component2, Border border) {
        if (component2 != null && border != null) {
            Border old = component2.getBorder();
            if (old != null) {
                border = BorderFactory.createCompoundBorder(border, old);
            }
            component2.setBorder(border);
        }
    }

    @NotNull
    public static Color getDecoratedRowColor() {
        JBColor jBColor = JBColor.namedColor("Table.stripeColor", DECORATED_ROW_BG_COLOR);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(232);
        }
        return jBColor;
    }

    @NotNull
    public static Paint getGradientPaint(float x1, float y1, @NotNull Color c1, float x2, float y2, @NotNull Color c2) {
        if (c1 == null) {
            UIUtil.$$$reportNull$$$0(233);
        }
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(234);
        }
        return Registry.is("ui.no.bangs.and.whistles", false) ? ColorUtil.mix(c1, c2, 0.5) : new GradientPaint(x1, y1, c1, x2, y2, c2);
    }

    @Nullable
    public static Point getLocationOnScreen(@NotNull JComponent component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(235);
        }
        int dx = 0;
        int dy = 0;
        for (Container c2 = component2; c2 != null; c2 = c2.getParent()) {
            if (c2.isShowing()) {
                Point locationOnScreen = c2.getLocationOnScreen();
                locationOnScreen.translate(dx, dy);
                return locationOnScreen;
            }
            Point location2 = c2.getLocation();
            dx += location2.x;
            dy += location2.y;
        }
        return null;
    }

    public static void setAutoRequestFocus(@NotNull Window window, boolean value) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(236);
        }
        if (!SystemInfoRt.isMac) {
            window.setAutoRequestFocus(value);
        }
    }

    public static void runWhenWindowOpened(@NotNull Window window, final @NotNull Runnable runnable) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(237);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(238);
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable.run();
            }
        });
    }

    public static void runWhenWindowClosed(@NotNull Window window, final @NotNull Runnable runnable) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(239);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(240);
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable.run();
            }
        });
    }

    @NotNull
    public static String getDebugText(@NotNull Component c2) {
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(241);
        }
        StringBuilder builder2 = new StringBuilder();
        UIUtil.getAllTextsRecursively(c2, builder2);
        String string2 = builder2.toString();
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(242);
        }
        return string2;
    }

    private static void getAllTextsRecursively(@NotNull Component component2, @NotNull StringBuilder builder2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(243);
        }
        if (builder2 == null) {
            UIUtil.$$$reportNull$$$0(244);
        }
        String candidate = NO_BORDER_UNDER_WINDOW_TITLE_KEY;
        if (component2 instanceof JLabel) {
            candidate = ((JLabel)component2).getText();
        }
        if (component2 instanceof JTextComponent) {
            candidate = ((JTextComponent)component2).getText();
        }
        if (component2 instanceof AbstractButton) {
            candidate = ((AbstractButton)component2).getText();
        }
        if (StringUtil.isNotEmpty(candidate)) {
            candidate = candidate.replaceAll("<a href=\"#inspection/[^)]+\\)", NO_BORDER_UNDER_WINDOW_TITLE_KEY);
            if (builder2.length() > 0) {
                builder2.append(' ');
            }
            builder2.append(StringUtil.removeHtmlTags(candidate).trim());
        }
        if (component2 instanceof Container) {
            Component[] components;
            for (Component child : components = ((Container)component2).getComponents()) {
                UIUtil.getAllTextsRecursively(child, builder2);
            }
        }
    }

    public static boolean isAncestor(@NotNull Component ancestor, @Nullable Component descendant) {
        if (ancestor == null) {
            UIUtil.$$$reportNull$$$0(245);
        }
        while (descendant != null) {
            if (descendant == ancestor) {
                return true;
            }
            descendant = descendant.getParent();
        }
        return false;
    }

    @Deprecated
    public static void addUndoRedoActions(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(246);
        }
        SwingUndoUtil.addUndoRedoActions(textComponent);
    }

    public static void playSoundFromResource(@NotNull String resourceName) {
        Class<?> callerClass;
        if (resourceName == null) {
            UIUtil.$$$reportNull$$$0(247);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return;
        }
        UIUtil.playSoundFromStream(() -> callerClass.getResourceAsStream(resourceName));
    }

    public static void playSoundFromStream(@NotNull Factory<? extends InputStream> streamProducer) {
        if (streamProducer == null) {
            UIUtil.$$$reportNull$$$0(248);
        }
        new Thread(() -> {
            try {
                Clip clip = AudioSystem.getClip();
                InputStream stream = (InputStream)streamProducer.create();
                if (!stream.markSupported()) {
                    stream = new BufferedInputStream(stream);
                }
                AudioInputStream inputStream = AudioSystem.getAudioInputStream(stream);
                clip.open(inputStream);
                clip.start();
            }
            catch (Exception e) {
                UIUtil.getLogger().info(e);
            }
        }, "play sound").start();
    }

    @NlsSafe
    @NotNull
    public static String leftArrow() {
        String string2 = FontUtil.leftArrow(StartupUiUtil.getLabelFont());
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(249);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String rightArrow() {
        String string2 = FontUtil.rightArrow(StartupUiUtil.getLabelFont());
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(250);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String upArrow(@NotNull String defaultValue) {
        if (defaultValue == null) {
            UIUtil.$$$reportNull$$$0(251);
        }
        String string2 = FontUtil.upArrow(StartupUiUtil.getLabelFont(), defaultValue);
        if (string2 == null) {
            UIUtil.$$$reportNull$$$0(252);
        }
        return string2;
    }

    public static void configureNumericFormattedTextField(@NotNull JFormattedTextField textField) {
        if (textField == null) {
            UIUtil.$$$reportNull$$$0(253);
        }
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setParseIntegerOnly(true);
        format.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(format);
        numberFormatter.setMinimum(Integer.valueOf(0));
        textField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        textField.setHorizontalAlignment(11);
        textField.setColumns(4);
    }

    @Nullable
    public static Window getWindow(@Nullable Component component2) {
        return ComponentUtil.getWindow(component2);
    }

    public static void toFront(@Nullable Window window) {
        if (window instanceof Frame) {
            ((Frame)window).setState(0);
        }
        if (window != null) {
            window.toFront();
        }
    }

    public static boolean hasScrollPane(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(254);
        }
        return UIUtil.hasComponentOfType(component2, JScrollPane.class);
    }

    public static boolean hasComponentOfType(@NotNull Component component2, Class<?> ... types) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(255);
        }
        if (types == null) {
            UIUtil.$$$reportNull$$$0(256);
        }
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(component2.getClass())) continue;
            return true;
        }
        if (component2 instanceof Container) {
            Container container = (Container)component2;
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                if (!UIUtil.hasComponentOfType(container.getComponent(i2), types)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setColumns(JTextComponent textComponent, int columns2) {
        if (textComponent instanceof JTextField) {
            ((JTextField)textComponent).setColumns(columns2);
        }
        if (textComponent instanceof JTextArea) {
            ((JTextArea)textComponent).setColumns(columns2);
        }
    }

    public static int getLineHeight(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(257);
        }
        return UIUtil.getLineHeight((JComponent)textComponent);
    }

    public static int getLineHeight(@NotNull JComponent component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(258);
        }
        return component2.getFontMetrics(component2.getFont()).getHeight();
    }

    public static JComponent getPreferredFocusedComponent(Container container) {
        Container parent2 = container;
        if (parent2 == null) {
            return null;
        }
        FocusTraversalPolicy policy = parent2.getFocusTraversalPolicy();
        while (policy == null) {
            if ((parent2 = parent2.getParent()) == null) {
                return null;
            }
            policy = parent2.getFocusTraversalPolicy();
        }
        Component component2 = policy.getFirstComponent(container);
        return component2 instanceof JComponent ? (JComponent)component2 : null;
    }

    @NotNull
    public static ComponentStyle getComponentStyle(Component component2) {
        if (component2 instanceof JComponent) {
            Object property = ((JComponent)component2).getClientProperty("JComponent.sizeVariant");
            if ("large".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.LARGE;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(259);
                }
                return componentStyle;
            }
            if ("small".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.SMALL;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(260);
                }
                return componentStyle;
            }
            if ("mini".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.MINI;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(261);
                }
                return componentStyle;
            }
        }
        ComponentStyle componentStyle = ComponentStyle.REGULAR;
        if (componentStyle == null) {
            UIUtil.$$$reportNull$$$0(262);
        }
        return componentStyle;
    }

    public static void repaintViewport(@NotNull JComponent c2) {
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(263);
        }
        if (!c2.isDisplayable() || !c2.isVisible()) {
            return;
        }
        Container p = c2.getParent();
        if (p instanceof JViewport) {
            p.repaint();
        }
    }

    public static void setCursor(@NotNull Component component2, Cursor cursor) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(264);
        }
        if (!component2.isCursorSet() || component2.getCursor() != cursor) {
            component2.setCursor(cursor);
        }
    }

    public static boolean haveCommonOwner(Component c1, Component c2) {
        Window owner;
        if (c1 == null || c2 == null) {
            return false;
        }
        Window c1Ancestor = UIUtil.findWindowAncestor(c1);
        Window c2Ancestor = UIUtil.findWindowAncestor(c2);
        HashSet<Window> ownerSet = new HashSet<Window>();
        for (owner = c1Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            ownerSet.add(owner);
        }
        for (owner = c2Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            if (!ownerSet.contains(owner)) continue;
            return true;
        }
        return false;
    }

    private static Window findWindowAncestor(@NotNull Component c2) {
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(265);
        }
        return c2 instanceof Window ? (Window)c2 : SwingUtilities.getWindowAncestor(c2);
    }

    public static boolean isSimpleWindow(Window window) {
        return window != null && !(window instanceof Frame) && !(window instanceof Dialog);
    }

    public static boolean isHelpButton(Component button2) {
        return button2 instanceof JButton && "help".equals(((JComponent)button2).getClientProperty("JButton.buttonType"));
    }

    public static boolean isRetina(@NotNull GraphicsDevice device) {
        if (device == null) {
            UIUtil.$$$reportNull$$$0(266);
        }
        return DetectRetinaKit.isOracleMacRetinaDevice(device);
    }

    public static void useSafely(@NotNull Graphics originGraphics, @NotNull Consumer<? super Graphics2D> drawingConsumer) {
        if (originGraphics == null) {
            UIUtil.$$$reportNull$$$0(267);
        }
        if (drawingConsumer == null) {
            UIUtil.$$$reportNull$$$0(268);
        }
        Graphics2D graphics = (Graphics2D)originGraphics.create();
        try {
            drawingConsumer.consume(graphics);
        }
        finally {
            graphics.dispose();
        }
    }

    @NotNull
    public static Font getListFont() {
        Font font = UIManager.getFont("List.font");
        Font font2 = font != null ? font : StartupUiUtil.getLabelFont();
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(269);
        }
        return font2;
    }

    @NotNull
    public static Color getListBackground() {
        Color color = JBUI.CurrentTheme.List.BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(270);
        }
        return color;
    }

    @NotNull
    public static Color getListSelectionBackground(boolean focused) {
        Color color = JBUI.CurrentTheme.List.Selection.background(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(271);
        }
        return color;
    }

    @NotNull
    public static Dimension updateListRowHeight(@NotNull Dimension size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(272);
        }
        size.height = Math.max(size.height, UIManager.getInt("List.rowHeight"));
        Dimension dimension = size;
        if (dimension == null) {
            UIUtil.$$$reportNull$$$0(273);
        }
        return dimension;
    }

    @NotNull
    public static Color getListBackground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getListBackground() : UIUtil.getListSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getListBackground(boolean selected) {
        return UIUtil.getListBackground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionBackground() {
        return UIUtil.getListSelectionBackground(true);
    }

    @Deprecated
    @NotNull
    public static Color getListUnfocusedSelectionBackground() {
        return UIUtil.getListSelectionBackground(false);
    }

    @NotNull
    public static Color getListForeground() {
        Color color = JBUI.CurrentTheme.List.FOREGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(274);
        }
        return color;
    }

    @NotNull
    public static Color getListSelectionForeground(boolean focused) {
        Color color = NamedColorUtil.getListSelectionForeground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(275);
        }
        return color;
    }

    @NotNull
    public static Color getListForeground(boolean selected, boolean focused) {
        Color color = !selected ? UIUtil.getListForeground() : NamedColorUtil.getListSelectionForeground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(276);
        }
        return color;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color getListForeground(boolean selected) {
        return UIUtil.getListForeground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionForeground() {
        Color color = NamedColorUtil.getListSelectionForeground(true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(277);
        }
        return color;
    }

    @NotNull
    public static Font getTreeFont() {
        Font font = UIManager.getFont("Tree.font");
        Font font2 = font != null ? font : StartupUiUtil.getLabelFont();
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(278);
        }
        return font2;
    }

    @NotNull
    public static Color getTreeBackground() {
        Color color = JBUI.CurrentTheme.Tree.BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(279);
        }
        return color;
    }

    @NotNull
    public static Color getTreeSelectionBackground(boolean focused) {
        Color color = JBUI.CurrentTheme.Tree.Selection.background(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(280);
        }
        return color;
    }

    @NotNull
    public static Color getTreeBackground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTreeBackground() : UIUtil.getTreeSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionBackground() {
        return UIUtil.getTreeSelectionBackground(true);
    }

    @Deprecated
    @NotNull
    public static Color getTreeUnfocusedSelectionBackground() {
        return UIUtil.getTreeSelectionBackground(false);
    }

    @NotNull
    public static Color getTreeForeground() {
        Color color = JBUI.CurrentTheme.Tree.FOREGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(281);
        }
        return color;
    }

    @NotNull
    public static Color getTreeSelectionForeground(boolean focused) {
        Color color = JBUI.CurrentTheme.Tree.Selection.foreground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(282);
        }
        return color;
    }

    @NotNull
    public static Color getTreeForeground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTreeForeground() : UIUtil.getTreeSelectionForeground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionForeground() {
        return UIUtil.getTreeSelectionForeground(true);
    }

    @NotNull
    public static Color getTableBackground() {
        Color color = JBUI.CurrentTheme.Table.BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(283);
        }
        return color;
    }

    @NotNull
    public static Color getTableSelectionBackground(boolean focused) {
        Color color = JBUI.CurrentTheme.Table.Selection.background(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(284);
        }
        return color;
    }

    @NotNull
    public static Color getTableBackground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTableBackground() : UIUtil.getTableSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTableBackground(boolean selected) {
        return UIUtil.getTableBackground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionBackground() {
        return UIUtil.getTableSelectionBackground(true);
    }

    @NotNull
    public static Color getTableForeground() {
        Color color = JBUI.CurrentTheme.Table.FOREGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(285);
        }
        return color;
    }

    @NotNull
    public static Color getTableSelectionForeground(boolean focused) {
        Color color = JBUI.CurrentTheme.Table.Selection.foreground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(286);
        }
        return color;
    }

    @NotNull
    public static Color getTableForeground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTableForeground() : UIUtil.getTableSelectionForeground(focused);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color getTableForeground(boolean selected) {
        return UIUtil.getTableForeground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionForeground() {
        return UIUtil.getTableSelectionForeground(true);
    }

    public static void doNotScrollToCaret(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(287);
        }
        textComponent.setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle nloc) {
            }
        });
    }

    public static void convertToLabel(@NotNull JEditorPane editorPane) {
        if (editorPane == null) {
            UIUtil.$$$reportNull$$$0(288);
        }
        editorPane.setEditable(false);
        editorPane.setFocusable(false);
        editorPane.setOpaque(false);
        editorPane.setBorder(null);
        editorPane.setContentType(HTML_MIME);
        editorPane.setEditorKit(HTMLEditorKitBuilder.simple());
    }

    public static void enableEagerSoftWrapping(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(289);
        }
        textComponent.getDocument().putProperty("multiByte", Boolean.TRUE);
    }

    @NotNull
    public static Color getTooltipSeparatorColor() {
        JBColor jBColor = JBColor.namedColor("Tooltip.separatorColor", 0xD1D1D1, 5527128);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(290);
        }
        return jBColor;
    }

    public static void scrollToReference(@NotNull JEditorPane editor2, @NotNull @NonNls String reference2) {
        Element elementById;
        Document document;
        if (editor2 == null) {
            UIUtil.$$$reportNull$$$0(291);
        }
        if (reference2 == null) {
            UIUtil.$$$reportNull$$$0(292);
        }
        if ((document = editor2.getDocument()) instanceof HTMLDocument && (elementById = ((HTMLDocument)document).getElement(reference2)) != null) {
            try {
                int pos = elementById.getStartOffset();
                Rectangle r = editor2.modelToView(pos);
                if (r != null) {
                    r.height = editor2.getVisibleRect().height;
                    editor2.scrollRectToVisible(r);
                    editor2.setCaretPosition(pos);
                }
            }
            catch (BadLocationException e) {
                UIUtil.getLogger().error(e);
            }
            return;
        }
        editor2.scrollToReference(reference2);
    }

    @ApiStatus.Experimental
    public static boolean isShowing(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(293);
        }
        return UIUtil.isShowing(component2, true);
    }

    @ApiStatus.Experimental
    public static boolean isShowing(@NotNull Component component2, boolean checkHeadless) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(294);
        }
        if (checkHeadless && Boolean.getBoolean("java.awt.headless")) {
            return true;
        }
        if (component2.isShowing()) {
            return true;
        }
        while (component2 != null) {
            JComponent jComponent;
            JComponent jComponent2 = jComponent = component2 instanceof JComponent ? (JComponent)component2 : null;
            if (jComponent != null && Boolean.TRUE.equals(jComponent.getClientProperty(IS_SHOWING))) {
                return true;
            }
            component2 = component2.getParent();
        }
        return false;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void markAsShowing(@NotNull JComponent component2, boolean value) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(295);
        }
        if (Boolean.getBoolean("java.awt.headless")) {
            return;
        }
        component2.putClientProperty(IS_SHOWING, value ? Boolean.TRUE : null);
    }

    public static void runWhenFocused(@NotNull Component component2, final @NotNull Runnable runnable) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(296);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(297);
        }
        assert (component2.isShowing());
        if (component2.isFocusOwner()) {
            runnable.run();
        } else {
            final Disposable disposable = Disposer.newDisposable();
            FocusAdapter focusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Disposer.dispose(disposable);
                    runnable.run();
                }
            };
            HierarchyListener hierarchyListener = e -> {
                if ((e.getChangeFlags() & 4L) != 0L && !component2.isShowing()) {
                    Disposer.dispose(disposable);
                }
            };
            component2.addFocusListener(focusListener);
            component2.addHierarchyListener(hierarchyListener);
            Disposer.register(disposable, () -> {
                component2.removeFocusListener(focusListener);
                component2.removeHierarchyListener(hierarchyListener);
            });
        }
    }

    public static void runWhenHidden(@NotNull Component component2, @NotNull Runnable runnable) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(298);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(299);
        }
        component2.addHierarchyListener(UIUtil.runWhenHidden(runnable));
    }

    @NotNull
    private static HierarchyListener runWhenHidden(final @NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(300);
        }
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!BitUtil.isSet(e.getChangeFlags(), 2L)) {
                    return;
                }
                Component component2 = e.getComponent();
                if (component2.isDisplayable()) {
                    return;
                }
                component2.removeHierarchyListener(this);
                runnable.run();
            }
        };
    }

    public static void runWhenChanged(final @NotNull Component component2, final @NotNull String property, final @NotNull Runnable runnable) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(301);
        }
        if (property == null) {
            UIUtil.$$$reportNull$$$0(302);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(303);
        }
        component2.addPropertyChangeListener(property, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component2.removePropertyChangeListener(property, this);
                runnable.run();
            }
        });
    }

    public static Future<?> runOnceWhenResized(final @NotNull Component component2, final @NotNull Runnable runnable) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(304);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(305);
        }
        final CompletableFuture future = new CompletableFuture();
        component2.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                component2.removeComponentListener(this);
                if (!future.isCancelled()) {
                    try {
                        runnable.run();
                        future.complete(null);
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                    }
                }
            }
        });
        return future;
    }

    public static Font getLabelFont() {
        return StartupUiUtil.getLabelFont();
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(306);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(307);
        }
        StartupUiUtil.drawImage(g, image, x, y, observer);
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Dimension container, @NotNull Dimension child) {
        if (container == null) {
            UIUtil.$$$reportNull$$$0(308);
        }
        if (child == null) {
            UIUtil.$$$reportNull$$$0(309);
        }
        Point point = StartupUiUtil.getCenterPoint(container, child);
        if (point == null) {
            UIUtil.$$$reportNull$$$0(310);
        }
        return point;
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Rectangle container, @NotNull Dimension child) {
        if (container == null) {
            UIUtil.$$$reportNull$$$0(311);
        }
        if (child == null) {
            UIUtil.$$$reportNull$$$0(312);
        }
        Point point = StartupUiUtil.getCenterPoint(container, child);
        if (point == null) {
            UIUtil.$$$reportNull$$$0(313);
        }
        return point;
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(314);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(315);
        }
        StartupUiUtil.drawImage(g, image, dstBounds, srcBounds, null, observer);
    }

    @TestOnly
    public static void pump() {
        assert (!SwingUtilities.isEventDispatchThread());
        Semaphore lock = new Semaphore(1);
        SwingUtilities.invokeLater(() -> lock.up());
        lock.waitFor();
    }

    public static boolean isJreHiDPI() {
        return StartupUiUtil.isJreHiDPI();
    }

    public static Color makeTransparent(@NotNull Color color, @NotNull Color backgroundColor, double transparency) {
        if (color == null) {
            UIUtil.$$$reportNull$$$0(316);
        }
        if (backgroundColor == null) {
            UIUtil.$$$reportNull$$$0(317);
        }
        int r = UIUtil.makeTransparent(transparency, color.getRed(), backgroundColor.getRed());
        int g = UIUtil.makeTransparent(transparency, color.getGreen(), backgroundColor.getGreen());
        int b = UIUtil.makeTransparent(transparency, color.getBlue(), backgroundColor.getBlue());
        return new Color(r, g, b);
    }

    private static int makeTransparent(double transparency, int channel, int backgroundChannel) {
        int result2 = (int)((double)backgroundChannel * (1.0 - transparency) + (double)channel * transparency);
        if (result2 < 0) {
            return 0;
        }
        return Math.min(result2, 255);
    }

    public static void stopFocusedEditing(@NotNull Window window) {
        Container obj1;
        Container obj;
        Component focusOwner;
        if (window == null) {
            UIUtil.$$$reportNull$$$0(318);
        }
        if ((focusOwner = FocusManager.getCurrentManager().getFocusOwner()) == null || !SwingUtilities.isDescendingFrom(focusOwner, window)) {
            return;
        }
        if (focusOwner instanceof JFormattedTextField) {
            try {
                ((JFormattedTextField)focusOwner).commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((obj = focusOwner.getParent()) instanceof JTable) {
            TableUtil.stopEditing((JTable)obj);
        }
        if ((obj1 = focusOwner.getParent()) instanceof JTree) {
            ((JTree)obj1).stopEditing();
        }
    }

    public static String colorToHex(Color color) {
        return UIUtil.to2DigitsHex(color.getRed()) + UIUtil.to2DigitsHex(color.getGreen()) + UIUtil.to2DigitsHex(color.getBlue());
    }

    private static String to2DigitsHex(int i2) {
        Object s = Integer.toHexString(i2);
        if (((String)s).length() < 2) {
            s = "0" + (String)s;
        }
        return s;
    }

    public static boolean isXServerOnWindows() {
        return SystemInfo.isXWindow && !SystemInfo.isWayland && System.getenv("WSLENV") != null;
    }

    public static void applyDeprecatedBackground(@NotNull JComponent component2) {
        Color color;
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(319);
        }
        if ((color = UIUtil.getDeprecatedBackground()) != null) {
            component2.setBackground(color);
            component2.setOpaque(true);
        }
    }

    @Nullable
    private static Color getDeprecatedBackground() {
        return Registry.getColor("ui.deprecated.components.color", null);
    }

    public static boolean isMetalRendering() {
        return SystemInfo.isMac && Boolean.getBoolean("sun.java2d.metal");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 52, 53, 55, 56, 57, 64, 66, 71, 72, 74, 76, 89, 90, 94, 97, 99, 100, 101, 102, 103, 104, 105, 108, 109, 110, 111, 112, 113, 114, 115, 117, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 156, 157, 158, 159, 160, 161, 162, 166, 167, 168, 175, 176, 178, 182, 183, 185, 187, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 208, 209, 210, 211, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 240, 241, 243, 244, 245, 246, 247, 248, 251, 253, 254, 255, 256, 257, 258, 263, 264, 265, 266, 267, 268, 272, 287, 288, 289, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 311, 312, 314, 315, 316, 317, 318, 319 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 9: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: 
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 37: 
            case 38: 
            case 76: 
            case 97: 
            case 123: 
            case 125: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 145: 
            case 146: 
            case 147: 
            case 159: 
            case 160: 
            case 167: 
            case 194: 
            case 215: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 224: 
            case 226: 
            case 227: 
            case 229: 
            case 230: 
            case 235: 
            case 243: 
            case 254: 
            case 255: 
            case 258: 
            case 264: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 298: 
            case 301: 
            case 304: 
            case 319: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 18: 
            case 42: 
            case 45: 
            case 47: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: 
            case 182: 
            case 183: 
            case 185: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 25: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 199: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 39: 
            case 40: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 135: 
            case 306: 
            case 314: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 35: 
            case 161: 
            case 162: 
            case 175: 
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 46: 
            case 48: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 49: 
            case 50: 
            case 52: 
            case 57: 
            case 272: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontColor";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 64: 
            case 66: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyPrefix";
                break;
            }
            case 72: 
            case 89: 
            case 154: 
            case 166: 
            case 213: 
            case 241: 
            case 263: 
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slider";
                break;
            }
            case 90: 
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
            case 99: 
            case 316: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 121: 
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 122: 
            case 157: 
            case 158: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 133: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 134: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 141: 
            case 236: 
            case 237: 
            case 239: 
            case 318: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 143: 
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 189: 
            case 190: 
            case 192: 
            case 238: 
            case 240: 
            case 297: 
            case 299: 
            case 300: 
            case 303: 
            case 305: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 197: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 201: 
            case 291: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 208: 
            case 308: 
            case 311: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 210: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 216: 
            case 217: 
            case 218: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
            case 223: 
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 234: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 246: 
            case 257: 
            case 287: 
            case 289: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamProducer";
                break;
            }
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 256: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 266: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 267: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originGraphics";
                break;
            }
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingConsumer";
                break;
            }
            case 288: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
            case 292: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 302: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 307: 
            case 315: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 309: 
            case 312: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 317: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 64: 
            case 66: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 89: 
            case 90: 
            case 94: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 166: 
            case 167: 
            case 168: 
            case 175: 
            case 176: 
            case 178: 
            case 182: 
            case 183: 
            case 185: 
            case 187: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 251: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 272: 
            case 287: 
            case 288: 
            case 289: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 311: 
            case 312: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrayFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextGrayFilter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellColors";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlBody";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "splitText";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelFontColor";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelForeground";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelSuccessForeground";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorForeground";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelDisabledForeground";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelInfoForeground";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextHelpForeground";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMnemonic";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveTextColor";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipBackground";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipActionBackground";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipForeground";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelBackground";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorColor";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonInformationIcon";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonWarningIcon";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonErrorIcon";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeCollapsedIcon";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeExpandedIcon";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectedCollapsedIcon";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectedExpandedIcon";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarFont";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularPanelInsets";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCellPadding";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getListViewportPadding";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidFontNames";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardFontSizes";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "displayPropertiesToCSS";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchMatchGradientStartColor";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchMatchGradientEndColor";
                break;
            }
            case 116: 
            case 118: 
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 155: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgFillColor";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssFontDeclaration";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedBoundsColor";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundsColor";
                break;
            }
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderActiveColor";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedBorderColor";
                break;
            }
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderInactiveColor";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitledBorderFont";
                break;
            }
            case 173: 
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "getHTMLEditorKit";
                break;
            }
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontWithFallbackIfNeeded";
                break;
            }
            case 179: 
            case 180: 
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontWithFallback";
                break;
            }
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
            case 186: {
                objectArray = objectArray2;
                objectArray2[1] = "addPadding";
                break;
            }
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSpace2Nbsp";
                break;
            }
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "uiParents";
                break;
            }
            case 205: 
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "uiChildren";
                break;
            }
            case 207: {
                objectArray = objectArray2;
                objectArray2[1] = "uiTraverser";
                break;
            }
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentsOfType";
                break;
            }
            case 232: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecoratedRowColor";
                break;
            }
            case 242: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugText";
                break;
            }
            case 249: {
                objectArray = objectArray2;
                objectArray2[1] = "leftArrow";
                break;
            }
            case 250: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
            case 252: {
                objectArray = objectArray2;
                objectArray2[1] = "upArrow";
                break;
            }
            case 259: 
            case 260: 
            case 261: 
            case 262: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentStyle";
                break;
            }
            case 269: {
                objectArray = objectArray2;
                objectArray2[1] = "getListFont";
                break;
            }
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "getListBackground";
                break;
            }
            case 271: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionBackground";
                break;
            }
            case 273: {
                objectArray = objectArray2;
                objectArray2[1] = "updateListRowHeight";
                break;
            }
            case 274: 
            case 276: {
                objectArray = objectArray2;
                objectArray2[1] = "getListForeground";
                break;
            }
            case 275: 
            case 277: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionForeground";
                break;
            }
            case 278: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeFont";
                break;
            }
            case 279: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeBackground";
                break;
            }
            case 280: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionBackground";
                break;
            }
            case 281: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeForeground";
                break;
            }
            case 282: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionForeground";
                break;
            }
            case 283: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableBackground";
                break;
            }
            case 284: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionBackground";
                break;
            }
            case 285: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableForeground";
                break;
            }
            case 286: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionForeground";
                break;
            }
            case 290: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipSeparatorColor";
                break;
            }
            case 310: 
            case 313: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterPoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleOwner";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyStyle";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCellColors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fixOSXEditorBackground";
                break;
            }
            case 9: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "isRetina";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getWindowClientProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putWindowClientProperty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isClientPropertyTrue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 18: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlBody";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "drawLinePickedOut";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isReallyTypedEvent";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getStringY";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "drawLabelDottedRectangle";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLabelTextBounds";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getHighestGlyphHeight";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "drawLine";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "drawWave";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "splitText";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setActionNameAndMnemonic";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "assignMnemonic";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFont";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getFontSize";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFontColor";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxTextHorizontalOffset";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getButtonTextHorizontalOffset";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "removeMnemonic";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMnemonicIndex";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyMaxGutterIconWidth";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getTabbedPanePaintContentBorder";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "setSliderIsFilled";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "setLineStyleAngled";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "shade";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isControlKeyDown";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "setupEnclosingDialogBounds";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "appendColor";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedRectangle";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "drawBoldDottedLine";
                break;
            }
            case 105: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "drawSearchMatch";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "drawBoringDottedLine";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "drawGradientHToolbarBackground";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "drawHeader";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "drawDoubleSpaceDottedLine";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "drawAppleDottedLine";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "applyRenderingHints";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "setupComposite";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "addAwtListener";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "addParentChangeListener";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "removeParentChangeListener";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "drawVDottedLine";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "drawHDottedLine";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedLine";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "drawStringWithHighlighting";
                break;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "drawCenteredString";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "isFocusAncestor";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "setFosterParent";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "validateFosterParent";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralizedAncestor";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "kindaHasFocus";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "hasFocus";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "markAsFocused";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "isCloseClick";
                break;
            }
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "isActionClick";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "getAllModifiers";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "getBgFillColor";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAt";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAtForComponent";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "layoutRecursively";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "getCssFontDeclaration";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "canDisplayFocusedState";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "disposeProgress";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallbackIfNeeded";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "addPadding";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "convertSpace2Nbsp";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "maybeInstall";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "changeBackGround";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "getComboBoxPopup";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "fixFormattedField";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedButton";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedButton";
                break;
            }
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionButtonDown";
                break;
            }
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "isToggleListSelectionEvent";
                break;
            }
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "setComboBoxEditorBounds";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "isDescendingFrom";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "addNotInHierarchyComponents";
                break;
            }
            case 210: {
                objectArray = objectArray;
                objectArray[2] = "scrollListToVisibleIfNeeded";
                break;
            }
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "findComponentsOfType";
                break;
            }
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "setFutureRootPane";
                break;
            }
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "runWhenVisibilityChanged";
                break;
            }
            case 216: 
            case 217: 
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "mergeComponentsWithAnchor";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "setOpaqueRecursively";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "setEnabledRecursively";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundRecursively";
                break;
            }
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "setForegroundRecursively";
                break;
            }
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "setTooltipRecursively";
                break;
            }
            case 227: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "forEachComponentInHierarchy";
                break;
            }
            case 229: 
            case 230: 
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 233: 
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "getGradientPaint";
                break;
            }
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "getLocationOnScreen";
                break;
            }
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "setAutoRequestFocus";
                break;
            }
            case 237: 
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "runWhenWindowOpened";
                break;
            }
            case 239: 
            case 240: {
                objectArray = objectArray;
                objectArray[2] = "runWhenWindowClosed";
                break;
            }
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "getDebugText";
                break;
            }
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "getAllTextsRecursively";
                break;
            }
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "addUndoRedoActions";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromResource";
                break;
            }
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromStream";
                break;
            }
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericFormattedTextField";
                break;
            }
            case 254: {
                objectArray = objectArray;
                objectArray[2] = "hasScrollPane";
                break;
            }
            case 255: 
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "hasComponentOfType";
                break;
            }
            case 257: 
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "getLineHeight";
                break;
            }
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "repaintViewport";
                break;
            }
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "findWindowAncestor";
                break;
            }
            case 267: 
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "useSafely";
                break;
            }
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "updateListRowHeight";
                break;
            }
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "doNotScrollToCaret";
                break;
            }
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "convertToLabel";
                break;
            }
            case 289: {
                objectArray = objectArray;
                objectArray[2] = "enableEagerSoftWrapping";
                break;
            }
            case 291: 
            case 292: {
                objectArray = objectArray;
                objectArray[2] = "scrollToReference";
                break;
            }
            case 293: 
            case 294: {
                objectArray = objectArray;
                objectArray[2] = "isShowing";
                break;
            }
            case 295: {
                objectArray = objectArray;
                objectArray[2] = "markAsShowing";
                break;
            }
            case 296: 
            case 297: {
                objectArray = objectArray;
                objectArray[2] = "runWhenFocused";
                break;
            }
            case 298: 
            case 299: 
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "runWhenHidden";
                break;
            }
            case 301: 
            case 302: 
            case 303: {
                objectArray = objectArray;
                objectArray[2] = "runWhenChanged";
                break;
            }
            case 304: 
            case 305: {
                objectArray = objectArray;
                objectArray[2] = "runOnceWhenResized";
                break;
            }
            case 306: 
            case 307: 
            case 314: 
            case 315: {
                objectArray = objectArray;
                objectArray[2] = "drawImage";
                break;
            }
            case 308: 
            case 309: 
            case 311: 
            case 312: {
                objectArray = objectArray;
                objectArray[2] = "getCenterPoint";
                break;
            }
            case 316: 
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "makeTransparent";
                break;
            }
            case 318: {
                objectArray = objectArray;
                objectArray[2] = "stopFocusedEditing";
                break;
            }
            case 319: {
                objectArray = objectArray;
                objectArray[2] = "applyDeprecatedBackground";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 52, 53, 55, 56, 57, 64, 66, 71, 72, 74, 76, 89, 90, 94, 97, 99, 100, 101, 102, 103, 104, 105, 108, 109, 110, 111, 112, 113, 114, 115, 117, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 156, 157, 158, 159, 160, 161, 162, 166, 167, 168, 175, 176, 178, 182, 183, 185, 187, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 208, 209, 210, 211, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 240, 241, 243, 244, 245, 246, 247, 248, 251, 253, 254, 255, 256, 257, 258, 263, 264, 265, 266, 267, 268, 272, 287, 288, 289, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 311, 312, 314, 315, 316, 317, 318, 319 -> new IllegalArgumentException(string2);
        };
    }

    public static enum ComponentStyle {
        LARGE,
        REGULAR,
        SMALL,
        MINI;

    }

    public static enum FontSize {
        NORMAL,
        SMALL,
        MINI;

    }

    public static class GrayFilter
    extends RGBImageFilter {
        private float brightness;
        private float contrast;
        private int alpha;
        private int origContrast;
        private int origBrightness;

        public GrayFilter(int brightness, int contrast, int alpha) {
            this.setBrightness(brightness);
            this.setContrast(contrast);
            this.setAlpha(alpha);
        }

        public GrayFilter() {
            this(0, 0, 100);
        }

        private void setBrightness(int brightness) {
            this.origBrightness = Math.max(-100, Math.min(100, brightness));
            this.brightness = (float)(Math.pow(this.origBrightness, 3.0) / 10000.0);
        }

        public int getBrightness() {
            return this.origBrightness;
        }

        private void setContrast(int contrast) {
            this.origContrast = Math.max(-100, Math.min(100, contrast));
            this.contrast = (float)this.origContrast / 100.0f;
        }

        public int getContrast() {
            return this.origContrast;
        }

        private void setAlpha(int alpha) {
            this.alpha = Math.max(0, Math.min(100, alpha));
        }

        public int getAlpha() {
            return this.alpha;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = (int)(0.3 * (double)(rgb >> 16 & 0xFF) + 0.59 * (double)(rgb >> 8 & 0xFF) + 0.11 * (double)(rgb & 0xFF));
            gray = this.brightness >= 0.0f ? (int)(((float)gray + this.brightness * 255.0f) / (1.0f + this.brightness)) : (int)((float)gray / (1.0f - this.brightness));
            gray = this.contrast >= 0.0f ? (gray >= 127 ? (int)((float)gray + (float)(255 - gray) * this.contrast) : (int)((float)gray - (float)gray * this.contrast)) : (int)(127.0f + (float)(gray - 127) * (this.contrast + 1.0f));
            int a = (rgb >> 24 & 0xFF) * this.alpha / 100;
            return a << 24 | gray << 16 | gray << 8 | gray;
        }

        @NotNull
        public GrayFilterUIResource asUIResource() {
            return new GrayFilterUIResource(this);
        }

        @NotNull
        public static GrayFilter namedFilter(@NotNull String resourceName, @NotNull GrayFilter defaultFilter) {
            if (resourceName == null) {
                GrayFilter.$$$reportNull$$$0(0);
            }
            if (defaultFilter == null) {
                GrayFilter.$$$reportNull$$$0(1);
            }
            GrayFilter grayFilter = Objects.requireNonNullElse((GrayFilter)UIManager.get(resourceName), defaultFilter);
            if (grayFilter == null) {
                GrayFilter.$$$reportNull$$$0(2);
            }
            return grayFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/UIUtil$GrayFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/UIUtil$GrayFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "namedFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "namedFilter";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }

        public static class GrayFilterUIResource
        extends GrayFilter
        implements UIResource {
            public GrayFilterUIResource(@NotNull GrayFilter filter2) {
                if (filter2 == null) {
                    GrayFilterUIResource.$$$reportNull$$$0(0);
                }
                super(filter2.origBrightness, filter2.origContrast, filter2.alpha);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/UIUtil$GrayFilter$GrayFilterUIResource", "<init>"));
            }
        }
    }

    public static enum FontColor {
        NORMAL,
        BRIGHTER;

    }

    public static class TextPainter {
        private final List<String> myLines = new ArrayList<String>();
        private boolean myDrawShadow = StartupUiUtil.isUnderDarcula();
        private Color myShadowColor = StartupUiUtil.isUnderDarcula() ? Gray._0.withAlpha(100) : Gray._220;
        private float myLineSpacing = 1.0f;
        private Font myFont;
        private Color myColor;

        @NotNull
        public TextPainter withShadow(boolean drawShadow, Color shadowColor) {
            this.myDrawShadow = drawShadow;
            this.myShadowColor = shadowColor;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(0);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withLineSpacing(float lineSpacing) {
            this.myLineSpacing = lineSpacing;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(1);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withColor(Color color) {
            this.myColor = color;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(2);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withFont(Font font) {
            this.myFont = font;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(3);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter appendLine(String text2) {
            if (text2 == null || text2.isEmpty()) {
                TextPainter textPainter = this;
                if (textPainter == null) {
                    TextPainter.$$$reportNull$$$0(4);
                }
                return textPainter;
            }
            this.myLines.add(text2);
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(5);
            }
            return textPainter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(@NotNull Graphics g, @NotNull PairFunction<? super Integer, ? super Integer, ? extends Couple<Integer>> _position) {
            if (g == null) {
                TextPainter.$$$reportNull$$$0(6);
            }
            if (_position == null) {
                TextPainter.$$$reportNull$$$0(7);
            }
            Font oldFont = null;
            if (this.myFont != null) {
                oldFont = g.getFont();
                g.setFont(this.myFont);
            }
            Color oldColor = null;
            if (this.myColor != null) {
                oldColor = g.getColor();
                g.setColor(this.myColor);
            }
            try {
                int[] maxWidth = new int[]{0};
                int[] height = new int[]{0};
                ContainerUtil.process(this.myLines, text2 -> {
                    FontMetrics fm = g.getFontMetrics();
                    maxWidth[0] = Math.max(fm.stringWidth(text2.replace("<shortcut>", UIUtil.NO_BORDER_UNDER_WINDOW_TITLE_KEY).replace("</shortcut>", UIUtil.NO_BORDER_UNDER_WINDOW_TITLE_KEY)), maxWidth[0]);
                    height[0] = (int)((float)height[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    return true;
                });
                Couple<Integer> position = _position.fun((Integer)(maxWidth[0] + 20), (Integer)height[0]);
                assert (position != null);
                int[] yOffset = new int[]{(Integer)position.getSecond()};
                ContainerUtil.process(this.myLines, text2 -> {
                    String shortcut = UIUtil.NO_BORDER_UNDER_WINDOW_TITLE_KEY;
                    if (text2.contains("<shortcut>")) {
                        shortcut = text2.substring(text2.indexOf("<shortcut>") + "<shortcut>".length(), text2.indexOf("</shortcut>"));
                        text2 = text2.substring(0, text2.indexOf("<shortcut>"));
                    }
                    int x = (Integer)position.getFirst() + 10;
                    FontMetrics fm = g.getFontMetrics();
                    if (this.myDrawShadow) {
                        int xOff = StartupUiUtil.isUnderDarcula() ? 1 : 0;
                        Color oldColor1 = g.getColor();
                        g.setColor(this.myShadowColor);
                        int yOff = 1;
                        g.drawString((String)text2, x + xOff, yOffset[0] + yOff);
                        g.setColor(oldColor1);
                    }
                    g.drawString((String)text2, x, yOffset[0]);
                    if (!StringUtil.isEmpty(shortcut)) {
                        Color oldColor1 = g.getColor();
                        g.setColor(JBColor.namedColor("Editor.shortcutForeground", new JBColor(new Color(82, 99, 155), new Color(88, 157, 246))));
                        g.drawString(shortcut, x + fm.stringWidth(text2 + (StartupUiUtil.isUnderDarcula() ? " " : UIUtil.NO_BORDER_UNDER_WINDOW_TITLE_KEY)), yOffset[0]);
                        g.setColor(oldColor1);
                    }
                    yOffset[0] = (int)((float)yOffset[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    return true;
                });
            }
            finally {
                if (oldFont != null) {
                    g.setFont(oldFont);
                }
                if (oldColor != null) {
                    g.setColor(oldColor);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/UIUtil$TextPainter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_position";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withShadow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withLineSpacing";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withColor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withFont";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendLine";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/UIUtil$TextPainter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "draw";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 6, 7 -> new IllegalArgumentException(string2);
            };
        }
    }

    @Deprecated
    public static final class JBWordWrapHtmlEditorKit
    extends JBHtmlEditorKit {
        @Override
        public ViewFactory getViewFactory() {
            return ExtendableHTMLViewFactory.DEFAULT_WORD_WRAP;
        }
    }
}

