/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public final class UpDownHandler {
    private static final CustomShortcutSet UP_KEY = CustomShortcutSet.fromString((String[])new String[]{"UP"});
    private static final CustomShortcutSet DOWN_KEY = CustomShortcutSet.fromString((String[])new String[]{"DOWN"});

    private UpDownHandler() {
    }

    public static void register(JComponent input, JComponent affectedComponent) {
        UpDownHandler.register(input, affectedComponent, true);
    }

    public static void register(JComponent input, JComponent affectedComponent, boolean registerOnBothComponents) {
        SelectionMover mover = new SelectionMover(affectedComponent);
        UpDownAction up = new UpDownAction(mover, input, true);
        up.registerCustomShortcutSet((ShortcutSet)UP_KEY, input);
        UpDownAction down = new UpDownAction(mover, input, false);
        down.registerCustomShortcutSet((ShortcutSet)DOWN_KEY, input);
        if (registerOnBothComponents) {
            up.registerCustomShortcutSet((ShortcutSet)UP_KEY, affectedComponent);
            down.registerCustomShortcutSet((ShortcutSet)DOWN_KEY, affectedComponent);
        }
    }

    private static final class SelectionMover {
        private JComboBox myCombo;
        private JList myList;

        private SelectionMover(JComponent comp) {
            if (comp instanceof JComboBox) {
                this.myCombo = (JComboBox)comp;
            } else if (comp instanceof JList) {
                this.myList = (JList)comp;
            }
        }

        void move(int direction) {
            int index2 = -1;
            int size = 0;
            if (this.myCombo != null) {
                index2 = this.myCombo.getSelectedIndex();
                size = this.myCombo.getModel().getSize();
            } else if (this.myList != null) {
                index2 = this.myList.getSelectedIndex();
                size = this.myList.getModel().getSize();
            }
            if (index2 == -1 || size == 0) {
                return;
            }
            if ((index2 += direction) == size) {
                if (!UISettings.getInstance().getCycleScrolling()) {
                    return;
                }
                index2 = 0;
            } else if (index2 == -1) {
                if (!UISettings.getInstance().getCycleScrolling()) {
                    return;
                }
                index2 = size - 1;
            }
            if (this.myCombo != null) {
                this.myCombo.setSelectedIndex(index2);
            } else if (this.myList != null) {
                this.myList.setSelectedIndex(index2);
            }
        }
    }

    static class UpDownAction
    extends AnAction {
        private final int myDirection;
        private final SelectionMover myMover;
        private final JComponent myInput;

        UpDownAction(SelectionMover mover, JComponent input, boolean isUp) {
            super(isUp ? LangBundle.message("action.UpDownAction.up.text", new Object[0]) : LangBundle.message("action.UpDownAction.down.text", new Object[0]));
            this.myMover = mover;
            this.myInput = input;
            this.myDirection = isUp ? -1 : 1;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UpDownAction.$$$reportNull$$$0(0);
            }
            this.myMover.move(this.myDirection);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                UpDownAction.$$$reportNull$$$0(1);
            }
            LookupEx lookup2 = this.myInput instanceof EditorTextField ? LookupManager.getActiveLookup(((EditorTextField)this.myInput).getEditor()) : (this.myInput instanceof EditorComponentImpl ? LookupManager.getActiveLookup((Editor)((EditorComponentImpl)this.myInput).getEditor()) : null);
            JComboBox comboBox = UIUtil.findComponentOfType(this.myInput, JComboBox.class);
            boolean popupMenuVisible = comboBox != null && comboBox.isPopupVisible();
            e.getPresentation().setEnabled(lookup2 == null && !popupMenuVisible);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                UpDownAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/UpDownHandler$UpDownAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/UpDownHandler$UpDownAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

