/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.html;

import com.intellij.icons.AllIcons;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.text.Element;
import javax.swing.text.html.ImageView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/ui/html/HiDpiScalingImageView;", "Ljavax/swing/text/html/ImageView;", "elem", "Ljavax/swing/text/Element;", "(Ljavax/swing/text/Element;)V", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "getScaleContext", "()Lcom/intellij/ui/scale/ScaleContext;", "sysScale", "", "getSysScale", "()F", "getLoadingImageIcon", "Ljavax/swing/Icon;", "getMaximumSpan", "axis", "", "getMinimumSpan", "getPreferredSpan", "paint", "", "g", "Ljava/awt/Graphics;", "a", "Ljava/awt/Shape;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nHiDpiScalingImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiDpiScalingImageView.kt\ncom/intellij/util/ui/html/HiDpiScalingImageView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class HiDpiScalingImageView
extends ImageView {
    public HiDpiScalingImageView(@NotNull Element elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        super(elem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ScaleContext getScaleContext() {
        Container container = this.getContainer();
        Container container2 = container;
        if (container == null) return null;
        Container container3 = container2;
        Component p0 = container3;
        boolean bl = false;
        if (!StartupUiUtil.isJreHiDPI(p0)) return null;
        Container container4 = container3;
        container2 = container4;
        if (container4 == null) return null;
        p0 = container2;
        boolean bl2 = false;
        ScaleContext scaleContext = ScaleContext.create(p0);
        return scaleContext;
    }

    private final float getSysScale() {
        ScaleContext scaleContext = this.getScaleContext();
        return scaleContext != null ? (float)scaleContext.getScale(ScaleType.SYS_SCALE) : 1.0f;
    }

    @Override
    public float getMaximumSpan(int axis) {
        return super.getMaximumSpan(axis) / this.getSysScale();
    }

    @Override
    public float getMinimumSpan(int axis) {
        return super.getMinimumSpan(axis) / this.getSysScale();
    }

    @Override
    public float getPreferredSpan(int axis) {
        return super.getPreferredSpan(axis) / this.getSysScale();
    }

    @Override
    @NotNull
    public Icon getLoadingImageIcon() {
        Icon icon2 = AllIcons.Process.Step_passive;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Step_passive");
        return icon2;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull Shape a) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        ScaleContext scaleContext = this.getScaleContext();
        if (scaleContext == null) {
            super.paint(g, a);
            return;
        }
        Rectangle bounds = a.getBounds();
        double width = super.getPreferredSpan(0);
        double height = super.getPreferredSpan(1);
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        BufferedImage bufferedImage = ImageUtil.createImage(ScaleContext.createIdentity(), width, height, 2, PaintUtil.RoundingMode.ROUND);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(ScaleContext\u2026tUtil.RoundingMode.ROUND)");
        BufferedImage image = bufferedImage;
        Graphics2D graphics = image.createGraphics();
        super.paint(graphics, new Rectangle(image.getWidth(), image.getHeight()));
        StartupUiUtil.drawImage(g, ImageUtil.ensureHiDPI(image, scaleContext), bounds.x, bounds.y, null);
    }
}

