/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.ManageRepoDialog;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementUsageCollector;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.intellij.webcore.packaging.RepoPackage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManagePackagesDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ManagePackagesDialog.class);
    @NotNull
    private final Project myProject;
    private final PackageManagementService myController;
    private JPanel myFilter;
    private JPanel myMainPanel;
    private JEditorPane myDescriptionTextArea;
    private final JBList myPackages;
    private JButton myInstallButton;
    private JCheckBox myOptionsCheckBox;
    private JTextField myOptionsField;
    private JCheckBox myInstallToUser;
    private JComboBox myVersionComboBox;
    private JCheckBox myVersionCheckBox;
    private JButton myManageButton;
    private final PackagesNotificationPanel myNotificationArea;
    private JSplitPane mySplitPane;
    private JPanel myNotificationsAreaPlaceholder;
    private PackagesModel myPackagesModel;
    private String mySelectedPackageName;
    private final Set<String> myInstalledPackages;
    @Nullable
    private final PackageManagementService.Listener myPackageListener;
    private final Set<String> myCurrentlyInstalling;
    protected final ListSpeedSearch myListSpeedSearch;

    public ManagePackagesDialog(@NotNull Project project2, PackageManagementService packageManagementService, @Nullable PackageManagementService.Listener packageListener) {
        if (project2 == null) {
            ManagePackagesDialog.$$$reportNull$$$0(0);
        }
        this(project2, packageManagementService, packageListener, new PackagesNotificationPanel());
    }

    public ManagePackagesDialog(@NotNull Project project2, PackageManagementService packageManagementService, @Nullable PackageManagementService.Listener packageListener, @NotNull PackagesNotificationPanel notificationPanel) {
        if (project2 == null) {
            ManagePackagesDialog.$$$reportNull$$$0(1);
        }
        if (notificationPanel == null) {
            ManagePackagesDialog.$$$reportNull$$$0(2);
        }
        super(project2, true);
        this.$$$setupUI$$$();
        this.myCurrentlyInstalling = new HashSet<String>();
        this.myProject = project2;
        this.myController = packageManagementService;
        this.myPackageListener = packageListener;
        this.init();
        this.setTitle(IdeBundle.message((String)"available.packages.dialog.title", (Object[])new Object[0]));
        this.myPackages = new JBList();
        this.myNotificationArea = notificationPanel;
        this.myNotificationsAreaPlaceholder.add((Component)this.myNotificationArea.getComponent(), "Center");
        AnActionButton reloadButton = new AnActionButton(IdeBundle.messagePointer((String)"action.AnActionButton.text.reload.list.of.packages", (Object[])new Object[0]), AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ManagePackagesDialog.this.myPackages.setPaintBusy(true);
                Application application = ApplicationManager.getApplication();
                application.executeOnPooledThread(() -> {
                    try {
                        ManagePackagesDialog.this.myController.reloadAllPackages();
                        ManagePackagesDialog.this.initModel();
                        ManagePackagesDialog.this.myPackages.setPaintBusy(false);
                    }
                    catch (IOException e1) {
                        application.invokeLater(() -> {
                            Messages.showErrorDialog((Component)ManagePackagesDialog.this.myMainPanel, (String)IdeBundle.message((String)"error.updating.package.list", (Object[])new Object[]{e1.getMessage()}), (String)IdeBundle.message((String)"action.AnActionButton.text.reload.list.of.packages", (Object[])new Object[0]));
                            LOG.info("Error updating list of repository packages", e1);
                            ManagePackagesDialog.this.myPackages.setPaintBusy(false);
                        }, ModalityState.any());
                    }
                });
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/webcore/packaging/ManagePackagesDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/webcore/packaging/ManagePackagesDialog$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        };
        this.myListSpeedSearch = new ListSpeedSearch((JList)this.myPackages, o -> {
            if (o instanceof RepoPackage) {
                return ((RepoPackage)o).getName();
            }
            return "";
        });
        JPanel packagesPanel = ToolbarDecorator.createDecorator((JList)this.myPackages).disableAddAction().disableUpDownActions().disableRemoveAction().addExtraAction(reloadButton).createPanel();
        packagesPanel.setPreferredSize(new Dimension(JBUIScale.scale(400), -1));
        packagesPanel.setMinimumSize(new Dimension(JBUIScale.scale(100), -1));
        this.myPackages.setFixedCellWidth(0);
        this.myPackages.setFixedCellHeight(JBUIScale.scale(22));
        this.myPackages.setSelectionMode(0);
        this.mySplitPane.setLeftComponent(packagesPanel);
        this.myPackages.addListSelectionListener((ListSelectionListener)new MyPackageSelectionListener());
        this.myInstallToUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ManagePackagesDialog.this.myController.installToUserChanged(ManagePackagesDialog.this.myInstallToUser.isSelected());
            }
        });
        this.myOptionsCheckBox.setEnabled(false);
        this.myVersionCheckBox.setEnabled(false);
        this.myVersionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ManagePackagesDialog.this.myVersionComboBox.setEnabled(ManagePackagesDialog.this.myVersionCheckBox.isSelected());
            }
        });
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myPackages, this::initModel);
        this.myOptionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ManagePackagesDialog.this.myOptionsField.setEnabled(ManagePackagesDialog.this.myOptionsCheckBox.isSelected());
            }
        });
        this.myInstallButton.setEnabled(false);
        this.myDescriptionTextArea.addHyperlinkListener((HyperlinkListener)new PluginManagerMain.MyHyperlinkListener());
        this.addInstallAction();
        this.myInstalledPackages = new HashSet<String>();
        this.updateInstalledPackages();
        this.addManageAction();
        this.myPackages.setCellRenderer((ListCellRenderer)new MyTableRenderer());
        if (this.myController.canInstallToUser()) {
            this.myInstallToUser.setVisible(true);
            this.myInstallToUser.setSelected(this.myController.isInstallToUserSelected());
            this.myInstallToUser.setText(this.myController.getInstallToUserText());
        } else {
            this.myInstallToUser.setVisible(false);
        }
        this.myMainPanel.setPreferredSize(new Dimension(JBUIScale.scale(900), JBUIScale.scale(700)));
    }

    public void selectPackage(@NotNull InstalledPackage pkg) {
        if (pkg == null) {
            ManagePackagesDialog.$$$reportNull$$$0(3);
        }
        this.mySelectedPackageName = pkg.getName();
        this.doSelectPackage(this.mySelectedPackageName);
    }

    private void addManageAction() {
        if (this.myController.canManageRepositories()) {
            this.myManageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ManageRepoDialog dialog = new ManageRepoDialog(ManagePackagesDialog.this.myProject, ManagePackagesDialog.this.myController);
                    dialog.show();
                }
            });
        } else {
            this.myManageButton.setVisible(false);
        }
    }

    private void addInstallAction() {
        this.myInstallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object pyPackage = ManagePackagesDialog.this.myPackages.getSelectedValue();
                if (pyPackage instanceof RepoPackage) {
                    RepoPackage repoPackage = (RepoPackage)pyPackage;
                    String extraOptions = null;
                    if (ManagePackagesDialog.this.myOptionsCheckBox.isEnabled() && ManagePackagesDialog.this.myOptionsCheckBox.isSelected()) {
                        extraOptions = ManagePackagesDialog.this.myOptionsField.getText();
                    }
                    String version = null;
                    if (ManagePackagesDialog.this.myVersionCheckBox.isEnabled() && ManagePackagesDialog.this.myVersionCheckBox.isSelected()) {
                        version = (String)ManagePackagesDialog.this.myVersionComboBox.getSelectedItem();
                    }
                    PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                        @Override
                        public void operationStarted(String packageName) {
                            if (!ApplicationManager.getApplication().isDispatchThread()) {
                                ApplicationManager.getApplication().invokeLater(() -> ManagePackagesDialog.this.handleInstallationStarted(packageName), ModalityState.stateForComponent(ManagePackagesDialog.this.myMainPanel));
                            } else {
                                ManagePackagesDialog.this.handleInstallationStarted(packageName);
                            }
                        }

                        @Override
                        public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                            if (!ApplicationManager.getApplication().isDispatchThread()) {
                                ApplicationManager.getApplication().invokeLater(() -> ManagePackagesDialog.this.handleInstallationFinished(packageName, errorDescription), ModalityState.stateForComponent(ManagePackagesDialog.this.myMainPanel));
                            } else {
                                ManagePackagesDialog.this.handleInstallationFinished(packageName, errorDescription);
                            }
                        }
                    };
                    ManagePackagesDialog.this.myController.installPackage(repoPackage, version, false, extraOptions, listener2, ManagePackagesDialog.this.myInstallToUser.isSelected());
                    ManagePackagesDialog.this.myInstallButton.setEnabled(false);
                }
                PackageManagementUsageCollector.triggerInstallPerformed(ManagePackagesDialog.this.myProject, ManagePackagesDialog.this.myController);
            }
        });
    }

    private void handleInstallationStarted(String packageName) {
        this.myNotificationArea.hide();
        this.setDownloadStatus(true);
        this.myCurrentlyInstalling.add(packageName);
        if (this.myPackageListener != null) {
            this.myPackageListener.operationStarted(packageName);
        }
        this.myPackages.repaint();
    }

    private void handleInstallationFinished(String packageName, PackageManagementService.ErrorDescription errorDescription) {
        if (this.myPackageListener != null) {
            this.myPackageListener.operationFinished(packageName, errorDescription);
        }
        this.setDownloadStatus(false);
        this.myNotificationArea.showResult(packageName, errorDescription);
        this.updateInstalledPackages();
        this.myCurrentlyInstalling.remove(packageName);
        this.myPackages.repaint();
    }

    private void updateInstalledPackages() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List<String> installedPackages = ContainerUtil.map(this.myController.getInstalledPackagesList(), InstalledPackage::getName);
                UIUtil.invokeLaterIfNeeded(() -> {
                    this.myInstalledPackages.clear();
                    this.myInstalledPackages.addAll(installedPackages);
                });
            }
            catch (ExecutionException e) {
                LOG.info("Error updating list of installed packages", e);
            }
        });
    }

    public void initModel() {
        this.setDownloadStatus(true);
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            try {
                this.myPackagesModel = new PackagesModel(this.myController.getAllPackages());
                application.invokeLater(() -> {
                    this.myPackages.setModel((ListModel)this.myPackagesModel);
                    ((MyPackageFilter)((Object)((Object)((Object)this.myFilter)))).filter();
                    this.doSelectPackage(this.mySelectedPackageName);
                    this.setDownloadStatus(false);
                }, ModalityState.any());
            }
            catch (IOException e) {
                application.invokeLater(() -> {
                    if (this.myMainPanel.isShowing()) {
                        Messages.showErrorDialog((Component)this.myMainPanel, (String)IdeBundle.message((String)"error.loading.package.list", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"packages.title", (Object[])new Object[0]));
                    }
                    LOG.info("Error initializing model", e);
                    this.setDownloadStatus(false);
                }, ModalityState.any());
            }
        });
    }

    private void doSelectPackage(@Nullable String packageName) {
        PackagesModel packagesModel = ObjectUtils.tryCast(this.myPackages.getModel(), PackagesModel.class);
        if (packageName == null || packagesModel == null) {
            return;
        }
        for (int i2 = 0; i2 < packagesModel.getSize(); ++i2) {
            RepoPackage repoPackage = packagesModel.getElementAt(i2);
            if (!packageName.equals(repoPackage.getName())) continue;
            this.myPackages.setSelectedIndex(i2);
            this.myPackages.ensureIndexIsVisible(i2);
            break;
        }
    }

    protected void setDownloadStatus(boolean status) {
        this.myPackages.setPaintBusy(status);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myFilter = new MyPackageFilter();
        this.myDescriptionTextArea = SwingHelper.createHtmlViewer((boolean)true, null, null, null);
    }

    public void setOptionsText(@NotNull String optionsText) {
        if (optionsText == null) {
            ManagePackagesDialog.$$$reportNull$$$0(4);
        }
        this.myOptionsField.setText(optionsText);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return ((FilterComponent)this.myFilter).getTextEditor();
    }

    protected Action @NotNull [] createActions() {
        return new Action[0];
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JButton jButton;
        JButton jButton2;
        JComboBox jComboBox;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JSplitPane jSplitPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = this.myFilter;
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 2, 0, null, new Dimension(-1, 30), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(false);
        jPanel4.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jSplitPane.setRightComponent(jPanel5);
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder(null, (String)DynamicBundle.getBundle("messages/IdeBundle", ManagePackagesDialog.class).getString("editbox.plugin.description"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 5, 0, 3, 3, 3, null, new Dimension(300, -1), null));
        JEditorPane jEditorPane = this.myDescriptionTextArea;
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setMaximumSize(new Dimension(-1, -1));
        jBScrollPane.setViewportView(jEditorPane);
        this.myVersionCheckBox = jCheckBox3 = new JCheckBox();
        ((Component)jCheckBox3).setEnabled(true);
        jCheckBox3.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle("messages/LangBundle", ManagePackagesDialog.class).getString("checkbox.package.specify.version"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptionsCheckBox = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(true);
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle("messages/LangBundle", ManagePackagesDialog.class).getString("checkbox.package.options"));
        jPanel5.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptionsField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel5.add((Component)jTextField, new GridConstraints(2, 1, 1, 4, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        this.myVersionComboBox = jComboBox = new JComboBox();
        ((Component)jComboBox).setEnabled(false);
        jPanel5.add(jComboBox, new GridConstraints(1, 1, 1, 4, 8, 1, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInstallButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle("messages/LangBundle", ManagePackagesDialog.class).getString("button.install.package"));
        jPanel6.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myManageButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle("messages/LangBundle", ManagePackagesDialog.class).getString("button.manage.repositories"));
        jPanel6.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInstallToUser = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setSelected(false);
        jCheckBox.setText("");
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNotificationsAreaPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c2 = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/packaging/ManagePackagesDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "selectPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setOptionsText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyPackageSelectionListener
    implements ListSelectionListener {
        private MyPackageSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            ManagePackagesDialog.this.myOptionsCheckBox.setEnabled(ManagePackagesDialog.this.myPackages.getSelectedIndex() >= 0);
            ManagePackagesDialog.this.myVersionCheckBox.setEnabled(ManagePackagesDialog.this.myPackages.getSelectedIndex() >= 0);
            ManagePackagesDialog.this.myOptionsCheckBox.setSelected(false);
            ManagePackagesDialog.this.myVersionCheckBox.setSelected(false);
            ManagePackagesDialog.this.myVersionComboBox.setEnabled(false);
            ManagePackagesDialog.this.myOptionsField.setEnabled(false);
            ManagePackagesDialog.this.myDescriptionTextArea.setText(IdeBundle.message((String)"loading.in.progress", (Object[])new Object[0]));
            final Object pyPackage = ManagePackagesDialog.this.myPackages.getSelectedValue();
            if (pyPackage instanceof RepoPackage) {
                String packageName;
                ManagePackagesDialog.this.mySelectedPackageName = packageName = ((RepoPackage)pyPackage).getName();
                ManagePackagesDialog.this.myVersionComboBox.removeAllItems();
                if (ManagePackagesDialog.this.myVersionCheckBox.isEnabled()) {
                    ManagePackagesDialog.this.myController.fetchPackageVersions(packageName, (CatchingConsumer<? super List<String>, ? super Exception>)new CatchingConsumer<List<String>, Exception>(){

                        @Override
                        public void consume(List<@NlsSafe String> releases) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (ManagePackagesDialog.this.myPackages.getSelectedValue() == pyPackage) {
                                    ManagePackagesDialog.this.myVersionComboBox.removeAllItems();
                                    for (String release : releases) {
                                        ManagePackagesDialog.this.myVersionComboBox.addItem(release);
                                    }
                                }
                            }, ModalityState.any());
                        }

                        @Override
                        public void consume(Exception e) {
                            LOG.info("Error retrieving releases", e);
                        }
                    });
                }
                ManagePackagesDialog.this.myInstallButton.setEnabled(!ManagePackagesDialog.this.myCurrentlyInstalling.contains(packageName));
                ManagePackagesDialog.this.myController.fetchPackageDetails(packageName, (CatchingConsumer<? super String, ? super Exception>)new CatchingConsumer<String, Exception>(){

                    @Override
                    public void consume(@Nls String details2) {
                        UIUtil.invokeLaterIfNeeded(() -> {
                            if (ManagePackagesDialog.this.myPackages.getSelectedValue() == pyPackage) {
                                ManagePackagesDialog.this.myDescriptionTextArea.setText(details2);
                                ManagePackagesDialog.this.myDescriptionTextArea.setCaretPosition(0);
                            }
                        });
                    }

                    @Override
                    public void consume(Exception exception) {
                        UIUtil.invokeLaterIfNeeded(() -> ManagePackagesDialog.this.myDescriptionTextArea.setText(IdeBundle.message((String)"no.information.available", (Object[])new Object[0])));
                        LOG.info("Error retrieving package details", exception);
                    }
                });
            } else {
                ManagePackagesDialog.this.myInstallButton.setEnabled(false);
                ManagePackagesDialog.this.myDescriptionTextArea.setText("");
            }
        }
    }

    private final class MyTableRenderer
    implements ListCellRenderer<RepoPackage> {
        private final SimpleColoredComponent myNameComponent = new SimpleColoredComponent();
        private final SimpleColoredComponent myRepositoryComponent = new SimpleColoredComponent();
        private final JPanel myPanel = new JPanel(new BorderLayout());

        private MyTableRenderer() {
            this.myPanel.add((Component)this.myNameComponent, "West");
            this.myPanel.add((Component)this.myRepositoryComponent, "East");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends RepoPackage> list2, RepoPackage repoPackage, int index2, boolean isSelected, boolean cellHasFocus) {
            String repoUrl;
            this.myNameComponent.clear();
            this.myRepositoryComponent.clear();
            String packageName = repoPackage.getName();
            SimpleTextAttributes blueText = new SimpleTextAttributes(0, PlatformColors.BLUE);
            Color defaultForeground = isSelected ? list2.getSelectionForeground() : list2.getForeground();
            SimpleTextAttributes defaultText = new SimpleTextAttributes(0, defaultForeground);
            this.myNameComponent.append(packageName, ManagePackagesDialog.this.myInstalledPackages.contains(packageName) ? blueText : defaultText, true);
            if (ManagePackagesDialog.this.myCurrentlyInstalling.contains(packageName)) {
                this.myNameComponent.append(LangBundle.message("package.component.installing.suffix", new Object[0]), blueText, false);
            }
            if (StringUtil.isNotEmpty(repoUrl = repoPackage.getRepoUrl())) {
                this.myRepositoryComponent.append(repoUrl, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES, false);
            }
            if (isSelected) {
                this.myPanel.setBackground(list2.getSelectionBackground());
            } else {
                this.myPanel.setBackground(index2 % 2 == 1 ? UIUtil.getListBackground() : UIUtil.getDecoratedRowColor());
            }
            return this.myPanel;
        }
    }

    private class PackagesModel
    extends CollectionListModel<RepoPackage> {
        protected final List<RepoPackage> myFilteredOut;
        protected List<RepoPackage> myView;

        PackagesModel(List<RepoPackage> packages) {
            super(packages);
            this.myFilteredOut = new ArrayList<RepoPackage>();
            this.myView = new ArrayList<RepoPackage>();
            this.myView = packages;
        }

        public void add(String urlResource, String element) {
            super.add(new RepoPackage(element, urlResource));
        }

        protected void filter(String filter2) {
            ArrayList<RepoPackage> toProcess = this.toProcess();
            toProcess.addAll(this.myFilteredOut);
            this.myFilteredOut.clear();
            ArrayList<RepoPackage> filtered = new ArrayList<RepoPackage>();
            RepoPackage toSelect2 = null;
            for (RepoPackage repoPackage : toProcess) {
                String packageName = repoPackage.getName();
                if (StringUtil.containsIgnoreCase(packageName, filter2)) {
                    filtered.add(repoPackage);
                } else {
                    this.myFilteredOut.add(repoPackage);
                }
                if (!StringUtil.equalsIgnoreCase(packageName, filter2)) continue;
                toSelect2 = repoPackage;
            }
            this.filter(filtered, toSelect2);
        }

        public void filter(List<? extends RepoPackage> filtered, @Nullable RepoPackage toSelect2) {
            this.myView.clear();
            ManagePackagesDialog.this.myPackages.clearSelection();
            this.myView.addAll(filtered);
            if (toSelect2 != null) {
                ManagePackagesDialog.this.myPackages.setSelectedValue((Object)toSelect2, true);
            }
            Collections.sort(this.myView);
            this.fireContentsChanged(this, 0, this.myView.size());
        }

        @Override
        public RepoPackage getElementAt(int index2) {
            return this.myView.get(index2);
        }

        protected ArrayList<RepoPackage> toProcess() {
            return new ArrayList<RepoPackage>(this.myView);
        }

        @Override
        public int getSize() {
            return this.myView.size();
        }
    }

    private class MyPackageFilter
    extends FilterComponent {
        MyPackageFilter() {
            super("PACKAGE_FILTER", 5);
            this.getTextEditor().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        e.consume();
                        MyPackageFilter.this.filter();
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)ManagePackagesDialog.this.myPackages, true));
                    } else if (e.getKeyCode() == 27) {
                        MyPackageFilter.this.onEscape(e);
                    }
                }
            });
        }

        public void filter() {
            if (ManagePackagesDialog.this.myPackagesModel != null) {
                ManagePackagesDialog.this.myPackagesModel.filter(this.getFilter());
            }
        }
    }
}

