/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.CustomEntityProjectModelInfoProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.LibrarySourceRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleContentRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.PlatformInternalWorkspaceFileIndexContributor;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/CustomEntityProjectModelInfoProviderBridge;", "E", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PlatformInternalWorkspaceFileIndexContributor;", "provider", "Lcom/intellij/openapi/roots/impl/CustomEntityProjectModelInfoProvider;", "(Lcom/intellij/openapi/roots/impl/CustomEntityProjectModelInfoProvider;)V", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "registerFileSets", "", "entity", "registrar", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;Lcom/intellij/workspaceModel/storage/EntityStorage;)V", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nCustomEntityProjectModelInfoProviderBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomEntityProjectModelInfoProviderBridge.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/CustomEntityProjectModelInfoProviderBridge\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1295#2,2:51\n1295#2:53\n1296#2:60\n1295#2:61\n1296#2:64\n1855#3,2:54\n1855#3,2:56\n1855#3,2:58\n1855#3,2:62\n*S KotlinDebug\n*F\n+ 1 CustomEntityProjectModelInfoProviderBridge.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/CustomEntityProjectModelInfoProviderBridge\n*L\n19#1:51,2\n25#1:53\n25#1:60\n43#1:61\n43#1:64\n26#1:54,2\n29#1:56,2\n32#1:58,2\n44#1:62,2\n*E\n"})
public final class CustomEntityProjectModelInfoProviderBridge<E extends WorkspaceEntity>
implements WorkspaceFileIndexContributor<E>,
PlatformInternalWorkspaceFileIndexContributor {
    @NotNull
    private final CustomEntityProjectModelInfoProvider<E> provider;

    public CustomEntityProjectModelInfoProviderBridge(@NotNull CustomEntityProjectModelInfoProvider<E> provider2) {
        Intrinsics.checkNotNullParameter(provider2, (String)"provider");
        this.provider = provider2;
    }

    @Override
    @NotNull
    public Class<E> getEntityClass() {
        Class<E> clazz = this.provider.getEntityClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"provider.entityClass");
        return clazz;
    }

    @Override
    public void registerFileSets(@NotNull E entity, @NotNull WorkspaceFileSetRegistrar registrar, @NotNull EntityStorage storage) {
        VirtualFile it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Object[] objectArray = new WorkspaceEntity[]{entity};
        Sequence<CustomEntityProjectModelInfoProvider.CustomContentRoot<E>> sequence = this.provider.getContentRoots(SequencesKt.sequenceOf((Object[])objectArray), storage);
        Intrinsics.checkNotNullExpressionValue(sequence, (String)"provider.getContentRoots\u2026uenceOf(entity), storage)");
        Object $this$forEach$iv2 = sequence;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CustomEntityProjectModelInfoProvider.CustomContentRoot it2 = (CustomEntityProjectModelInfoProvider.CustomContentRoot)element$iv;
            boolean bl = false;
            ModuleEntity moduleEntity = it2.parentModule;
            Intrinsics.checkNotNullExpressionValue((Object)moduleEntity, (String)"it.parentModule");
            ModuleBridge module2 = ModuleEntityUtils.findModule(moduleEntity, storage);
            if (module2 == null) continue;
            VirtualFile virtualFile2 = it2.root;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it.root");
            registrar.registerFileSet(virtualFile2, WorkspaceFileKind.CONTENT, (WorkspaceEntity)entity, (WorkspaceFileSetData)new ModuleContentRootData(module2, it2.root));
        }
        Object[] $i$f$forEach22 = new WorkspaceEntity[]{entity};
        Sequence<CustomEntityProjectModelInfoProvider.LibraryRoots<E>> sequence2 = this.provider.getLibraryRoots(SequencesKt.sequenceOf((Object[])$i$f$forEach22), storage);
        Intrinsics.checkNotNullExpressionValue(sequence2, (String)"provider.getLibraryRoots\u2026uenceOf(entity), storage)");
        $this$forEach$iv2 = sequence2;
        boolean $i$f$forEach32 = false;
        for (Object element$iv : $this$forEach$iv2) {
            SyntheticLibrary.ExcludeFileCondition condition;
            CustomEntityProjectModelInfoProvider.LibraryRoots libraryRoots = (CustomEntityProjectModelInfoProvider.LibraryRoots)element$iv;
            boolean bl = false;
            Collection<VirtualFile> collection = libraryRoots.classes;
            Intrinsics.checkNotNullExpressionValue(collection, (String)"libraryRoots.classes");
            $this$forEach$iv = collection;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (VirtualFile)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                registrar.registerFileSet(it, WorkspaceFileKind.EXTERNAL, (WorkspaceEntity)entity, (WorkspaceFileSetData)new LibraryRootFileSetData(null, ""));
            }
            Collection<VirtualFile> collection2 = libraryRoots.sources;
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"libraryRoots.sources");
            $this$forEach$iv = collection2;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (VirtualFile)element$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                registrar.registerFileSet(it, WorkspaceFileKind.EXTERNAL_SOURCE, (WorkspaceEntity)entity, (WorkspaceFileSetData)new LibrarySourceRootFileSetData(null, ""));
            }
            Collection<VirtualFile> collection3 = libraryRoots.excluded;
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"libraryRoots.excluded");
            $this$forEach$iv = collection3;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (VirtualFile)element$iv2;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                registrar.registerExcludedRoot(it, WorkspaceFileKind.EXTERNAL, (WorkspaceEntity)entity);
            }
            if (libraryRoots.excludeFileCondition == null) continue;
            boolean bl5 = false;
            Collection<VirtualFile> collection4 = libraryRoots.classes;
            Intrinsics.checkNotNullExpressionValue(collection4, (String)"libraryRoots.classes");
            Collection<VirtualFile> collection5 = libraryRoots.sources;
            Intrinsics.checkNotNullExpressionValue(collection5, (String)"libraryRoots.sources");
            List allRoots = CollectionsKt.plus(collection4, (Iterable)collection5);
            Intrinsics.checkNotNullExpressionValue(condition.transformToCondition(allRoots), (String)"condition.transformToCondition(allRoots)");
            for (VirtualFile root : allRoots) {
                Condition<VirtualFile> predicate2;
                Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                registrar.registerExclusionCondition(root, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(predicate2){
                    final /* synthetic */ Condition<VirtualFile> $predicate;
                    {
                        this.$predicate = $predicate;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull VirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$predicate.value(it);
                    }
                }), (WorkspaceEntity)entity);
            }
        }
        Object[] $i$f$forEach32 = new WorkspaceEntity[]{entity};
        Sequence<CustomEntityProjectModelInfoProvider.ExcludeStrategy<E>> sequence3 = this.provider.getExcludeSdkRootStrategies(SequencesKt.sequenceOf((Object[])$i$f$forEach32), storage);
        Intrinsics.checkNotNullExpressionValue(sequence3, (String)"provider.getExcludeSdkRo\u2026uenceOf(entity), storage)");
        $this$forEach$iv2 = sequence3;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CustomEntityProjectModelInfoProvider.ExcludeStrategy excludeStrategy = (CustomEntityProjectModelInfoProvider.ExcludeStrategy)element$iv;
            boolean bl = false;
            List<VirtualFileUrl> list2 = excludeStrategy.excludeUrls;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"excludeStrategy.excludeUrls");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                it = (VirtualFileUrl)element$iv3;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                registrar.registerExcludedRoot((VirtualFileUrl)it, (WorkspaceEntity)entity);
            }
        }
    }
}

