/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleStoredWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetsKt;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0003\u0005\u0006\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0016\u0082\u0001\u0003\b\t\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSet;", "add", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "fileSet", "ByCondition", "ByFileKind", "ByPattern", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByCondition;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByFileKind;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByPattern;", "intellij.platform.projectModel.impl"})
public interface ExcludedFileSet
extends StoredFileSet {
    @Override
    @NotNull
    default public StoredFileSetCollection add(@NotNull StoredFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        Object[] objectArray = new StoredFileSet[]{this, fileSet};
        return new MultipleStoredWorkspaceFileSets(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByCondition;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "condition", "Lkotlin/Function1;", "", "entityReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entityStorageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;Lcom/intellij/workspaceModel/storage/EntityReference;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;)V", "getCondition", "()Lkotlin/jvm/functions/Function1;", "getEntityReference", "()Lcom/intellij/workspaceModel/storage/EntityReference;", "getEntityStorageKind", "()Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "computeMasks", "", "currentMasks", "project", "Lcom/intellij/openapi/project/Project;", "honorExclusion", "file", "isExcluded", "intellij.platform.projectModel.impl"})
    public static final class ByCondition
    implements ExcludedFileSet {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final Function1<VirtualFile, Boolean> condition;
        @NotNull
        private final EntityReference<WorkspaceEntity> entityReference;
        @NotNull
        private final EntityStorageKind entityStorageKind;

        public ByCondition(@NotNull VirtualFile root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull EntityReference<? extends WorkspaceEntity> entityReference, @NotNull EntityStorageKind entityStorageKind) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Intrinsics.checkNotNullParameter(entityReference, (String)"entityReference");
            Intrinsics.checkNotNullParameter((Object)((Object)entityStorageKind), (String)"entityStorageKind");
            this.root = root;
            this.condition = condition;
            this.entityReference = entityReference;
            this.entityStorageKind = entityStorageKind;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final Function1<VirtualFile, Boolean> getCondition() {
            return this.condition;
        }

        @Override
        @NotNull
        public EntityReference<WorkspaceEntity> getEntityReference() {
            return this.entityReference;
        }

        @Override
        @NotNull
        public EntityStorageKind getEntityStorageKind() {
            return this.entityStorageKind;
        }

        private final boolean isExcluded(VirtualFile file2) {
            VirtualFile current = file2;
            while (!Intrinsics.areEqual((Object)current, (Object)this.root)) {
                if (((Boolean)this.condition.invoke((Object)current)).booleanValue()) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)current.getParent(), (String)"current.parent");
            }
            return (Boolean)this.condition.invoke((Object)this.root);
        }

        @Override
        public int computeMasks(int currentMasks, @NotNull Project project2, boolean honorExclusion, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            int withExclusion = honorExclusion && this.isExcluded(file2) ? WorkspaceFileSetsKt.access$unsetAcceptedKinds(currentMasks, 7) : currentMasks;
            return withExclusion | 2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ(\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByFileKind;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet;", "mask", "", "entityReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entityStorageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "(ILcom/intellij/workspaceModel/storage/EntityReference;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;)V", "getEntityReference", "()Lcom/intellij/workspaceModel/storage/EntityReference;", "getEntityStorageKind", "()Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "getMask", "()I", "computeMasks", "currentMasks", "project", "Lcom/intellij/openapi/project/Project;", "honorExclusion", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.projectModel.impl"})
    public static final class ByFileKind
    implements ExcludedFileSet {
        private final int mask;
        @NotNull
        private final EntityReference<WorkspaceEntity> entityReference;
        @NotNull
        private final EntityStorageKind entityStorageKind;

        public ByFileKind(int mask, @NotNull EntityReference<? extends WorkspaceEntity> entityReference, @NotNull EntityStorageKind entityStorageKind) {
            Intrinsics.checkNotNullParameter(entityReference, (String)"entityReference");
            Intrinsics.checkNotNullParameter((Object)((Object)entityStorageKind), (String)"entityStorageKind");
            this.mask = mask;
            this.entityReference = entityReference;
            this.entityStorageKind = entityStorageKind;
        }

        public /* synthetic */ ByFileKind(int n, EntityReference entityReference, EntityStorageKind entityStorageKind, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                entityStorageKind = EntityStorageKind.MAIN;
            }
            this(n, (EntityReference<? extends WorkspaceEntity>)entityReference, entityStorageKind);
        }

        public final int getMask() {
            return this.mask;
        }

        @Override
        @NotNull
        public EntityReference<WorkspaceEntity> getEntityReference() {
            return this.entityReference;
        }

        @Override
        @NotNull
        public EntityStorageKind getEntityStorageKind() {
            return this.entityStorageKind;
        }

        @Override
        public int computeMasks(int currentMasks, @NotNull Project project2, boolean honorExclusion, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            int withExclusion = honorExclusion ? WorkspaceFileSetsKt.access$unsetAcceptedKinds(currentMasks, this.mask) : currentMasks;
            return withExclusion | 2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0003H\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByPattern;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "patterns", "", "", "entityReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entityStorageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Lcom/intellij/workspaceModel/storage/EntityReference;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;)V", "getEntityReference", "()Lcom/intellij/workspaceModel/storage/EntityReference;", "getEntityStorageKind", "()Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "table", "Lcom/intellij/openapi/fileTypes/impl/FileTypeAssocTable;", "", "getTable", "()Lcom/intellij/openapi/fileTypes/impl/FileTypeAssocTable;", "computeMasks", "", "currentMasks", "project", "Lcom/intellij/openapi/project/Project;", "honorExclusion", "file", "isExcluded", "intellij.platform.projectModel.impl"})
    public static final class ByPattern
    implements ExcludedFileSet {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final EntityReference<WorkspaceEntity> entityReference;
        @NotNull
        private final EntityStorageKind entityStorageKind;
        @NotNull
        private final FileTypeAssocTable<Boolean> table;

        public ByPattern(@NotNull VirtualFile root, @NotNull List<String> patterns, @NotNull EntityReference<? extends WorkspaceEntity> entityReference, @NotNull EntityStorageKind entityStorageKind) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
            Intrinsics.checkNotNullParameter(entityReference, (String)"entityReference");
            Intrinsics.checkNotNullParameter((Object)((Object)entityStorageKind), (String)"entityStorageKind");
            this.root = root;
            this.entityReference = entityReference;
            this.entityStorageKind = entityStorageKind;
            this.table = new FileTypeAssocTable();
            for (String pattern : patterns) {
                this.table.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(pattern), (Object)true);
            }
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @Override
        @NotNull
        public EntityReference<WorkspaceEntity> getEntityReference() {
            return this.entityReference;
        }

        @Override
        @NotNull
        public EntityStorageKind getEntityStorageKind() {
            return this.entityStorageKind;
        }

        @NotNull
        public final FileTypeAssocTable<Boolean> getTable() {
            return this.table;
        }

        private final boolean isExcluded(VirtualFile file2) {
            VirtualFile current = file2;
            while (!Intrinsics.areEqual((Object)current, (Object)this.root)) {
                if (this.table.findAssociatedFileType(current.getNameSequence()) != null) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)current.getParent(), (String)"current.parent");
            }
            return false;
        }

        @Override
        public int computeMasks(int currentMasks, @NotNull Project project2, boolean honorExclusion, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            int withExclusion = honorExclusion && this.isExcluded(file2) ? WorkspaceFileSetsKt.access$unsetAcceptedKinds(currentMasks, 7) : currentMasks;
            return withExclusion | 2;
        }
    }
}

