/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.RootFileSupplier;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ExcludedFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.GlobalLibraryReference;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.LibrarySourceRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.SdkReference;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetsKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyIndex;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyListener;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0000\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011BS\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012(\u0010\u000b\u001a$\u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000e0\fj\u0002`\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0017H\u0016J\b\u0010#\u001a\u00020 H\u0016J\b\u0010$\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020 H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0017H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0006\u0010(\u001a\u00020 J\u0010\u0010)\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0017H\u0002J\b\u0010*\u001a\u00020 H\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0010\u0010,\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0017H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0017H\u0002J\b\u0010/\u001a\u00020 H\u0002J\u0010\u00100\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u000b\u001a$\u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000e0\fj\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u001c\u001a#\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001b0\u001b\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\t0\t0\u000e\u00a2\u0006\u0002\b\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/LibrariesAndSdkContributors;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleDependencyListener;", "Lcom/intellij/openapi/roots/ex/ProjectRootManagerEx$ProjectJdkListener;", "project", "Lcom/intellij/openapi/project/Project;", "rootFileSupplier", "Lcom/intellij/openapi/roots/impl/RootFileSupplier;", "fileSets", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "fileSetsByPackagePrefix", "Ljava/util/HashMap;", "", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PackagePrefixStorage;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/impl/RootFileSupplier;Ljava/util/Map;Ljava/util/HashMap;)V", "includeProjectSdk", "", "libraryRoots", "Lcom/intellij/openapi/roots/libraries/Library;", "moduleDependencyIndex", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleDependencyIndex;", "registeredProjectSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdkRoots", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addedDependencyOn", "", "sdk", "library", "firstDependencyOnSdkAdded", "lastDependencyOnSdkRemoved", "projectJdkChanged", "referencedLibraryChanged", "referencedSdkChanged", "registerFileSets", "registerLibraryRoots", "registerProjectSdkRoots", "registerSdkRoots", "removedDependencyOn", "shouldListen", "unregisterLibraryRoots", "unregisterProjectSdkRoots", "unregisterSdkRoots", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nLibrariesAndSdkContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibrariesAndSdkContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibrariesAndSdkContributors\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n13579#2,2:242\n13579#2,2:245\n13579#2,2:249\n13579#2,2:255\n13579#2,2:257\n1295#3:244\n1296#3:247\n1#4:248\n1855#5,2:251\n1855#5,2:253\n*S KotlinDebug\n*F\n+ 1 LibrariesAndSdkContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibrariesAndSdkContributors\n*L\n50#1:242,2\n60#1:245,2\n96#1:249,2\n83#1:255,2\n106#1:257,2\n59#1:244\n59#1:247\n124#1:251,2\n132#1:253,2\n*E\n"})
public final class LibrariesAndSdkContributors
implements ModuleDependencyListener,
ProjectRootManagerEx.ProjectJdkListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RootFileSupplier rootFileSupplier;
    @NotNull
    private final Map<VirtualFile, StoredFileSetCollection> fileSets;
    @NotNull
    private final HashMap<String, MultiMap<EntityReference<WorkspaceEntity>, WorkspaceFileSetImpl>> fileSetsByPackagePrefix;
    @NotNull
    private final MultiMap<Sdk, VirtualFile> sdkRoots;
    @NotNull
    private final MultiMap<Library, VirtualFile> libraryRoots;
    @NotNull
    private final ModuleDependencyIndex moduleDependencyIndex;
    @Nullable
    private Sdk registeredProjectSdk;
    private boolean includeProjectSdk;

    public LibrariesAndSdkContributors(@NotNull Project project2, @NotNull RootFileSupplier rootFileSupplier, @NotNull Map<VirtualFile, StoredFileSetCollection> fileSets, @NotNull HashMap<String, MultiMap<EntityReference<WorkspaceEntity>, WorkspaceFileSetImpl>> fileSetsByPackagePrefix) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootFileSupplier, (String)"rootFileSupplier");
        Intrinsics.checkNotNullParameter(fileSets, (String)"fileSets");
        Intrinsics.checkNotNullParameter(fileSetsByPackagePrefix, (String)"fileSetsByPackagePrefix");
        this.project = project2;
        this.rootFileSupplier = rootFileSupplier;
        this.fileSets = fileSets;
        this.fileSetsByPackagePrefix = fileSetsByPackagePrefix;
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue(multiMap, (String)"create<Sdk, VirtualFile>()");
        this.sdkRoots = multiMap;
        this.libraryRoots = new MultiMap(new IdentityHashMap());
        this.moduleDependencyIndex = ModuleDependencyIndex.Companion.getInstance(this.project);
        if (Intrinsics.areEqual((Object)this.rootFileSupplier, (Object)RootFileSupplier.INSTANCE)) {
            this.moduleDependencyIndex.addListener(this);
            ProjectRootManagerEx.getInstanceEx(this.project).addProjectJdkListener(this);
        }
    }

    public final void registerFileSets() {
        boolean noSdkIsUsed = false;
        noSdkIsUsed = true;
        Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getInstance().allJdks");
        Sequence $this$forEach$iv = (Sequence)sdkArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sdk sdk2 = (Sdk)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"sdk");
            if (!this.moduleDependencyIndex.hasDependencyOn(sdk2)) continue;
            this.registerSdkRoots(sdk2);
            noSdkIsUsed = false;
        }
        if (noSdkIsUsed) {
            this.registerProjectSdkRoots();
        }
        List<LibraryTable> list2 = LibraryTablesRegistrar.getInstance().getCustomLibraryTables();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance().customLibraryTables");
        $this$forEach$iv = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)list2), (Object)LibraryTablesRegistrar.getInstance().getLibraryTable());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryTable it = (LibraryTable)element$iv;
            boolean bl = false;
            Library[] libraryArray = it.getLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"it.libraries");
            Object[] $this$forEach$iv2 = libraryArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Library library = (Library)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)library, (String)"library");
                if (!this.moduleDependencyIndex.hasDependencyOn(library)) continue;
                this.registerLibraryRoots(library);
            }
        }
    }

    private final void registerProjectSdkRoots() {
        this.unregisterProjectSdkRoots();
        this.includeProjectSdk = true;
        Sdk projectSdk = ProjectRootManager.getInstance(this.project).getProjectSdk();
        if (projectSdk != null) {
            this.registeredProjectSdk = projectSdk;
            this.registerSdkRoots(projectSdk);
        }
    }

    private final void registerLibraryRoots(Library library) {
        block2: {
            GlobalLibraryReference reference2 = new GlobalLibraryReference(library);
            OrderRootType orderRootType = OrderRootType.CLASSES;
            Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"CLASSES");
            LibrariesAndSdkContributors.registerLibraryRoots$registerLibraryRoots(this, library, orderRootType, WorkspaceFileKind.EXTERNAL, reference2, new LibraryRootFileSetData(null, ""));
            OrderRootType orderRootType2 = OrderRootType.SOURCES;
            Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"SOURCES");
            LibrariesAndSdkContributors.registerLibraryRoots$registerLibraryRoots(this, library, orderRootType2, WorkspaceFileKind.EXTERNAL_SOURCE, reference2, new LibrarySourceRootFileSetData(null, ""));
            VirtualFile[] virtualFileArray = library instanceof LibraryEx ? (VirtualFile[])library : null;
            if (virtualFileArray == null) break block2;
            VirtualFile[] it = virtualFileArray;
            boolean bl = false;
            VirtualFile[] virtualFileArray2 = this.rootFileSupplier.getExcludedRoots((LibraryEx)it);
            virtualFileArray = virtualFileArray2;
            if (virtualFileArray2 != null) {
                VirtualFile[] $this$forEach$iv = virtualFileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile element$iv;
                    VirtualFile it2 = element$iv = $this$forEach$iv[j];
                    boolean bl2 = false;
                    if (!RootFileSupplier.ensureValid(it2, library, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    WorkspaceFileSetsKt.putValue(this.fileSets, it2, new ExcludedFileSet.ByFileKind(6, reference2, null, 4, null));
                    this.libraryRoots.putValue(library, it2);
                }
            }
        }
    }

    private final void registerSdkRoots(Sdk sdk2) {
        SdkReference reference2 = new SdkReference(sdk2);
        OrderRootType orderRootType = OrderRootType.CLASSES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"CLASSES");
        LibrariesAndSdkContributors.registerSdkRoots$registerSdkRoots(sdk2, this, orderRootType, WorkspaceFileKind.EXTERNAL, reference2, new LibraryRootFileSetData(null, ""));
        OrderRootType orderRootType2 = OrderRootType.SOURCES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"SOURCES");
        LibrariesAndSdkContributors.registerSdkRoots$registerSdkRoots(sdk2, this, orderRootType2, WorkspaceFileKind.EXTERNAL_SOURCE, reference2, new LibrarySourceRootFileSetData(null, ""));
    }

    private final void unregisterSdkRoots(Sdk sdk2) {
        block1: {
            Collection<VirtualFile> roots2;
            Collection<VirtualFile> collection = roots2 = this.sdkRoots.remove(sdk2);
            if (collection == null) break block1;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile root = (VirtualFile)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                WorkspaceFileSetsKt.removeValueIf(this.fileSets, root, (Function1<? super StoredFileSet, Boolean>)((Function1)new Function1<StoredFileSet, Boolean>(sdk2){
                    final /* synthetic */ Sdk $sdk;
                    {
                        this.$sdk = $sdk;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull StoredFileSet fileSet) {
                        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
                        EntityReference<WorkspaceEntity> entityReference = fileSet.getEntityReference();
                        SdkReference sdkReference = entityReference instanceof SdkReference ? (SdkReference)entityReference : null;
                        return Intrinsics.areEqual((Object)(sdkReference != null ? sdkReference.getSdk() : null), (Object)this.$sdk);
                    }
                }));
                WorkspaceFileSetsKt.removeByPrefixAndReference(this.fileSetsByPackagePrefix, "", (EntityReference<? extends WorkspaceEntity>)((EntityReference)new SdkReference(sdk2)));
            }
        }
    }

    private final void unregisterLibraryRoots(Library library) {
        block1: {
            Collection<VirtualFile> roots2;
            Collection<VirtualFile> collection = roots2 = this.libraryRoots.remove(library);
            if (collection == null) break block1;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile root = (VirtualFile)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                WorkspaceFileSetsKt.removeValueIf(this.fileSets, root, (Function1<? super StoredFileSet, Boolean>)((Function1)new Function1<StoredFileSet, Boolean>(library){
                    final /* synthetic */ Library $library;
                    {
                        this.$library = $library;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull StoredFileSet fileSet) {
                        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
                        EntityReference<WorkspaceEntity> entityReference = fileSet.getEntityReference();
                        GlobalLibraryReference globalLibraryReference = entityReference instanceof GlobalLibraryReference ? (GlobalLibraryReference)entityReference : null;
                        return (globalLibraryReference != null ? globalLibraryReference.getLibrary() : null) == this.$library;
                    }
                }));
                WorkspaceFileSetsKt.removeByPrefixAndReference(this.fileSetsByPackagePrefix, "", (EntityReference<? extends WorkspaceEntity>)((EntityReference)new GlobalLibraryReference(library)));
            }
        }
    }

    @Override
    public void firstDependencyOnSdkAdded() {
        this.unregisterProjectSdkRoots();
    }

    private final void unregisterProjectSdkRoots() {
        Sdk sdk2 = this.registeredProjectSdk;
        if (sdk2 != null) {
            Sdk it = sdk2;
            boolean bl = false;
            this.unregisterSdkRoots(it);
        }
        this.registeredProjectSdk = null;
        this.includeProjectSdk = false;
    }

    @Override
    public void lastDependencyOnSdkRemoved() {
        this.registerProjectSdkRoots();
    }

    @Override
    public void addedDependencyOn(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (this.shouldListen(library)) {
            this.registerLibraryRoots(library);
        }
    }

    private final boolean shouldListen(Library library) {
        LibraryTable libraryTable = library.getTable();
        return !Intrinsics.areEqual((Object)(libraryTable != null ? libraryTable.getTableLevel() : null), (Object)"project");
    }

    @Override
    public void referencedLibraryChanged(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (this.shouldListen(library)) {
            this.unregisterLibraryRoots(library);
            this.registerLibraryRoots(library);
        }
    }

    @Override
    public void removedDependencyOn(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (this.shouldListen(library)) {
            this.unregisterLibraryRoots(library);
        }
    }

    @Override
    public void addedDependencyOn(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        this.registerSdkRoots(sdk2);
    }

    @Override
    public void referencedSdkChanged(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        this.unregisterSdkRoots(sdk2);
        this.registerSdkRoots(sdk2);
    }

    @Override
    public void removedDependencyOn(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        this.unregisterSdkRoots(sdk2);
    }

    @Override
    public void projectJdkChanged() {
        if (this.includeProjectSdk) {
            this.registerProjectSdkRoots();
        }
    }

    private static final void registerLibraryRoots$registerLibraryRoots(LibrariesAndSdkContributors this$0, Library $library, OrderRootType rootType, WorkspaceFileKind kind, GlobalLibraryReference reference2, WorkspaceFileSetData data2) {
        VirtualFile[] virtualFileArray = this$0.rootFileSupplier.getLibraryRoots($library, rootType);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"rootFileSupplier.getLibr\u2026yRoots(library, rootType)");
        Object[] $this$forEach$iv = virtualFileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile root = (VirtualFile)element$iv;
            boolean bl = false;
            if (!RootFileSupplier.ensureValid(root, $library, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
            WorkspaceFileSetImpl fileSet = new WorkspaceFileSetImpl(root, kind, (EntityReference<? extends WorkspaceEntity>)((EntityReference)reference2), EntityStorageKind.MAIN, data2);
            WorkspaceFileSetsKt.putValue(this$0.fileSets, root, fileSet);
            WorkspaceFileSetsKt.addFileSet(this$0.fileSetsByPackagePrefix, "", fileSet);
            this$0.libraryRoots.putValue($library, root);
        }
    }

    private static final void registerSdkRoots$registerSdkRoots(Sdk $sdk, LibrariesAndSdkContributors this$0, OrderRootType rootType, WorkspaceFileKind kind, SdkReference reference2, WorkspaceFileSetData data2) {
        String[] stringArray = $sdk.getRootProvider().getUrls(rootType);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"sdk.rootProvider.getUrls(rootType)");
        Object[] $this$forEach$iv = stringArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String url = (String)element$iv;
            boolean bl = false;
            VirtualFile root = this$0.rootFileSupplier.findFileByUrl(url);
            if (root == null || !RootFileSupplier.ensureValid(root, $sdk, null)) continue;
            WorkspaceFileSetImpl fileSet = new WorkspaceFileSetImpl(root, kind, (EntityReference<? extends WorkspaceEntity>)((EntityReference)reference2), EntityStorageKind.MAIN, data2);
            WorkspaceFileSetsKt.putValue(this$0.fileSets, root, fileSet);
            WorkspaceFileSetsKt.addFileSet(this$0.fileSetsByPackagePrefix, "", fileSet);
            this$0.sdkRoots.putValue($sdk, root);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/LibrariesAndSdkContributors$Companion;", "", "()V", "getGlobalLibraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "getGlobalLibraryId$intellij_platform_projectModel_impl", "getSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdk$intellij_platform_projectModel_impl", "isPlaceholderReference", "", "entityReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nLibrariesAndSdkContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibrariesAndSdkContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibrariesAndSdkContributors$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,241:1\n10#2:242\n10#2:243\n*S KotlinDebug\n*F\n+ 1 LibrariesAndSdkContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibrariesAndSdkContributors$Companion\n*L\n194#1:242\n200#1:243\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LibraryId getGlobalLibraryId$intellij_platform_projectModel_impl(@NotNull WorkspaceFileSet fileSet) {
            LibraryId libraryId;
            Object object;
            Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
            WorkspaceFileSet $this$asSafely$iv = fileSet;
            boolean $i$f$asSafely = false;
            WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
            if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
                workspaceFileSet = null;
            }
            WorkspaceFileSetImpl workspaceFileSetImpl = (WorkspaceFileSetImpl)workspaceFileSet;
            EntityReference<WorkspaceEntity> $this$asSafely$iv2 = workspaceFileSetImpl != null ? workspaceFileSetImpl.getEntityReference() : null;
            boolean $i$f$asSafely2 = false;
            EntityReference<WorkspaceEntity> entityReference = $this$asSafely$iv2;
            if (!(entityReference instanceof GlobalLibraryReference)) {
                entityReference = null;
            }
            if ((object = (GlobalLibraryReference)entityReference) != null && (object = object.getLibrary()) != null) {
                Object it = object;
                boolean bl = false;
                libraryId = LibraryEntityUtils.findLibraryId((Library)it);
            } else {
                libraryId = null;
            }
            return libraryId;
        }

        @Nullable
        public final Sdk getSdk$intellij_platform_projectModel_impl(@NotNull WorkspaceFileSet fileSet) {
            Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
            WorkspaceFileSet $this$asSafely$iv = fileSet;
            boolean $i$f$asSafely = false;
            WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
            if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
                workspaceFileSet = null;
            }
            WorkspaceFileSetImpl workspaceFileSetImpl = (WorkspaceFileSetImpl)workspaceFileSet;
            EntityReference<WorkspaceEntity> $this$asSafely$iv2 = workspaceFileSetImpl != null ? workspaceFileSetImpl.getEntityReference() : null;
            boolean $i$f$asSafely2 = false;
            EntityReference<WorkspaceEntity> entityReference = $this$asSafely$iv2;
            if (!(entityReference instanceof SdkReference)) {
                entityReference = null;
            }
            SdkReference sdkReference = (SdkReference)entityReference;
            return sdkReference != null ? sdkReference.getSdk() : null;
        }

        public final boolean isPlaceholderReference(@NotNull EntityReference<? extends WorkspaceEntity> entityReference) {
            Intrinsics.checkNotNullParameter(entityReference, (String)"entityReference");
            return entityReference instanceof GlobalLibraryReference || entityReference instanceof SdkReference;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

