/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.LibrarySourceRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.PlatformInternalWorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.ide.VirtualFileUrls;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRootTypeId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0004J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J0\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PlatformInternalWorkspaceFileIndexContributor;", "()V", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "registerArchivesUnderRoot", "", "root", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "registrar", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "data", "Lcom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileSetData;", "kind", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;", "entity", "registerArchivesUnderRootRecursively", "registerFileSets", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nlibraryRootContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 libraryRootContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,118:1\n1#2:119\n13579#3,2:120\n*S KotlinDebug\n*F\n+ 1 libraryRootContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor\n*L\n60#1:120,2\n*E\n"})
public final class LibraryRootFileIndexContributor
implements WorkspaceFileIndexContributor<LibraryEntity>,
PlatformInternalWorkspaceFileIndexContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Class<LibraryEntity> getEntityClass() {
        return LibraryEntity.class;
    }

    @Override
    public void registerFileSets(@NotNull LibraryEntity entity, @NotNull WorkspaceFileSetRegistrar registrar, @NotNull EntityStorage storage) {
        LibraryId libraryId;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (entity.getSymbolicId().getTableId() instanceof LibraryTableId.GlobalLibraryTableId) {
            return;
        }
        LibraryId it = libraryId = entity.getSymbolicId();
        boolean bl = false;
        LibraryId projectLibraryId = Intrinsics.areEqual((Object)it.getTableId(), (Object)LibraryTableId.ProjectLibraryTableId.INSTANCE) ? libraryId : null;
        LibraryRootFileSetData compiledRootsData = new LibraryRootFileSetData(projectLibraryId, "");
        LibrarySourceRootFileSetData sourceRootFileSetData = new LibrarySourceRootFileSetData(projectLibraryId, "");
        for (LibraryRoot root : entity.getRoots()) {
            LibraryRootFileSetData data2 = null;
            WorkspaceFileKind kind = null;
            LibraryRootTypeId libraryRootTypeId = root.getType();
            if (Intrinsics.areEqual((Object)libraryRootTypeId, (Object)LibraryRootTypeId.Companion.getCOMPILED())) {
                data2 = compiledRootsData;
                kind = WorkspaceFileKind.EXTERNAL;
            } else {
                if (!Intrinsics.areEqual((Object)libraryRootTypeId, (Object)LibraryRootTypeId.Companion.getSOURCES())) continue;
                data2 = sourceRootFileSetData;
                kind = WorkspaceFileKind.EXTERNAL_SOURCE;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[root.getInclusionOptions().ordinal()]) {
                case 1: {
                    registrar.registerFileSet(root.getUrl(), kind, (WorkspaceEntity)entity, (WorkspaceFileSetData)data2);
                    break;
                }
                case 2: {
                    this.registerArchivesUnderRoot(root.getUrl(), registrar, data2, kind, entity);
                    break;
                }
                case 3: {
                    this.registerArchivesUnderRootRecursively(root.getUrl(), registrar, data2, kind, entity);
                }
            }
        }
    }

    private final void registerArchivesUnderRoot(VirtualFileUrl root, WorkspaceFileSetRegistrar registrar, LibraryRootFileSetData data2, WorkspaceFileKind kind, LibraryEntity entity) {
        block1: {
            VirtualFile[] virtualFileArray = VirtualFileUrls.getVirtualFile(root);
            if (virtualFileArray == null || (virtualFileArray = virtualFileArray.getChildren()) == null) break block1;
            VirtualFile[] $this$forEach$iv = virtualFileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile jarRoot;
                VirtualFile element$iv;
                VirtualFile file2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                if (file2.isDirectory() || FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getNameSequence()) != ArchiveFileType.INSTANCE || (jarRoot = StandardFileSystems.jar().findFileByPath(file2.getPath() + "!/")) == null) continue;
                registrar.registerFileSet(jarRoot, kind, (WorkspaceEntity)entity, (WorkspaceFileSetData)data2);
            }
        }
    }

    private final void registerArchivesUnderRootRecursively(VirtualFileUrl root, WorkspaceFileSetRegistrar registrar, LibraryRootFileSetData data2, WorkspaceFileKind kind, LibraryEntity entity) {
        VirtualFile virtualFile2 = VirtualFileUrls.getVirtualFile(root);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively(virtualFile3, new VirtualFileVisitor<Void>(registrar, kind, entity, data2, optionArray){
            final /* synthetic */ WorkspaceFileSetRegistrar $registrar;
            final /* synthetic */ WorkspaceFileKind $kind;
            final /* synthetic */ LibraryEntity $entity;
            final /* synthetic */ LibraryRootFileSetData $data;
            {
                this.$registrar = $registrar;
                this.$kind = $kind;
                this.$entity = $entity;
                this.$data = $data;
                super($super_call_param$1);
            }

            public boolean visitFile(@NotNull VirtualFile file2) {
                VirtualFile jarRoot;
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (!file2.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getNameSequence()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file2.getPath() + "!/")) != null) {
                    this.$registrar.registerFileSet(jarRoot, this.$kind, (WorkspaceEntity)this.$entity, (WorkspaceFileSetData)this.$data);
                    return false;
                }
                return true;
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LibraryRoot.InclusionOptions.values().length];
            try {
                nArray[LibraryRoot.InclusionOptions.ROOT_ITSELF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0017\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor$Companion;", "", "()V", "getModuleLibraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "getProjectLibraryId", "data", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "getProjectLibraryId$intellij_platform_projectModel_impl", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nlibraryRootContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 libraryRootContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,118:1\n10#2:119\n10#2:120\n*S KotlinDebug\n*F\n+ 1 libraryRootContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor$Companion\n*L\n92#1:119\n96#1:120\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LibraryId getProjectLibraryId$intellij_platform_projectModel_impl(@NotNull WorkspaceFileSetData data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            WorkspaceFileSetData $this$asSafely$iv = data2;
            boolean $i$f$asSafely = false;
            WorkspaceFileSetData workspaceFileSetData = $this$asSafely$iv;
            if (!(workspaceFileSetData instanceof LibraryRootFileSetData)) {
                workspaceFileSetData = null;
            }
            LibraryRootFileSetData libraryRootFileSetData = (LibraryRootFileSetData)workspaceFileSetData;
            return libraryRootFileSetData != null ? libraryRootFileSetData.getProjectLibraryId$intellij_platform_projectModel_impl() : null;
        }

        @Nullable
        public final LibraryId getModuleLibraryId(@NotNull WorkspaceFileSet fileSet, @NotNull EntityStorage storage) {
            EntityReference<WorkspaceEntity> entityReference;
            Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            WorkspaceFileSet $this$asSafely$iv = fileSet;
            boolean $i$f$asSafely = false;
            WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
            if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
                workspaceFileSet = null;
            }
            WorkspaceEntity $this$asSafely$iv2 = (entityReference = (EntityReference<WorkspaceEntity>)workspaceFileSet) != null && (entityReference = entityReference.getEntityReference()) != null ? entityReference.resolve(storage) : null;
            boolean $i$f$asSafely2 = false;
            WorkspaceEntity workspaceEntity = $this$asSafely$iv2;
            if (!(workspaceEntity instanceof LibraryEntity)) {
                workspaceEntity = null;
            }
            LibraryEntity libraryEntity = (LibraryEntity)workspaceEntity;
            return libraryEntity != null ? libraryEntity.getSymbolicId() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

