/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.URLUtil;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.impl.EntityChangeStorage;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetKind;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistryKt;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.VfsChangeApplier;
import com.intellij.workspaceModel.core.fileIndex.impl.VfsChangeApplierImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.VirtualFileUrls;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010 \u001a\u00020\tJ\u001a\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\tH\u0002J,\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\t2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020#J&\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\t2\u0006\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020#J\u000e\u0010.\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\tJ$\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\t2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+J\u001e\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\t2\u0006\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020+JH\u00101\u001a\u00020\u0015\"\u0004\b\u0000\u00102\"\u0004\b\u0001\u00103*\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30\b2\u0006\u00104\u001a\u0002H22\u0014\b\u0004\u00105\u001a\u000e\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u00020\u001e06H\u0082\b\u00a2\u0006\u0002\u00107R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0007\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;", "", "project", "Lcom/intellij/openapi/project/Project;", "indexData", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl;)V", "nonExistingFiles", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "kotlin.jvm.PlatformType", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingFileSetData;", "Lorg/jetbrains/annotations/NotNull;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "analyzeVfsChanges", "Lcom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "calculateEntityChangesIfNeeded", "", "virtualFileUrl", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "entityChanges", "Lcom/intellij/workspaceModel/core/fileIndex/impl/EntityChangeStorage;", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "allRootsWereRemoved", "", "collectAffectedEntities", "url", "getFileSetKindsFor", "", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingFileSetKind;", "getIncludingJarDirectory", "registerUrl", "root", "reference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "storageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "fileSetKind", "entity", "removeUrl", "unregisterUrl", "fileUrl", "removeValueIf", "K", "V", "key", "valuePredicate", "Lkotlin/Function1;", "(Lcom/intellij/util/containers/MultiMap;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nNonExistingWorkspaceRootsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonExistingWorkspaceRootsRegistry.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,286:1\n63#1,6:287\n63#1,6:293\n1620#2,3:299\n1855#2,2:304\n1855#2,2:306\n1295#3,2:302\n*S KotlinDebug\n*F\n+ 1 NonExistingWorkspaceRootsRegistry.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry\n*L\n40#1:287,6\n46#1:293,6\n59#1:299,3\n140#1:304,2\n163#1:306,2\n133#1:302,2\n*E\n"})
public final class NonExistingWorkspaceRootsRegistry {
    @NotNull
    private final Project project;
    @NotNull
    private final WorkspaceFileIndexDataImpl indexData;
    @NotNull
    private final VirtualFileUrlManager virtualFileManager;
    @NotNull
    private final MultiMap<VirtualFileUrl, NonExistingFileSetData> nonExistingFiles;

    public NonExistingWorkspaceRootsRegistry(@NotNull Project project2, @NotNull WorkspaceFileIndexDataImpl indexData) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indexData, (String)"indexData");
        this.project = project2;
        this.indexData = indexData;
        this.virtualFileManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue(multiMap, (String)"create<VirtualFileUrl, NonExistingFileSetData>()");
        this.nonExistingFiles = multiMap;
    }

    public final void registerUrl(@NotNull VirtualFileUrl root, @NotNull WorkspaceEntity entity, @NotNull EntityStorageKind storageKind, @NotNull NonExistingFileSetKind fileSetKind) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        Intrinsics.checkNotNullParameter((Object)((Object)fileSetKind), (String)"fileSetKind");
        this.registerUrl(root, (EntityReference<? extends WorkspaceEntity>)entity.createReference(), storageKind, fileSetKind);
    }

    public final void registerUrl(@NotNull VirtualFileUrl root, @NotNull EntityReference<? extends WorkspaceEntity> reference2, @NotNull EntityStorageKind storageKind, @NotNull NonExistingFileSetKind fileSetKind) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(reference2, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        Intrinsics.checkNotNullParameter((Object)((Object)fileSetKind), (String)"fileSetKind");
        this.nonExistingFiles.putValue(root, new NonExistingFileSetData(reference2, storageKind, fileSetKind));
    }

    public final void unregisterUrl(@NotNull VirtualFileUrl fileUrl, @NotNull WorkspaceEntity entity, @NotNull EntityStorageKind storageKind) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        NonExistingWorkspaceRootsRegistry nonExistingWorkspaceRootsRegistry = this;
        MultiMap<VirtualFileUrl, NonExistingFileSetData> $this$removeValueIf$iv = this.nonExistingFiles;
        boolean $i$f$removeValueIf = false;
        Collection<NonExistingFileSetData> collection = $this$removeValueIf$iv.get(fileUrl);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"get(key)");
        Collection<NonExistingFileSetData> collection$iv = collection;
        Function1 function1 = (Function1)new Function1<NonExistingFileSetData, Boolean>(storageKind, entity){
            final /* synthetic */ EntityStorageKind $storageKind$inlined;
            final /* synthetic */ WorkspaceEntity $entity$inlined;
            {
                this.$storageKind$inlined = entityStorageKind;
                this.$entity$inlined = workspaceEntity;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            @NotNull
            public final Boolean invoke(Object it) {
                NonExistingFileSetData nonExistingFileSetData = (NonExistingFileSetData)it;
                boolean bl = false;
                EntityReference<WorkspaceEntity> reference2 = nonExistingFileSetData.component1();
                EntityStorageKind kind = nonExistingFileSetData.component2();
                return kind == this.$storageKind$inlined && reference2.isReferenceTo(this.$entity$inlined);
            }
        };
        collection$iv.removeIf(new Predicate(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean test(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
        if (collection$iv.isEmpty()) {
            $this$removeValueIf$iv.remove(fileUrl);
        }
    }

    public final void unregisterUrl(@NotNull VirtualFileUrl fileUrl, @NotNull EntityReference<? extends WorkspaceEntity> reference2, @NotNull EntityStorageKind storageKind) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter(reference2, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        NonExistingWorkspaceRootsRegistry nonExistingWorkspaceRootsRegistry = this;
        MultiMap<VirtualFileUrl, NonExistingFileSetData> $this$removeValueIf$iv = this.nonExistingFiles;
        boolean $i$f$removeValueIf = false;
        Collection<NonExistingFileSetData> collection = $this$removeValueIf$iv.get(fileUrl);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"get(key)");
        Collection<NonExistingFileSetData> collection$iv = collection;
        Function1 function1 = (Function1)new Function1<NonExistingFileSetData, Boolean>(storageKind, reference2){
            final /* synthetic */ EntityStorageKind $storageKind$inlined;
            final /* synthetic */ EntityReference $reference$inlined;
            {
                this.$storageKind$inlined = entityStorageKind;
                this.$reference$inlined = entityReference;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            @NotNull
            public final Boolean invoke(Object it) {
                NonExistingFileSetData nonExistingFileSetData = (NonExistingFileSetData)it;
                boolean bl = false;
                EntityReference<WorkspaceEntity> ref = nonExistingFileSetData.component1();
                EntityStorageKind kind = nonExistingFileSetData.component2();
                return kind == this.$storageKind$inlined && Intrinsics.areEqual(ref, (Object)this.$reference$inlined);
            }
        };
        collection$iv.removeIf(new /* invalid duplicate definition of identical inner class */);
        if (collection$iv.isEmpty()) {
            $this$removeValueIf$iv.remove(fileUrl);
        }
    }

    public final void removeUrl(@NotNull VirtualFileUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.nonExistingFiles.remove(url);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<NonExistingFileSetKind> getFileSetKindsFor(@NotNull VirtualFileUrl url) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Collection<NonExistingFileSetData> collection = this.nonExistingFiles.get(url);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"nonExistingFiles.get(url)");
        Collection<NonExistingFileSetData> data2 = collection;
        if (data2.isEmpty()) {
            return SetsKt.emptySet();
        }
        Iterable iterable = data2;
        Collection destination$iv = EnumSet.noneOf(NonExistingFileSetKind.class);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            NonExistingFileSetData nonExistingFileSetData = (NonExistingFileSetData)item$iv;
            Collection collection2 = destination$iv;
            boolean bl = false;
            collection2.add(it.getFileSetKind());
        }
        Collection collection3 = destination$iv;
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"data.mapTo(EnumSet.noneO\u2026java)) { it.fileSetKind }");
        return (Set)collection3;
    }

    private final <K, V> void removeValueIf(MultiMap<K, V> $this$removeValueIf, K key, Function1<? super V, Boolean> valuePredicate) {
        boolean $i$f$removeValueIf = false;
        Collection<V> collection = $this$removeValueIf.get(key);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"get(key)");
        Collection<V> collection2 = collection;
        Function1 function1 = new Function1<V, Boolean>(valuePredicate){
            final /* synthetic */ Function1<V, Boolean> $valuePredicate;
            {
                this.$valuePredicate = $valuePredicate;
                super(1);
            }

            @NotNull
            public final Boolean invoke(V it) {
                return (Boolean)this.$valuePredicate.invoke(it);
            }
        };
        collection2.removeIf(new /* invalid duplicate definition of identical inner class */);
        if (collection2.isEmpty()) {
            $this$removeValueIf.remove(key);
        }
    }

    @Nullable
    public final VfsChangeApplier analyzeVfsChanges(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        EntityChangeStorage entityChanges = new EntityChangeStorage();
        EntityStorageSnapshot entityStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        for (VFileEvent vFileEvent : events) {
            String newUrl;
            Pair<String, String> pair;
            String oldUrl;
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileDeleteEvent) {
                String string2 = ((VFileDeleteEvent)vFileEvent).getFile().getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.file.url");
                this.calculateEntityChangesIfNeeded(this.virtualFileManager.fromUrl(string2), ((VFileDeleteEvent)vFileEvent).getFile(), entityChanges, (EntityStorage)entityStorage, true);
                continue;
            }
            if (vFileEvent2 instanceof VFileCreateEvent) {
                Object object;
                String parentUrl;
                Intrinsics.checkNotNullExpressionValue((Object)((VFileCreateEvent)vFileEvent).getParent().getUrl(), (String)"event.parent.url");
                int protocolEnd = StringsKt.indexOf$default((CharSequence)parentUrl, (String)"://", (int)0, (boolean)false, (int)6, null);
                if (protocolEnd != -1) {
                    String string3 = parentUrl.substring(0, protocolEnd);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    object = string3 + "://" + ((VFileCreateEvent)vFileEvent).getPath();
                } else {
                    String string4 = VfsUtilCore.pathToUrl(((VFileCreateEvent)vFileEvent).getPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n            VfsUtilCor\u2026l(event.path)\n          }");
                    object = string4;
                }
                String url = object;
                VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromUrl(url);
                this.calculateEntityChangesIfNeeded(virtualFileUrl, null, entityChanges, (EntityStorage)entityStorage, false);
                if (!StringsKt.startsWith$default((String)url, (String)"file", (boolean)false, (int)2, null)) continue;
                if (!((VFileCreateEvent)vFileEvent).isDirectory()) {
                    String string4 = ((VFileCreateEvent)vFileEvent).getChildName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"event.childName");
                    if (!StringsKt.endsWith$default((String)string4, (String)".jar", (boolean)false, (int)2, null)) continue;
                }
                String suffix = ((VFileCreateEvent)vFileEvent).isDirectory() ? "" : "!/";
                String jarFileUrl = "jar://" + URLUtil.urlToPath(url) + suffix;
                VirtualFileUrl jarVirtualFileUrl = this.virtualFileManager.fromUrl(jarFileUrl);
                this.calculateEntityChangesIfNeeded(jarVirtualFileUrl, null, entityChanges, (EntityStorage)entityStorage, false);
                continue;
            }
            if (vFileEvent2 instanceof VFileCopyEvent) {
                String string5 = VfsUtilCore.pathToUrl(((VFileCopyEvent)vFileEvent).getPath());
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"pathToUrl(event.path)");
                this.calculateEntityChangesIfNeeded(this.virtualFileManager.fromUrl(string5), null, entityChanges, (EntityStorage)entityStorage, false);
                continue;
            }
            if (!(vFileEvent2 instanceof VFilePropertyChangeEvent ? true : vFileEvent2 instanceof VFileMoveEvent) || Intrinsics.areEqual((Object)(oldUrl = (String)(pair = NonExistingWorkspaceRootsRegistryKt.getOldAndNewUrls(vFileEvent)).component1()), (Object)(newUrl = (String)pair.component2()))) continue;
            this.calculateEntityChangesIfNeeded(this.virtualFileManager.fromUrl(oldUrl), vFileEvent.getFile(), entityChanges, (EntityStorage)entityStorage, true);
            this.calculateEntityChangesIfNeeded(this.virtualFileManager.fromUrl(newUrl), null, entityChanges, (EntityStorage)entityStorage, false);
        }
        if (!entityChanges.hasChanges()) {
            return null;
        }
        return new VfsChangeApplierImpl(entityChanges, this.indexData, this, this.project);
    }

    private final VirtualFileUrl getIncludingJarDirectory(EntityStorage storage, VirtualFileUrl virtualFileUrl) {
        VirtualFileUrlIndex virtualFileUrlIndex = storage.getVirtualFileUrlIndex();
        Intrinsics.checkNotNull((Object)virtualFileUrlIndex, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex");
        Set indexedJarDirectories = ((VirtualFileIndex)virtualFileUrlIndex).getIndexedJarDirectories();
        VirtualFileUrl parentVirtualFileUrl = virtualFileUrl;
        while (parentVirtualFileUrl != null && !indexedJarDirectories.contains(parentVirtualFileUrl)) {
            parentVirtualFileUrl = this.virtualFileManager.getParentVirtualUrl(parentVirtualFileUrl);
        }
        return parentVirtualFileUrl != null && indexedJarDirectories.contains(parentVirtualFileUrl) ? parentVirtualFileUrl : null;
    }

    private final void calculateEntityChangesIfNeeded(VirtualFileUrl virtualFileUrl, VirtualFile virtualFile2, EntityChangeStorage entityChanges, EntityStorage storage, boolean allRootsWereRemoved) {
        VirtualFileUrl includingJarDirectory = this.getIncludingJarDirectory(storage, virtualFileUrl);
        if (includingJarDirectory != null) {
            Sequence $this$forEach$iv = storage.getVirtualFileUrlIndex().findEntitiesByUrl(includingJarDirectory);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                entityChanges.addAffectedEntity((EntityReference<? extends WorkspaceEntity>)((WorkspaceEntity)it.getFirst()).createReference(), allRootsWereRemoved);
            }
            return;
        }
        this.collectAffectedEntities(virtualFileUrl, virtualFile2, allRootsWereRemoved, entityChanges);
        List list2 = virtualFileUrl.getSubTreeFileUrls();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"virtualFileUrl.subTreeFileUrls");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile virtualFile3;
            VirtualFileUrl urlUnder = (VirtualFileUrl)element$iv;
            boolean bl = false;
            if (virtualFile2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)urlUnder, (String)"urlUnder");
                virtualFile3 = VirtualFileUrls.getVirtualFile(urlUnder);
            } else {
                virtualFile3 = null;
            }
            VirtualFile fileUnder = virtualFile3;
            Intrinsics.checkNotNullExpressionValue((Object)urlUnder, (String)"urlUnder");
            this.collectAffectedEntities(urlUnder, fileUnder, allRootsWereRemoved, entityChanges);
        }
    }

    private final void collectAffectedEntities(VirtualFileUrl url, VirtualFile virtualFile2, boolean allRootsWereRemoved, EntityChangeStorage entityChanges) {
        if (virtualFile2 != null) {
            Ref.BooleanRef hasEntities = new Ref.BooleanRef();
            this.indexData.processFileSets(virtualFile2, (Function1<? super StoredFileSet, Unit>)((Function1)new Function1<StoredFileSet, Unit>(entityChanges, allRootsWereRemoved, hasEntities){
                final /* synthetic */ EntityChangeStorage $entityChanges;
                final /* synthetic */ boolean $allRootsWereRemoved;
                final /* synthetic */ Ref.BooleanRef $hasEntities;
                {
                    this.$entityChanges = $entityChanges;
                    this.$allRootsWereRemoved = $allRootsWereRemoved;
                    this.$hasEntities = $hasEntities;
                    super(1);
                }

                public final void invoke(@NotNull StoredFileSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it.getEntityStorageKind() == EntityStorageKind.MAIN) {
                        this.$entityChanges.addAffectedEntity(it.getEntityReference(), this.$allRootsWereRemoved);
                    }
                    this.$hasEntities.element = true;
                }
            }));
            if (hasEntities.element && allRootsWereRemoved) {
                entityChanges.addFileToInvalidate(VirtualFileUrls.getVirtualFile(url));
            }
        }
        boolean hasEntities = false;
        Collection<NonExistingFileSetData> collection = this.nonExistingFiles.get(url);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"nonExistingFiles[url]");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NonExistingFileSetData data2 = (NonExistingFileSetData)element$iv;
            boolean bl = false;
            if (data2.getStorageKind() != EntityStorageKind.MAIN) continue;
            hasEntities = true;
            entityChanges.addAffectedEntity(data2.getReference(), allRootsWereRemoved);
        }
        if (hasEntities) {
            entityChanges.addUrlToCleanUp(url);
        }
    }
}

