/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.JavaSyntheticLibrary;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.RootFileSupplier;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.Function;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.MultiMap;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.DummyWorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ExcludedFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.JvmPackageRootDataInternal;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.LibrarySourceRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleOrLibrarySourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetKind;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistry;
import com.intellij.workspaceModel.core.fileIndex.impl.NonIncrementalContributors;
import com.intellij.workspaceModel.core.fileIndex.impl.NonIncrementalMarker;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.SyntheticLibrarySourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetsKt;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0010H\u0002J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007JL\u0010\u0017\u001a\u00020\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u00192(\u0010\u001a\u001a$\u0012\u0004\u0012\u00020\u001c\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\u0004\u0012\u00020 0\u001d0\u001bj\u0002`!2\u0006\u0010\"\u001a\u00020#R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors;", "", "project", "Lcom/intellij/openapi/project/Project;", "rootFileSupplier", "Lcom/intellij/openapi/roots/impl/RootFileSupplier;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/impl/RootFileSupplier;)V", "allRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "excludedUrls", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "lock", "upToDate", "", "computeCustomExcludedRoots", "Lkotlin/Pair;", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "computeFileSets", "", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "resetCache", "", "updateIfNeeded", "fileSets", "", "fileSetsByPackagePrefix", "Ljava/util/HashMap;", "", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PackagePrefixStorage;", "nonExistingFilesRegistry", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nNonIncrementalContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonIncrementalContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1855#2,2:192\n1855#2,2:194\n1855#2,2:196\n1855#2:200\n1446#2,5:208\n1855#2:213\n1855#2,2:214\n1856#2:216\n1856#2:221\n1855#2:222\n1855#2:223\n1855#2,2:224\n1855#2,2:226\n1856#2:228\n1856#2:229\n1855#2,2:230\n215#3,2:198\n13579#4,2:201\n11661#4:203\n13579#4:204\n13580#4:206\n11662#4:207\n13579#4:217\n13579#4,2:218\n13580#4:220\n1#5:205\n*S KotlinDebug\n*F\n+ 1 NonIncrementalContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors\n*L\n60#1:192,2\n64#1:194,2\n72#1:196,2\n98#1:200\n112#1:208,5\n113#1:213\n114#1:214,2\n113#1:216\n98#1:221\n144#1:222\n145#1:223\n156#1:224,2\n161#1:226,2\n145#1:228\n144#1:229\n147#1:230,2\n75#1:198,2\n99#1:201,2\n111#1:203\n111#1:204\n111#1:206\n111#1:207\n124#1:217\n125#1:218,2\n124#1:220\n111#1:205\n*E\n"})
public final class NonIncrementalContributors {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RootFileSupplier rootFileSupplier;
    @NotNull
    private Set<? extends VirtualFile> allRoots;
    @NotNull
    private Set<? extends VirtualFileUrl> excludedUrls;
    private volatile boolean upToDate;
    @NotNull
    private final Object lock;

    public NonIncrementalContributors(@NotNull Project project2, @NotNull RootFileSupplier rootFileSupplier) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootFileSupplier, (String)"rootFileSupplier");
        this.project = project2;
        this.rootFileSupplier = rootFileSupplier;
        this.allRoots = SetsKt.emptySet();
        this.excludedUrls = SetsKt.emptySet();
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateIfNeeded(@NotNull Map<VirtualFile, StoredFileSetCollection> fileSets, @NotNull HashMap<String, MultiMap<EntityReference<WorkspaceEntity>, WorkspaceFileSetImpl>> fileSetsByPackagePrefix, @NotNull NonExistingWorkspaceRootsRegistry nonExistingFilesRegistry) {
        Intrinsics.checkNotNullParameter(fileSets, (String)"fileSets");
        Intrinsics.checkNotNullParameter(fileSetsByPackagePrefix, (String)"fileSetsByPackagePrefix");
        Intrinsics.checkNotNullParameter((Object)nonExistingFilesRegistry, (String)"nonExistingFilesRegistry");
        if (!this.upToDate) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Pair<Object2IntMap<VirtualFile>, Set<VirtualFileUrl>> pair = this.computeCustomExcludedRoots();
            Object2IntMap newExcludedRoots = (Object2IntMap)pair.component1();
            Set newExcludedUrls = (Set)pair.component2();
            Map<VirtualFile, StoredFileSetCollection> newFileSets = this.computeFileSets();
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (!this.upToDate) {
                    Object element$iv;
                    Iterable $this$forEach$iv = this.allRoots;
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        VirtualFile file2 = (VirtualFile)element$iv2;
                        boolean bl2 = false;
                        WorkspaceFileSetsKt.removeValueIf(fileSets, file2, (Function1<? super StoredFileSet, Boolean>)((Function1)updateIfNeeded.1.1.1.INSTANCE));
                        WorkspaceFileSetsKt.removeByPrefixAndReference(fileSetsByPackagePrefix, "", (EntityReference<? extends WorkspaceEntity>)((EntityReference)NonIncrementalMarker.INSTANCE));
                    }
                    $this$forEach$iv = this.excludedUrls;
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        VirtualFileUrl it = (VirtualFileUrl)element$iv2;
                        boolean bl3 = false;
                        nonExistingFilesRegistry.unregisterUrl(it, (EntityReference<? extends WorkspaceEntity>)((EntityReference)NonIncrementalMarker.INSTANCE), EntityStorageKind.MAIN);
                    }
                    HashSet<VirtualFile> newRoots = new HashSet<VirtualFile>();
                    Object2IntMaps.fastForEach(newExcludedRoots, arg_0 -> NonIncrementalContributors.updateIfNeeded$lambda$5$lambda$2((Function1)new Function1<Object2IntMap.Entry<VirtualFile>, Unit>(fileSets, newRoots){
                        final /* synthetic */ Map<VirtualFile, StoredFileSetCollection> $fileSets;
                        final /* synthetic */ HashSet<VirtualFile> $newRoots;
                        {
                            this.$fileSets = $fileSets;
                            this.$newRoots = $newRoots;
                            super(1);
                        }

                        public final void invoke(Object2IntMap.Entry<VirtualFile> it) {
                            K k = it.getKey();
                            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                            WorkspaceFileSetsKt.putValue(this.$fileSets, k, new ExcludedFileSet.ByFileKind(it.getIntValue(), NonIncrementalMarker.INSTANCE, null, 4, null));
                            this.$newRoots.add((VirtualFile)it.getKey());
                        }
                    }, arg_0));
                    Object $this$forEach$iv2 = newExcludedUrls;
                    boolean $i$f$forEach2 = false;
                    Iterator<Object> iterator2 = $this$forEach$iv2.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        VirtualFileUrl it = (VirtualFileUrl)element$iv;
                        boolean bl4 = false;
                        nonExistingFilesRegistry.registerUrl(it, (EntityReference<? extends WorkspaceEntity>)((EntityReference)NonIncrementalMarker.INSTANCE), EntityStorageKind.MAIN, NonExistingFileSetKind.EXCLUDED_FROM_CONTENT);
                    }
                    $this$forEach$iv2 = newFileSets;
                    $i$f$forEach2 = false;
                    iterator2 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Object object2 = element$iv = (Map.Entry)iterator2.next();
                        boolean bl5 = false;
                        VirtualFile root = (VirtualFile)object2.getKey();
                        StoredFileSetCollection sets = (StoredFileSetCollection)object2.getValue();
                        sets.forEach((Function1<? super StoredFileSet, Unit>)((Function1)new Function1<StoredFileSet, Unit>(fileSets, root, fileSetsByPackagePrefix){
                            final /* synthetic */ Map<VirtualFile, StoredFileSetCollection> $fileSets;
                            final /* synthetic */ VirtualFile $root;
                            final /* synthetic */ HashMap<String, MultiMap<EntityReference<WorkspaceEntity>, WorkspaceFileSetImpl>> $fileSetsByPackagePrefix;
                            {
                                this.$fileSets = $fileSets;
                                this.$root = $root;
                                this.$fileSetsByPackagePrefix = $fileSetsByPackagePrefix;
                                super(1);
                            }

                            public final void invoke(@NotNull StoredFileSet set2) {
                                WorkspaceFileSetImpl fileSet;
                                Intrinsics.checkNotNullParameter((Object)set2, (String)"set");
                                WorkspaceFileSetsKt.putValue(this.$fileSets, this.$root, set2);
                                WorkspaceFileSetImpl workspaceFileSetImpl = fileSet = set2 instanceof WorkspaceFileSetImpl ? (WorkspaceFileSetImpl)set2 : null;
                                if (fileSet != null && fileSet.getData() instanceof JvmPackageRootDataInternal) {
                                    WorkspaceFileSetsKt.addFileSet(this.$fileSetsByPackagePrefix, "", fileSet);
                                }
                            }
                        }));
                        newRoots.add(root);
                    }
                    this.allRoots = newRoots;
                    this.excludedUrls = newExcludedUrls;
                    this.upToDate = true;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Object2IntMap<VirtualFile>, Set<VirtualFileUrl>> computeCustomExcludedRoots() {
        VirtualFileUrlManager virtualFileUrlManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        Object2IntOpenHashMap<VirtualFile> excludedFiles = new Object2IntOpenHashMap<VirtualFile>();
        HashSet<VirtualFileUrl> excludedUrls = new HashSet<VirtualFileUrl>();
        Iterable $this$forEach$iv = DirectoryIndexExcludePolicy.EP_NAME.getExtensions(this.project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DirectoryIndexExcludePolicy policy = (DirectoryIndexExcludePolicy)element$iv;
            boolean bl = false;
            String[] stringArray = policy.getExcludeUrlsForProject();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"policy.excludeUrlsForProject");
            Object[] $this$forEach$iv2 = stringArray;
            boolean $i$f$forEach2 = false;
            for (Object object : $this$forEach$iv2) {
                String url = (String)object;
                boolean bl2 = false;
                VirtualFile file2 = this.rootFileSupplier.findFileByUrl(url);
                if (file2 != null) {
                    if (!RootFileSupplier.ensureValid(file2, this.project, policy)) continue;
                    excludedFiles.put(file2, 7);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
                excludedUrls.add(virtualFileUrlManager.fromUrl(url));
            }
            if (policy.getExcludeSdkRootsStrategy() != null) {
                void $this$flatMapTo$iv;
                boolean bl3 = false;
                Module[] moduleArray = ModuleManager.Companion.getInstance(this.project).getModules();
                Iterable<Sdk> destination$iv = new HashSet();
                boolean $i$f$mapNotNullTo = false;
                Module[] $this$forEach$iv$iv = moduleArray;
                boolean $i$f$forEach3 = false;
                int n = $this$forEach$iv$iv.length;
                for (int j = 0; j < n; ++j) {
                    Sdk it$iv;
                    Module element$iv$iv;
                    Module element$iv3 = element$iv$iv = $this$forEach$iv$iv[j];
                    boolean bl4 = false;
                    Module it = element$iv3;
                    boolean bl5 = false;
                    if (ModuleRootManager.getInstance(it).getSdk() == null) continue;
                    boolean bl6 = false;
                    destination$iv.add(it$iv);
                }
                HashSet sdks = (HashSet)destination$iv;
                destination$iv = sdks;
                Collection destination$iv2 = new HashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv4 : $this$flatMapTo$iv) {
                    Sdk it = (Sdk)element$iv4;
                    boolean bl7 = false;
                    VirtualFile[] virtualFileArray = it.getRootProvider().getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"it.rootProvider.getFiles(OrderRootType.CLASSES)");
                    Iterable list$iv = ArraysKt.asList((Object[])virtualFileArray);
                    CollectionsKt.addAll((Collection)destination$iv2, (Iterable)list$iv);
                }
                HashSet hashSet = (HashSet)destination$iv2;
                Iterable $this$forEach$iv3 = sdks;
                boolean $i$f$forEach4 = false;
                for (Object element$iv5 : $this$forEach$iv3) {
                    Function<Sdk, List<VirtualFile>> strategy;
                    Sdk sdk2 = (Sdk)element$iv5;
                    boolean bl8 = false;
                    List<VirtualFile> list2 = strategy.fun(sdk2);
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"strategy.`fun`(sdk)");
                    Iterable $this$forEach$iv4 = list2;
                    boolean $i$f$forEach5 = false;
                    for (Object element$iv6 : $this$forEach$iv4) {
                        VirtualFile correctedRoot;
                        VirtualFile root = (VirtualFile)element$iv6;
                        boolean bl9 = false;
                        if (hashSet.contains(root) || (correctedRoot = this.rootFileSupplier.correctRoot(root, sdk2, policy)) == null) continue;
                        excludedFiles.put(correctedRoot, 6 | excludedFiles.getInt(correctedRoot));
                    }
                }
            }
            Module[] $this$forEach$iv3 = ModuleManager.Companion.getInstance(this.project).getModules();
            boolean $i$f$forEach3 = false;
            int n = $this$forEach$iv3.length;
            for (int j = 0; j < n; ++j) {
                Module module2;
                Module module22 = module2 = $this$forEach$iv3[j];
                boolean bl10 = false;
                VirtualFilePointer[] virtualFilePointerArray = policy.getExcludeRootsForModule(ModuleRootManager.getInstance(module22));
                Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointerArray, (String)"policy.getExcludeRootsFo\u2026ager.getInstance(module))");
                Object[] $this$forEach$iv5 = virtualFilePointerArray;
                boolean $i$f$forEach6 = false;
                for (Object element$iv7 : $this$forEach$iv5) {
                    VirtualFilePointer pointer = (VirtualFilePointer)element$iv7;
                    boolean bl11 = false;
                    VirtualFile file3 = pointer.getFile();
                    if (file3 != null) {
                        VirtualFile correctedRoot = this.rootFileSupplier.correctRoot(file3, module22, policy);
                        if (correctedRoot == null) continue;
                        excludedFiles.put(correctedRoot, 1 | excludedFiles.getInt(correctedRoot));
                        continue;
                    }
                    String string2 = pointer.getUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pointer.url");
                    excludedUrls.add(virtualFileUrlManager.fromUrl(string2));
                }
            }
        }
        return TuplesKt.to(excludedFiles, excludedUrls);
    }

    private final Map<VirtualFile, StoredFileSetCollection> computeFileSets() {
        HashMap<VirtualFile, StoredFileSetCollection> result2 = new HashMap<VirtualFile, StoredFileSetCollection>();
        Iterable $this$forEach$iv = AdditionalLibraryRootsProvider.EP_NAME.getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AdditionalLibraryRootsProvider provider2 = (AdditionalLibraryRootsProvider)element$iv;
            boolean bl = false;
            Collection<SyntheticLibrary> collection = provider2.getAdditionalProjectLibraries(this.project);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"provider.getAdditionalProjectLibraries(project)");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Condition<VirtualFile> condition;
                SyntheticLibrary library = (SyntheticLibrary)element$iv2;
                boolean bl2 = false;
                Collection<VirtualFile> collection2 = library.getSourceRoots();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"library.sourceRoots");
                NonIncrementalContributors.computeFileSets$lambda$21$lambda$20$registerRoots(this, library, provider2, result2, collection2, WorkspaceFileKind.EXTERNAL_SOURCE, library instanceof JavaSyntheticLibrary ? (ModuleOrLibrarySourceRootData)new LibrarySourceRootFileSetData(null, "") : (ModuleOrLibrarySourceRootData)SyntheticLibrarySourceRootData.INSTANCE);
                Collection<VirtualFile> collection3 = library.getBinaryRoots();
                Intrinsics.checkNotNullExpressionValue(collection3, (String)"library.binaryRoots");
                NonIncrementalContributors.computeFileSets$lambda$21$lambda$20$registerRoots(this, library, provider2, result2, collection3, WorkspaceFileKind.EXTERNAL, library instanceof JavaSyntheticLibrary ? (WorkspaceFileSetData)new LibraryRootFileSetData(null, "") : (WorkspaceFileSetData)DummyWorkspaceFileSetData.INSTANCE);
                Set<VirtualFile> set2 = library.getExcludedRoots();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"library.excludedRoots");
                Iterable $this$forEach$iv3 = set2;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    VirtualFile it = (VirtualFile)element$iv3;
                    boolean bl3 = false;
                    Map map2 = result2;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    WorkspaceFileSetsKt.putValue(map2, it, new ExcludedFileSet.ByFileKind(6, NonIncrementalMarker.INSTANCE, null, 4, null));
                }
                if (library.getUnitedExcludeCondition() == null) continue;
                boolean bl4 = false;
                Function1 predicate2 = (Function1)new Function1<VirtualFile, Boolean>(condition){
                    final /* synthetic */ Condition<VirtualFile> $condition;
                    {
                        this.$condition = $condition;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull VirtualFile file2) {
                        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                        return this.$condition.value(file2);
                    }
                };
                Collection<VirtualFile> collection4 = library.getSourceRoots();
                Intrinsics.checkNotNullExpressionValue(collection4, (String)"library.sourceRoots");
                Collection<VirtualFile> collection5 = library.getBinaryRoots();
                Intrinsics.checkNotNullExpressionValue(collection5, (String)"library.binaryRoots");
                Iterable $this$forEach$iv4 = CollectionsKt.plus(collection4, (Iterable)collection5);
                boolean $i$f$forEach4 = false;
                for (Object element$iv4 : $this$forEach$iv4) {
                    VirtualFile root = (VirtualFile)element$iv4;
                    boolean bl5 = false;
                    Map map3 = result2;
                    Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                    WorkspaceFileSetsKt.putValue(map3, root, new ExcludedFileSet.ByCondition(root, (Function1<? super VirtualFile, Boolean>)predicate2, (EntityReference<? extends WorkspaceEntity>)((EntityReference)NonIncrementalMarker.INSTANCE), EntityStorageKind.MAIN));
                }
            }
        }
        return result2;
    }

    @RequiresWriteLock
    public final void resetCache() {
        this.upToDate = false;
    }

    private static final void updateIfNeeded$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void computeFileSets$lambda$21$lambda$20$registerRoots(NonIncrementalContributors this$0, SyntheticLibrary $library, AdditionalLibraryRootsProvider $provider, HashMap<VirtualFile, StoredFileSetCollection> result2, Collection<VirtualFile> files2, WorkspaceFileKind kind, WorkspaceFileSetData fileSetData) {
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it;
            VirtualFile root = (VirtualFile)element$iv;
            boolean bl = false;
            if (this$0.rootFileSupplier.correctRoot(root, $library, $provider) == null) continue;
            boolean bl2 = false;
            Map map2 = result2;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            WorkspaceFileSetsKt.putValue(map2, it, new WorkspaceFileSetImpl(it, kind, (EntityReference<? extends WorkspaceEntity>)((EntityReference)NonIncrementalMarker.INSTANCE), EntityStorageKind.MAIN, fileSetData));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0014\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors$Companion;", "", "()V", "isFromAdditionalLibraryRootsProvider", "", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "isFromAdditionalLibraryRootsProvider$intellij_platform_projectModel_impl", "isPlaceholderReference", "entityReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nNonIncrementalContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonIncrementalContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,191:1\n10#2:192\n*S KotlinDebug\n*F\n+ 1 NonIncrementalContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors$Companion\n*L\n177#1:192\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isFromAdditionalLibraryRootsProvider$intellij_platform_projectModel_impl(@NotNull WorkspaceFileSet fileSet) {
            Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
            WorkspaceFileSet $this$asSafely$iv = fileSet;
            boolean $i$f$asSafely = false;
            WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
            if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
                workspaceFileSet = null;
            }
            WorkspaceFileSetImpl workspaceFileSetImpl = (WorkspaceFileSetImpl)workspaceFileSet;
            return (workspaceFileSetImpl != null ? workspaceFileSetImpl.getEntityReference() : null) instanceof NonIncrementalMarker;
        }

        public final boolean isPlaceholderReference(@NotNull EntityReference<? extends WorkspaceEntity> entityReference) {
            Intrinsics.checkNotNullParameter(entityReference, (String)"entityReference");
            return entityReference instanceof NonIncrementalMarker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

